/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.ui.payment;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.game.sdk.comon.cmd.CmdPaymentV3;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.InitalizePurchaseObj;
import com.game.sdk.comon.object.ListPurchaseHistoryObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.err.GetListPurchaseErrObj;
import com.game.sdk.comon.object.err.InitialPurchaseErrObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.InitalizePuchaseRequestObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.InitialPurchaseResponseObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.PurchaseUtils;
import com.game.sdk.comon.utils.ToastUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.payment.IPaymentPresenter;
import com.game.sdk.ui.payment.PaymentPresenterImpl;
import com.mobgame.R;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PaymentUtil
implements BaseView {
    private static final String TAG = PaymentUtil.class.getSimpleName();
    private static PaymentUtil paymentUtil;
    private PaymentPresenterImpl paymentPresenter;
    private Activity activity;
    InitalizePurchaseObj initalizePuchaseObj;
    List<SkuDetails> skuDetails;
    int current;
    PurchaseHistoryObj currentPurchase;
    String accountId;
    String productId;
    ArrayList<IPaymentPresenter> listPresenter;
    PaymentResponse paymentResponse;
    private final SkuDetailsResponseListener skuDetailsResponseListener = new SkuDetailsResponseListener(){

        public void onSkuDetailsResponse(@NonNull BillingResult billingResult, @Nullable List<SkuDetails> list) {
            int responseCode = billingResult.getResponseCode();
            String debugMessage = billingResult.getDebugMessage();
            switch (responseCode) {
                case 0: {
                    Log.d((String)TAG, (String)("onSkuDetailsResponse: " + responseCode));
                    if (list != null && list.size() > 0) {
                        PaymentUtil.this.skuDetails = list;
                        CmdPaymentV3.getInstance().launchBillingFlow(PaymentUtil.this.activity, PaymentUtil.this.skuDetails.get(PaymentUtil.this.skuDetails.size() - 1));
                        break;
                    }
                    DialogUtils.showErrorDialog(PaymentUtil.this.activity, PaymentUtil.this.activity.getString(R.string.error_transaction));
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Log.e((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                    break;
                }
                default: {
                    Log.wtf((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                }
            }
        }
    };

    public static PaymentUtil getInstance() {
        if (paymentUtil == null) {
            paymentUtil = new PaymentUtil();
        }
        return paymentUtil;
    }

    public void initialPayment(Activity activity, String product_Id, String itemNo, String state, PaymentResponse paymentResponse) {
        this.activity = activity;
        this.paymentResponse = paymentResponse;
        this.skuDetails = new ArrayList<SkuDetails>();
        this.accountId = GameConfigs.getInstance().getUser().getAccount().getAccountId();
        this.productId = product_Id;
        this.listPresenter = new ArrayList();
        this.paymentPresenter = new PaymentPresenterImpl(this);
        this.current = -1;
        this.initIAP();
        this.checkPurchaseHistory();
        this.initialPurchase(product_Id, itemNo, state);
    }

    private void initialPurchase(String productId, String itemNo, String state) {
        Log.d((String)TAG, (String)("onPaymentStartIAP: " + productId + " " + itemNo));
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String invoice_no = DeviceUtils.getOSInfo().replace(" ", "") + System.currentTimeMillis();
        if (state == null || "".equals(state)) {
            state = "";
        }
        if (TextUtils.isEmpty((CharSequence)productId) || TextUtils.isEmpty((CharSequence)productId)) {
            ToastUtils.showWarmToast((Context)this.activity, this.activity.getResources().getString(R.string.err_and_try_again_late));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)itemNo) || TextUtils.isEmpty((CharSequence)itemNo)) {
            ToastUtils.showWarmToast((Context)this.activity, this.activity.getResources().getString(R.string.err_and_try_again_late));
            return;
        }
        InitalizePuchaseRequestObj obj = new InitalizePuchaseRequestObj();
        obj.setRequest(PrefManager.getAppKey((Context)this.activity));
        obj.setDevice_id(DeviceUtils.getUniqueDeviceID((Context)this.activity));
        obj.setMethod("2");
        obj.setCharacter_name("");
        obj.setCharacter_id(character_id);
        obj.setArea_id(area_id);
        obj.setArea_name("");
        obj.setItem_no(itemNo);
        obj.setProduct_id(productId);
        obj.setPayload(state);
        obj.setInvoice_no(invoice_no);
        obj.setApp_version(Utils.getGameVersion((Context)this.activity));
        obj.setSdk_version(Utils.getSDKVersion((Context)this.activity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setNetwork(Utils.getNetwork((Context)this.activity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID((Context)this.activity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID((Context)this.activity));
        obj.setLocale(PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "APP_LANG", "en"));
        obj.setResolution(DeviceUtils.getResolution((Context)this.activity));
        if (this.paymentPresenter != null) {
            this.paymentPresenter.initialPurchase(obj);
        }
    }

    @Override
    public void showProgress(String message) {
        Utils.showLoading(this.activity, true);
    }

    @Override
    public void hideProgress() {
        Utils.showLoading(this.activity, false);
    }

    public void success(Object x) {
        InitialPurchaseResponseObj initialPurchaseResponseObj;
        if (x instanceof InitialPurchaseResponseObj && (initialPurchaseResponseObj = (InitialPurchaseResponseObj)x).getStatus() == 0) {
            this.initalizePuchaseObj = initialPurchaseResponseObj.getData();
            Log.d((String)TAG, (String)("onPaymentStartIAP response: " + this.initalizePuchaseObj.getProduct_id()));
            if (TextUtils.isEmpty((CharSequence)this.initalizePuchaseObj.getOrder_no())) {
                DialogUtils.showErrorDialog(this.activity, this.activity.getString(R.string.err_and_try_again_late));
                Log.e((String)TAG, (String)"InitialPurchaseResponseObj response error");
                return;
            }
            CmdPaymentV3.getInstance().querySkuDetails(this.initalizePuchaseObj.getProduct_id(), this.skuDetailsResponseListener);
        }
    }

    public void error(Object o) {
        Log.d((String)TAG, (String)("error response: " + o.toString()));
        if (o instanceof GetListPurchaseErrObj) {
            TrackingUtil.getInstance().trackPaymentLoadScreenFail(((GetListPurchaseErrObj)o).getStatus() + "", ((GetListPurchaseErrObj)o).getMessage());
            DialogUtils.showErrorDialog(this.activity, this.activity.getString(R.string.err_and_try_again_late));
        } else if (o instanceof InitialPurchaseErrObj) {
            DialogUtils.showErrorDialog(this.activity, this.activity.getString(R.string.err_and_try_again_late));
        } else if (o instanceof VerifyPurchaseErrObj) {
            DialogUtils.showErrorDialog(this.activity, this.activity.getString(R.string.err_and_try_again_late));
        }
    }

    private void initIAP() {
        CmdPaymentV3.getInstance().initIABv3((Context)this.activity, new BillingClientStateListener(){

            public void onBillingSetupFinished(@NonNull BillingResult billingResult) {
                int responseCode = billingResult.getResponseCode();
                String debugMessage = billingResult.getDebugMessage();
                Log.d((String)TAG, (String)("onBillingSetupFinished: " + responseCode + " " + debugMessage));
            }

            public void onBillingServiceDisconnected() {
                Log.d((String)TAG, (String)"onBillingServiceDisconnected: ");
            }
        }, new PurchasesUpdatedListener(){

            public void onPurchasesUpdated(@NonNull BillingResult billingResult, @Nullable List<Purchase> list) {
                int responseCode = billingResult.getResponseCode();
                String debugMessage = billingResult.getDebugMessage();
                Log.d((String)TAG, (String)("onPurchasesUpdated:  " + responseCode + " " + debugMessage));
                switch (responseCode) {
                    case 0: {
                        PaymentUtil.this.processPurchases(list);
                        break;
                    }
                    case 1: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: User canceled the purchase");
                        PaymentUtil.this.skuDetails.clear();
                        break;
                    }
                    case 4: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: This item is unavailable");
                        break;
                    }
                    case 7: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: The user already owns this item");
                        break;
                    }
                    case 5: {
                        Log.e((String)TAG, (String)"onPurchasesUpdated: Developer error means that Google Play does not recognize the configuration. If you are just getting started, make sure you have configured the application correctly in the Google Play Console. The SKU product ID must match and the APK you are using must be signed with release keys.");
                        break;
                    }
                    default: {
                        Log.i((String)TAG, (String)("onPurchasesUpdated: " + debugMessage));
                    }
                }
            }
        });
    }

    private void processPurchases(List<Purchase> purchasesList) {
        if (purchasesList != null) {
            Log.d((String)TAG, (String)("processPurchases: " + purchasesList.size() + " purchase(s)"));
            for (Purchase purchase : purchasesList) {
                this.handlePurchase(purchase);
            }
        } else {
            Log.d((String)TAG, (String)"processPurchases: with no purchases");
            Log.d((String)TAG, (String)"onPurchasesUpdated: null purchase list");
        }
    }

    private void handlePurchase(final Purchase purchase) {
        Log.i((String)TAG, (String)("handlePurchase: " + purchase.getOriginalJson()));
        if (purchase.getPurchaseState() == 1) {
            Log.i((String)TAG, (String)"PURCHASE IS PURCHASED ");
            CmdPaymentV3.getInstance().consumeAsyncPurchase(purchase, new ConsumeResponseListener(){

                public void onConsumeResponse(@NonNull BillingResult billingResult, @NonNull String s) {
                    PaymentUtil.this.skuDetails.clear();
                    if (billingResult.getResponseCode() == 0) {
                        PaymentUtil.this.currentPurchase = new PurchaseHistoryObj();
                        String character_id = PrefManager.getString((Context)PaymentUtil.this.activity, "MOB_ROLE_ID", "");
                        String area_id = PrefManager.getString((Context)PaymentUtil.this.activity, "MOB_AREA_ID", "");
                        PaymentUtil.this.currentPurchase.setArea_id(area_id);
                        PaymentUtil.this.currentPurchase.setCharactor_id(character_id);
                        PaymentUtil.this.currentPurchase.setOrder_no(PaymentUtil.this.initalizePuchaseObj.getOrder_no());
                        Log.i((String)TAG, (String)("currentPurchase: " + PaymentUtil.this.currentPurchase.getOrder_no()));
                        try {
                            JSONObject joReceipt = new JSONObject(purchase.getOriginalJson());
                            VerifyPurchaseRequestObj.Receipt rec = new VerifyPurchaseRequestObj.Receipt();
                            rec.setData(joReceipt.toString());
                            rec.setItemType("inapp");
                            rec.setSignature(purchase.getSignature());
                            PaymentUtil.this.currentPurchase.setReceipt(rec);
                        }
                        catch (Exception e) {
                            LogUtils.e("Err Purchase", e.getMessage());
                        }
                        PaymentUtil.this.currentPurchase.setIs_send(false);
                        PaymentUtil.this.currentPurchase.setAccount_id(PaymentUtil.this.accountId);
                        LogUtils.d("RECEIPT 1", purchase.getOriginalJson());
                        for (IPaymentPresenter p : PaymentUtil.this.listPresenter) {
                            if (p == null) continue;
                            p.cancelRequest(new String[0]);
                        }
                        PrefManager.saveUsePurchaseHistory((Context)PaymentUtil.this.activity, PaymentUtil.this.accountId, PaymentUtil.this.currentPurchase);
                        Log.i((String)TAG, (String)("currentPurchase: " + PaymentUtil.this.currentPurchase.getOrder_no()));
                        if (PaymentUtil.this.paymentResponse != null) {
                            PaymentUtil.this.paymentResponse.onPaymentSuccess(PaymentUtil.this.productId, PaymentUtil.this.currentPurchase);
                        }
                        CmdPaymentV3.getInstance().billingEndConnection();
                    }
                }
            });
        } else if (purchase.getPurchaseState() == 2) {
            Log.i((String)TAG, (String)"PURCHASE IS PENDING ");
        }
    }

    public void checkPurchaseHistory() {
        ++this.current;
        ListPurchaseHistoryObj listPurchaseHistoryObj = PrefManager.getHistoryPurchase((Context)this.activity, this.accountId);
        if (listPurchaseHistoryObj.getData() == null || listPurchaseHistoryObj.getData().size() == 0 || listPurchaseHistoryObj.getData().size() <= this.current) {
            return;
        }
        PurchaseHistoryObj obj = listPurchaseHistoryObj.getData().get(this.current);
        this.sendHistory(obj);
    }

    public void sendHistory(final PurchaseHistoryObj obj) {
        PaymentPresenterImpl presenter = new PaymentPresenterImpl(new BaseView(){

            @Override
            public void showProgress(String message) {
            }

            @Override
            public void hideProgress() {
            }

            public void success(Object x) {
                if (x instanceof VerifyPurchaseResponseObj) {
                    VerifyPurchaseResponseObj responseObj = (VerifyPurchaseResponseObj)x;
                    int status = responseObj.getData().getStatus();
                    if (status == 3 || status == 2 || status == 17) {
                        TrackingUtil.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                    } else {
                        TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(status), responseObj.getData().getDescription());
                    }
                    obj.setAccount_id(PaymentUtil.this.accountId);
                    PurchaseUtils.removeSuccessPurchase(obj, PaymentUtil.this.activity);
                    --PaymentUtil.this.current;
                    PaymentUtil.this.checkPurchaseHistory();
                    LogUtils.e(TAG, "Verify Success - " + obj.getOrder_no());
                }
            }

            public void error(Object o) {
                BaseObj err;
                if (o instanceof VerifyPurchaseErrObj) {
                    err = (VerifyPurchaseErrObj)o;
                    LogUtils.e(TAG, "Verify failed - " + obj.getOrder_no() + " :" + err.getMessage());
                    PaymentUtil.this.checkPurchaseHistory();
                }
                if (o instanceof BaseObj) {
                    err = (BaseObj)o;
                    TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(err.getStatus()), err.getMessage());
                }
            }
        });
        TrackingUtil.getInstance().trackPaymentBeforVerify(obj.getOrder_no());
        this.listPresenter.add(presenter);
        this.verifyPurchase(presenter, obj.getReceipt(), obj.getOrder_no());
    }

    public void verifyPurchase(IPaymentPresenter presenter, VerifyPurchaseRequestObj.Receipt receipt, String order_no) {
        VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setOrder_no(order_no);
        obj.setMethod("2");
        obj.setReceipt(receipt);
        obj.setApp_version(Utils.getGameVersion((Context)this.activity));
        obj.setSdk_version(Utils.getSDKVersion((Context)this.activity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setResolution(DeviceUtils.getResolution((Context)this.activity));
        obj.setNetwork(Utils.getNetwork((Context)this.activity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID((Context)this.activity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID((Context)this.activity));
        obj.setLocale(GameConfigs.getInstance().getLang());
        if (presenter != null) {
            presenter.verifyPurchase(obj);
        }
    }

    public static interface PaymentResponse {
        public void onPaymentSuccess(String var1, PurchaseHistoryObj var2);
    }
}

