package com.mobgame.gui.dialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.legacy.app.FragmentPagerAdapter;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.ViewPager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.Utils;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.mobgame.MobGameHelper;
import com.mobgame.R;
import com.mobgame.gui.MobGamePagerFragment;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.view.adapter.DashboardMenuAdapter;
import com.mobgame.listener.RecyclerItemClickListener;
import com.mobgame.model.ItemMenuDashboard;
import com.mobgame.utils.Constants;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by khaitran on 7/20/17.
 */

public class MobGameDashboardNewDialog extends DialogFragment {
    public static final String TAG = MobGameDashboardNewDialog.class.getSimpleName();
    public static final String CLOSE_PROGRESS_BAR = "close_progress_bar";
    public static String KEY_DATA = "data";
    public static String KEY_ID = "parent_id";
    public static String KEY_ICON = "icon";
    public static boolean isDashBoard = true;

    EventListener eventListener;

    private ImageView btnClose;
    private RecyclerView mRecycleView;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout layoutMainDashboard;
    private TextView txtTitle;

    private ProgressBar circleProgressBar;
    private View rootView, layoutChildContent, layoutTmp;
    private MobGamePagerFragment fragContent;
    private MobPagerAdapter adapter;
    private DashboardMenuAdapter menuAdapter;
    private boolean isLandscape, isTabletSize;


    private int currentPage;
    private List<ItemMenuDashboard> listItemMenuDashboard = new ArrayList<>();
    private final String TAG_FRAGMENT = "fragment_webview";
    private String data;
    private Activity activity;
    ItemMenuDashboard selectedItem;

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (eventListener != null) {
            eventListener.onDismissDashboard();
        }

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        activity = getActivity();
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        isTabletSize = getResources().getBoolean(R.bool.isTablet);
        if (isTabletSize) {
            rootView = inflater.inflate(R.layout.dialog_dashboard_new_tablet, container,
                    false);
        } else {
            rootView = inflater.inflate(R.layout.dialog_dashboard_new, container,
                    false);
        }
        try {
            isLandscape = DeviceUtils.getScreenOrientation(rootView.getContext()) == 2;
        } catch (Exception e) {
            e.printStackTrace();
        }
        getDialog().getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        getDialog().getWindow()
                .getAttributes().windowAnimations = R.style.DashBoardDialogAnimation;
        isDashBoard = true;
        initViewLayout();
        initFragment();
        setUpListener();
        if (selectedItem != null)
            loadItemData(selectedItem);
        return rootView;
    }

    private List<ItemMenuDashboard> getDataItemDashboard(ArrayList<SdkConfigObj.Menu> listMenuItems) {
        List<ItemMenuDashboard> listMenuDashboard = new ArrayList<>();
        for (int i = listMenuItems.size() - 1; i >= 0; i--) {
            ItemMenuDashboard itemMenuDashboard = new ItemMenuDashboard();
            itemMenuDashboard = setDataToItemMenuDashboard(listMenuItems.get(i));
            if (listMenuDashboard.size() == 0) {
                itemMenuDashboard.setClick(true);
                selectedItem = itemMenuDashboard;
                listMenuDashboard.add(itemMenuDashboard);
            } else {
                for (int j = listMenuDashboard.size() - 1; j >= 0; j--) {
                    if (j != 0 & listMenuDashboard.get(j).getPriority() < itemMenuDashboard.getPriority()) {
                        listMenuDashboard.get(j).setClick(false);
                        itemMenuDashboard.setClick(true);
                        selectedItem = itemMenuDashboard;
                        listMenuDashboard.add(j, itemMenuDashboard);
                        break;
                    } else if (j == 0 & listMenuDashboard.get(j).getPriority() < itemMenuDashboard.getPriority()) {
                        listMenuDashboard.get(j).setClick(false);
                        itemMenuDashboard.setClick(true);
                        selectedItem = itemMenuDashboard;
                        listMenuDashboard.add(itemMenuDashboard);
                    } else if (j == 0 & listMenuDashboard.get(j).getPriority() > itemMenuDashboard.getPriority()) {
                        listMenuDashboard.add(itemMenuDashboard);
                    }
                }

            }
        }

        return listMenuDashboard;
    }

    private ItemMenuDashboard setDataToItemMenuDashboard(SdkConfigObj.Menu mobMenuItem) {
        ItemMenuDashboard itemMenuDashboard = new ItemMenuDashboard();
        int idMenu = mobMenuItem.getId();

        itemMenuDashboard.setId_menu(idMenu);
        String title = mobMenuItem.getTitle();
        itemMenuDashboard.setTitle_menu(title);
        ArrayList<SdkConfigObj.SubMenu> SubIdMenus = mobMenuItem.getSubMenu();
        itemMenuDashboard.setSubId_menu(SubIdMenus);
        String urlIcon = mobMenuItem.getIcon();
        itemMenuDashboard.setUrlIcon(urlIcon);
        String urlIconActive = mobMenuItem.getIconActive();
        itemMenuDashboard.setUrlIconActive(urlIconActive);
        itemMenuDashboard.setPriority(mobMenuItem.getPriority());
        itemMenuDashboard.setOpenType(0);

        if (NotificationUtils.hasNtf(activity, 2) || NotificationUtils.hasNtf(activity, 3)) {
            if (idMenu == 1) itemMenuDashboard.setHasNtf(true);
        }
        if (NotificationUtils.hasNtf(activity, 5) || NotificationUtils.hasNtf(activity, 4)) {
            if (idMenu == 4) itemMenuDashboard.setHasNtf(true);
        }
        if (NotificationUtils.hasNtf(activity, 7) || NotificationUtils.hasNtf(activity, 6)) {
            if (idMenu == 6) itemMenuDashboard.setHasNtf(true);
        }
        return itemMenuDashboard;
    }

    private void initFragment() {
        try {
            fragContent = new MobGamePagerFragment(activity);
            fragContent.addOnPageChangeListener(mOnPageChangeListener);
            fragContent.setWebEventListener(mWebEventListener);

            getChildFragmentManager().beginTransaction().add(layoutChildContent.getId(), fragContent, TAG_FRAGMENT).commit();
            try {
                data = getArguments().getString(KEY_DATA);
            } catch (Exception e) {
                try {
                    performOnItemClick(0);
                } catch (IndexOutOfBoundsException | NullPointerException e2) {
                    performOnItemClick(0);
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initViewLayout() {
        try {
            if (isTabletSize || isLandscape) {
                layoutMainDashboard = rootView.findViewById(R.id.layout_main_dashboard);
            }
            layoutTmp = rootView.findViewById(R.id.layout_tmp);
            layoutChildContent = rootView.findViewById(R.id.layout_child_content);
            txtTitle = rootView.findViewById(R.id.title_item);
            btnClose = rootView.findViewById(R.id.btn_close);
            mRecycleView = rootView.findViewById(R.id.recycleview_menu);
            layoutManager = new LinearLayoutManager(activity);
            mRecycleView.setLayoutManager(layoutManager);
            circleProgressBar = rootView.findViewById(R.id.circle_progress_bar);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpListener() {
        try {
            ArrayList<SdkConfigObj.Menu> listMenuItems = new ArrayList<>();
            if (GameConfigs.getInstance().getSdkConfig() != null && GameConfigs.getInstance().getSdkConfig().getMenu() != null)
                listMenuItems.addAll(GameConfigs.getInstance().getSdkConfig().getMenu());
            listItemMenuDashboard = getDataItemDashboard(listMenuItems);
            menuAdapter = new DashboardMenuAdapter(listItemMenuDashboard, activity, isLandscape, isTabletSize);
            mRecycleView.setAdapter(menuAdapter);

            btnClose.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    isDashBoard = false;
                    dismiss();
                    SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
                    if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                        MobGameHelper.showNotiFloatButton(game.getEx());
                    }

                    Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);

                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "is_showads");
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                }
            });
            if (isTabletSize || isLandscape) {
                layoutMainDashboard.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        try {
                            layoutTmp.setVisibility(View.GONE);
                            dismiss();

                            SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
                            if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                                MobGameHelper.showNotiFloatButton(game.getEx());
                            }

                            Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);

                            Intent intent = new Intent(Constants.INTENT_FILTER);
                            intent.putExtra("category", "is_showads");
                            LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }

            layoutTmp.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    try {
                        layoutTmp.setVisibility(View.GONE);
                        dismiss();

                        SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
                        if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                            MobGameHelper.showNotiFloatButton(game.getEx());
                        }

                        Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "is_showads");
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });

            getDialog().setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialogInterface, int keyCode, KeyEvent event) {
                    if (event != null && (keyCode == KeyEvent.KEYCODE_BACK) && (event.getAction() == KeyEvent.ACTION_UP)) {
                        try {
                            dismiss();
                            SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
                            if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                                MobGameHelper.showNotiFloatButton(game.getEx());
                            }

                            Preference.remove(activity, Constants.SHARED_PREF_SHOW_DASHBOARD);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        return true;
                    }
                    return false;
                }
            });

            Preference.save(activity, Constants.SHARED_PREF_SHOW_DASHBOARD, true);
            mRecycleView.addOnItemTouchListener(new RecyclerItemClickListener(activity, mRecycleView, new RecyclerItemClickListener.OnItemClickListener() {
                @Override
                public void onItemClick(View view, int position) {
                    try {
                        ItemMenuDashboard itemMenuDashboard = listItemMenuDashboard.get(position);
                        switch (itemMenuDashboard.getOpenType()) {
                            //todo sửa opentype
                            case 0:
                                for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                                    if (i == position) {
                                        listItemMenuDashboard.get(i).setClick(true);
                                    } else {
                                        listItemMenuDashboard.get(i).setClick(false);
                                    }
                                }
                                menuAdapter.notifyDataSetChanged();
                                loadItemData(itemMenuDashboard);
                                break;
                            case 2:
                            case 3:
                                //                            showFragment(itemMenuDashboard.getOpenLink(), itemMenuDashboard.getOpenType(), false);
                                break;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onItemLongClick(View view, int position) {

                }
            }));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadItemData(ItemMenuDashboard itemMenuDashboard) {
        if (itemMenuDashboard.getSubId_menu() == null) {
            Log.d(TAG, "SubMenu null");
            return;
        } else {
            txtTitle.setVisibility(View.VISIBLE);

            loadUrls(itemMenuDashboard.getSubId_menu());
        }
        switch (itemMenuDashboard.getId_menu()) {
            case 1:
                txtTitle.setVisibility(View.GONE);
                if (!NotificationUtils.hasNtf(activity, 2) && !NotificationUtils.hasNtf(activity, 3)) {
                    itemMenuDashboard.setHasNtf(false);
                }
                Log.d(TAG, "addOnItemTouchListener : " + 1);
                handleNewEvent();
                menuAdapter.notifyDataSetChanged();
                break;
            case 4:
                itemMenuDashboard.setHasNtf(false);
                menuAdapter.notifyDataSetChanged();
                Log.d(TAG, "addOnItemTouchListener : " + 4);
                handleGiftcode();
                break;
            case 6:
                itemMenuDashboard.setHasNtf(false);
                menuAdapter.notifyDataSetChanged();
                Log.d(TAG, "addOnItemTouchListener : " + 6);
                handleBug();
                break;
            case 8:
                Log.d(TAG, "addOnItemTouchListener : " + 8);
                handleOther();
                break;
            case 10:
                Toast.makeText(activity, "id : " + 10, Toast.LENGTH_SHORT).show();
                break;
        }
    }

    private void handleOther() {
        hideTabs();
        isDashBoard = false;
    }

    private void handleBug() {
        if (NotificationUtils.hasNtf(activity, 7)) {
            NotificationUtils.removeNtf(activity, 7);
        }
        if (NotificationUtils.hasNtf(activity, 6)) {
            NotificationUtils.removeNtf(activity, 6);
        }
        hideTabs();
        isDashBoard = false;
        trackEventFromButton(Constants.STR_EVENT_BUGS, "root_report_bugs");
    }

    private void handleGiftcode() {
        try {
            if (NotificationUtils.hasNtf(activity, 5)) {
                NotificationUtils.removeNtf(activity, 5);
            }
            if (NotificationUtils.hasNtf(activity, 4)) {
                NotificationUtils.removeNtf(activity, 4);
            }
            hideTabs();
            isDashBoard = false;
            trackEventFromButton(Constants.STR_EVENT_GIFTCODE, "root_giftcode");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleNewEvent() {
        try {
            showTabs();
            isDashBoard = true;
            trackEventFromButton(Constants.STR_EVENT_NEWS, "root_news_event");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showTabs() {
        try {
            if (fragContent != null) {
                fragContent.showTabs(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideTabs() {
        try {
            if (fragContent != null) {
                fragContent.hideTabs(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        setStyle(STYLE_NO_TITLE, android.R.style.Theme_Translucent_NoTitleBar);
        super.onCreate(savedInstanceState);
    }

    private void performOnItemClick(int position) {

    }

    public void loadUrls(ArrayList<SdkConfigObj.SubMenu> items) {
        LogUtils.i(TAG, "item:" + items.toString());
        if (adapter == null) {
            adapter = new MobPagerAdapter(getChildFragmentManager());
        }
        currentPage = 0;

        for (int i = items.size() - 1; i >= 0; i--) {
            try {
                SdkConfigObj.SubMenu item = items.get(i);
                if (item.getPriority() > currentPage) {
                    currentPage = i;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        adapter.setItems(items);
        fragContent.setAdapter(adapter, currentPage);

    }

    private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener() {

        @SuppressLint("JavascriptInterface")
        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        MobGameWebFragment fragWeb = adapter.getItem(currentPage);
                        Log.i(TAG, "fragContent.countTabs(): " + fragContent.countTabs());
                        if (Utils.isOnline(activity)) {
                            if (fragContent.countTabs() > 1 && !fragWeb.canGoBack()) {
                                fragContent.showTabs(false);
                                new Handler().postDelayed(new Runnable() {
                                    @Override
                                    public void run() {

                                    }
                                }, 1000);
                            } else {
                                fragContent.hideTabs(true);
                            }
                        } else {
                            if (fragContent.countTabs() > 1) {
                                fragContent.showTabs(false);
                            } else {
                                fragContent.hideTabs(false);
                            }
                        }
                    }
                });

                view.addJavascriptInterface(activity, "android");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            int pos = Integer.parseInt((String) view.getTag());
            if (pos == currentPage) {
                progress = Math.max(1, progress);
                circleProgressBar.setProgress(progress);
                if (progress == 100) {
                    hideProgressBar();
                } else {
                    showProgressBar();
                }
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            int pos = Integer.parseInt((String) view.getTag());
            if (pos == currentPage) {
                hideProgressBar();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {

        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }

    };

    @Override
    public void show(FragmentManager manager, String tag) {
        try {
            FragmentTransaction ft = manager.beginTransaction();
            ft.add(this, tag);
            ft.commitAllowingStateLoss();
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    private ViewPager.SimpleOnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener() {

        @Override
        public void onPageSelected(int position) {
            if (position != currentPage) {
                currentPage = position;

                MobGameWebFragment fragWeb = adapter.getItem(currentPage);
                fragWeb.loadUrlToLoadIfHave();
                mWebEventListener.onScrollChanged(fragWeb.getWebView(),
                        fragWeb.getScrollX(), fragWeb.getScrollY(),
                        fragWeb.getScrollX(), fragWeb.getScrollY());
            }
            int itemId = (int) adapter.getItemId(position);
            if (NotificationUtils.hasNtf(activity, itemId)) {
                hideNtf(itemId);
                //TODO gone ntf icon
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        fragContent.notifiTabsChanged();
                    }
                });
            }
        }
    };


    @Override
    public void onPause() {
        super.onPause();
//        circleProgressBar.setVisibility(View.GONE);
        try {
            LocalBroadcastManager.getInstance(activity).unregisterReceiver(mBroadcastReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance(activity).registerReceiver(
                    mBroadcastReceiver, new IntentFilter(Constants.INTENT_FILTER)
            );
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                String category = intent.getStringExtra("category");
                if ("gcm".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    Log.d(TAG, "funtap :" + strId);
                    if (strId != null) {
                        fragContent.notifiTabsChanged();
                    }
                    int id = Integer.parseInt(strId);
                    showNtf(id);

                    //TODO : xu ly event duoc lang nghe khi co ntf moi
                } else if ("swipe_refresh".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    int id = Integer.parseInt(strId);
                    //TODO : xu ly event duoc lang nghe khi co ntf moi
                    hideNtf(id);
                    fragContent.notifiTabsChanged();

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void showNtf(int id) {
        if (NotificationUtils.hasNtf(activity, id)) {
            switch (id) {
                case 2:
                case 3:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 1) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 4:
                case 5:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 4) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 6:
                case 7:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 6) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
            }

        }
    }

    private void hideNtf(int id) {
        if (NotificationUtils.hasNtf(activity, id)) {
            switch (id) {
                case 2:
                case 3:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 1) {
                            NotificationUtils.removeNtf(activity, id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 4:
                case 5:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 4) {
                            NotificationUtils.removeNtf(activity, id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 6:
                case 7:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 6) {
                            NotificationUtils.removeNtf(activity, id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
            }

        }
    }

    private class MobPagerAdapter extends FragmentPagerAdapter {

        private ArrayList<MobGameWebFragment> fragments;
        private FragmentManager fragmentManager;
        private ArrayList<SdkConfigObj.SubMenu> items;

        {
            fragments = new ArrayList<>();
        }

        public MobPagerAdapter(FragmentManager fm) {
            super(fm);
            this.fragmentManager = fm;
        }

        public void setItems(ArrayList<SdkConfigObj.SubMenu> items) {
            releaseFragments();
            this.items = items;
            fragments = new ArrayList<MobGameWebFragment>();
            for (int i = 0; i < items.size(); i++) {
                SdkConfigObj.SubMenu item = items.get(i);
                String url = item.getAction();
                int id = item.getId();
                MobGameWebFragment frag;
                if (i == currentPage) {
                    frag = new MobGameWebFragment(url, id);
                } else {
                    frag = new MobGameWebFragment(url, true, id);
                }
                frag.setEventListener(mWebEventListener);
                frag.setWebViewTag(i + "");
                fragments.add(frag);
            }
        }

        @Override
        public MobGameWebFragment getItem(int position) {
            try {
                return fragments.get(position);
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public int getCount() {
            try {
                return fragments.size();
            } catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        @Override
        public long getItemId(int position) {
            try {
                return items.get(position).getId();
            } catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }

        @Override
        public int getItemPosition(Object object) {
            return POSITION_NONE;
        }

        @Override
        public CharSequence getPageTitle(int position) {
            try {
                SdkConfigObj.SubMenu item = items.get(position);
                int id = item.getId();
                if (item.getTitle() != null && !TextUtils.isEmpty(item.getTitle())) {
                    String title = item.getTitle();
                    txtTitle.setText(title);
                    if (NotificationUtils.hasNtf(activity, id)) {
                        Drawable image = Res.drawable(activity, R.drawable.ic_notification_tab_strip);
                        image.setBounds(0, 0, image.getIntrinsicWidth(), image.getIntrinsicHeight());
                        SpannableString sb = new SpannableString(title + "  ");
                        ImageSpan imageSpan = new ImageSpan(image, ImageSpan.ALIGN_BASELINE);
                        sb.setSpan(imageSpan, title.length() + 1, title.length() + 2, Spannable.SPAN_INCLUSIVE_INCLUSIVE);
                        return sb;
                    }
                    return title;
                } else {
                    return "Tab " + position;
                }

            } catch (Exception e) {
                e.printStackTrace();
                return "Tab " + position;
            }
        }

        private void releaseFragments() {
            try {
                if (fragments != null) {
                    for (MobGameWebFragment frag : fragments) {
                        frag.stopLoading();
                        fragmentManager.beginTransaction().remove(frag).commit();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void hideProgressBar() {
        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        circleProgressBar.setVisibility(View.GONE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        circleProgressBar.setVisibility(View.VISIBLE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FirebaseAnalytics mFirebaseAnalytics;

    private void trackEventFromButton(String eventName, String data) {
        try {
            Log.d(TAG, "event : " + eventName + " , data : " + data);
            mFirebaseAnalytics = FirebaseAnalytics.getInstance(activity);
            Bundle bundle = new Bundle();
            bundle.putString("data", data);
            mFirebaseAnalytics.logEvent(eventName, bundle);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EventListener getEventListener() {
        return eventListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public interface EventListener {
        void onDismissDashboard();
    }

}
