/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.js;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.listener.IPaymentListener;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.PurchaseUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.payment.PaymentFragment;
import com.game.sdk.ui.payment.PaymentPresenterImpl;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.api.ProcessPaypalReceiptTask;
import com.mobgame.utils.iab.IabHelper;
import com.mobgame.utils.iab.IabResult;
import com.mobgame.utils.iab.Inventory;
import com.mobgame.utils.iab.Purchase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.ResponseBody;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public final class CmdPayment {
    private static String TAG = CmdPayment.class.getSimpleName();
    private static CmdPayment INSTANCE;
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_IAB = 1;
    private static final int TYPE_PAYPAL = 2;
    private IabHelper mIabHelper;
    private ArrayList<String> listPendingPurchases = new ArrayList();
    private Activity activity;
    boolean mStartIAB = false;
    PaymentFragment.Listener listener;
    private IabHelper.OnIabSetupFinishedListener mOnIabSetupFinishedListener = new IabHelper.OnIabSetupFinishedListener(){

        @Override
        public void onIabSetupFinished(IabResult result) {
            try {
                Log.i((String)TAG, (String)"onIabSetupFinished");
                if (!result.isSuccess()) {
                    Log.i((String)TAG, (String)("Problem setting up In-app Billing: " + result));
                    Intent intent = new Intent("com.mobgame.broadcast");
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Problem setting up In-app Billing: " + result);
                    LocalBroadcastManager.getInstance((Context)CmdPayment.this.activity).sendBroadcast(intent);
                    return;
                }
                if (CmdPayment.this.mIabHelper != null) {
                    Log.i((String)TAG, (String)"mQueryInventoryFinishedListener 2");
                    CmdPayment.this.mIabHelper.queryInventoryAsync(CmdPayment.this.mQueryInventoryFinishedListener);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private IabHelper.QueryInventoryFinishedListener mQueryInventoryFinishedListener = new IabHelper.QueryInventoryFinishedListener(){

        @Override
        public void onQueryInventoryFinished(IabResult result, Inventory inv) {
            try {
                Log.i((String)TAG, (String)"onQueryInventoryFinished");
                if (!result.isSuccess()) {
                    Log.i((String)TAG, (String)("Problem setting up In-App-Billing" + result));
                    Intent intent = new Intent("com.mobgame.broadcast");
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Problem setting up In-app Billing: " + result);
                    LocalBroadcastManager.getInstance((Context)CmdPayment.this.activity).sendBroadcast(intent);
                    return;
                }
                if (inv.getAllPurchases().size() > 0) {
                    Log.i((String)TAG, (String)("inv.getAllPurchases().size() " + inv.getAllPurchases().size()));
                    CmdPayment.this.mIabHelper.consumeAsync(inv.getAllPurchases(), CmdPayment.this.mOnIabConsumeMultiFinishedListener);
                } else {
                    Log.i((String)TAG, (String)("listPendingPurchases 11" + CmdPayment.this.listPendingPurchases.size()));
                    if (CmdPayment.this.listPendingPurchases.size() > 0) {
                        Log.i((String)TAG, (String)("listPendingPurchases 2" + CmdPayment.this.listPendingPurchases.size()));
                        String sku = (String)CmdPayment.this.listPendingPurchases.get(CmdPayment.this.listPendingPurchases.size() - 1);
                        CmdPayment.this.listPendingPurchases.clear();
                        CmdPayment.this.mIabHelper.launchPurchaseFlowWithRetry(sku, 10001, CmdPayment.this.mOnIabPurchaseFinishedListener);
                        Log.i((String)TAG, (String)("listPendingPurchases 3" + CmdPayment.this.listPendingPurchases.size()));
                    } else {
                        Log.i((String)TAG, (String)"MobGameSDK.close() ");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private IabHelper.OnConsumeFinishedListener mOnIabConsumeFinishedListener = new IabHelper.OnConsumeFinishedListener(){

        @Override
        public void onConsumeFinished(Purchase purchase, IabResult result) {
            CmdPayment.this.handleConsume(purchase, result);
        }
    };
    private IabHelper.OnConsumeMultiFinishedListener mOnIabConsumeMultiFinishedListener = new IabHelper.OnConsumeMultiFinishedListener(){

        @Override
        public void onConsumeMultiFinished(List<Purchase> purchases, List<IabResult> results) {
            try {
                for (int i = 0; i < purchases.size(); ++i) {
                    CmdPayment.this.handleConsume(purchases.get(i), results.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private IabHelper.OnIabPurchaseFinishedListener mOnIabPurchaseFinishedListener = new IabHelper.OnIabPurchaseFinishedListener(){

        @Override
        public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
            try {
                Log.i((String)TAG, (String)"onIabPurchaseFinished");
                if (result.isFailure()) {
                    if (result.getResponse() != -1005) {
                        Log.i((String)TAG, (String)("Error purchasing: " + result));
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "payment");
                        intent.putExtra("status", false);
                        intent.putExtra("message", "Error IAB purchasing: " + result);
                        LocalBroadcastManager.getInstance((Context)CmdPayment.this.activity).sendBroadcast(intent);
                    }
                    return;
                }
                CmdPayment.this.mIabHelper.consumeAsync(purchase, CmdPayment.this.mOnIabConsumeFinishedListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private CmdPayment() {
    }

    public static CmdPayment getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdPayment();
        }
        return INSTANCE;
    }

    public void verifyPayment(final Activity mActivity, final PurchaseHistoryObj historyObj, final IPaymentListener iPaymentListener) {
        final VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setOrder_no(historyObj.getOrder_no());
        obj.setMethod("2");
        obj.setReceipt(historyObj.getReceipt());
        obj.setApp_version(Utils.getGameVersion((Context)mActivity));
        obj.setSdk_version(Utils.getSDKVersion((Context)mActivity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setResolution(DeviceUtils.getResolution((Context)mActivity));
        obj.setNetwork(Utils.getNetwork((Context)mActivity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID((Context)mActivity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID((Context)mActivity));
        obj.setLocale(GameConfigs.getInstance().getLang());
        PaymentPresenterImpl presenter = new PaymentPresenterImpl(new BaseView(){

            @Override
            public void showProgress(String message) {
                Utils.showLoading(mActivity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(mActivity, false);
            }

            public void success(Object x) {
                if (x instanceof VerifyPurchaseResponseObj) {
                    VerifyPurchaseResponseObj responseObj = (VerifyPurchaseResponseObj)x;
                    if (responseObj.getData().getStatus() == 3 || responseObj.getData().getStatus() == 2 || responseObj.getData().getStatus() == 17) {
                        LogUtils.e(TAG, "Verify Success - " + historyObj.getOrder_no());
                        PurchaseUtils.removeSuccessPurchase(historyObj, mActivity);
                        TrackingUtil.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                        if (iPaymentListener != null) {
                            iPaymentListener.onPaymentSuccess(responseObj.getData());
                        }
                    } else {
                        TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(responseObj.getData().getStatus()), responseObj.getData().getDescription());
                        DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.err_verify_purchase), new DialogUtils.DlgCloseListener(){

                            @Override
                            public void onClose() {
                            }
                        });
                    }
                }
            }

            public void error(Object o) {
                BaseObj apiErrorObj = (BaseObj)o;
                TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(apiErrorObj.getStatus()), apiErrorObj.getMessage());
                if (apiErrorObj.getStatus() == -100) {
                    DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.error_network));
                    return;
                }
                if (o instanceof VerifyPurchaseErrObj) {
                    VerifyPurchaseErrObj obj2 = (VerifyPurchaseErrObj)o;
                    if (obj2.getStatus() == 401) {
                        DialogUtils.showExpireDialog(mActivity);
                    } else {
                        final int count_time = mActivity.getIntent().getIntExtra("count_time", 0);
                        if (count_time <= 2) {
                            DialogUtils.showPaymentRetryDialog(mActivity, obj2.getMessage(), new DialogUtils.Listener(){

                                @Override
                                public void onRetry() {
                                    mActivity.getIntent().putExtra("count_time", count_time + 1);
                                    CmdPayment.this.verifyPayment(mActivity, historyObj, iPaymentListener);
                                }
                            });
                        } else {
                            DialogUtils.showErrorDialog(mActivity, obj2.getMessage(), new DialogUtils.DlgCloseListener(){

                                @Override
                                public void onClose() {
                                }
                            });
                        }
                    }
                }
            }
        });
        TrackingUtil.getInstance().trackPaymentBeforVerify(historyObj.getOrder_no());
        presenter.verifyPurchase(obj);
    }

    public void handleResult(Activity activity, int requestCode, int resultCode, Intent data) {
        this.activity = activity;
        switch (requestCode) {
            case 10001: {
                this.mIabHelper.handleActivityResult(requestCode, resultCode, data);
                break;
            }
        }
    }

    private void initPaypal(Activity activity) {
        Log.i((String)TAG, (String)"initPaypal");
    }

    private void sendPayPalConfirmToPlf(final Activity activity, String data) {
        new ProcessPaypalReceiptTask(data, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                try {
                    String responseBody = ((ResponseBody)response.body()).string();
                    CmdPayment.this.mobPaymentSuccess(activity, responseBody, 2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable e) {
            }
        });
    }

    public void mobPaymentStartIAP(Activity activity, String params, PaymentFragment.Listener listener) {
        this.listener = listener;
        Log.i((String)TAG, (String)("paymentStartIAP:" + params));
        this.activity = activity;
        this.initIAB(activity);
        try {
            JSONObject obj = new JSONObject(params);
            String product_id = obj.getString("product_id");
            HashMap<String, String> eventValue = new HashMap<String, String>();
            eventValue.put("product_id", product_id);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Value", product_id);
            this.listPendingPurchases.add(product_id);
            if (this.mIabHelper != null && this.mIabHelper.isSetupDone()) {
                Log.i((String)TAG, (String)"mQueryInventoryFinishedListener 1");
                this.mIabHelper.queryInventoryAsync(this.mQueryInventoryFinishedListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initIAB(Activity activity) {
        Log.i((String)TAG, (String)"initIAB");
        try {
            if (this.mIabHelper == null || !this.mIabHelper.getActivity().equals(activity)) {
                SdkConfigObj.GoogleIAB config = GameConfigs.getInstance().getGgIABConfig();
                this.mIabHelper = new IabHelper(activity);
                this.mIabHelper.startSetup(this.mOnIabSetupFinishedListener);
            }
            Log.i((String)TAG, (String)"init done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleConsume(Purchase purchase, IabResult result) {
        Log.i((String)TAG, (String)"onConsumeFinished");
        try {
            if (result.isFailure()) {
                if (result.getResponse() != -1005) {
                    Log.i((String)TAG, (String)("Error purchasing: " + result));
                    Intent intent = new Intent("com.mobgame.broadcast");
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Error IAB purchasing: " + result);
                    LocalBroadcastManager.getInstance((Context)this.activity).sendBroadcast(intent);
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)"purchase successful .");
        try {
            if (this.listener != null) {
                this.listener.onProcessIAB(purchase);
            }
            Log.i((String)TAG, (String)"mQueryInventoryFinishedListener 3");
            MobGameSDK.getInstance().close();
            this.mIabHelper.queryInventoryAsync(this.mQueryInventoryFinishedListener);
        }
        catch (Exception e) {
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "payment");
            intent.putExtra("status", false);
            intent.putExtra("message", e.getMessage());
            LocalBroadcastManager.getInstance((Context)this.activity).sendBroadcast(intent);
        }
    }

    void mobPaymentSuccess(Activity activity, String params) {
        this.mobPaymentSuccess(activity, params, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mobPaymentSuccess(Activity activity, String params, int type) {
        Log.i((String)TAG, (String)"mobPaymentSuccess");
        try {
            JSONObject order = new JSONObject(params);
            if (order != null && order.getString("status").equals("0")) {
                String userId = order.getString("user_id");
                String orderId = order.getString("order_id");
                String orderProduct = order.getString("order_product");
                String orderInfo = order.getString("details");
                String orderTime = order.getString("time");
                String platformPrice = order.getString("platform_price");
                String gamePrice = order.getString("game_price");
                String state = "";
                String game_role_id = "";
                String game_area_id = "";
                String is_sandbox = "";
                if (order.has("state")) {
                    state = order.getString("state");
                }
                if (order.has("game_role_id")) {
                    game_role_id = order.getString("game_role_id");
                }
                if (order.has("game_area_id")) {
                    game_area_id = order.getString("game_area_id");
                }
                if (order.has("is_sandbox")) {
                    is_sandbox = order.getString("is_sandbox");
                }
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", "payment");
                intent.putExtra("status", true);
                intent.putExtra("user_id", userId);
                intent.putExtra("order_id", orderId);
                intent.putExtra("order_product", orderProduct);
                intent.putExtra("order_info", orderInfo);
                intent.putExtra("order_time", orderTime);
                intent.putExtra("platform_price", platformPrice);
                intent.putExtra("game_price", gamePrice);
                intent.putExtra("state", state);
                intent.putExtra("game_role_id", game_role_id);
                intent.putExtra("game_area_id", game_area_id);
                intent.putExtra("is_sandbox", is_sandbox);
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
            } else {
                Log.i((String)TAG, (String)"on pay failed");
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", "payment");
                intent.putExtra("status", false);
                intent.putExtra("message", "Error purchasing");
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
            }
        }
        catch (Exception e) {
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "payment");
            intent.putExtra("status", false);
            intent.putExtra("message", e.getMessage());
            LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
        }
        finally {
            switch (type) {
                case 0: 
                case 2: {
                    MobGameSDK.getInstance().close();
                    break;
                }
            }
        }
    }
}

