/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.dialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v13.app.FragmentPagerAdapter;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.Utils;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.mobgame.MobGameHelper;
import com.mobgame.R;
import com.mobgame.gui.MobGamePagerFragment;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.view.adapter.DashboardMenuAdapter;
import com.mobgame.listener.RecyclerItemClickListener;
import com.mobgame.model.ItemMenuDashboard;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import java.util.ArrayList;
import java.util.List;

public class MobGameDashboardNewDialog
extends DialogFragment {
    public static final String TAG = MobGameDashboardNewDialog.class.getSimpleName();
    public static final String CLOSE_PROGRESS_BAR = "close_progress_bar";
    public static String KEY_DATA = "data";
    public static String KEY_ID = "parent_id";
    public static String KEY_ICON = "icon";
    public static boolean isDashBoard = true;
    EventListener eventListener;
    private ImageView btnClose;
    private RecyclerView mRecycleView;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout layoutMainDashboard;
    private TextView txtTitle;
    private ProgressBar circleProgressBar;
    private View rootView;
    private View layoutChildContent;
    private View layoutTmp;
    private MobGamePagerFragment fragContent;
    private MobPagerAdapter adapter;
    private DashboardMenuAdapter menuAdapter;
    private boolean isLandscape;
    private boolean isTabletSize;
    private int currentPage;
    private List<ItemMenuDashboard> listItemMenuDashboard = new ArrayList<ItemMenuDashboard>();
    private final String TAG_FRAGMENT = "fragment_webview";
    private String data;
    private Activity activity;
    ItemMenuDashboard selectedItem;
    private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener(){

        @Override
        @SuppressLint(value={"JavascriptInterface"})
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                MobGameDashboardNewDialog.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameWebFragment fragWeb = MobGameDashboardNewDialog.this.adapter.getItem(MobGameDashboardNewDialog.this.currentPage);
                        Log.i((String)TAG, (String)("fragContent.countTabs(): " + MobGameDashboardNewDialog.this.fragContent.countTabs()));
                        if (Utils.isOnline((Context)MobGameDashboardNewDialog.this.activity)) {
                            if (MobGameDashboardNewDialog.this.fragContent.countTabs() > 1 && !fragWeb.canGoBack()) {
                                MobGameDashboardNewDialog.this.fragContent.showTabs(false);
                                new Handler().postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                    }
                                }, 1000L);
                            } else {
                                MobGameDashboardNewDialog.this.fragContent.hideTabs(true);
                            }
                        } else if (MobGameDashboardNewDialog.this.fragContent.countTabs() > 1) {
                            MobGameDashboardNewDialog.this.fragContent.showTabs(false);
                        } else {
                            MobGameDashboardNewDialog.this.fragContent.hideTabs(false);
                        }
                    }
                });
                view.addJavascriptInterface((Object)MobGameDashboardNewDialog.this.activity, "android");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            int pos = Integer.parseInt((String)view.getTag());
            if (pos == MobGameDashboardNewDialog.this.currentPage) {
                progress = Math.max(1, progress);
                MobGameDashboardNewDialog.this.circleProgressBar.setProgress(progress);
                if (progress == 100) {
                    MobGameDashboardNewDialog.this.hideProgressBar();
                } else {
                    MobGameDashboardNewDialog.this.showProgressBar();
                }
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            int pos = Integer.parseInt((String)view.getTag());
            if (pos == MobGameDashboardNewDialog.this.currentPage) {
                MobGameDashboardNewDialog.this.hideProgressBar();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {
        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }
    };
    private ViewPager.SimpleOnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            if (position != MobGameDashboardNewDialog.this.currentPage) {
                MobGameDashboardNewDialog.this.currentPage = position;
                MobGameWebFragment fragWeb = MobGameDashboardNewDialog.this.adapter.getItem(MobGameDashboardNewDialog.this.currentPage);
                fragWeb.loadUrlToLoadIfHave();
                MobGameDashboardNewDialog.this.mWebEventListener.onScrollChanged(fragWeb.getWebView(), fragWeb.getScrollX(), fragWeb.getScrollY(), fragWeb.getScrollX(), fragWeb.getScrollY());
            }
            int itemId = (int)MobGameDashboardNewDialog.this.adapter.getItemId(position);
            if (NotificationUtils.hasNtf((Context)MobGameDashboardNewDialog.this.activity, itemId)) {
                MobGameDashboardNewDialog.this.hideNtf(itemId);
                MobGameDashboardNewDialog.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameDashboardNewDialog.this.fragContent.notifiTabsChanged();
                    }
                });
            }
        }
    };
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                String category = intent.getStringExtra("category");
                if ("gcm".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    Log.d((String)TAG, (String)("funtap :" + strId));
                    if (strId != null) {
                        MobGameDashboardNewDialog.this.fragContent.notifiTabsChanged();
                    }
                    int id2 = Integer.parseInt(strId);
                    MobGameDashboardNewDialog.this.showNtf(id2);
                } else if ("swipe_refresh".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    int id3 = Integer.parseInt(strId);
                    MobGameDashboardNewDialog.this.hideNtf(id3);
                    MobGameDashboardNewDialog.this.fragContent.notifiTabsChanged();
                }
                if (intent.hasExtra(MobGameDashboardNewDialog.CLOSE_PROGRESS_BAR)) {
                    MobGameDashboardNewDialog.this.circleProgressBar.setVisibility(8);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private FirebaseAnalytics mFirebaseAnalytics;

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.eventListener != null) {
            this.eventListener.onDismissDashboard();
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.activity = this.getActivity();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.isTabletSize = this.getResources().getBoolean(R.bool.isTablet);
        this.rootView = this.isTabletSize ? inflater.inflate(R.layout.dialog_dashboard_new_tablet, container, false) : inflater.inflate(R.layout.dialog_dashboard_new, container, false);
        try {
            this.isLandscape = DeviceUtils.getScreenOrientation(this.rootView.getContext()) == 2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getDialog().getWindow().setFlags(1024, 1024);
        this.getDialog().requestWindowFeature(1);
        this.getDialog().getWindow().getAttributes().windowAnimations = R.style.DashBoardDialogAnimation;
        isDashBoard = true;
        this.initViewLayout();
        this.initFragment();
        this.setUpListener();
        if (this.selectedItem != null) {
            this.loadItemData(this.selectedItem);
        }
        return this.rootView;
    }

    private List<ItemMenuDashboard> getDataItemDashboard(ArrayList<SdkConfigObj.Menu> listMenuItems) {
        ArrayList<ItemMenuDashboard> listMenuDashboard = new ArrayList<ItemMenuDashboard>();
        block0: for (int i = listMenuItems.size() - 1; i >= 0; --i) {
            ItemMenuDashboard itemMenuDashboard = new ItemMenuDashboard();
            itemMenuDashboard = this.setDataToItemMenuDashboard(listMenuItems.get(i));
            if (listMenuDashboard.size() == 0) {
                itemMenuDashboard.setClick(true);
                this.selectedItem = itemMenuDashboard;
                listMenuDashboard.add(itemMenuDashboard);
                continue;
            }
            for (int j = listMenuDashboard.size() - 1; j >= 0; --j) {
                if (j != 0 & ((ItemMenuDashboard)listMenuDashboard.get(j)).getPriority() < itemMenuDashboard.getPriority()) {
                    ((ItemMenuDashboard)listMenuDashboard.get(j)).setClick(false);
                    itemMenuDashboard.setClick(true);
                    this.selectedItem = itemMenuDashboard;
                    listMenuDashboard.add(j, itemMenuDashboard);
                    continue block0;
                }
                if (j == 0 & ((ItemMenuDashboard)listMenuDashboard.get(j)).getPriority() < itemMenuDashboard.getPriority()) {
                    ((ItemMenuDashboard)listMenuDashboard.get(j)).setClick(false);
                    itemMenuDashboard.setClick(true);
                    this.selectedItem = itemMenuDashboard;
                    listMenuDashboard.add(itemMenuDashboard);
                    continue;
                }
                if (!(j == 0 & ((ItemMenuDashboard)listMenuDashboard.get(j)).getPriority() > itemMenuDashboard.getPriority())) continue;
                listMenuDashboard.add(itemMenuDashboard);
            }
        }
        return listMenuDashboard;
    }

    private ItemMenuDashboard setDataToItemMenuDashboard(SdkConfigObj.Menu mobMenuItem) {
        ItemMenuDashboard itemMenuDashboard = new ItemMenuDashboard();
        int idMenu = mobMenuItem.getId();
        itemMenuDashboard.setId_menu(idMenu);
        String title = mobMenuItem.getTitle();
        itemMenuDashboard.setTitle_menu(title);
        ArrayList<SdkConfigObj.SubMenu> SubIdMenus = mobMenuItem.getSubMenu();
        itemMenuDashboard.setSubId_menu(SubIdMenus);
        String urlIcon = mobMenuItem.getIcon();
        itemMenuDashboard.setUrlIcon(urlIcon);
        String urlIconActive = mobMenuItem.getIconActive();
        itemMenuDashboard.setUrlIconActive(urlIconActive);
        itemMenuDashboard.setPriority(mobMenuItem.getPriority());
        itemMenuDashboard.setOpenType(0);
        if ((NotificationUtils.hasNtf((Context)this.activity, 2) || NotificationUtils.hasNtf((Context)this.activity, 3)) && idMenu == 1) {
            itemMenuDashboard.setHasNtf(true);
        }
        if ((NotificationUtils.hasNtf((Context)this.activity, 5) || NotificationUtils.hasNtf((Context)this.activity, 4)) && idMenu == 4) {
            itemMenuDashboard.setHasNtf(true);
        }
        if ((NotificationUtils.hasNtf((Context)this.activity, 7) || NotificationUtils.hasNtf((Context)this.activity, 6)) && idMenu == 6) {
            itemMenuDashboard.setHasNtf(true);
        }
        return itemMenuDashboard;
    }

    private void initFragment() {
        try {
            this.fragContent = new MobGamePagerFragment(this.activity);
            this.fragContent.addOnPageChangeListener(this.mOnPageChangeListener);
            this.fragContent.setWebEventListener(this.mWebEventListener);
            this.getChildFragmentManager().beginTransaction().add(this.layoutChildContent.getId(), (Fragment)this.fragContent, "fragment_webview").commit();
            try {
                this.data = this.getArguments().getString(KEY_DATA);
            }
            catch (Exception e) {
                try {
                    this.performOnItemClick(0);
                }
                catch (IndexOutOfBoundsException | NullPointerException e2) {
                    this.performOnItemClick(0);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initViewLayout() {
        try {
            if (this.isTabletSize || this.isLandscape) {
                this.layoutMainDashboard = (LinearLayout)this.rootView.findViewById(R.id.layout_main_dashboard);
            }
            this.layoutTmp = this.rootView.findViewById(R.id.layout_tmp);
            this.layoutChildContent = this.rootView.findViewById(R.id.layout_child_content);
            this.txtTitle = (TextView)this.rootView.findViewById(R.id.title_item);
            this.btnClose = (ImageView)this.rootView.findViewById(R.id.btn_close);
            this.mRecycleView = (RecyclerView)this.rootView.findViewById(R.id.recycleview_menu);
            this.layoutManager = new LinearLayoutManager((Context)this.activity);
            this.mRecycleView.setLayoutManager(this.layoutManager);
            this.circleProgressBar = (ProgressBar)this.rootView.findViewById(R.id.circle_progress_bar);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpListener() {
        try {
            ArrayList<SdkConfigObj.Menu> listMenuItems = new ArrayList<SdkConfigObj.Menu>();
            if (GameConfigs.getInstance().getSdkConfig() != null && GameConfigs.getInstance().getSdkConfig().getMenu() != null) {
                listMenuItems.addAll(GameConfigs.getInstance().getSdkConfig().getMenu());
            }
            this.listItemMenuDashboard = this.getDataItemDashboard(listMenuItems);
            this.menuAdapter = new DashboardMenuAdapter(this.listItemMenuDashboard, (Context)this.activity, this.isLandscape, this.isTabletSize);
            this.mRecycleView.setAdapter((RecyclerView.Adapter)this.menuAdapter);
            this.btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    isDashBoard = false;
                    MobGameDashboardNewDialog.this.dismiss();
                    SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
                    if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                        MobGameHelper.showNotiFloatButton(game.getEx());
                    }
                    Preference.remove((Context)MobGameDashboardNewDialog.this.activity, "shared_pref_show_dashboard");
                    Intent intent = new Intent("com.mobgame.broadcast");
                    intent.putExtra("category", "is_showads");
                    LocalBroadcastManager.getInstance((Context)MobGameDashboardNewDialog.this.activity).sendBroadcast(intent);
                }
            });
            if (this.isTabletSize || this.isLandscape) {
                this.layoutMainDashboard.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        try {
                            MobGameDashboardNewDialog.this.layoutTmp.setVisibility(8);
                            MobGameDashboardNewDialog.this.dismiss();
                            SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
                            if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                                MobGameHelper.showNotiFloatButton(game.getEx());
                            }
                            Preference.remove((Context)MobGameDashboardNewDialog.this.activity, "shared_pref_show_dashboard");
                            Intent intent = new Intent("com.mobgame.broadcast");
                            intent.putExtra("category", "is_showads");
                            LocalBroadcastManager.getInstance((Context)MobGameDashboardNewDialog.this.activity).sendBroadcast(intent);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            this.layoutTmp.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        MobGameDashboardNewDialog.this.layoutTmp.setVisibility(8);
                        MobGameDashboardNewDialog.this.dismiss();
                        SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
                        if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                            MobGameHelper.showNotiFloatButton(game.getEx());
                        }
                        Preference.remove((Context)MobGameDashboardNewDialog.this.activity, "shared_pref_show_dashboard");
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "is_showads");
                        LocalBroadcastManager.getInstance((Context)MobGameDashboardNewDialog.this.activity).sendBroadcast(intent);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialogInterface, int keyCode, KeyEvent event) {
                    if (event != null && keyCode == 4 && event.getAction() == 1) {
                        try {
                            MobGameDashboardNewDialog.this.dismiss();
                            SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
                            if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                                MobGameHelper.showNotiFloatButton(game.getEx());
                            }
                            Preference.remove((Context)MobGameDashboardNewDialog.this.activity, "shared_pref_show_dashboard");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return true;
                    }
                    return false;
                }
            });
            Preference.save((Context)this.activity, "shared_pref_show_dashboard", true);
            this.mRecycleView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener((Context)this.activity, this.mRecycleView, new RecyclerItemClickListener.OnItemClickListener(){

                @Override
                public void onItemClick(View view, int position) {
                    try {
                        ItemMenuDashboard itemMenuDashboard = (ItemMenuDashboard)MobGameDashboardNewDialog.this.listItemMenuDashboard.get(position);
                        switch (itemMenuDashboard.getOpenType()) {
                            case 0: {
                                for (int i = 0; i < MobGameDashboardNewDialog.this.listItemMenuDashboard.size(); ++i) {
                                    if (i == position) {
                                        ((ItemMenuDashboard)MobGameDashboardNewDialog.this.listItemMenuDashboard.get(i)).setClick(true);
                                        continue;
                                    }
                                    ((ItemMenuDashboard)MobGameDashboardNewDialog.this.listItemMenuDashboard.get(i)).setClick(false);
                                }
                                MobGameDashboardNewDialog.this.menuAdapter.notifyDataSetChanged();
                                MobGameDashboardNewDialog.this.loadItemData(itemMenuDashboard);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onItemLongClick(View view, int position) {
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadItemData(ItemMenuDashboard itemMenuDashboard) {
        if (itemMenuDashboard.getSubId_menu() == null) {
            Log.d((String)TAG, (String)"SubMenu null");
            return;
        }
        this.txtTitle.setVisibility(0);
        this.loadUrls(itemMenuDashboard.getSubId_menu());
        switch (itemMenuDashboard.getId_menu()) {
            case 1: {
                this.txtTitle.setVisibility(8);
                if (!NotificationUtils.hasNtf((Context)this.activity, 2) && !NotificationUtils.hasNtf((Context)this.activity, 3)) {
                    itemMenuDashboard.setHasNtf(false);
                }
                Log.d((String)TAG, (String)"addOnItemTouchListener : 1");
                this.handleNewEvent();
                this.menuAdapter.notifyDataSetChanged();
                break;
            }
            case 4: {
                itemMenuDashboard.setHasNtf(false);
                this.menuAdapter.notifyDataSetChanged();
                Log.d((String)TAG, (String)"addOnItemTouchListener : 4");
                this.handleGiftcode();
                break;
            }
            case 6: {
                itemMenuDashboard.setHasNtf(false);
                this.menuAdapter.notifyDataSetChanged();
                Log.d((String)TAG, (String)"addOnItemTouchListener : 6");
                this.handleBug();
                break;
            }
            case 8: {
                Log.d((String)TAG, (String)"addOnItemTouchListener : 8");
                this.handleOther();
                break;
            }
            case 10: {
                Toast.makeText((Context)this.activity, (CharSequence)"id : 10", (int)0).show();
            }
        }
    }

    private void handleOther() {
        this.hideTabs();
        isDashBoard = false;
    }

    private void handleBug() {
        if (NotificationUtils.hasNtf((Context)this.activity, 7)) {
            NotificationUtils.removeNtf((Context)this.activity, 7);
        }
        if (NotificationUtils.hasNtf((Context)this.activity, 6)) {
            NotificationUtils.removeNtf((Context)this.activity, 6);
        }
        this.hideTabs();
        isDashBoard = false;
        this.trackEventFromButton("event_report_bugs", "root_report_bugs");
    }

    private void handleGiftcode() {
        try {
            if (NotificationUtils.hasNtf((Context)this.activity, 5)) {
                NotificationUtils.removeNtf((Context)this.activity, 5);
            }
            if (NotificationUtils.hasNtf((Context)this.activity, 4)) {
                NotificationUtils.removeNtf((Context)this.activity, 4);
            }
            this.hideTabs();
            isDashBoard = false;
            this.trackEventFromButton("event_giftcode", "root_giftcode");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleNewEvent() {
        try {
            this.showTabs();
            isDashBoard = true;
            this.trackEventFromButton("event_news_event", "root_news_event");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showTabs() {
        try {
            if (this.fragContent != null) {
                this.fragContent.showTabs(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideTabs() {
        try {
            if (this.fragContent != null) {
                this.fragContent.hideTabs(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        this.setStyle(1, 0x1030010);
        super.onCreate(savedInstanceState);
    }

    private void performOnItemClick(int position) {
    }

    public void loadUrls(ArrayList<SdkConfigObj.SubMenu> items) {
        LogUtils.i(TAG, "item:" + items.toString());
        if (this.adapter == null) {
            this.adapter = new MobPagerAdapter(this.getChildFragmentManager());
        }
        this.currentPage = 0;
        for (int i = items.size() - 1; i >= 0; --i) {
            try {
                SdkConfigObj.SubMenu item = items.get(i);
                if (item.getPriority() <= this.currentPage) continue;
                this.currentPage = i;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.adapter.setItems(items);
        this.fragContent.setAdapter(this.adapter, this.currentPage);
    }

    public void show(FragmentManager manager, String tag) {
        try {
            FragmentTransaction ft = manager.beginTransaction();
            ft.add((Fragment)this, tag);
            ft.commitAllowingStateLoss();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        super.onPause();
        try {
            LocalBroadcastManager.getInstance((Context)this.activity).unregisterReceiver(this.mBroadcastReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance((Context)this.activity).registerReceiver(this.mBroadcastReceiver, new IntentFilter("com.mobgame.broadcast"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showNtf(int id2) {
        if (NotificationUtils.hasNtf((Context)this.activity, id2)) {
            block0 : switch (id2) {
                case 2: 
                case 3: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 1) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 4: 
                case 5: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 4) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 6: 
                case 7: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 6) continue;
                        this.listItemMenuDashboard.get(i).setHasNtf(true);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    private void hideNtf(int id2) {
        if (NotificationUtils.hasNtf((Context)this.activity, id2)) {
            block0 : switch (id2) {
                case 2: 
                case 3: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 1) continue;
                        NotificationUtils.removeNtf((Context)this.activity, id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 4: 
                case 5: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 4) continue;
                        NotificationUtils.removeNtf((Context)this.activity, id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
                case 6: 
                case 7: {
                    for (int i = 0; i < this.listItemMenuDashboard.size(); ++i) {
                        if (this.listItemMenuDashboard.get(i).getId_menu() != 6) continue;
                        NotificationUtils.removeNtf((Context)this.activity, id2);
                        this.listItemMenuDashboard.get(i).setHasNtf(false);
                        this.menuAdapter.notifyDataSetChanged();
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    private void hideProgressBar() {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MobGameDashboardNewDialog.this.circleProgressBar.setVisibility(8);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MobGameDashboardNewDialog.this.circleProgressBar.setVisibility(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackEventFromButton(String eventName, String data) {
        try {
            Log.d((String)TAG, (String)("event : " + eventName + " , data : " + data));
            this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)this.activity);
            Bundle bundle = new Bundle();
            bundle.putString("data", data);
            this.mFirebaseAnalytics.logEvent(eventName, bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public static interface EventListener {
        public void onDismissDashboard();
    }

    private class MobPagerAdapter
    extends FragmentPagerAdapter {
        private ArrayList<MobGameWebFragment> fragments;
        private FragmentManager fragmentManager;
        private ArrayList<SdkConfigObj.SubMenu> items;

        public MobPagerAdapter(FragmentManager fm) {
            super(fm);
            this.fragments = new ArrayList();
            this.fragmentManager = fm;
        }

        public void setItems(ArrayList<SdkConfigObj.SubMenu> items) {
            this.releaseFragments();
            this.items = items;
            this.fragments = new ArrayList();
            for (int i = 0; i < items.size(); ++i) {
                SdkConfigObj.SubMenu item = items.get(i);
                String url = item.getAction();
                int id2 = item.getId();
                MobGameWebFragment frag = i == MobGameDashboardNewDialog.this.currentPage ? new MobGameWebFragment(url, id2) : new MobGameWebFragment(url, true, id2);
                frag.setEventListener(MobGameDashboardNewDialog.this.mWebEventListener);
                frag.setWebViewTag(i + "");
                this.fragments.add(frag);
            }
        }

        public MobGameWebFragment getItem(int position) {
            try {
                return this.fragments.get(position);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getCount() {
            try {
                return this.fragments.size();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public long getItemId(int position) {
            try {
                return this.items.get(position).getId();
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1L;
            }
        }

        public int getItemPosition(Object object) {
            return -2;
        }

        public CharSequence getPageTitle(int position) {
            try {
                SdkConfigObj.SubMenu item = this.items.get(position);
                int id2 = item.getId();
                if (item.getTitle() != null && !TextUtils.isEmpty((CharSequence)item.getTitle())) {
                    String title = item.getTitle();
                    MobGameDashboardNewDialog.this.txtTitle.setText((CharSequence)title);
                    if (NotificationUtils.hasNtf((Context)MobGameDashboardNewDialog.this.activity, id2)) {
                        Drawable image = Res.drawable((Context)MobGameDashboardNewDialog.this.activity, R.drawable.ic_notification_tab_strip);
                        image.setBounds(0, 0, image.getIntrinsicWidth(), image.getIntrinsicHeight());
                        SpannableString sb = new SpannableString((CharSequence)(title + "  "));
                        ImageSpan imageSpan = new ImageSpan(image, 1);
                        sb.setSpan((Object)imageSpan, title.length() + 1, title.length() + 2, 18);
                        return sb;
                    }
                    return title;
                }
                return "Tab " + position;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Tab " + position;
            }
        }

        private void releaseFragments() {
            try {
                if (this.fragments != null) {
                    for (MobGameWebFragment frag : this.fragments) {
                        frag.stopLoading();
                        this.fragmentManager.beginTransaction().remove((Fragment)frag).commit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

