/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.ui.payment;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.BaseDialogWebFragment;
import com.game.sdk.comon.js.JsBase;
import com.game.sdk.comon.js.JsPayment;
import com.game.sdk.comon.listener.IWebViewClientListener;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.ListPurchaseHistoryObj;
import com.game.sdk.comon.object.ProductObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.PurchaseUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.payment.IPaymentPresenter;
import com.game.sdk.ui.payment.PaymentPresenterImpl;
import com.mobgame.R;
import com.mobgame.js.CmdPayment;
import com.mobgame.utils.iab.Purchase;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentFragment
extends BaseDialogWebFragment {
    public static String TAG = PaymentFragment.class.getSimpleName();
    IPaymentPresenter iPaymentPresenter;
    String account_id;
    int curent;
    PurchaseHistoryObj currentPurchase;
    PaymentGGSuccess paymentGGSuccess;
    boolean sendHistory;
    ArrayList<IPaymentPresenter> listPresenter;

    public static PaymentFragment newInstance(String url, PaymentGGSuccess paymentGGSuccess) {
        PaymentFragment frag = new PaymentFragment();
        Bundle args = new Bundle();
        args.putString(URL_WEBVIEW, url);
        LogUtils.d(TAG, url);
        frag.setArguments(args);
        frag.setPaymentGGSuccess(paymentGGSuccess);
        return frag;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            TrackingUtil.getInstance().trackPaymentScreenOpened();
            this.account_id = GameConfigs.getInstance().getUser().getAccount().getAccountId();
            this.listPresenter = new ArrayList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.curent = -1;
        this.sendHistory = false;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.sendHistory) {
            this.sendHistory = true;
        }
    }

    public void sendHistory(final PurchaseHistoryObj obj) {
        PaymentPresenterImpl presenter = new PaymentPresenterImpl(new BaseView(){

            @Override
            public void showProgress(String message) {
            }

            @Override
            public void hideProgress() {
            }

            public void success(Object x) {
                if (x instanceof VerifyPurchaseResponseObj) {
                    VerifyPurchaseResponseObj responseObj = (VerifyPurchaseResponseObj)x;
                    int status = responseObj.getData().getStatus();
                    if (status == 3 || status == 2 || status == 17) {
                        TrackingUtil.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                    } else {
                        TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(status), responseObj.getData().getDescription());
                    }
                    obj.setAccount_id(PaymentFragment.this.account_id);
                    PurchaseUtils.removeSuccessPurchase(obj, PaymentFragment.this.mActivity);
                    --PaymentFragment.this.curent;
                    PaymentFragment.this.checkPurchaseHistory();
                    LogUtils.e(TAG, "Verify Success - " + obj.getOrder_no());
                }
            }

            public void error(Object o) {
                BaseObj err;
                if (o instanceof VerifyPurchaseErrObj) {
                    err = (VerifyPurchaseErrObj)o;
                    LogUtils.e(TAG, "Verify failed - " + obj.getOrder_no() + " :" + err.getMessage());
                    PaymentFragment.this.checkPurchaseHistory();
                }
                if (o instanceof BaseObj) {
                    err = (BaseObj)o;
                    TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(err.getStatus()), err.getMessage());
                }
            }
        });
        TrackingUtil.getInstance().trackPaymentBeforVerify(obj.getOrder_no());
        this.listPresenter.add(presenter);
        this.onVerifyPurchase(presenter, obj.getReceipt(), obj.getOrder_no());
    }

    public void checkPurchaseHistory() {
        ++this.curent;
        ListPurchaseHistoryObj listPurchaseHistoryObj = PrefManager.getHistoryPurchase((Context)this.mActivity, this.account_id);
        if (listPurchaseHistoryObj.getData() == null || listPurchaseHistoryObj.getData().size() == 0 || listPurchaseHistoryObj.getData().size() <= this.curent && this.curent >= 0) {
            return;
        }
        PurchaseHistoryObj obj = listPurchaseHistoryObj.getData().get(this.curent);
        this.sendHistory(obj);
    }

    public void onVerifyPurchase(IPaymentPresenter presenter, VerifyPurchaseRequestObj.Receipt receipt, String order_no) {
        VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setOrder_no(order_no);
        obj.setMethod("2");
        obj.setReceipt(receipt);
        obj.setApp_version(Utils.getGameVersion((Context)this.mActivity));
        obj.setSdk_version(Utils.getSDKVersion((Context)this.mActivity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setResolution(DeviceUtils.getResolution((Context)this.mActivity));
        obj.setNetwork(Utils.getNetwork((Context)this.mActivity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID((Context)this.mActivity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID((Context)this.mActivity));
        obj.setLocale(GameConfigs.getInstance().getLang());
        if (presenter != null) {
            presenter.verifyPurchase(obj);
        }
    }

    @Override
    protected JsBase getJsHandler() {
        return new JsPayment(new JsPayment.Listener(){

            @Override
            public void onPaymentStartIAP(String params) {
                final ProductObj obj = new ProductObj(params);
                if (TextUtils.isEmpty((CharSequence)obj.getOrder_no())) {
                    DialogUtils.showErrorDialog(PaymentFragment.this.mActivity, PaymentFragment.this.mActivity.getString(R.string.err_and_try_again_late));
                    return;
                }
                CmdPayment.getInstance().mobPaymentStartIAP(PaymentFragment.this.mActivity, params, new Listener(){

                    @Override
                    public void onProcessIAB(Purchase purchase) {
                        PaymentFragment.this.currentPurchase = new PurchaseHistoryObj();
                        String charactor_id = PrefManager.getString((Context)PaymentFragment.this.mActivity, "MOB_ROLE_ID", "");
                        String area_id = PrefManager.getString((Context)PaymentFragment.this.mActivity, "MOB_AREA_ID", "");
                        PaymentFragment.this.currentPurchase.setArea_id(area_id);
                        PaymentFragment.this.currentPurchase.setCharactor_id(charactor_id);
                        PaymentFragment.this.currentPurchase.setOrder_no(obj.getOrder_no());
                        try {
                            JSONObject joReceipt = new JSONObject(purchase.getOriginalJson());
                            VerifyPurchaseRequestObj.Receipt rec = new VerifyPurchaseRequestObj.Receipt();
                            rec.setData(joReceipt.toString());
                            rec.setItemType("inapp");
                            rec.setSignature(purchase.getSignature());
                            PaymentFragment.this.currentPurchase.setReceipt(rec);
                        }
                        catch (JSONException e) {
                            LogUtils.e("Err Purchase", e.getMessage());
                        }
                        PaymentFragment.this.currentPurchase.setIs_send(false);
                        PaymentFragment.this.currentPurchase.setAccount_id(PaymentFragment.this.account_id);
                        LogUtils.d("RECEIPT 1", purchase.getOriginalJson());
                        for (IPaymentPresenter p : PaymentFragment.this.listPresenter) {
                            if (p == null) continue;
                            p.cancelRequest(new String[0]);
                        }
                        PrefManager.saveUsePurchaseHistory((Context)PaymentFragment.this.mActivity, PaymentFragment.this.account_id, PaymentFragment.this.currentPurchase);
                        if (PaymentFragment.this.paymentGGSuccess != null) {
                            PaymentFragment.this.dismiss();
                            PaymentFragment.this.paymentGGSuccess.onPaymentGGSuccess(PaymentFragment.this.currentPurchase);
                        }
                    }
                });
            }

            @Override
            public void onCloseWindow() {
                PaymentFragment.this.dismiss();
            }

            @Override
            public void onOpenWindow() {
            }

            @Override
            public void onBackToWindowns() {
                PaymentFragment.this.goBack();
            }
        });
    }

    @Override
    protected IWebViewClientListener getWebListener() {
        return new IWebViewClientListener(){

            @Override
            public void shouldOverrideUrlLoading(WebView view, String url) {
            }

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
            }

            @Override
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                TrackingUtil.getInstance().trackPaymentLoadScreenFail(String.valueOf(errorCode), description);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                TrackingUtil.getInstance().trackPaymentLoadScreenSuccess();
            }
        };
    }

    public void setPaymentGGSuccess(PaymentGGSuccess paymentGGSuccess) {
        this.paymentGGSuccess = paymentGGSuccess;
    }

    public static interface PaymentGGSuccess {
        public void onPaymentGGSuccess(PurchaseHistoryObj var1);
    }

    public static interface Listener {
        public void onProcessIAB(Purchase var1);
    }
}

