/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.login;

import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.listener.IAuthentFBListener;
import java.security.MessageDigest;
import java.util.Arrays;

public class FacebookManager {
    private static FacebookManager facebookManager;
    private Context context;
    private CallbackManager callbackManager;
    Handler mHandler;
    Runnable runnable;

    public static FacebookManager getInstance(Context context) {
        if (facebookManager == null) {
            facebookManager = new FacebookManager(context);
        }
        return facebookManager;
    }

    public FacebookManager(Context context) {
        this.context = context;
    }

    public void init(String applicationId) {
        FacebookSdk.setApplicationId((String)applicationId);
        FacebookSdk.fullyInitialize();
        AppEventsLogger.activateApp((Application)GameSdk.getInstance().getApplication());
        this.callbackManager = CallbackManager.Factory.create();
        this.mHandler = new Handler();
    }

    public void startAuth(final Fragment fragment, final @NonNull IAuthentFBListener listener) {
        if (this.mHandler != null && this.runnable != null) {
            this.mHandler.removeCallbacks(this.runnable);
        }
        this.logout();
        this.runnable = new Runnable(){

            @Override
            public void run() {
                LoginManager.getInstance().registerCallback(FacebookManager.this.callbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

                    public void onSuccess(LoginResult loginResult) {
                        listener.onAuthFBSuccess(loginResult);
                    }

                    public void onCancel() {
                        listener.onAuthFBCancel();
                    }

                    public void onError(FacebookException error) {
                        listener.onAuthFBFailed(error);
                    }
                });
                LoginManager.getInstance().logInWithReadPermissions(fragment, Arrays.asList("public_profile", "email"));
            }
        };
        this.mHandler.postDelayed(this.runnable, 300L);
    }

    public void logout() {
        LoginManager.getInstance().logOut();
    }

    public void onAuthResult(int requestCode, int resultCode, @Nullable Intent data) {
        this.callbackManager.onActivityResult(requestCode, resultCode, data);
    }

    public String getHashkey(Context c) {
        try {
            String packagename = c.getPackageName();
            PackageInfo info = c.getPackageManager().getPackageInfo(packagename, 64);
            Signature[] signatureArray = info.signatures;
            int n = signatureArray.length;
            int n2 = 0;
            if (n2 < n) {
                Signature signature = signatureArray[n2];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

