/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGamePagerTabStrip;
import com.mobgame.gui.MobGameViewPager;
import com.mobgame.gui.MobGameWebFragment2;
import com.mobgame.model.Game;

public class MobGamePagerFragment2
extends Fragment {
    private Activity activity;
    private View layoutMain;
    private MobGameViewPager viewPager;
    private MobGamePagerTabStrip tabs;
    private FragmentPagerAdapter adapter;
    private MobGameWebFragment2.EventListener mWebEventListener;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private int selectedIndex;
    private Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animator) {
            try {
                MobGamePagerFragment2.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((ViewGroup)MobGamePagerFragment2.this.layoutMain).updateViewLayout((View)MobGamePagerFragment2.this.viewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MobGamePagerFragment2.this.layoutMain.getHeight()));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onAnimationRepeat(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
            try {
                MobGamePagerFragment2.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGamePagerFragment2.this.updateTabs();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onAnimationCancel(Animator animator) {
        }
    };

    public MobGamePagerFragment2() {
    }

    @SuppressLint(value={"ValidFragment"})
    public MobGamePagerFragment2(Activity activity) {
        this.activity = activity;
    }

    public static final MobGamePagerFragment2 newInstance(Activity activity) {
        MobGamePagerFragment2 mPagerFragment = new MobGamePagerFragment2(activity);
        return mPagerFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_pager2, container, false);
        this.layoutMain = view.findViewById(R.id.layout_main);
        this.viewPager = (MobGameViewPager)view.findViewById(R.id.pager);
        this.tabs = (MobGamePagerTabStrip)view.findViewById(R.id.pager_title_strip);
        try {
            Game gameConfigs = GameConfigManager.getInstance().getGameConfig();
            String lang = "eng";
            if (gameConfigs != null) {
                lang = gameConfigs.getLang();
            }
            if ("vie".equalsIgnoreCase(lang)) {
                this.tabs.setIndicatorColor(Color.rgb((int)241, (int)67, (int)8));
                this.tabs.setTextColor(Color.rgb((int)241, (int)67, (int)8));
            } else {
                this.tabs.setIndicatorColor(Color.rgb((int)194, (int)39, (int)45));
                this.tabs.setTextColor(Color.rgb((int)194, (int)39, (int)45));
            }
            if (this.adapter != null) {
                this.setAdapter(this.adapter);
            }
            if (this.mOnPageChangeListener != null) {
                this.viewPager.addOnPageChangeListener(this.mOnPageChangeListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    public void setAdapter(FragmentPagerAdapter adapter) {
        this.setAdapter(adapter, this.selectedIndex);
    }

    public void setAdapter(FragmentPagerAdapter adapter, int selectedIndex) {
        try {
            if (this.viewPager != null && this.tabs != null) {
                this.viewPager.setAdapter(null);
                this.viewPager.setAdapter((PagerAdapter)adapter);
                this.tabs.setViewPager(this.viewPager);
                if (adapter.getCount() <= 1 && this.adapter.getCount() > 1) {
                    this.hideTabs(false);
                } else if (adapter.getCount() > 1 && this.adapter.getCount() <= 1) {
                    this.showTabs(false);
                }
                for (int i = 0; i < adapter.getCount(); ++i) {
                    Fragment frag = adapter.getItem(i);
                    if (!(frag instanceof MobGameWebFragment2)) continue;
                    ((MobGameWebFragment2)frag).setWebViewTag(i + "");
                    if (this.mWebEventListener == null) continue;
                    ((MobGameWebFragment2)frag).setEventListener(this.mWebEventListener);
                }
                this.viewPager.setCurrentItem(selectedIndex, false);
                if (this.mOnPageChangeListener != null) {
                    this.mOnPageChangeListener.onPageSelected(selectedIndex);
                }
            }
            this.adapter = adapter;
            this.selectedIndex = selectedIndex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyTabsChanged() {
        if (this.tabs != null) {
            this.tabs.notifyDataSetChanged();
        }
    }

    public void setWebEventListener(MobGameWebFragment2.EventListener eventListener) {
        try {
            this.mWebEventListener = eventListener;
            if (this.adapter != null) {
                for (int i = 0; i < this.adapter.getCount(); ++i) {
                    Fragment frag = this.adapter.getItem(i);
                    if (!(frag instanceof MobGameWebFragment2)) continue;
                    ((MobGameWebFragment2)frag).setEventListener(this.mWebEventListener);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addOnPageChangeListener(ViewPager.SimpleOnPageChangeListener onPageChangeListener) {
        if (this.viewPager != null) {
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)onPageChangeListener);
        }
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public int countTabs() {
        return this.adapter.getCount();
    }

    public void showTabs(boolean isAnimated) {
        try {
            this.viewPager.setPagingEnabled(true);
            this.tabs.setVisibility(0);
            if (isAnimated) {
                this.tabs.animate().setDuration(250L).y(0.0f);
                this.viewPager.animate().setDuration(250L).y((float)this.tabs.getHeight()).setListener(this.mAnimatorListener);
            } else {
                this.tabs.setY(0.0f);
                this.viewPager.setY(this.tabs.getHeight());
                ((ViewGroup)this.layoutMain).updateViewLayout((View)this.viewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.layoutMain.getHeight() - this.tabs.getHeight()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideTabs(boolean isAnimated) {
        try {
            if (this.viewPager == null) {
                return;
            }
            this.viewPager.setPagingEnabled(false);
            if (isAnimated) {
                this.tabs.animate().setDuration(250L).y((float)(-this.tabs.getHeight()));
                this.viewPager.animate().setDuration(250L).y(0.0f).setListener(this.mAnimatorListener);
            } else {
                this.tabs.setY(-this.tabs.getHeight());
                this.viewPager.setY(0.0f);
                ((ViewGroup)this.layoutMain).updateViewLayout((View)this.viewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.layoutMain.getHeight()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTabs() {
        try {
            ((ViewGroup)this.layoutMain).updateViewLayout((View)this.viewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.layoutMain.getHeight() - this.tabs.getHeight() - (int)this.tabs.getY()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

