/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RestfulApi;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.IngameNoti;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.EncryptionUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetIngameNotificationTask
extends AsyncTask<Void, Void, Void> {
    private static final String TAG = GetIngameNotificationTask.class.getSimpleName();
    private Listener callback;
    private Activity mActivity;

    public GetIngameNotificationTask(Activity activity, Listener callback) {
        this.callback = callback;
        this.mActivity = activity;
    }

    protected Void doInBackground(Void ... voids) {
        try {
            Context c = MobGameSDK.getApplicationContext();
            String sign = EncryptionUtils.getSignedString(c);
            RestfulApi.removeInstance();
            RestfulApi api = RestfulApi.getInstance();
            int tablet = 0;
            tablet = DeviceUtils.isTablet(c) ? 1 : 0;
            Call<EncodedResponse> call = api.getIngameNotiList(tablet);
            call.enqueue((Callback)new Callback<EncodedResponse>(){

                public void onResponse(@NotNull Call<EncodedResponse> call, @NotNull Response<EncodedResponse> response) {
                    block6: {
                        try {
                            if (response.isSuccessful()) {
                                String responseBody = ((EncodedResponse)Objects.requireNonNull(response.body())).getDecodedData();
                                Log.e((String)TAG, (String)("response :" + responseBody));
                                ArrayList<IngameNoti> listNoti = IngameNoti.parse(responseBody);
                                if (GetIngameNotificationTask.this.callback != null) {
                                    GetIngameNotificationTask.this.callback.onSuccess(listNoti);
                                }
                            } else if (GetIngameNotificationTask.this.callback != null) {
                                GetIngameNotificationTask.this.callback.onFailure(new Exception());
                            }
                        }
                        catch (Exception e) {
                            if (GetIngameNotificationTask.this.callback == null) break block6;
                            GetIngameNotificationTask.this.callback.onFailure(e);
                        }
                    }
                }

                public void onFailure(@NotNull Call<EncodedResponse> call, @NotNull Throwable t) {
                    try {
                        if (GetIngameNotificationTask.this.callback != null) {
                            GetIngameNotificationTask.this.callback.onFailure(t);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static interface Listener {
        public void onSuccess(ArrayList<IngameNoti> var1);

        public void onFailure(Throwable var1);
    }
}

