/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import com.mobgame.R;
import com.mobgame.utils.KeyboardHeightObserver;

public class KeyboardHeightProvider
extends PopupWindow {
    private static final String TAG = "sample_KeyboardHeightProvider";
    private static final int NAVIGATION_BAR_MIN_HEIGHT = 100;
    private KeyboardHeightObserver observer;
    private int keyboardLandscapeHeight;
    private int keyboardPortraitHeight;
    private View popupView;
    private View parentView;
    private Activity activity;
    private boolean navigationBarVisible;
    private boolean isChangedKeyboard;

    public KeyboardHeightProvider(Activity activity) {
        super((Context)activity);
        this.activity = activity;
        try {
            LayoutInflater inflator = (LayoutInflater)activity.getSystemService("layout_inflater");
            this.popupView = inflator.inflate(R.layout.popupwindow, null, false);
            this.setContentView(this.popupView);
            this.setSoftInputMode(21);
            this.setInputMethodMode(1);
            this.parentView = activity.findViewById(0x1020002);
            this.setWidth(0);
            this.setHeight(-1);
            this.popupView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (KeyboardHeightProvider.this.popupView != null) {
                        KeyboardHeightProvider.this.handleOnGlobalLayout();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        if (!this.isShowing() && this.parentView.getWindowToken() != null) {
            this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.showAtLocation(this.parentView, 0, 0, 0);
        }
    }

    public void close() {
        this.observer = null;
        this.dismiss();
    }

    public void setKeyboardHeightObserver(KeyboardHeightObserver observer) {
        this.observer = observer;
    }

    private int getScreenOrientation() {
        return this.activity.getResources().getConfiguration().orientation;
    }

    private void handleOnGlobalLayout() {
        try {
            Point screenSize = new Point();
            this.activity.getWindowManager().getDefaultDisplay().getSize(screenSize);
            Rect rect = new Rect();
            this.popupView.getWindowVisibleDisplayFrame(rect);
            int orientation = this.getScreenOrientation();
            int keyboardHeight = 0;
            Log.d((String)"TAG", (String)("keyboardHeight : " + keyboardHeight + "; screenSize.y : " + screenSize.y + "; rect.bottom : " + rect.bottom + "; screenSize.x : " + screenSize.x + "; rect.top : " + rect.top));
            if (keyboardHeight == 0) {
                this.notifyKeyboardHeightChanged(0, orientation);
                Log.d((String)"TAG", (String)("keyboardHeight 1 :" + keyboardHeight));
            } else if (orientation == 1) {
                this.keyboardPortraitHeight = keyboardHeight;
                Log.d((String)"TAG", (String)("keyboardHeight 2 :" + keyboardHeight));
                this.notifyKeyboardHeightChanged(this.keyboardPortraitHeight, orientation);
            } else {
                this.keyboardLandscapeHeight = keyboardHeight;
                Log.d((String)"TAG", (String)("keyboardHeight 3 :" + keyboardHeight));
                this.notifyKeyboardHeightChanged(this.keyboardLandscapeHeight, orientation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void notifyKeyboardHeightChanged(int height, int orientation) {
        if (this.observer != null) {
            Log.d((String)"TAG", (String)"MO BAN PHIM");
            this.observer.onKeyboardHeightChanged(height, orientation);
        } else {
            Log.d((String)"TAG", (String)"TAT BAN PHIM");
        }
    }

    public boolean checkKeyboardChanged() {
        return this.isChangedKeyboard;
    }
}

