/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.mobgame.R;

public class MobIndicator
extends LinearLayout {
    private SparseArray<ImageButton> btnIndicators;
    private LinearLayout layoutIndicators;
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private boolean init = false;
    private View rootView;
    private ViewPager mViewPager;
    private int numberOfItem;
    private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (MobIndicator.this.mViewPager.getAdapter() == null || MobIndicator.this.mViewPager.getAdapter().getCount() <= 0) {
                return;
            }
            MobIndicator.this.updatePosition(position);
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    };
    private Context indicatorContext;

    public MobIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    @SuppressLint(value={"InflateParams"})
    private void init(Context context) {
        this.setIndicatorContext(context);
        if (this.init) {
            return;
        }
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.indicator_view, null);
        this.layoutIndicators = (LinearLayout)this.rootView.findViewById(R.id.indicator);
        this.addView(this.rootView);
        this.init = true;
    }

    public void initialize() {
        Log.d((String)this.TAG, (String)("number of indicator: " + this.numberOfItem));
        if (this.numberOfItem <= 1) {
            this.setVisibility(8);
            return;
        }
        this.btnIndicators = new SparseArray();
        for (int i = 0; i < this.numberOfItem; ++i) {
            float density = this.getDensity(this.indicatorContext);
            int padding = (int)(4.0f * density);
            ImageButton btnIndicator = new ImageButton(this.indicatorContext);
            btnIndicator.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            if (i == 0) {
                btnIndicator.setImageResource(R.drawable.indicator_orange);
            } else {
                btnIndicator.setImageResource(R.drawable.indicator_orange_inactive);
            }
            btnIndicator.setBackgroundResource(0);
            btnIndicator.setScaleType(ImageView.ScaleType.FIT_XY);
            btnIndicator.setPadding(padding, 0, padding, 0);
            this.layoutIndicators.addView((View)btnIndicator);
            this.btnIndicators.put(i, (Object)btnIndicator);
        }
        this.setVisibility(0);
    }

    public void updatePosition(int index) {
        if (this.btnIndicators == null) {
            return;
        }
        int itemSize = this.btnIndicators.size();
        for (int i = 0; i < itemSize; ++i) {
            if (i == index) {
                ((ImageButton)this.btnIndicators.get(i)).setImageResource(R.drawable.indicator_orange);
                continue;
            }
            ((ImageButton)this.btnIndicators.get(i)).setImageResource(R.drawable.indicator_orange_inactive);
        }
    }

    private float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public MobIndicator setNumberOfItem(int numberOfItem) {
        this.numberOfItem = numberOfItem;
        return this;
    }

    public MobIndicator setViewPager(ViewPager mViewpager) {
        this.mViewPager = mViewpager;
        if (mViewpager != null && mViewpager.getAdapter() != null) {
            this.numberOfItem = this.mViewPager.getAdapter().getCount();
        }
        this.mViewPager.addOnPageChangeListener(this.mInternalPageChangeListener);
        this.layoutIndicators.removeAllViews();
        this.initialize();
        return this;
    }

    public int getNumberOfItem() {
        return this.numberOfItem;
    }

    public Context getIndicatorContext() {
        return this.indicatorContext;
    }

    public void setIndicatorContext(Context indicatorContext) {
        this.indicatorContext = indicatorContext;
    }
}

