package com.mobgame.model;

import com.google.gson.annotations.SerializedName;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class MobMenu {
	
	@SerializedName("menu")
	ArrayList<MobMenuItem> menuItems;
	public static MobMenu parse(String json) {
		try {
			ArrayList<MobMenuItem> menuItems = new ArrayList<MobMenuItem>();
			JSONArray menuJsonAray = new JSONArray(json);
			for (int i = 0; i < menuJsonAray.length(); i++) {
				try {
					MobMenuItem menuItem = new MobMenuItem();
					JSONObject menuItemJSON = menuJsonAray.getJSONObject(i);
					if (menuItemJSON.has("id")) {
						menuItem.setId(menuItemJSON.getInt("id"));
					}
					if (menuItemJSON.has("title")) {
						menuItem.setTitle(menuItemJSON.getString("title"));
					}
					if(menuItemJSON.has("sub_menu")){
						menuItem.setSubMenu(menuItemJSON.getString("sub_menu"));
					}
					if(menuItemJSON.has("priority")){
						menuItem.setPriority(menuItemJSON.getInt("priority"));
					}
					if(menuItemJSON.has("icon")){
						menuItem.setIcon(menuItemJSON.getString("icon"));
					}
					if(menuItemJSON.has("icon_active")){
						menuItem.setIconActive(menuItemJSON.getString("icon_active"));
					}
					if(menuItemJSON.has("show")){
						menuItem.setShow(menuItemJSON.getBoolean("show"));
					}
					if(menuItemJSON.has("open_type")){
						menuItem.setOpenType(menuItemJSON.getInt("open_type"));
					}
					if(menuItemJSON.has("open_link")){
						menuItem.setOpenLink(menuItemJSON.getString("open_link"));
					}
					menuItems.add(menuItem);
				} catch (JSONException e) {
					e.printStackTrace();
				}

			}
			MobMenu mobMenu = new MobMenu();
			mobMenu.setMenuItems(menuItems);
			return mobMenu;
		} catch (JSONException e) {
			return new MobMenu();
		}
	}

	public MobMenu() {
	}

	public ArrayList<MobMenuItem> getMenuItems() {
		if (menuItems == null) {
			menuItems = new ArrayList<>();
		}
		return menuItems;
	}

	public void setMenuItems(ArrayList<MobMenuItem> menuItems) {
		this.menuItems = menuItems;
	}

}
