package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.webkit.CookieManager;

import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Preference;

public class LogoutTask extends AsyncTask<Void, Void, Void> {
	private OnLogoutSuccessfulListener callback;
	
	public LogoutTask(OnLogoutSuccessfulListener callback) {
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		try {
			Context c = MobGameSDK.getApplicationContext();
			String roleId ="";
			try {
				roleId = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
			}catch (Exception e){
				e.printStackTrace();
			}
			Preference.remove(c, Constants.SHARED_PREF_COOKIES);
			Preference.remove(c , Constants.SHARED_PREF_HIDE_FLOAT_BUTTON);
			Preference.remove(c , Constants.SHARED_PREF_SHOW_DASHBOARD);
			Preference.remove(c , Constants.SHARED_PREF_NOTIFICATONS);
			CookieManager cookieManager = CookieManager.getInstance();
			cookieManager.removeSessionCookie();
			cookieManager.removeAllCookie();

			GameConfigManager.getInstance().clearLogin();
			FacebookManager.getInstance().logout();
			GoogleAuthManager.getInstance().logout();
			if(callback!=null){
				callback.onLogoutSuccessfull(roleId);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}

	@Override
	protected void onPostExecute(Void aVoid) {
		super.onPostExecute(aVoid);
	}

	public interface OnLogoutSuccessfulListener{
		void onLogoutSuccessfull(String roleId);
	}
}