/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.dialog;

import android.app.Activity;
import android.app.DialogFragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.mobgame.R;
import com.mobgame.api.GetPayItemTask;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.js.CmdPayment;
import com.mobgame.model.MItemPayment;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FunTrackingUtil;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class MobGamePayDialogFragment
extends DialogFragment {
    private static final String TAG = MobGamePayDialogFragment.class.getSimpleName();
    private ImageButton btn_close;
    private Button btnReload;
    private GridView gridView;
    private View viewConnectionLost;
    private DialogInterface.OnDismissListener mOnDismissListener;
    ArrayList<MItemPayment> listItemPay = new ArrayList();
    int col;
    int row;
    BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                boolean isClosePayment = intent.getBooleanExtra(Constants.INTENT_EXTRA_CLOSE_PAYMENT, false);
                if (isClosePayment) {
                    MobGamePayDialogFragment.this.closePayment();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.payment_dialog_fragment, container, false);
        this.getDialog().getWindow().setFlags(1024, 1024);
        this.getDialog().requestWindowFeature(1);
        this.btn_close = (ImageButton)rootView.findViewById(R.id.btn_close_pay);
        this.gridView = (GridView)rootView.findViewById(R.id.grid_view_pay);
        this.viewConnectionLost = rootView.findViewById(R.id.layout_connection_lost);
        this.btnReload = (Button)rootView.findViewById(R.id.btn_reload);
        String columnGrid = GameConfigManager.getInstance().getGameConfig().getPayForm().getPaymentDesign().getCol();
        this.col = Integer.parseInt(columnGrid);
        String rowGrid = GameConfigManager.getInstance().getGameConfig().getPayForm().getPaymentDesign().getRow();
        this.row = Integer.parseInt(rowGrid);
        int orientation = this.getResources().getConfiguration().orientation;
        Log.e((String)TAG, (String)("col : " + this.col + " , row : " + this.row));
        if (orientation == 1) {
            this.gridView.setNumColumns(this.col);
            this.initFormPayment(this.col, this.row);
        }
        if (orientation == 2) {
            this.gridView.setNumColumns(this.col);
            this.initFormPayment(this.col, this.row);
        }
        this.btn_close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MobGamePayDialogFragment.this.closePayment();
            }
        });
        return rootView;
    }

    private void initFormPayment(final int col, final int row) {
        try {
            if (Utils.isOnline((Context)this.getActivity())) {
                this.viewConnectionLost.setVisibility(8);
                new GetPayItemTask(this.getActivity(), new GetPayItemTask.Listener(){

                    @Override
                    public void onSuccess(ArrayList<MItemPayment> listItem) {
                        MobGamePayDialogFragment.this.listItemPay = listItem;
                        PayGridViewItem adapter = new PayGridViewItem(MobGamePayDialogFragment.this.getActivity(), MobGamePayDialogFragment.this.listItemPay, col, row);
                        MobGamePayDialogFragment.this.gridView.setAdapter((ListAdapter)adapter);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                    }
                }).execute(new Void[0]);
            } else {
                this.viewConnectionLost.setVisibility(0);
                this.btnReload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int orientation = MobGamePayDialogFragment.this.getResources().getConfiguration().orientation;
                        if (orientation == 1) {
                            MobGamePayDialogFragment.this.initFormPayment(col, row);
                        }
                        if (orientation == 2) {
                            MobGamePayDialogFragment.this.initFormPayment(col, row);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closePayment() {
        this.dismiss();
        FunTrackingUtil.getInstance().trackEvent((Context)this.getActivity(), "ft_payment_closed", null);
        boolean isNotHideFloatButton = Preference.getBoolean((Context)this.getActivity(), "shared_pref_hide_float_button", true);
        boolean isEnableDashboard = Utils.isDashboardEnabled((Context)this.getActivity());
        Log.d((String)TAG, (String)("isNotHideFloatButton: " + isNotHideFloatButton));
        Log.d((String)TAG, (String)("isEnableDashboard: " + isEnableDashboard));
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, 0x1030010);
    }

    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this.getActivity().getApplicationContext()).registerReceiver(this.receiver, new IntentFilter(Constants.INTENT_CLOSE_PAYMENT));
    }

    public void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this.getActivity().getApplicationContext()).unregisterReceiver(this.receiver);
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    class PayGridViewItem
    extends BaseAdapter {
        private Activity mActivity;
        private ArrayList<MItemPayment> listItemPayment;
        private int col;
        private int row;
        int widthItem;
        int heghtItem;
        int width;
        int height;

        public PayGridViewItem(Activity activity, ArrayList<MItemPayment> listItemPayment, int col, int row) {
            this.mActivity = activity;
            this.listItemPayment = listItemPayment;
            this.col = col;
            this.width = this.getScreenWidthInPixel((Context)this.mActivity);
            this.height = this.getScreenHeightInPixel((Context)this.mActivity);
            this.widthItem = this.width / col;
            this.heghtItem = this.height / row;
        }

        public int getCount() {
            return this.listItemPayment.size();
        }

        public Object getItem(int position) {
            return this.listItemPayment.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            View view;
            LayoutInflater inflater = (LayoutInflater)this.mActivity.getSystemService("layout_inflater");
            if (convertView == null) {
                view = new View((Context)this.mActivity);
                view = inflater.inflate(R.layout.item_payment, null);
                ImageView imgView = (ImageView)view.findViewById(R.id.img_item_pay);
                Log.d((String)TAG, (String)("width : " + this.widthItem + " , heght: " + this.heghtItem));
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.widthItem, this.heghtItem);
                imgView.setLayoutParams((ViewGroup.LayoutParams)params);
                RequestOptions fitOptions = new RequestOptions().centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL);
                Glide.with((Activity)this.mActivity).asBitmap().load(this.listItemPayment.get(position).getUrlPng()).apply(fitOptions).into(imgView);
                boolean isSubmit = GameConfigManager.getInstance().getGameConfig().isSubm();
                if (isSubmit && this.listItemPayment.get(position).getCategoryItem().equals("xx02")) {
                    imgView.setVisibility(8);
                }
                imgView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getCategoryItem().equals("xx01")) {
                            try {
                                JSONObject json = new JSONObject();
                                json.put("product_id", (Object)((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getProductId());
                                Log.d((String)TAG, (String)("json:" + json));
                                CmdPayment.getInstance().mobPaymentStartIAP(PayGridViewItem.this.mActivity, json.toString());
                                HashMap<String, Object> eventValue = new HashMap<String, Object>();
                                eventValue.put("product_id", ((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getProductId());
                                FunTrackingUtil.getInstance().trackEvent((Context)MobGamePayDialogFragment.this.getActivity(), "ft_payment_clicked", eventValue);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (((MItemPayment)PayGridViewItem.this.listItemPayment.get(position)).getCategoryItem().equals("xx02")) {
                            String url = Constants.URL_PAYMENT;
                            Log.d((String)TAG, (String)url);
                            Intent intent = new Intent((Context)PayGridViewItem.this.mActivity, MobGameActivity.class);
                            intent.putExtra(MobGameActivity.KEY_DATA, "[{'action':'" + url + "'}]");
                            intent.putExtra(MobGameActivity.FORM, "payment");
                            PayGridViewItem.this.mActivity.startActivity(intent);
                            MobGamePayDialogFragment.this.getDialog().dismiss();
                        }
                    }
                });
            } else {
                view = convertView;
            }
            return view;
        }

        public int getScreenWidthInPixel(Context context) {
            return context.getResources().getDisplayMetrics().widthPixels;
        }

        public int getScreenHeightInPixel(Context context) {
            return context.getResources().getDisplayMetrics().heightPixels - (int)(50.0f * DeviceUtils.getDensity((Context)this.mActivity));
        }
    }
}

