package com.mobgame.gui;

import java.util.ArrayList;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Window;

import com.mobgame.model.MPermission;

public class PermissionFragment extends DialogFragment {

	public final static String PERMISSIONS = "permissions";
	
	public final static int RESULT_REQUEST_PERMISSIONS = 21;
	
	private static final int REQUEST_CODE_PERMISSIONS = 20001;
	
	public static PermissionFragment newInstance(String[] permissions) {
		PermissionFragment fr = new PermissionFragment();

	    Bundle args = new Bundle();
	    args.putStringArray(PERMISSIONS, permissions);
	    fr.setArguments(args);

	    return fr;
	}
	
	@Override
	public Dialog onCreateDialog(Bundle savedInstanceState) {
		Dialog dialog = super.onCreateDialog(savedInstanceState);

		// request a window without the title
		dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
		dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
		return dialog;
	}

	@TargetApi(23)
	@Override
	public void onActivityCreated(Bundle savedInstanceState) {
		super.onActivityCreated(savedInstanceState);
		Bundle args = getArguments();
		if (args != null) {
			String[] permisisons = args.getStringArray(PERMISSIONS);
			requestPermissions(
					permisisons,
					REQUEST_CODE_PERMISSIONS);
		} else {
			dismiss();
		}
	}

	@Override
	public void onRequestPermissionsResult(int requestCode,
			@NonNull String[] permissions, @NonNull int[] grantResults) {
		switch (requestCode) {
		case REQUEST_CODE_PERMISSIONS:
			try {
				// If request is cancelled, the result arrays are empty.
				ArrayList<MPermission> result = new ArrayList<MPermission>();
				for (int i = 0; i < grantResults.length; i++) {
					String permission = permissions[i];
					int granted = grantResults[i];
					MPermission m = new MPermission(permission, granted);
					result.add(m);
				}

				Intent intentData = new Intent();
				intentData.putParcelableArrayListExtra(PERMISSIONS, result);
				dismiss();
				return;
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	}
}