package com.mobgame.gui.floatbutton;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.graphics.Typeface;
import android.os.Handler;
import android.util.Log;
import android.view.GestureDetector;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.OvershootInterpolator;
import android.view.animation.Transformation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.CountDownTimerEgde;
import com.mobgame.gui.view.MobAutoScrollTextView;
import com.mobgame.model.NtfModel;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Preference;

import java.util.ArrayList;
import java.util.Calendar;

@SuppressLint({"InflateParams", "ClickableViewAccessibility"})
public class MobGameFloatGestureView {

    private static String TAG = MobGameFloatGestureView.class.getSimpleName();

    static final int ANIMAION_TIME_MOVE_TO_EDGE = 200;
    static final int BUTTON_SIZE = 44;

    Activity activity;
    View rootView, floatArea;
    EventListener listener;
    GestureDetector gestureDetector;

    int buttonSize;
    // Screen
    int movableWidth, movableHeight;
    float density;
    // Touch event
    long timeTouchDown, timeTouchUp;
    float deltaX, deltaY;

    WindowManager windowManager;
    WindowManager.LayoutParams params;

    private LinearLayout viewNotification, txt_linnear_layout;
    //	private ScrollingTextView textNotification;
    private MobAutoScrollTextView switcher;

    private RelativeLayout viewTimer, timer_layout;
    private CountDownTimerEgde countdownTimer;

    public MobGameFloatGestureView(Activity a) {
        activity = a;

        density = DeviceUtils.getDensity(a);
        movableWidth = DeviceUtils.getScreenWidthInPixels(a);
        movableHeight = DeviceUtils.getScreenHeightInPixels(a);
        buttonSize = (int) (BUTTON_SIZE * density);

        gestureDetector = new GestureDetector(a, new GestureListener());

        initView();
        attachView();
    }

    public void initView() {
        Log.d(TAG, "initView");
        rootView = LayoutInflater.from(activity).inflate(R.layout.float_area, null);
        floatArea = rootView.findViewById(R.id.layout_float);

        floatArea.getLayoutParams().width = buttonSize;
        floatArea.getLayoutParams().height = buttonSize;
        floatArea.setOnTouchListener(mOnTouchListener);
//view noti
        viewNotification = (LinearLayout) LayoutInflater.from(activity).inflate(R.layout.float_text_layout, null);
        switcher = (MobAutoScrollTextView) viewNotification.findViewById(R.id.txt_noti);
        txt_linnear_layout = (LinearLayout) viewNotification.findViewById(R.id.txt_linnearlayout);
        //timer view
        viewTimer = (RelativeLayout) LayoutInflater.from(activity).inflate(R.layout.timer_layout_egde, null);
        countdownTimer = (CountDownTimerEgde) viewTimer.findViewById(R.id.countdown_timer_egde);
        timer_layout = (RelativeLayout) viewTimer.findViewById(R.id.timer_layout_egde);

    }

    public void attachView() {
        try {
            Log.d(TAG, "attachView");
            windowManager = (WindowManager) activity.getApplicationContext()
                    .getSystemService(Activity.WINDOW_SERVICE);
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                params = new WindowManager.LayoutParams(
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY,
                        WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE| WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN,
                        PixelFormat.TRANSPARENT);
            } else {
                params = new WindowManager.LayoutParams(
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.TYPE_PHONE,
                        WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE| WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN,
                        PixelFormat.TRANSPARENT);
            }
            params.gravity = Gravity.LEFT | Gravity.TOP;
            params.x = 0;
            params.y = 0;
            windowManager.addView(rootView, params);

            if (listener != null) {
                listener.onMove(params.x, params.y);
            }

            // add view show notification
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                WindowManager.LayoutParams paramsTxt = new WindowManager.LayoutParams(
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY,
                        WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE | WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH | WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS| WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN,
                        PixelFormat.TRANSLUCENT
                );

                paramsTxt.gravity = Gravity.TOP | Gravity.LEFT;
                switcher.setVisibility(View.GONE);

                windowManager.addView(viewNotification, paramsTxt);
                // end add view
                // add view timer
                WindowManager.LayoutParams paramstimer = new WindowManager.LayoutParams(
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY,
                        WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE | WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH | WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS| WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN,
                        PixelFormat.TRANSLUCENT);
                paramstimer.gravity = Gravity.TOP | Gravity.RIGHT;
                windowManager.addView(viewTimer, paramstimer);
            } else {
                WindowManager.LayoutParams paramsTxt = new WindowManager.LayoutParams(
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.TYPE_PHONE,
                        WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE | WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH | WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS| WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN,
                        PixelFormat.TRANSLUCENT
                );

                paramsTxt.gravity = Gravity.TOP | Gravity.LEFT;
                switcher.setVisibility(View.GONE);

                windowManager.addView(viewNotification, paramsTxt);
                // end add view
                // add view timer
                WindowManager.LayoutParams paramstimer = new WindowManager.LayoutParams(
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.WRAP_CONTENT,
                        WindowManager.LayoutParams.TYPE_PHONE,
                        WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE | WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH | WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS| WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN,
                        PixelFormat.TRANSLUCENT);
                paramstimer.gravity = Gravity.TOP | Gravity.RIGHT;
                windowManager.addView(viewTimer, paramstimer);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEventListener(EventListener listener) {
        this.listener = listener;
    }

    public void setMovableWidth(int width) {
        movableWidth = width;
    }

    public void setMovableHeight(int height) {
        movableHeight = height;
    }

    public int getSize() {
        return BUTTON_SIZE;
    }

    public int getSizeInPixels() {
        return buttonSize;
    }

    public int getX() {
        if (rootView == null) return 0;
        return params.x;
    }

    public int getY() {
        if (rootView == null) return 0;
        return params.y;
    }

    public void moveTo(int x, int y) {
        moveTo(x, y, false);
    }

    public void moveTo(int x, int y, boolean isAnimated) {
        try {
            params.x = x;
            params.y = y;
            windowManager.updateViewLayout(rootView, params);
            if (listener != null) {
                listener.onMove(params.x, params.y);
                listener.onTouchUp(null);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isLeft;

    public void setIsLeft(boolean isLeft) {
        this.isLeft = isLeft;
    }

    public boolean isLeft() {
        return isLeft;
    }

    public void moveToEdge(boolean isAnimated) {
        Log.d(TAG, "moveToEdge");
        try {
            if (isAnimated) {
                Animation animation = new Animation() {

                    @Override
                    protected void applyTransformation(float interpolatedTime, Transformation t) {
                        super.applyTransformation(interpolatedTime, t);
                        try {
                            float left = params.x;
                            float right = movableWidth - buttonSize - left;

                            if (left <= right) {
//								Log.d(TAG , "left");
                                params.x = (int) (left - left * interpolatedTime);
                                isLeft = true;
                            } else {
//								Log.d(TAG , "right");
                                params.x = (int) (left - (left - movableWidth) * interpolatedTime);
                                isLeft = false;
                            }

                            windowManager.updateViewLayout(rootView, params);
                            if (listener != null) {
                                listener.onMove(params.x, params.y);
                            }
                            timer_layout.setVisibility(View.GONE);
                            Log.d(TAG , "FloatArea : " + params.x + " , " + params.y);
                            Preference.save(activity , Constants.SAVE_FLOAT_AREA_X , params.x);
                            Preference.save(activity , Constants.SAVE_FLOAT_AREA_Y , params.y);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };


                animation.setDuration(ANIMAION_TIME_MOVE_TO_EDGE);
                animation.setInterpolator(new OvershootInterpolator(0.5f));
                floatArea.startAnimation(animation);
            } else {
                float left = params.x;
                float right = movableWidth - buttonSize - left;
                if (left <= right) {
                    params.x = 0;
                } else {
                    params.x = movableWidth - buttonSize;
                }
                windowManager.updateViewLayout(rootView, params);
                if (listener != null) {
                    listener.onMove(params.x, params.y);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //correct roi khong can chinh nua.
    public void fadeOutRight() {
        try {
            timer_layout.setVisibility(View.VISIBLE);
            WindowManager.LayoutParams params_float = (WindowManager.LayoutParams) rootView.getLayoutParams();
            WindowManager.LayoutParams params_right = (WindowManager.LayoutParams) viewTimer.getLayoutParams();

            timer_layout.getLayoutParams().height = (int) buttonSize;
            timer_layout.getLayoutParams().width = (int) (16 * density);
            if(DeviceUtils.isTablet(activity)){
                if (DeviceUtils.hasHardwareButtons() == false
                        && activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                    params_right.x = buttonSize / 2 - 12;
                    if(movableHeight - params.y == buttonSize){
                        params_right.y = params_float.y - (int) (16 * density);
                    } else {
                        params_right.y = params_float.y;
                    }
                } else {
                    params_right.x = 0 + buttonSize / 2 - 12;
                    if(movableHeight - params.y == buttonSize){
                        params_right.y = params_float.y - (int) (16 * density);
                    } else {
                        params_right.y = params_float.y;
                    }

                }
            }else{
                if (DeviceUtils.hasHardwareButtons() == false
                        && activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                    params_right.x = buttonSize / 2 - 30;
                    if(movableHeight - params.y == buttonSize){
                        params_right.y = params_float.y - (int) (16 * density);
                    } else {
                        params_right.y = params_float.y;
                    }
                } else {
                    params_right.x = 0 + buttonSize / 2 - 30;
                    if(movableHeight - params.y == buttonSize){
                        params_right.y = params_float.y - (int) (16 * density);
                    } else {
                        params_right.y = params_float.y;
                    }

                }
            }

            if (countdownTimer != null) {
                timer_layout.removeAllViews();
            }
            long endTimer = getEndTimer();
            long countDown = endTimer - Calendar.getInstance().getTimeInMillis();
            if (endTimer >= 0) {
                countdownTimer = new CountDownTimerEgde(activity);
                countdownTimer.setDraw(true);

                Log.d(TAG, "countDown :" + countDown + " , " + Calendar.getInstance().getTimeInMillis());
                countdownTimer.setBase(Calendar.getInstance().getTime().getTime() + countDown);
                countdownTimer.setCountdownListener(new CountDownTimerEgde.CountdownListener() {
                    @Override
                    public void done() {
                        if (countdownTimer != null) {
                            countdownTimer.setVisibility(View.GONE);
                            timer_layout.setVisibility(View.GONE);
                        }
                    }

                });
                countdownTimer.start();

                countdownTimer.setTextColor(Color.parseColor("#02f600"));
                countdownTimer.setTextSize(9);
                countdownTimer.setTypeface(null , Typeface.BOLD);
                countdownTimer.setShadowLayer(3 , 0 , 0 , Color.parseColor("#000000"));

                RelativeLayout.LayoutParams lpView = new RelativeLayout.LayoutParams(WindowManager.LayoutParams.WRAP_CONTENT, WindowManager.LayoutParams.WRAP_CONTENT);
                lpView.addRule(RelativeLayout.CENTER_IN_PARENT);
                viewTimer.addView(countdownTimer, lpView);
            }


            viewTimer.setAlpha(0.5f);
            windowManager.updateViewLayout(viewTimer, params_right);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    long endTimer;

    public void setEndTimer(long endTimer) {
        this.endTimer = endTimer;
    }

    public long getEndTimer() {
        return endTimer;
    }

    public void fadeOutLeft() {
        try {

            timer_layout.setVisibility(View.VISIBLE);
            WindowManager.LayoutParams params_float = (WindowManager.LayoutParams) rootView.getLayoutParams();
            WindowManager.LayoutParams params_left = (WindowManager.LayoutParams) viewTimer.getLayoutParams();

            timer_layout.getLayoutParams().height = (int) buttonSize;
            timer_layout.getLayoutParams().width = (int) (16 * density);
            if(DeviceUtils.isTablet(activity)){
                if (DeviceUtils.hasHardwareButtons() == false
                        && activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                    params_left.x = movableWidth - buttonSize / 2 - (int) (16 * density) + 12;
                    if(movableHeight - params.y == buttonSize){
                        params_left.y = params_float.y - (int) (16 * density);
                    } else {
                        params_left.y = params_float.y;
                    }

                } else {
                    params_left.x = movableWidth - buttonSize / 2 - (int) (16 * density) + 12;
                    if(movableHeight - params.y == buttonSize){
                        params_left.y = params_float.y - (int) (16 * density);
                    } else {
                        params_left.y = params_float.y;
                    }

                }
            }else{
                if (DeviceUtils.hasHardwareButtons() == false
                        && activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                    params_left.x = movableWidth - buttonSize / 2 - (int) (16 * density) + 30;
                    if(movableHeight - params.y == buttonSize){
                        params_left.y = params_float.y - (int) (16 * density);
                    } else {
                        params_left.y = params_float.y;
                    }
                } else {
                    params_left.x = movableWidth - buttonSize / 2 - (int) (16 * density) + 30;
                    if(movableHeight - params.y == buttonSize){
                        params_left.y = params_float.y - (int) (16 * density);
                    } else {
                        params_left.y = params_float.y;
                    }

                }
            }


            if (countdownTimer != null) {
                timer_layout.removeAllViews();
            }
            long endTimer = getEndTimer();
            long countDown = endTimer - Calendar.getInstance().getTimeInMillis();
            if (endTimer >= 0) {
                countdownTimer = new CountDownTimerEgde(activity);
                countdownTimer.setDraw(true);

                Log.d(TAG, "countDown :" + countDown + " , " + Calendar.getInstance().getTimeInMillis());
                countdownTimer.setBase(Calendar.getInstance().getTime().getTime() + countDown);
                countdownTimer.setCountdownListener(new CountDownTimerEgde.CountdownListener() {
                    @Override
                    public void done() {
                        if (countdownTimer != null) {
                            countdownTimer.setVisibility(View.GONE);
                            timer_layout.setVisibility(View.GONE);
                        }
                    }

                });
                countdownTimer.start();

                countdownTimer.setTextColor(Color.parseColor("#02f600"));
                countdownTimer.setTextSize(9);
                countdownTimer.setTypeface(null , Typeface.BOLD);
                countdownTimer.setShadowLayer(3 , 0 , 0 , Color.parseColor("#000000"));

                RelativeLayout.LayoutParams lpView = new RelativeLayout.LayoutParams(WindowManager.LayoutParams.WRAP_CONTENT, WindowManager.LayoutParams.WRAP_CONTENT);
                lpView.addRule(RelativeLayout.CENTER_IN_PARENT);
                viewTimer.addView(countdownTimer, lpView);
            }
            viewTimer.setAlpha(0.5f);
            windowManager.updateViewLayout(viewTimer, params_left);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void showMsg(final ArrayList<NtfModel> listNotification) {
        try {
            viewNotification.setVisibility(View.VISIBLE);
            WindowManager.LayoutParams paramsFloat = (WindowManager.LayoutParams) rootView.getLayoutParams();
            final WindowManager.LayoutParams paramsText = (WindowManager.LayoutParams) viewNotification.getLayoutParams();

            txt_linnear_layout.getLayoutParams().height = WindowManager.LayoutParams.WRAP_CONTENT;
            txt_linnear_layout.getLayoutParams().width = WindowManager.LayoutParams.WRAP_CONTENT;
            int timerSize =  GameConfigManager.getInstance().getUserInfo().getTimerData().getListTimerObject().size();
            Log.d(TAG, "isLeft : " + isLeft);
            if (isLeft) {
                paramsText.x = paramsFloat.x + buttonSize;
                if (activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                    if(movableHeight - params.y == buttonSize && timerSize!= 0){
                        paramsText.y = paramsFloat.y + (int) (buttonSize * 0.2) - (int) (16 * density);
                    } else {
                        paramsText.y = paramsFloat.y + (int) (buttonSize * 0.2);
                    }
                } else {
                    if(movableHeight - params.y == buttonSize && timerSize!= 0){
                        paramsText.y = paramsFloat.y + (int) (buttonSize * 0.2) - (int) (16 * density);
                    } else {
                        paramsText.y = paramsFloat.y + (int) (buttonSize * 0.2);
                    }
                }
            } else {
                paramsText.x = paramsFloat.x - (int) (buttonSize * 3.8);
                if (activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                    if(movableHeight - params.y == buttonSize && timerSize!= 0){
                        paramsText.y = paramsFloat.y + (int) (buttonSize * 0.2) - (int) (16 * density);
                    } else {
                        paramsText.y = paramsFloat.y + (int) (buttonSize * 0.2);
                    }
                } else {
                    if(movableHeight - params.y == buttonSize && timerSize!= 0){
                        paramsText.y = paramsFloat.y + (int) (buttonSize * 0.2) - (int) (16 * density);
                    } else {
                        paramsText.y = paramsFloat.y + (int) (buttonSize * 0.2);
                    }
                }
            }
            windowManager.updateViewLayout(viewNotification, paramsText);
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    showViewNotification(listNotification, paramsText);
                }
            }, 1000);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showViewNotification(ArrayList<NtfModel> listNotification, WindowManager.LayoutParams paramsText) {
        switcher.setVisibility(View.VISIBLE);
        Animation slideLeft, slideRight;
        if(isLeft){
            switcher.setBackground(activity.getResources().getDrawable(R.drawable.noti_left));
            slideLeft = AnimationUtils.loadAnimation(activity, R.anim.slide_in_left);
            switcher.startAnimation(slideLeft);
            Log.d(TAG, "showMsg: show animation slide in Left");
        }else{
            switcher.setBackground(activity.getResources().getDrawable(R.drawable.noti_right));
            slideRight = AnimationUtils.loadAnimation(activity, R.anim.slide_in_right);
            switcher.startAnimation(slideRight);
            Log.d(TAG, "showMsg: show animation slide in right");
        }
        dem = 0;
        ArrayList<String> texts = new ArrayList<>();
        for (int i = 0; i < listNotification.size(); i++) {
            Log.d(TAG, "list noti:" + listNotification.get(i).getTitle());
            texts.add(listNotification.get(i).getTitle());
        }
        switcher.startAutoScroll(texts, 2000, new MobAutoScrollTextView.OnTextViewScrollListener() {
            @Override
            public void onTextViewScroll(String text, boolean reverse) {

            }

            @Override
            public void onTextViewScrollFinished() {
                Animation slideOut;
                if (isLeft) {
                    slideOut = AnimationUtils.loadAnimation(activity, R.anim.slide_out_left);
                    Log.d(TAG, "show animation: slide out left");
                } else {
                    slideOut = AnimationUtils.loadAnimation(activity, R.anim.slide_out_right);
                    Log.d(TAG, "show animation: slide out right");
                }
                switcher.startAnimation(slideOut);
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        onScrollFinishedListener.onScrollFinished();
                        switcher.setVisibility(View.GONE);
                        viewNotification.setVisibility(View.GONE);
                    }
                }, 300);
            }
        });
        //listNotification
    }

    int dem = 0;
    private OnTouchListener mOnTouchListener = new OnTouchListener() {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            boolean comsumed = true;
            try {
                gestureDetector.onTouchEvent(event);
                switch (event.getAction() & MotionEvent.ACTION_MASK) {
                    case MotionEvent.ACTION_DOWN: {
                        timeTouchDown = System.currentTimeMillis();
                        onTouchDown(event);
                        switcher.setVisibility(View.GONE);
                        viewNotification.setVisibility(View.GONE);
                        timer_layout.setVisibility(View.GONE);
                        break;
                    }
                    case MotionEvent.ACTION_UP: {
                        onTouchUp(event);
                        break;
                    }
                    case MotionEvent.ACTION_POINTER_DOWN:
                        break;
                    case MotionEvent.ACTION_POINTER_UP:
                        break;
                    case MotionEvent.ACTION_MOVE: {
                        onTouchMove(event);
                        break;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return comsumed;
        }
    };

    private void onTouchDown(MotionEvent event) {
        try {
            deltaX = event.getX();
            deltaY = event.getY();

            if (listener != null) {
                listener.onTouchDown(event);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchMove(MotionEvent event) {
        try {
            float left = event.getRawX() - deltaX;
            float top = event.getRawY() - deltaY;

            left = Math.max(0, Math.min(movableWidth - buttonSize, left));
            top = Math.max(0, Math.min(movableHeight - buttonSize, top));

            params.x = (int) left;
            params.y = (int) top;
            rootView.setLayoutParams(params);

            windowManager.updateViewLayout(rootView, params);

            if (listener != null) {
                listener.onTouchMove(event);
                listener.onMove(params.x, params.y);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchUp(MotionEvent event) {
        if (listener != null) {
            listener.onTouchUp(event);
        }
    }

    public void show() {
        try {
            if (rootView.getVisibility() == View.GONE) {
                rootView.setVisibility(View.VISIBLE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            viewNotification.setVisibility(View.GONE);
            rootView.setVisibility(View.GONE);
            viewTimer.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        try {
            rootView.setVisibility(View.GONE);
            windowManager.removeView(rootView);
            rootView = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    interface EventListener {
        public void onTouchUp(MotionEvent event);

        public void onTouchDown(MotionEvent event);

        public void onTouchMove(MotionEvent event);

        public void onClick(MotionEvent event);

        public void onMove(int x, int y);
    }
    OnScrollFinishedListener onScrollFinishedListener;
    interface OnScrollFinishedListener {
        void onScrollFinished();
    }
    public void setOnScrollFinishedListener(OnScrollFinishedListener onScrollFinishedListener){
        this.onScrollFinishedListener = onScrollFinishedListener;
    }

    GestureListener mGestureListener = new GestureListener();

    private class GestureListener extends GestureDetector.SimpleOnGestureListener {

        @Override
        public boolean onDown(MotionEvent e) {
            return true;
        }

        @Override
        public boolean onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        @Override
        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (listener != null) {
                listener.onClick(e);
            }
            return true;
        }

        @Override
        public void onLongPress(MotionEvent e) {
        }
    }

}
