package com.mobgame.gui.dialog;

import android.annotation.SuppressLint;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v13.app.FragmentPagerAdapter;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.WebView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.gson.Gson;
import com.mobgame.MobGameHelper;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGamePagerFragment;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.view.adapter.DashboardMenuAdapter;
import com.mobgame.js.CmdDashboard;
import com.mobgame.listener.RecyclerItemClickListener;
import com.mobgame.model.Game;
import com.mobgame.model.ItemMenuDashboard;
import com.mobgame.model.MUrl;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;

import static com.mobgame.MobGameSDK.activity;

/**
 * Created by khaitran on 7/20/17.
 */

public class MobGameDashboardDialog extends DialogFragment {
    public static final String TAG = MobGameDashboardDialog.class.getSimpleName();
    public static final String CLOSE_PROGRESS_BAR = "close_progress_bar";
    public static String KEY_DATA = "data";
    public static String KEY_ID = "parent_id";
    public static String KEY_ICON = "icon";
    public static String KEY_TIMER = "key_timer";
    public static String KEY_SHOW = "key_show";
    public static boolean isDashBoard = true;

    EventListener eventListener;

    private ImageButton btnClose;
    private RecyclerView mRecycleView;
    private RecyclerView.LayoutManager layoutManager;
    private TextView txtTitle;

    private ProgressBar circleProgressBar;
    private View rootView, layoutMain, layoutItemLeft, layoutChildContent, layoutTmp;
    private MobGamePagerFragment fragContent;
    private MobPagerAdapter adapter;
    private DashboardMenuAdapter menuAdapter;


    private int currentPage;
    private List<ItemMenuDashboard> listItemMenuDashboard = new ArrayList<>();
    private float density;
    private final String TAG_FRAGMENT = "fragment_webview";
    private String data, urlIcon;
    private int id;
    private boolean isShow;

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (eventListener != null) {
            eventListener.onDismissDashboard();
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.dialog_dashboard, container,
                false);
        try {
            int dialogSize;
            if (DeviceUtils.getScreenHeightInPixels(rootView.getContext()) > DeviceUtils.getScreenWidthInPixels(rootView.getContext())) {
                dialogSize = DeviceUtils.getScreenWidthInPixels(rootView.getContext());
            } else {
                dialogSize = DeviceUtils.getScreenHeightInPixels(rootView.getContext());
            }
            if (DeviceUtils.getScreenOrientation(rootView.getContext()) == 2) { //landscape
                LinearLayout leftDrawerLayout = rootView.findViewById(R.id.left_drawer);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(dialogSize, LinearLayout.LayoutParams.MATCH_PARENT);
                leftDrawerLayout.setLayoutParams(lp);
            } else {
                LinearLayout leftDrawerLayout = rootView.findViewById(R.id.left_drawer);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, dialogSize);
                leftDrawerLayout.setLayoutParams(lp);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        getDialog().getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        isDashBoard = true;
        getDialog().getWindow().setWindowAnimations(R.style.DialogAnimationLeftIn);
        density = DeviceUtils.getDensity(getActivity());
        long endTime = getArguments().getLong(MobGameDashboardDialog.KEY_TIMER);
        initViewLayout(endTime);
        initFragment();

        return rootView;
    }

    private List<ItemMenuDashboard> getDataItemDashboard(ArrayList<MobMenuItem> listMenuItems, Long endTimer) {
        List<ItemMenuDashboard> listMenuDashboard = new ArrayList<>();
        for (int i = listMenuItems.size() - 1; i >= 0; i--) {
            ItemMenuDashboard itemMenuDashboard = new ItemMenuDashboard();
            int idMenu = listMenuItems.get(i).getId();
            if (idMenu == 1) {
                itemMenuDashboard.setEndTimer(endTimer);
            }

            itemMenuDashboard.setId_menu(idMenu);
            ArrayList<MobMenuItem.SubMenu> SubIdMenus = listMenuItems.get(i).getSubMenu();
            itemMenuDashboard.setSubId_menu(SubIdMenus);
            int priority = listMenuItems.get(i).getPriority();
            itemMenuDashboard.setPriority(priority);
            String urlIcon = listMenuItems.get(i).getIcon();
            itemMenuDashboard.setUrlIcon(urlIcon);
            String urlIconActive = listMenuItems.get(i).getIconActive();
            itemMenuDashboard.setUrlIconActive(urlIconActive);

            boolean isShow = listMenuItems.get(i).isShow();
            itemMenuDashboard.setShow(isShow);

            itemMenuDashboard.setOpenLink(listMenuItems.get(i).getOpenLink());
            itemMenuDashboard.setOpenType(listMenuItems.get(i).getOpenType());

            if (NotificationUtils.hasNtf(getActivity(), 2) || NotificationUtils.hasNtf(getActivity(), 3)) {
                if (idMenu == 1) itemMenuDashboard.setHasNtf(true);
            }
            if (NotificationUtils.hasNtf(getActivity(), 5) || NotificationUtils.hasNtf(getActivity(), 4)) {
                if (idMenu == 4) itemMenuDashboard.setHasNtf(true);
            }
            if (NotificationUtils.hasNtf(getActivity(), 7) || NotificationUtils.hasNtf(getActivity(), 6)) {
                if (idMenu == 6) itemMenuDashboard.setHasNtf(true);
            }
            if (isShow) {
                listMenuDashboard.add(itemMenuDashboard);
            }

        }

        return listMenuDashboard;
    }

    //Ham nay de setup phan ntf & title cua dashboard
    private void initLeftLayout(ArrayList<MobMenuItem> listMenuItems) {
        try {
            // TODO gone ntf icon
            ArrayList<MobMenuItem.SubMenu> listSubMenu = new ArrayList<MobMenuItem.SubMenu>();
            //TODO xu ly phan title cua dashboard rieng o day
            if (listSubMenu == null) {
                Log.d(TAG, "SubMenu null");
                return;
            } else {
                txtTitle.setVisibility(View.GONE);
                JSONArray items = null;
                data = new Gson().toJson(listSubMenu).toString();
                Log.d(TAG, "data news:" + data);
                items = new JSONArray(data);
                loadUrls(items);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    private void initFragment() {
        try {
            fragContent = new MobGamePagerFragment(getActivity());
            fragContent.addOnPageChangeListener(mOnPageChangeListener);
            fragContent.setWebEventListener(mWebEventListener);

            getChildFragmentManager().beginTransaction().add(layoutChildContent.getId(), fragContent, TAG_FRAGMENT).commit();
            try {
                data = getArguments().getString(KEY_DATA);
                id = getArguments().getInt(KEY_ID);
                urlIcon = getArguments().getString(KEY_ICON);
                isShow = getArguments().getBoolean(KEY_SHOW);
                Log.d(TAG, "data : " + data);
                JSONArray items = new JSONArray(data);
                loadUrls(items);
            } catch (Exception e) {
                try {
                    performOnItemClick(0);
                } catch (IndexOutOfBoundsException | NullPointerException e2) {
                    performOnItemClick(0);
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initViewLayout(long endTimer) {
        try {
            final ArrayList<MobMenuItem> listMenuItems = GameConfigManager.getInstance().getMobMenu().getMenuItems();

            layoutTmp = rootView.findViewById(R.id.layout_tmp);
            layoutMain = rootView.findViewById(R.id.layout_main_dashboard);
            layoutItemLeft = rootView.findViewById(R.id.layout_item_left);
            layoutChildContent = rootView.findViewById(R.id.layout_child_content);

            txtTitle = rootView.findViewById(R.id.title_item);
            btnClose = rootView.findViewById(R.id.btn_close_dashboard);
            mRecycleView = rootView.findViewById(R.id.recycleview_menu);
            layoutManager = new LinearLayoutManager(getActivity());
            mRecycleView.setLayoutManager(layoutManager);

            listItemMenuDashboard = getDataItemDashboard(listMenuItems, endTimer);
            ItemMenuDashboard smallest = listItemMenuDashboard.get(0);
            for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                if (listItemMenuDashboard.get(i).getPriority() < smallest.getPriority()) {
                    smallest = listItemMenuDashboard.get(i);
                }
            }
            for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                if (smallest.getPriority() == listItemMenuDashboard.get(i).getPriority()) {
                    listItemMenuDashboard.get(i).setClick(true);
                    if(smallest.getId_menu() == 1){
                        txtTitle.setVisibility(View.GONE);
                    }
                }
            }
            menuAdapter = new DashboardMenuAdapter(listItemMenuDashboard, getActivity());
            mRecycleView.setAdapter(menuAdapter);

            circleProgressBar = rootView.findViewById(R.id.circle_progress_bar);

//            initLeftLayout(listMenuItems);
            btnClose.setOnClickListener(v -> {
                isDashBoard = false;
                Log.d(TAG, "Close button clicked");
                dismiss();
                Game game = GameConfigManager.getInstance().getGameConfig();
                boolean isShowLogo = game.getEx().isShowLogo();
                if (isShowLogo) {
                    MobGameHelper.showNotiFloatButton();
                }

                Preference.remove(getActivity(), Constants.SHARED_PREF_SHOW_DASHBOARD);
                MobGameHelper.showFloatButton();
            });

            layoutTmp.setOnClickListener(v -> {
                try {
                    Log.d(TAG, "tmp clicked");
                    dismiss();

                    Game game = GameConfigManager.getInstance().getGameConfig();
                    boolean isShowLogo = game.getEx().isShowLogo();
                    if (isShowLogo) {
                        MobGameHelper.showNotiFloatButton();
                    }

                    Preference.remove(getActivity(), Constants.SHARED_PREF_SHOW_DASHBOARD);
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "float_button");
                    LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(intent);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            Animation animationTmp = AnimationUtils.loadAnimation(getActivity(), R.anim.fade_in);
            layoutTmp.setAnimation(animationTmp);

            getDialog().setOnKeyListener((dialog, keyCode, event) -> {
                if (event != null && (keyCode == KeyEvent.KEYCODE_BACK) && (event.getAction() == KeyEvent.ACTION_UP)) {
                    dismiss();
                    Game game = GameConfigManager.getInstance().getGameConfig();
                    boolean isShowLogo = game.getEx().isShowLogo();
                    if (isShowLogo) {
                        MobGameHelper.showNotiFloatButton();
                    }

                    Preference.remove(getActivity(), Constants.SHARED_PREF_SHOW_DASHBOARD);
                    MobGameHelper.showFloatButton();
                    return true;
                }
                return false;
            });

            Preference.save(getActivity(), Constants.SHARED_PREF_SHOW_DASHBOARD, true);

            mRecycleView.addOnItemTouchListener(new RecyclerItemClickListener(getActivity(), mRecycleView, new RecyclerItemClickListener.OnItemClickListener() {
                @Override
                public void onItemClick(View view, int position) {
                    ItemMenuDashboard itemMenuDashboard = listItemMenuDashboard.get(position);
                    switch (itemMenuDashboard.getOpenType()) {
                        //todo sửa opentype
                        case 0:
                            for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                                if (i == position) {
                                    listItemMenuDashboard.get(i).setClick(true);
                                } else {
                                    listItemMenuDashboard.get(i).setClick(false);
                                }
                            }
                            menuAdapter.notifyDataSetChanged();
                            String data = "";
                            try {
                                if (listItemMenuDashboard.get(position).getSubId_menu() == null) {
                                    Log.d(TAG, "SubMenu null");
                                    return;
                                } else {
                                    txtTitle.setVisibility(View.VISIBLE);
                                    JSONArray items = null;
                                    data = new Gson().toJson(listItemMenuDashboard.get(position).getSubId_menu()).toString();
                                    Log.d(TAG, "data report bug :" + data);
                                    items = new JSONArray(data);
                                    loadUrls(items);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                            switch (itemMenuDashboard.getId_menu()) {
                                case 1:
                                    txtTitle.setVisibility(View.GONE);
                                    if (!NotificationUtils.hasNtf(getActivity(), 2) && !NotificationUtils.hasNtf(getActivity(), 3)) {
                                        itemMenuDashboard.setHasNtf(false);
                                    }
                                    Log.d(TAG, "addOnItemTouchListener : " + 1);
                                    handleNewEvent();
                                    menuAdapter.notifyDataSetChanged();
                                    break;
                                case 4:
                                    itemMenuDashboard.setHasNtf(false);
                                    menuAdapter.notifyDataSetChanged();
                                    Log.d(TAG, "addOnItemTouchListener : " + 4);
                                    handleGiftcode();
                                    break;
                                case 6:
                                    itemMenuDashboard.setHasNtf(false);
                                    menuAdapter.notifyDataSetChanged();
                                    Log.d(TAG, "addOnItemTouchListener : " + 6);
                                    handleBug();
                                    break;
                                case 8:
                                    Log.d(TAG, "addOnItemTouchListener : " + 8);
                                    handleOther();
                                    break;
                                case 10:
                                    Toast.makeText(getActivity(), "id : " + 10, Toast.LENGTH_SHORT).show();
                                    break;
                            }
                            break;
                        case 2:
                            showFragment(itemMenuDashboard.getOpenLink(), itemMenuDashboard.getOpenType(), false);
                            break;
                        case 3:
//                            isDashBoard = false;
//                            dismiss();
                            showFragment(itemMenuDashboard.getOpenLink(), itemMenuDashboard.getOpenType(), false);
                            break;
                    }
                }

                @Override
                public void onItemLongClick(View view, int position) {

                }
            }));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleOther() {
        hideTabs();
        isDashBoard = false;
    }

    private void handleBug() {
        if (NotificationUtils.hasNtf(getActivity(), 7)) {
            NotificationUtils.removeNtf(getActivity(), 7);
        }
        if (NotificationUtils.hasNtf(getActivity(), 6)) {
            NotificationUtils.removeNtf(getActivity(), 6);
        }
        hideTabs();
        isDashBoard = false;
        trackEventFromButton(Constants.STR_EVENT_BUGS, "root_report_bugs");
    }

    private void handleGiftcode() {
        if (NotificationUtils.hasNtf(getActivity(), 5)) {
            NotificationUtils.removeNtf(getActivity(), 5);
        }
        if (NotificationUtils.hasNtf(getActivity(), 4)) {
            NotificationUtils.removeNtf(getActivity(), 4);
        }
        hideTabs();
        isDashBoard = false;
        trackEventFromButton(Constants.STR_EVENT_GIFTCODE, "root_giftcode");
    }

    private void handleNewEvent() {
        showTabs();
        isDashBoard = true;
        trackEventFromButton(Constants.STR_EVENT_NEWS, "root_news_event");
    }

    private void showTabs() {
        try {
            if (fragContent != null) {
                fragContent.showTabs(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideTabs() {
        try {
            if (fragContent != null) {
                fragContent.hideTabs(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {
        setStyle(STYLE_NO_TITLE, android.R.style.Theme_Translucent_NoTitleBar);
        super.onCreate(savedInstanceState);
    }

    private void performOnItemClick(int position) {

    }

    public void loadUrls(JSONArray items) {
        Log.e(TAG, "item:" + items.toString());
        if (adapter == null) {
            adapter = new MobPagerAdapter(getChildFragmentManager());
        }
        currentPage = 0;
        JSONArray revItems = new JSONArray();
        for (int i = 0; i < items.length(); i++) {
            try {
                JSONObject item = items.getJSONObject(i);
                revItems.put(item);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = items.length() - 1; i >= 0; i--) {
            try {
                JSONObject item = revItems.getJSONObject(i);
                if (item.getInt("priority") < revItems.getJSONObject(currentPage).getInt("priority")) {
                    currentPage = i;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            adapter.setItems(revItems);
            fragContent.setAdapter(adapter, currentPage);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener() {

        @SuppressLint("JavascriptInterface")
        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                getActivity().runOnUiThread(() -> {
                    MobGameWebFragment fragWeb = adapter.getItem(currentPage);
                    Log.i(TAG, "fragContent.countTabs(): " + fragContent.countTabs());
                    if (Utils.isOnline(getActivity())) {
                        if (fragContent.countTabs() > 1 && !fragWeb.canGoBack()) {
                            fragContent.showTabs(false);
                            new Handler().postDelayed(() -> {
                            }, 1000);
                        } else {
                            fragContent.hideTabs(true);
                        }
                    } else {
                        if (fragContent.countTabs() > 1) {
                            fragContent.showTabs(false);
                        } else {
                            fragContent.hideTabs(false);
                        }
                    }

                });
                view.addJavascriptInterface(getActivity(), "android");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            int pos = Integer.parseInt((String) view.getTag());
            if (pos == currentPage) {
                progress = Math.max(1, progress);
                circleProgressBar.setProgress(progress);
                if (progress == 100) {
                    hideProgressBar();
                } else {
                    showProgressBar();
                }
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            int pos = Integer.parseInt((String) view.getTag());
            if (pos == currentPage) {
                hideProgressBar();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {

        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }

    };

    @Override
    public void show(FragmentManager manager, String tag) {
        try {
            FragmentTransaction ft = manager.beginTransaction();
            ft.add(this, tag);
            ft.commitAllowingStateLoss();
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    private ViewPager.SimpleOnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener() {

        @Override
        public void onPageSelected(int position) {
            if (position != currentPage) {
                currentPage = position;

                MobGameWebFragment fragWeb = adapter.getItem(currentPage);
                fragWeb.loadUrlToLoadIfHave();
                mWebEventListener.onScrollChanged(fragWeb.getWebView(),
                        fragWeb.getScrollX(), fragWeb.getScrollY(),
                        fragWeb.getScrollX(), fragWeb.getScrollY());
            }
            int itemId = (int) adapter.getItemId(position);
            if (NotificationUtils.hasNtf(getActivity(), itemId)) {
                hideNtf(itemId);
                //TODO gone ntf icon
                getActivity().runOnUiThread(() -> fragContent.notifiTabsChanged());
            }
        }
    };


    @Override
    public void onPause() {
        super.onPause();
//        circleProgressBar.setVisibility(View.GONE);
        try {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(mBroadcastReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(
                    mBroadcastReceiver, new IntentFilter(Constants.INTENT_FILTER)
            );
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "float_button");
            intent.putExtra("message", "hide");
            LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                String category = intent.getStringExtra("category");
                if ("gcm".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    Log.d(TAG, "funtap :" + strId);
                    if (strId != null) {
                        fragContent.notifiTabsChanged();
                    }
                    int id = Integer.parseInt(strId);
                    showNtf(id);

                    //TODO : xu ly event duoc lang nghe khi co ntf moi
                } else if ("swipe_refresh".equalsIgnoreCase(category)) {
                    String strId = intent.getStringExtra("id");
                    int id = Integer.parseInt(strId);
                    //TODO : xu ly event duoc lang nghe khi co ntf moi
                    hideNtf(id);
                    fragContent.notifiTabsChanged();

                }
                if (intent.hasExtra(CLOSE_PROGRESS_BAR)) {
                    circleProgressBar.setVisibility(View.GONE);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void showNtf(int id) {
        if (NotificationUtils.hasNtf(getActivity(), id)) {
            switch (id) {
                case 2:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 1) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 3:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 1) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 4:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 4) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 5:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 4) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 6:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 6) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 7:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 6) {
                            listItemMenuDashboard.get(i).setHasNtf(true);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
            }

        }
    }

    private void hideNtf(int id) {
        if (NotificationUtils.hasNtf(getActivity(), id)) {
            switch (id) {
                case 2:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 1) {
                            NotificationUtils.removeNtf(getActivity(), id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 3:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 1) {
                            NotificationUtils.removeNtf(getActivity(), id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 4:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 4) {
                            NotificationUtils.removeNtf(getActivity(), id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 5:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 4) {
                            NotificationUtils.removeNtf(getActivity(), id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 6:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 6) {
                            NotificationUtils.removeNtf(getActivity(), id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
                case 7:
                    for (int i = 0; i < listItemMenuDashboard.size(); i++) {
                        if (listItemMenuDashboard.get(i).getId_menu() == 6) {
                            NotificationUtils.removeNtf(getActivity(), id);
                            listItemMenuDashboard.get(i).setHasNtf(false);
                            menuAdapter.notifyDataSetChanged();
                            break;
                        }
                    }
                    break;
            }

        }
    }

    private class MobPagerAdapter extends FragmentPagerAdapter {

        private ArrayList<MobGameWebFragment> fragments;
        private FragmentManager fragmentManager;
        private JSONArray items;

        {
            fragments = new ArrayList<>();
        }

        public MobPagerAdapter(FragmentManager fm) {
            super(fm);
            this.fragmentManager = fm;
        }

        public void setItems(JSONArray items) {
            releaseFragments();
            this.items = items;
            fragments = new ArrayList<MobGameWebFragment>();
            for (int i = 0; i < items.length(); i++) {
                try {
                    JSONObject item = items.getJSONObject(i);
                    String url = item.getString("action");
                    int id = item.getInt("id");
                    MobGameWebFragment frag;
                    if (i == currentPage) {
                        frag = new MobGameWebFragment(url, id);
                    } else {
                        frag = new MobGameWebFragment(url, true, id);
                    }
                    frag.setEventListener(mWebEventListener);
                    frag.setWebViewTag(i + "");
                    fragments.add(frag);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public MobGameWebFragment getItem(int position) {
            try {
                return fragments.get(position);
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public int getCount() {
            try {
                return fragments.size();
            } catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        @Override
        public long getItemId(int position) {
            try {
                return items.getJSONObject(position).getInt("id");
            } catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }

        @Override
        public int getItemPosition(Object object) {
            return POSITION_NONE;
        }

        @Override
        public CharSequence getPageTitle(int position) {
            try {
                JSONObject item = items.getJSONObject(position);
                int id = item.getInt("id");
                if (item.has("title")) {
                    String title = item.getString("title");
                    txtTitle.setText(title.toString());
                    if (NotificationUtils.hasNtf(getActivity(), id)) {
                        Drawable image = Res.drawable(getActivity(), R.drawable.ic_notification_tab_strip);
                        image.setBounds(0, 0, image.getIntrinsicWidth(), image.getIntrinsicHeight());
                        SpannableString sb = new SpannableString(title + "  ");
                        ImageSpan imageSpan = new ImageSpan(image, ImageSpan.ALIGN_BASELINE);
                        sb.setSpan(imageSpan, title.length() + 1, title.length() + 2, Spannable.SPAN_INCLUSIVE_INCLUSIVE);
                        return sb;
                    }
                    return title;
                } else {
                    return "Tab " + position;
                }

            } catch (Exception e) {
                e.printStackTrace();
                return "Tab " + position;
            }
        }

        private void releaseFragments() {
            try {
                if (fragments != null) {
                    for (MobGameWebFragment frag : fragments) {
                        frag.stopLoading();
                        fragmentManager.beginTransaction().remove(frag).commit();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void hideProgressBar() {
        try {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        circleProgressBar.setVisibility(View.GONE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        circleProgressBar.setVisibility(View.VISIBLE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FirebaseAnalytics mFirebaseAnalytics;

    private void trackEventFromButton(String eventName, String data) {
        try {
            Log.d(TAG, "event : " + eventName + " , data : " + data);
            mFirebaseAnalytics = FirebaseAnalytics.getInstance(getActivity());
            Bundle bundle = new Bundle();
            bundle.putString("data", data);
            mFirebaseAnalytics.logEvent(eventName, bundle);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EventListener getEventListener() {
        return eventListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public interface EventListener {
        void onDismissDashboard();
    }

    private void showFragment(String url, int openType, boolean isEncrypted) {
        try {
            if (url != null && !url.equals("")) {
                FragmentManager fm = getActivity().getFragmentManager();
                MobGameSocialDialogFragment fr = (MobGameSocialDialogFragment) fm
                        .findFragmentByTag(Constants.TAG_FRAGMENT);

                if (fr == null) {
                    fr = new MobGameSocialDialogFragment(new MUrl(url, isEncrypted));
                    FragmentTransaction fragmentTransaction = fm.beginTransaction();
                    fragmentTransaction.add(fr, Constants.TAG_FRAGMENT);
                    // fragmentTransaction.commit();
                    fr.setOnDismissListener(dialog -> {
                        if (isDashBoard) {
                            Preference.save(getActivity(), Constants.SHARED_PREF_SHOW_DASHBOARD, true);
                        } else {
                            Game game = GameConfigManager.getInstance().getGameConfig();
                            boolean isShowLogo = game.getEx().isShowLogo();
                            if (isShowLogo) {
                                MobGameHelper.showNotiFloatButton();
                            }

                            Preference.remove(getActivity(), Constants.SHARED_PREF_SHOW_DASHBOARD);
//                            if (openType == 3) {
//                                MobGameHelper.showFloatButton();
//                            }
                        }
                    });
                    fragmentTransaction.commitAllowingStateLoss();
                } else {
                    try {
                        fr.loadUrlWithMobHeaders(new MUrl(url, isEncrypted));
                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Log.d(TAG, "url null");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
