/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils.iab;

import android.text.TextUtils;
import android.util.Log;
import com.mobgame.utils.iab.Base64;
import com.mobgame.utils.iab.Base64DecoderException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class Security {
    private static final String TAG = "IABUtil/Security";
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    public static boolean verifyPurchase(String base64PublicKey, String signedData, String signature) {
        if (TextUtils.isEmpty((CharSequence)signedData) || TextUtils.isEmpty((CharSequence)base64PublicKey) || TextUtils.isEmpty((CharSequence)signature)) {
            Log.e((String)TAG, (String)"Purchase verification failed: missing data.");
            return false;
        }
        PublicKey key = Security.generatePublicKey(base64PublicKey);
        return Security.verify(key, signedData, signature);
    }

    public static PublicKey generatePublicKey(String encodedPublicKey) {
        try {
            byte[] decodedKey = Base64.decode(encodedPublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            return keyFactory.generatePublic(new X509EncodedKeySpec(decodedKey));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            Log.e((String)TAG, (String)"Invalid key specification.");
            throw new IllegalArgumentException(e);
        }
        catch (Base64DecoderException e) {
            Log.e((String)TAG, (String)"Base64 decoding failed.");
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean verify(PublicKey publicKey, String signedData, String signature) {
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
            sig.initVerify(publicKey);
            sig.update(signedData.getBytes());
            if (!sig.verify(Base64.decode(signature))) {
                Log.e((String)TAG, (String)"Signature verification failed.");
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)"NoSuchAlgorithmException.");
        }
        catch (InvalidKeyException e) {
            Log.e((String)TAG, (String)"Invalid key specification.");
        }
        catch (SignatureException e) {
            Log.e((String)TAG, (String)"Signature exception.");
        }
        catch (Base64DecoderException e) {
            Log.e((String)TAG, (String)"Base64 decoding failed.");
        }
        return false;
    }
}

