package com.mobgame.model;

import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;

public class UserInfo {
	
	@SerializedName("user")
	private User user;

	@SerializedName("title")
	private String title;

	@SerializedName("coin")
	private int coin;

	private boolean enableTimer;

	private TimerData timerData;
	
	public UserInfo() {}
	
	public static UserInfo parse(String json) {
		Gson gson = new GsonBuilder().create();
		UserInfo game = gson.fromJson(json.trim(), UserInfo.class);
		return game;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public int getCoin() {
		return coin;
	}

	public void setCoin(int coin) {
		this.coin = coin;
	}

	public class User {

		@SerializedName("avatar_url")
		private String avatarUrl;

		@SerializedName("user_id")//ok
		private String userId;

		@SerializedName("account_id")//ok
		private String accountId;

		@SerializedName("user_name")//ok
		private String userName;

		@SerializedName("role")//ok
		private String role;
		
		@SerializedName("email")//ok
		private String email;
		
		@SerializedName("full_name")
		private String fullName;
		@SerializedName("vip")//ok
		private String vip;

		@SerializedName("vip_image")//ok
		private String vipImage;

		@SerializedName("last_action")//ok
		private String lastAction;

		@SerializedName("country_code")//ok
		private String countryCode;

		public String getLastAction() {
			return lastAction;
		}

		public void setLastAction(String lastAction) {
			this.lastAction = lastAction;
		}

		public String getCountryCode() {
			return countryCode;
		}

		public void setCountryCode(String countryCode) {
			this.countryCode = countryCode;
		}

		public String getVip() {
			return vip;
		}

		public void setVip(String vip) {
			this.vip = vip;
		}

		public String getVipImage() {
			return vipImage;
		}

		public void setVipImage(String vipImage) {
			this.vipImage = vipImage;
		}

		public String getAvatarUrl() {
			return avatarUrl;
		}

		public void setAvatarUrl(String avatarUrl) {
			this.avatarUrl = avatarUrl;
		}

		public String getUserId() {
			return userId;
		}

		public void setUserId(String userId) {
			this.userId = userId;
		}

		public String getAccountId() {
			return accountId;
		}

		public void setAccountId(String accountId) {
			this.accountId = accountId;
		}

		public String getUserName() {
			return userName;
		}

		public void setUserName(String userName) {
			this.userName = userName;
		}

		public String getRole() {
			return role;
		}

		public void setRole(String role) {
			this.role = role;
		}

		public String getEmail() {
			return email;
		}

		public void setEmail(String email) {
			this.email = email;
		}

		public String getFullName() {
			return fullName;
		}

		public void setFullName(String fullName) {
			this.fullName = fullName;
		}
		
	}

	public void setEnableTimer(boolean enableTimer) {
		this.enableTimer = enableTimer;
	}

	public boolean isEnableTimer(){
		return this.enableTimer;
	}

	public void setTimerData(TimerData timerData) {
//		if(timerData != null){
//			ArrayList<TimerObject> listTimer = new ArrayList<>();
//			listTimer = timerData.getListTimerObject();
//			Comparator<TimerObject> cmp = new Comparator<TimerObject>() {
//
//				@Override
//				public int compare(TimerObject a, TimerObject b) {
//					// TODO Auto-generated method stub
//					if(a.getEndTime() != b.getEndTime()){
//						return (int)(a.getEndTime() - b.getEndTime());
//					}
//					return b.getEndTime().compareTo(a.getEndTime());
//				}
//			};
//			Collections.sort(listTimer , cmp);
//			timerData.setListTimerObject(listTimer);
//			for (TimerObject t: listTimer) {
//				Log.e("TAG" , "endTimer : " + t.getEndTime());
//			}
//		}
		this.timerData = timerData;
		ArrayList<TimerObject> listTimer = new ArrayList<>();
		listTimer = timerData.getListTimerObject();
		for (TimerObject t: listTimer) {
				Log.e("TAG" , "endTimer : " + t.getEndTime());
		}
	}

	public TimerData getTimerData(){
		return this.timerData;
	}

}
