package com.mobgame.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
public class IngameNoti {
    @SerializedName("link")
    @Expose
    private String link;
    @SerializedName("text")
    @Expose
    private String text;
    @SerializedName("type")
    @Expose
    private Integer type;

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public IngameNoti() {
    }

    public IngameNoti(String link, String text, Integer type) {
        this.link = link;
        this.text = text;
        this.type = type;
    }

    public static ArrayList<IngameNoti> parse(String json){
        ArrayList<IngameNoti> notiList = new ArrayList<>();
        if(json != null){
            try {
                JSONArray jsonArray = new JSONArray(json);
                for (int i = 0 ; i < jsonArray.length() ; i++){
                    IngameNoti item = new IngameNoti();
                    JSONObject jsonObj = jsonArray.getJSONObject(i);
                    if(jsonObj.has("text")){
                        item.setText(jsonObj.getString("text"));
                    }
                    if(jsonObj.has("link")){
                        item.setLink(jsonObj.getString("link"));
                    }
                    if(jsonObj.has("type")){
                        item.setType(jsonObj.getInt("type"));
                    }
                    notiList.add(item);
                }
                return notiList;
            } catch (JSONException e) {
                e.printStackTrace();
                return notiList;
            }
        }
        return notiList;
    }
}
