/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class UserInfo {
    @SerializedName(value="user")
    private User user;
    @SerializedName(value="userDaily")
    private UserDaily userDaily;
    private boolean enableTimer;
    private TimerData timerData;

    public static UserInfo parse(String json) {
        Gson gson = new GsonBuilder().create();
        UserInfo game = (UserInfo)gson.fromJson(json.trim(), UserInfo.class);
        return game;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public UserDaily getUserDaily() {
        return this.userDaily;
    }

    public void setUserDaily(UserDaily userDaily) {
        this.userDaily = userDaily;
    }

    public void setEnableTimer(boolean enableTimer) {
        this.enableTimer = enableTimer;
    }

    public boolean isEnableTimer() {
        return this.enableTimer;
    }

    public void setTimerData(TimerData timerData) {
        if (timerData != null) {
            ArrayList<TimerObject> listTimer = new ArrayList();
            listTimer = timerData.getListTimerObject();
            Comparator<TimerObject> cmp = new Comparator<TimerObject>(){

                @Override
                public int compare(TimerObject a, TimerObject b) {
                    if (a.getEndTime() != b.getEndTime()) {
                        return (int)(a.getEndTime() - b.getEndTime());
                    }
                    return a.getEndTime().compareTo(b.getEndTime());
                }
            };
            Collections.sort(listTimer, cmp);
            timerData.setListTimerObject(listTimer);
        }
        this.timerData = timerData;
    }

    public TimerData getTimerData() {
        return this.timerData;
    }

    public class User {
        @SerializedName(value="avatar_url")
        private String avatarUrl;
        @SerializedName(value="user_id")
        private String userId;
        @SerializedName(value="account_id")
        private String accountId;
        @SerializedName(value="user_name")
        private String userName;
        @SerializedName(value="role")
        private String role;
        @SerializedName(value="email")
        private String email;
        @SerializedName(value="full_name")
        private String fullName;
        @SerializedName(value="vip")
        private String vip;
        @SerializedName(value="vip_image")
        private String vipImage;

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public String getVipImage() {
            return this.vipImage;
        }

        public void setVipImage(String vipImage) {
            this.vipImage = vipImage;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }
    }

    public class UserDaily {
        @SerializedName(value="title")
        private String title;
        @SerializedName(value="bonus_info")
        private int bonusInfo;
        @SerializedName(value="bonus_facebook")
        private int bonusFacebook;
        @SerializedName(value="bonus_email")
        private int bonusEmail;
        @SerializedName(value="coin")
        private int coin;
        @SerializedName(value="type_user")
        private String typeUser;
        @SerializedName(value="type_hello")
        private int typeHello;
        @SerializedName(value="title_notice")
        private String tooltip;
        @SerializedName(value="update_info")
        private Details updateInfoDetails;
        @SerializedName(value="upgrade_email")
        private Details upgradeEmailDetails;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public int getBonusInfo() {
            return this.bonusInfo;
        }

        public void setBonusInfo(int bonusInfo) {
            this.bonusInfo = bonusInfo;
        }

        public int getBonusFacebook() {
            return this.bonusFacebook;
        }

        public void setBonusFacebook(int bonusFacebook) {
            this.bonusFacebook = bonusFacebook;
        }

        public int getBonusEmail() {
            return this.bonusEmail;
        }

        public void setBonusEmail(int bonusEmail) {
            this.bonusEmail = bonusEmail;
        }

        public int getCoin() {
            return this.coin;
        }

        public void setCoin(int coin) {
            this.coin = coin;
        }

        public String getTypeUser() {
            return this.typeUser;
        }

        public void setTypeUser(String typeUser) {
            this.typeUser = typeUser;
        }

        public int getTypeHello() {
            return this.typeHello;
        }

        public void setTypeHello(int typeHello) {
            this.typeHello = typeHello;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }

        public Details getUpdateInfoDetails() {
            return this.updateInfoDetails;
        }

        public void setUpdateInfoDetails(Details updateInfoDetails) {
            this.updateInfoDetails = updateInfoDetails;
        }

        public Details getUpgradeEmailDetails() {
            return this.upgradeEmailDetails;
        }

        public void setUpgradeEmailDetails(Details upgradeEmailDetails) {
            this.upgradeEmailDetails = upgradeEmailDetails;
        }

        public class Details {
            @SerializedName(value="url")
            private String url;
            @SerializedName(value="type_open")
            private int type;

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public int getType() {
                return this.type;
            }

            public void setType(int type) {
                this.type = type;
            }
        }
    }
}

