/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.appsflyer.AFExecutor;
import com.appsflyer.AFKeystoreWrapper;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.ConversionDataListener;
import com.appsflyer.DebugLogQueue;
import com.appsflyer.cache.CacheManager;
import com.appsflyer.cache.RequestCacheData;
import com.appsflyer.f;
import com.appsflyer.g;
import com.appsflyer.h;
import com.appsflyer.i;
import com.appsflyer.j;
import com.appsflyer.k;
import com.appsflyer.l;
import com.google.android.gms.common.GoogleApiAvailability;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppsFlyerLib {
    private static final String SERVER_BUILD_NUMBER = "4.7.4".substring(0, "4.7.4".indexOf("."));
    public static final String LOG_TAG = "AppsFlyer_4.7.4";
    public static final String APPS_TRACKING_URL = "https://t.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=4.7.4" + "&app_id=";
    public static final String EVENTS_TRACKING_URL = "https://events.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=4.7.4" + "&app_id=";
    static final String REGISTER_URL = "https://register.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=4.7.4" + "&app_id=";
    static final String VALIDATE_WH_URL = "https://validate.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=4.7.4" + "&app_id=";
    private long lastSuccessfulLaunchTimestamp = -1L;
    public static final String ATTRIBUTION_ID_CONTENT_URI = "content://com.facebook.katana.provider.AttributionIdProvider";
    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final List<String> IGNORABLE_KEYS = Arrays.asList("is_cache");
    public static final String PRE_INSTALL_SYSTEM_RO_PROP = "ro.appsflyer.preinstall.path";
    public static final String PRE_INSTALL_SYSTEM_DEFAULT = "/data/local/tmp/pre_install.appsflyer";
    public static final String PRE_INSTALL_SYSTEM_DEFAULT_ETC = "/etc/pre_install.appsflyer";
    public static final String AF_PRE_INSTALL_PATH = "AF_PRE_INSTALL_PATH";
    public static final long LAUNCH_BLOCKING_TIME_WINDOW = TimeUnit.SECONDS.toMillis(5L);
    private static AppsFlyerConversionListener conversionDataListener = null;
    static AppsFlyerInAppPurchaseValidatorListener validatorListener = null;
    private boolean isDuringCheckCache = false;
    private long lastCacheCheck;
    private ScheduledExecutorService cacheScheduler = null;
    private long timeEnteredForeground;
    private long timeWentToBackground;
    private static AppsFlyerLib instance = new AppsFlyerLib();
    private i.b listener;
    String userCustomImei;
    String userCustomAndroidId;
    private Uri latestDeepLink = null;
    private long testModeStartTime;
    private boolean isRetargetingTestMode = false;
    private String pushPayload;
    private Map<Long, String> pushPayloadHistory;
    private boolean isTokenRefreshServiceConfigured;

    /*
     * WARNING - void declaration
     */
    void onReceive(Context context, Intent intent) {
        String string = intent.getStringExtra("shouldMonitor");
        if (string != null) {
            com.appsflyer.a.afLog("Turning on monitoring.");
            AppsFlyerProperties.getInstance().set("shouldMonitor", string.equals("true"));
            this.monitor(context, null, "START_TRACKING", context.getPackageName());
            return;
        }
        com.appsflyer.a.afLog("****** onReceive called *******");
        this.debugAction("******* onReceive: ", "", context);
        AppsFlyerProperties.getInstance().setOnReceiveCalled();
        string = intent.getStringExtra("referrer");
        com.appsflyer.a.afLog("Play store referrer: " + string);
        if (string != null) {
            String string2;
            if ((string2 = string2.getStringExtra("TestIntegrationMode")) != null && string2.equals("AppsFlyer_Test")) {
                string2 = context.getSharedPreferences("appsflyer-data", 0);
                string2 = string2.edit();
                string2.clear();
                this.editorCommit((SharedPreferences.Editor)string2);
                AppsFlyerProperties.getInstance().setFirstLaunchCalled(false);
                this.startTestMode();
            }
            this.debugAction("onReceive called. referrer: ", string, context);
            this.saveDataToSharedPreferences(context, "referrer", string);
            AppsFlyerProperties.getInstance().setReferrer(string);
            if (AppsFlyerProperties.getInstance().isFirstLaunchCalled()) {
                void var1_1;
                com.appsflyer.a.afLog("onReceive: isLaunchCalled");
                this.backgroundReferrerLaunch((Context)var1_1, string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void addReferrer(Context context, String referrer) {
        com.appsflyer.a.afDebugLog("received a new (extra) referrer: " + referrer);
        try {
            void var1_1;
            JSONArray jSONArray;
            long l2 = System.currentTimeMillis();
            Object object = context.getSharedPreferences("appsflyer-data", 0);
            object = object.getString("extraReferrers", null);
            if (object == null) {
                object = new JSONObject();
                jSONArray = new JSONArray();
            } else {
                jSONArray = (object = new JSONObject((String)object)).has(referrer) ? new JSONArray((String)object.get(referrer)) : new JSONArray();
            }
            if (jSONArray.length() <= 4) {
                jSONArray.put(l2);
            }
            object.put(referrer, (Object)jSONArray.toString());
            this.saveDataToSharedPreferences((Context)var1_1, "extraReferrers", object.toString());
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
        catch (Throwable throwable) {
            void var2_2;
            com.appsflyer.a.afLogE("Couldn't save referrer - " + (String)var2_2 + ": ", throwable);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"CommitPrefEdits"})
    void editorCommit(SharedPreferences.Editor editor) {
        void var1_1;
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
            return;
        }
        var1_1.commit();
    }

    private void startTestMode() {
        com.appsflyer.a.afLog("Test mode started..");
        this.testModeStartTime = System.currentTimeMillis();
    }

    private void endTestMode() {
        com.appsflyer.a.afLog("Test mode ended!");
        this.testModeStartTime = 0L;
    }

    private boolean isInTestMode(Context context) {
        String string;
        long l2 = System.currentTimeMillis() - this.testModeStartTime;
        string = AppsFlyerProperties.getInstance().getReferrer((Context)string);
        return l2 <= 30000L && string != null && string.contains("AppsFlyer_Test");
    }

    private AppsFlyerLib() {
    }

    public static AppsFlyerLib getInstance() {
        return instance;
    }

    public String getSdkVersion() {
        l.getInstance().addApiEvent("getSdkVersion", new String[0]);
        return "version: 4.7.4 (build 333)";
    }

    /*
     * WARNING - void declaration
     */
    private void registerForAppEvents(Application application) {
        if (this.listener == null) {
            void var1_1;
            AppsFlyerProperties.getInstance().loadProperties(application.getApplicationContext());
            if (Build.VERSION.SDK_INT >= 14) {
                i.init();
                this.listener = new com.appsflyer.a(this);
                i.getInstance().registerListener(application, this.listener);
                return;
            }
            com.appsflyer.a.afLog("SDK<14 call trackAppLaunch manually");
            this.trackEventInternal(var1_1.getApplicationContext(), null, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setGCMProjectID(String projectNumber) {
        void var1_1;
        l.getInstance().addApiEvent("setGCMProjectID", projectNumber);
        com.appsflyer.a.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please follow the documentation.");
        this.enableUninstallTracking((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setGCMProjectNumber(String projectNumber) {
        void var1_1;
        l.getInstance().addApiEvent("setGCMProjectNumber", projectNumber);
        com.appsflyer.a.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please follow the documentation.");
        this.enableUninstallTracking((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setGCMProjectNumber(Context context, String projectNumber) {
        void var2_2;
        l.getInstance().addApiEvent("setGCMProjectNumber", projectNumber);
        com.appsflyer.a.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please use 'enableUninstallTracking'.");
        this.enableUninstallTracking((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void enableUninstallTracking(String senderId) {
        void var1_1;
        l.getInstance().addApiEvent("enableUninstallTracking", senderId);
        this.setProperty("gcmProjectNumber", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void updateServerUninstallToken(Context context, String token) {
        if (token != null) {
            void var1_1;
            com.appsflyer.b b2;
            b2 = new com.appsflyer.b((String)((Object)b2));
            com.appsflyer.a.updateServerUninstallToken((Context)var1_1, b2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDebugLog(boolean shouldEnable) {
        void var1_1;
        l.getInstance().addApiEvent("setDebugLog", String.valueOf(shouldEnable));
        AppsFlyerProperties.getInstance().enableLogOutput((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setImeiData(String aImei) {
        void var1_1;
        l.getInstance().addApiEvent("setImeiData", aImei);
        this.userCustomImei = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAndroidIdData(String aAndroidId) {
        void var1_1;
        l.getInstance().addApiEvent("setAndroidIdData", aAndroidId);
        this.userCustomAndroidId = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void debugAction(String actionMsg, String parameter, Context context) {
        try {
            void var3_4;
            if (this.isAppsFlyerPackage((Context)var3_4)) {
                void var2_3;
                void var1_1;
                DebugLogQueue.getInstance().push((String)var1_1 + (String)var2_3);
            }
            return;
        }
        catch (Exception exception) {
            com.appsflyer.a.afLogE("Exception in AppsFlyerLib.debugAction(...):", exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAppsFlyerPackage(Context context) {
        void var1_1;
        return context != null && context.getPackageName().length() > 12 && "com.appsflyer".equals(var1_1.getPackageName().toLowerCase().substring(0, 13));
    }

    /*
     * WARNING - void declaration
     */
    private void saveDataToSharedPreferences(Context context, String key, String value) {
        void var3_3;
        void var2_2;
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        sharedPreferences = sharedPreferences.edit();
        sharedPreferences.putString((String)var2_2, (String)var3_3);
        this.editorCommit((SharedPreferences.Editor)sharedPreferences);
    }

    /*
     * WARNING - void declaration
     */
    private void saveIntegerToSharedPreferences(Context context, String key, int value) {
        void var3_3;
        void var2_2;
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        sharedPreferences = sharedPreferences.edit();
        sharedPreferences.putInt((String)var2_2, (int)var3_3);
        this.editorCommit((SharedPreferences.Editor)sharedPreferences);
    }

    /*
     * WARNING - void declaration
     */
    private void saveLongToSharedPreferences(Context context, String key, long value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.saveLongToSharedPreferences(var1_1.getSharedPreferences("appsflyer-data", 0), (String)var2_2, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void saveLongToSharedPreferences(SharedPreferences sharedPreferences, String key, long value) {
        void var3_3;
        void var2_2;
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong((String)var2_2, (long)var3_3);
        this.editorCommit(editor);
    }

    /*
     * WARNING - void declaration
     */
    private void setProperty(String key, String value) {
        void var2_2;
        void var1_1;
        AppsFlyerProperties.getInstance().set((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String getProperty(String key) {
        void var1_1;
        return AppsFlyerProperties.getInstance().getString((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setAppUserId(String id) {
        void var1_1;
        l.getInstance().addApiEvent("setAppUserId", id);
        this.setCustomerUserId((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomerUserId(String id) {
        void var1_1;
        l.getInstance().addApiEvent("setCustomerUserId", id);
        com.appsflyer.a.afLog("setCustomerUserId = " + id);
        this.setProperty("AppUserId", (String)var1_1);
    }

    public void setAdditionalData(HashMap<String, Object> customData) {
        if (customData != null) {
            JSONObject jSONObject;
            l.getInstance().addApiEvent("setAdditionalData", customData.toString());
            jSONObject = new JSONObject((Map)jSONObject);
            AppsFlyerProperties.getInstance().setCustomData(jSONObject.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendDeepLinkData(Activity activity) {
        void var1_1;
        if (activity != null && activity.getIntent() != null) {
            l.getInstance().addApiEvent("sendDeepLinkData", activity.getLocalClassName(), "activity_intent_" + activity.getIntent().toString());
        } else if (activity != null) {
            l.getInstance().addApiEvent("sendDeepLinkData", activity.getLocalClassName(), "activity_intent_null");
        } else {
            l.getInstance().addApiEvent("sendDeepLinkData", "activity_null");
        }
        com.appsflyer.a.afLog("getDeepLinkData with activity " + activity.getIntent().getDataString());
        this.registerForAppEvents(var1_1.getApplication());
    }

    /*
     * WARNING - void declaration
     */
    public void sendPushNotificationData(Activity activity) {
        if (activity != null && activity.getIntent() != null) {
            l.getInstance().addApiEvent("sendPushNotificationData", activity.getLocalClassName(), "activity_intent_" + activity.getIntent().toString());
        } else if (activity != null) {
            l.getInstance().addApiEvent("sendPushNotificationData", activity.getLocalClassName(), "activity_intent_null");
        } else {
            l.getInstance().addApiEvent("sendPushNotificationData", "activity_null");
        }
        this.pushPayload = this.getPushPayloadFromIntent((Context)activity);
        if (this.pushPayload != null) {
            void var1_1;
            long l2;
            long l3 = l2 = System.currentTimeMillis();
            if (this.pushPayloadHistory == null) {
                com.appsflyer.a.afLog("pushes: initializing pushes history..");
                this.pushPayloadHistory = new ConcurrentHashMap<Long, String>();
            } else {
                try {
                    long l4 = AppsFlyerProperties.getInstance().getLong("pushPayloadMaxAging", 1800000L);
                    for (Long l5 : this.pushPayloadHistory.keySet()) {
                        JSONObject jSONObject = new JSONObject(this.pushPayload);
                        JSONObject jSONObject2 = new JSONObject(this.pushPayloadHistory.get(l5));
                        if (jSONObject.get("pid").equals(jSONObject2.get("pid"))) {
                            com.appsflyer.a.afLog("PushNotificationMeasurement: A previous payload with same PID was already acknowledged! (old: " + jSONObject2 + ", new: " + jSONObject + ")");
                            this.pushPayload = null;
                            return;
                        }
                        if (l2 - l5 > l4) {
                            this.pushPayloadHistory.remove(l5);
                        }
                        if (l5 > l3) continue;
                        l3 = l5;
                    }
                }
                catch (Throwable throwable) {
                    com.appsflyer.a.afLogE("Error while handling push notification measurement: " + throwable.getClass().getSimpleName(), throwable);
                }
            }
            int n = AppsFlyerProperties.getInstance().getInt("pushPayloadHistorySize", 2);
            if (this.pushPayloadHistory.size() == n) {
                com.appsflyer.a.afLog("pushes: removing oldest overflowing push (oldest push:" + l3 + ")");
                this.pushPayloadHistory.remove(l3);
            }
            this.pushPayloadHistory.put(l2, this.pushPayload);
            this.registerForAppEvents(var1_1.getApplication());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setUserEmail(String email) {
        void var1_1;
        l.getInstance().addApiEvent("setUserEmail", email);
        this.setProperty("userEmail", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserEmails(String ... emails) {
        void var1_1;
        l.getInstance().addApiEvent("setUserEmails", emails);
        this.setUserEmails(AppsFlyerProperties.EmailsCryptType.NONE, (String[])var1_1);
    }

    public void setUserEmails(AppsFlyerProperties.EmailsCryptType cryptMethod, String ... emails) {
        JSONObject jSONObject;
        Cloneable cloneable = new ArrayList<String>(emails.length + 1);
        cloneable.add(cryptMethod.toString());
        cloneable.addAll(Arrays.asList(emails));
        l.getInstance().addApiEvent("setUserEmails", cloneable.toArray(new String[emails.length + 1]));
        AppsFlyerProperties.getInstance().set("userEmailsCryptType", cryptMethod.getValue());
        cloneable = new HashMap();
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block5: for (void var8_8 : jSONObject) {
            switch (cryptMethod) {
                default: {
                    string = "sha1_el_arr";
                    arrayList.add(j.toSHA1((String)var8_8));
                    continue block5;
                }
                case MD5: {
                    string = "md5_el_arr";
                    arrayList.add(j.toMD5((String)var8_8));
                    continue block5;
                }
                case SHA256: {
                    string = "sha256_el_arr";
                    arrayList.add(j.toSha256((String)var8_8));
                    continue block5;
                }
                case NONE: {
                    string = "plain_el_arr";
                    arrayList.add(var8_8);
                }
            }
        }
        cloneable.put(string, arrayList);
        jSONObject = new JSONObject((Map)((Object)cloneable));
        AppsFlyerProperties.getInstance().setUserEmails(jSONObject.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void setCollectAndroidID(boolean isCollect) {
        void var1_1;
        l.getInstance().addApiEvent("setCollectAndroidID", String.valueOf(isCollect));
        this.setProperty("collectAndroidId", Boolean.toString((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setCollectIMEI(boolean isCollect) {
        void var1_1;
        l.getInstance().addApiEvent("setCollectIMEI", String.valueOf(isCollect));
        this.setProperty("collectIMEI", Boolean.toString((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setCollectFingerPrint(boolean isCollect) {
        void var1_1;
        l.getInstance().addApiEvent("setCollectFingerPrint", String.valueOf(isCollect));
        this.setProperty("collectFingerPrint", Boolean.toString((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void startTracking(Application application, String key) {
        void var1_1;
        void var2_2;
        l.getInstance().addApiEvent("startTracking", key);
        com.appsflyer.a.afLogM("Build Number: 333");
        this.setProperty("AppsFlyerKey", key);
        com.appsflyer.a.setDevKey((String)var2_2);
        this.registerForAppEvents((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void getReInstallData(Context context) {
        if (Build.VERSION.SDK_INT >= 18) {
            AFKeystoreWrapper aFKeystoreWrapper = new AFKeystoreWrapper(context);
            if (!aFKeystoreWrapper.loadData()) {
                void var1_1;
                aFKeystoreWrapper.createFirstInstallData(k.id(new WeakReference<void>(var1_1)));
                this.setProperty("KSAppsFlyerId", aFKeystoreWrapper.getUid());
                this.setProperty("KSAppsFlyerRICounter", String.valueOf(aFKeystoreWrapper.getReInstallCounter()));
                return;
            }
            aFKeystoreWrapper.incrementReInstallCounter();
            this.setProperty("KSAppsFlyerId", aFKeystoreWrapper.getUid());
            this.setProperty("KSAppsFlyerRICounter", String.valueOf(aFKeystoreWrapper.getReInstallCounter()));
        }
    }

    private String getCustomerUserId() {
        return this.getProperty("AppUserId");
    }

    /*
     * WARNING - void declaration
     */
    public void setAppId(String id) {
        void var1_1;
        l.getInstance().addApiEvent("setAppId", id);
        this.setProperty("appid", (String)var1_1);
    }

    private String getAppId() {
        return this.getProperty("appid");
    }

    /*
     * WARNING - void declaration
     */
    public void setExtension(String extension) {
        void var1_1;
        l.getInstance().addApiEvent("setExtension", extension);
        AppsFlyerProperties.getInstance().set("sdkExtension", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIsUpdate(boolean isUpdate) {
        void var1_1;
        l.getInstance().addApiEvent("setIsUpdate", String.valueOf(isUpdate));
        AppsFlyerProperties.getInstance().set("IS_UPDATE", (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrencyCode(String currencyCode) {
        void var1_1;
        l.getInstance().addApiEvent("setCurrencyCode", currencyCode);
        AppsFlyerProperties.getInstance().set("currencyCode", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void trackLocation(Context context, double latitude, double longitude) {
        void var1_1;
        void var2_2;
        l.getInstance().addApiEvent("trackLocation", String.valueOf(latitude), String.valueOf(longitude));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("af_long", Double.toString(longitude));
        hashMap.put("af_lat", Double.toString((double)var2_2));
        this.trackEventInternal((Context)var1_1, "af_location_coordinates", hashMap);
    }

    /*
     * WARNING - void declaration
     */
    private void callStatsBackground(WeakReference<Context> context) {
        String string;
        void var1_1;
        Object object;
        if (context.get() == null) {
            return;
        }
        com.appsflyer.a.afLog("app went to background");
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences("appsflyer-data", 0);
        AppsFlyerProperties.getInstance().saveProperties(sharedPreferences);
        long l2 = this.timeWentToBackground - this.timeEnteredForeground;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getProperty("AppsFlyerKey");
        String string3 = this.getProperty("KSAppsFlyerId");
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (bl) {
            hashMap.put("deviceTrackingDisabled", "true");
        }
        if ((object = com.appsflyer.a.getAmazonAID(((Context)context.get()).getContentResolver())) != null) {
            hashMap.put("amazon_aid", ((f)object).getAdvertisingId());
            hashMap.put("amazon_aid_limit", String.valueOf(((f)object).isLimitAdTracking()));
        }
        if ((object = AppsFlyerProperties.getInstance().getString("advertiserId")) != null) {
            hashMap.put("advertiserId", (String)object);
        }
        hashMap.put("app_id", ((Context)context.get()).getPackageName());
        hashMap.put("devkey", string2);
        hashMap.put("uid", k.id(context));
        hashMap.put("time_in_app", String.valueOf(l2 / 1000L));
        hashMap.put("statType", "user_closed_app");
        hashMap.put("platform", "Android");
        hashMap.put("launch_counter", Integer.toString(this.getCounter(sharedPreferences, "appsFlyerCount", false)));
        hashMap.put("gcd_conversion_data_timing", Long.toString(sharedPreferences.getLong("appsflyerGetConversionDataTiming", 0L)));
        hashMap.put("channel", this.getConfiguredChannel((WeakReference<Context>)var1_1));
        hashMap.put("originalAppsflyerId", string3 != null ? string3 : "");
        boolean bl2 = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
        if (bl2 && (string = this.getUniquePsuedoID()) != null) {
            hashMap.put("deviceFingerPrintId", string);
        }
        try {
            h h2 = new h(null);
            new h(null).bodyParameters = hashMap;
            if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
                com.appsflyer.a.afDebugLog("Running callStats task (on current thread: " + Thread.currentThread().toString() + " )");
                h2.onPreExecute();
                h2.onPostExecute(h2.doInBackground("https://stats.appsflyer.com/stats"));
                return;
            }
            com.appsflyer.a.afDebugLog("Main thread detected. Running callStats task in a new thread.");
            h2.execute(new String[]{"https://stats.appsflyer.com/stats"});
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLogE("Could not send callStats request", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void trackAppLaunch(Context ctx, String devKey) {
        void var2_2;
        void var1_1;
        this.runInBackground((Context)var1_1, (String)var2_2, null, null, "", true);
    }

    /*
     * WARNING - void declaration
     */
    protected void setDeepLinkData(Intent intent) {
        try {
            if (intent != null && "android.intent.action.VIEW".equals(intent.getAction())) {
                void var1_1;
                this.latestDeepLink = var1_1.getData();
                com.appsflyer.a.afDebugLog("Unity setDeepLinkData = " + this.latestDeepLink);
            }
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLogE("Exception while setting deeplink data (unity). ", throwable);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reportTrackSession(Context ctx) {
        void var1_1;
        l.getInstance().addApiEvent("reportTrackSession", new String[0]);
        l.getInstance().disableRemoteDebuggingForThisApp();
        this.trackEventInternal((Context)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        void var3_3;
        void var2_2;
        void var1_1;
        JSONObject jSONObject = new JSONObject((Map)(eventValues == null ? new HashMap() : eventValues));
        l.getInstance().addApiEvent("trackEvent", eventName, jSONObject.toString());
        this.trackEventInternal((Context)var1_1, (String)var2_2, (Map<String, Object>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    void trackEventInternal(Context context, String eventName, Map<String, Object> eventValues) {
        void var2_2;
        void var1_1;
        JSONObject jSONObject;
        jSONObject = new JSONObject((Map)(eventValues == null ? new HashMap() : jSONObject));
        String string = AppsFlyerProperties.getInstance().getReferrer(context);
        this.runInBackground((Context)var1_1, null, (String)var2_2, jSONObject.toString(), string == null ? "" : string, true);
    }

    /*
     * WARNING - void declaration
     */
    private void monitor(Context context, String eventIdentifier, String message, String value) {
        if (AppsFlyerProperties.getInstance().getBoolean("shouldMonitor", false)) {
            void var1_1;
            void var2_2;
            void var3_3;
            Intent intent = new Intent("com.appsflyer.MonitorBroadcast");
            intent.setPackage("com.appsflyer.nightvision");
            intent.putExtra("message", (String)var3_3);
            intent.putExtra("value", value);
            intent.putExtra("packageName", "true");
            intent.putExtra("pid", (Serializable)new Integer(Process.myPid()));
            intent.putExtra("eventIdentifier", (String)var2_2);
            intent.putExtra("sdk", "4.7.4");
            var1_1.sendBroadcast(intent);
        }
    }

    /*
     * WARNING - void declaration
     */
    void callRegisterBackground(Context context, String token) {
        String string;
        Serializable serializable;
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getProperty("AppsFlyerKey");
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (bl) {
            hashMap.put("deviceTrackingDisabled", "true");
        }
        if ((object = com.appsflyer.a.getAmazonAID(context.getContentResolver())) != null) {
            hashMap.put("amazon_aid", ((f)object).getAdvertisingId());
            hashMap.put("amazon_aid_limit", String.valueOf(((f)object).isLimitAdTracking()));
        }
        if ((object = AppsFlyerProperties.getInstance().getString("advertiserId")) != null) {
            hashMap.put("advertiserId", (String)object);
        }
        hashMap.put("devkey", string2);
        hashMap.put("uid", k.id(new WeakReference<Context>(context)));
        hashMap.put("af_gcm_token", (String)((Object)serializable));
        hashMap.put("launch_counter", Integer.toString(this.getCounter(context.getSharedPreferences("appsflyer-data", 0), "appsFlyerCount", false)));
        hashMap.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
        hashMap.put("channel", this.getConfiguredChannel(new WeakReference<Context>(context)));
        try {
            serializable = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            long l2 = ((PackageInfo)serializable).firstInstallTime;
            serializable = new SimpleDateFormat("yyyy-MM-dd_HHmmssZ", Locale.US);
            hashMap.put("install_date", ((DateFormat)serializable).format(new Date(l2)));
        }
        catch (Throwable throwable) {
            serializable = throwable;
            com.appsflyer.a.afLogE(throwable.getMessage(), (Throwable)serializable);
        }
        boolean bl2 = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
        if (bl2 && (string = this.getUniquePsuedoID()) != null) {
            hashMap.put("deviceFingerPrintId", string);
        }
        try {
            void var1_1;
            h h2 = new h(context);
            new h(context).bodyParameters = hashMap;
            String string3 = REGISTER_URL + var1_1.getPackageName();
            h2.execute(new String[]{string3});
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.appsflyer.a.afLogE(throwable.getMessage(), throwable2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void broadcastBacktoTestApp(Context context, String paramsString) {
        Context context2;
        void var1_1;
        Intent intent = new Intent("com.appsflyer.testIntgrationBroadcast");
        intent.putExtra("params", (String)var1_1);
        context2.sendBroadcast(intent);
    }

    /*
     * WARNING - void declaration
     */
    public void setDeviceTrackingDisabled(boolean isDisabled) {
        void var1_1;
        l.getInstance().addApiEvent("setDeviceTrackingDisabled", String.valueOf(isDisabled));
        AppsFlyerProperties.getInstance().set("deviceTrackingDisabled", (boolean)var1_1);
    }

    private Map<String, String> getConversionData(Context context) throws g {
        String string;
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        String string2 = AppsFlyerProperties.getInstance().getReferrer(context);
        if (string2 != null && string2.length() > 0 && string2.contains("af_tranid")) {
            return this.referrerStringToMap((Context)string, string2);
        }
        string = sharedPreferences.getString("attributionId", null);
        if (string != null && string.length() > 0) {
            return this.attributionStringToMap(string);
        }
        throw new g();
    }

    /*
     * WARNING - void declaration
     */
    public void registerConversionListener(Context context, AppsFlyerConversionListener conversionDataListener) {
        void var2_2;
        void var1_1;
        l.getInstance().addApiEvent("registerConversionListener", new String[0]);
        this.registerConversionListenerInternal((Context)var1_1, (AppsFlyerConversionListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void registerConversionListenerInternal(Context context, AppsFlyerConversionListener conversionDataListener) {
        void var2_2;
        if (conversionDataListener == null) {
            return;
        }
        AppsFlyerLib.conversionDataListener = var2_2;
    }

    public void unregisterConversionListener() {
        l.getInstance().addApiEvent("unregisterConversionListener", new String[0]);
        conversionDataListener = null;
    }

    /*
     * WARNING - void declaration
     */
    public void registerValidatorListener(Context context, AppsFlyerInAppPurchaseValidatorListener validationListener) {
        void var2_2;
        l.getInstance().addApiEvent("registerValidatorListener", new String[0]);
        com.appsflyer.a.afDebugLog("registerValidatorListener called");
        if (validationListener == null) {
            com.appsflyer.a.afDebugLog("registerValidatorListener null listener");
            return;
        }
        validatorListener = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void getConversionData(Context context, ConversionDataListener conversionDataListener) {
        void var2_2;
        void var1_1;
        this.registerConversionListenerInternal((Context)var1_1, new AppsFlyerConversionListener((ConversionDataListener)var2_2){
            final /* synthetic */ ConversionDataListener val$conversionDataListener;
            {
                this.val$conversionDataListener = conversionDataListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                void var1_1;
                this.val$conversionDataListener.onConversionDataLoaded((Map<String, String>)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onInstallConversionFailure(String errorMessage) {
                void var1_1;
                this.val$conversionDataListener.onConversionFailure((String)var1_1);
            }

            @Override
            public final void onAppOpenAttribution(Map<String, String> attributionData) {
            }

            @Override
            public final void onAttributionFailure(String errorMessage) {
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> referrerStringToMap(Context context, String referrer) {
        PackageInfo packageInfo;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        packageInfo = packageInfo.split("&");
        boolean bl = false;
        for (Object object : packageInfo) {
            String string;
            int n = ((String)object).indexOf("=");
            String string2 = string = n > 0 ? ((String)object).substring(0, n) : object;
            if (!linkedHashMap.containsKey(string)) {
                if (string.equals("c")) {
                    string = "campaign";
                } else if (string.equals("pid")) {
                    string = "media_source";
                } else if (string.equals("af_prt")) {
                    bl = true;
                    string = "agency";
                }
                linkedHashMap.put(string, new String());
            }
            object = n > 0 && ((String)object).length() > n + 1 ? ((String)object).substring(n + 1) : null;
            linkedHashMap.put(string, (String)object);
        }
        try {
            if (!linkedHashMap.containsKey("install_time")) {
                void var1_1;
                Object object;
                packageInfo = context.getPackageManager().getPackageInfo(var1_1.getPackageName(), 0);
                long l2 = packageInfo.firstInstallTime;
                object = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                linkedHashMap.put("install_time", ((DateFormat)object).format(new Date(l2)));
            }
        }
        catch (Exception exception) {
            com.appsflyer.a.afLogE("Could not fetch install time. ", exception);
        }
        if (!linkedHashMap.containsKey("af_status")) {
            linkedHashMap.put("af_status", "Non-organic");
        }
        if (bl) {
            linkedHashMap.remove("media_source");
        }
        return linkedHashMap;
    }

    private Map<String, String> attributionStringToMap(String inputString) {
        JSONException jSONException;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            jSONException = new JSONObject((String)((Object)jSONException));
            Iterator iterator = jSONException.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (IGNORABLE_KEYS.contains(string)) continue;
                hashMap.put(string, jSONException.getString(string));
            }
        }
        catch (JSONException jSONException2) {
            jSONException = jSONException2;
            com.appsflyer.a.afLogE(jSONException2.getMessage(), jSONException);
            return null;
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private void runInBackground(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isNewAPI) {
        void var3_3;
        void var2_2;
        c c2;
        boolean bl = eventName == null;
        if (bl) {
            bl = AppsFlyerProperties.getInstance().getBoolean("launchProtectEnabled", true);
            if (bl) {
                if (this.isLaunchWithinBlockingTimeWindow(context)) {
                    return;
                }
            } else {
                com.appsflyer.a.afLog("Allowing multiple launches within a 5 second time window.");
            }
        }
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
        c2 = new c(new WeakReference<void>((void)c2), (String)var2_2, (String)var3_3, eventValue, referrer, isNewAPI, scheduledThreadPoolExecutor, null);
        this.scheduleJob(scheduledThreadPoolExecutor, c2, 150L, TimeUnit.MILLISECONDS);
    }

    private boolean isLaunchWithinBlockingTimeWindow(Context context) {
        if (this.lastSuccessfulLaunchTimestamp > 0L) {
            long l2 = System.currentTimeMillis();
            double d2 = l2 - this.lastSuccessfulLaunchTimestamp;
            String string = new SimpleDateFormat("yyyy-MM-dd_HHmmssZ", Locale.US).format(this.lastSuccessfulLaunchTimestamp);
            if (d2 < (double)LAUNCH_BLOCKING_TIME_WINDOW) {
                String string2 = "Last successful launch event: %s. This launch is blocked: %s ms < 5 ms";
                com.appsflyer.a.afLog(String.format(Locale.US, string2, string, d2));
                return true;
            }
            String string3 = "Last successful launch event: %s. Sending launch (%s ms)";
            com.appsflyer.a.afLog(String.format(Locale.US, string3, string, d2));
        } else {
            com.appsflyer.a.afLog("Sending first launch for this session!");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void backgroundReferrerLaunch(Context context, String referrer) {
        if (referrer != null && referrer.length() > 5) {
            void var2_2;
            c c2;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
            c2 = new c(new WeakReference<void>((void)c2), null, null, null, (String)var2_2, true, scheduledThreadPoolExecutor, null);
            this.scheduleJob(scheduledThreadPoolExecutor, c2, 5L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendTrackingWithEvent(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isUseNewAPI) {
        void var1_1;
        String string;
        Map<String, Object> map;
        if (context == null) {
            return;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        AppsFlyerProperties.getInstance().saveProperties(sharedPreferences);
        com.appsflyer.a.afLog("sendTrackingWithEvent from activity: " + context.getClass().getName());
        boolean bl = eventName == null;
        map = this.getEventParameters(context, (String)((Object)map), string, eventValue, referrer, isUseNewAPI, sharedPreferences, bl);
        string = (String)map.get("appsflyerKey");
        if (string == null || string.length() == 0) {
            com.appsflyer.a.afDebugLog("Not sending data yet, waiting for dev key");
            return;
        }
        com.appsflyer.a.afLog("AppsFlyerLib.sendTrackingWithEvent");
        string = (bl ? APPS_TRACKING_URL : EVENTS_TRACKING_URL) + context.getPackageName();
        new e(string, map, var1_1.getApplicationContext(), bl, null).run();
    }

    /*
     * WARNING - void declaration
     */
    Map<String, Object> getEventParameters(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isUseNewAPI, SharedPreferences sharedPreferences, boolean isLaunchEvent) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        com.appsflyer.a.addGoogleAID(context, hashMap);
        hashMap.put("af_timestamp", Long.toString(new Date().getTime()));
        try {
            void var3_17;
            void var1_1;
            String string;
            Object object;
            String string2;
            String string3;
            Object object2;
            Object object3;
            String string4;
            String string5;
            String string6;
            Object object4;
            this.debugAction("collect data for server", "", context);
            com.appsflyer.a.afLog("******* sendTrackingWithEvent: " + (isLaunchEvent ? "Launch" : eventName));
            this.debugAction("********* sendTrackingWithEvent: ", isLaunchEvent ? "Launch" : eventName, context);
            this.monitor(context, LOG_TAG, "EVENT_CREATED_WITH_NAME", isLaunchEvent ? "Launch" : eventName);
            CacheManager.getInstance().init(context);
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                object4 = Arrays.asList(packageInfo.requestedPermissions);
                if (!object4.contains("android.permission.INTERNET")) {
                    com.appsflyer.a.afWarnLog("Permission android.permission.INTERNET is missing in the AndroidManifest.xml");
                    this.monitor(context, null, "PERMISSION_INTERNET_MISSING", null);
                }
                if (!object4.contains("android.permission.ACCESS_NETWORK_STATE")) {
                    com.appsflyer.a.afWarnLog("Permission android.permission.ACCESS_NETWORK_STATE is missing in the AndroidManifest.xml");
                }
                if (!object4.contains("android.permission.ACCESS_WIFI_STATE")) {
                    com.appsflyer.a.afWarnLog("Permission android.permission.ACCESS_WIFI_STATE is missing in the AndroidManifest.xml");
                }
            }
            catch (Exception exception) {
                com.appsflyer.a.afLogE("Exception while validation permissions. ", exception);
            }
            if (isUseNewAPI) {
                hashMap.put("af_events_api", "1");
            }
            hashMap.put("brand", Build.BRAND);
            hashMap.put("device", Build.DEVICE);
            hashMap.put("product", Build.PRODUCT);
            hashMap.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
            hashMap.put("model", Build.MODEL);
            hashMap.put("deviceType", Build.TYPE);
            if (isLaunchEvent) {
                if (this.isAppsFlyerFirstLaunch(context)) {
                    if (!AppsFlyerProperties.getInstance().isOtherSdkStringDisabled()) {
                        hashMap.put("af_sdks", this.generateOtherSDKsString());
                        float f2 = this.getBatteryLevel(context);
                        hashMap.put("batteryLevel", String.valueOf(f2));
                    }
                    this.getReInstallData(context);
                }
                hashMap.put("timepassedsincelastlaunch", Long.toString(this.getTimePassedSinceLastLaunch(context, true)));
            } else {
                this.lastEventsProcessing(context, hashMap, eventName, eventValue);
            }
            String string7 = this.getProperty("KSAppsFlyerId");
            object4 = this.getProperty("KSAppsFlyerRICounter");
            if (string7 != null && object4 != null && Integer.valueOf((String)object4) > 0) {
                hashMap.put("reinstallCounter", object4);
                hashMap.put("originalAppsflyerId", string7);
            }
            if ((string6 = this.getProperty("additionalCustomData")) != null) {
                hashMap.put("customData", string6);
            }
            try {
                string6 = context.getPackageManager().getInstallerPackageName(context.getPackageName());
                if (string6 != null) {
                    hashMap.put("installer_package", string6);
                }
            }
            catch (Exception exception) {
                com.appsflyer.a.afLogE("Exception while getting the app's installer package. ", exception);
            }
            string6 = AppsFlyerProperties.getInstance().getString("sdkExtension");
            if (string6 != null && string6.length() > 0) {
                hashMap.put("sdkExtension", string6);
            }
            if ((string7 = this.getCachedChannel(context, string6 = this.getConfiguredChannel(new WeakReference<Context>(context)))) != null) {
                hashMap.put("channel", string7);
            }
            if (string7 != null && !string7.equals(string6) || string7 == null && string6 != null) {
                hashMap.put("af_latestchannel", string6);
            }
            if ((string6 = this.getCachedStore(context)) != null) {
                hashMap.put("af_installstore", string6.toLowerCase());
            }
            if ((string6 = this.getPreInstallName(context)) != null) {
                hashMap.put("af_preinstall_name", string6.toLowerCase());
            }
            if ((string6 = this.getCurrentStore(context)) != null) {
                hashMap.put("af_currentstore", string6.toLowerCase());
            }
            if (appsFlyerKey != null && appsFlyerKey.length() >= 0) {
                hashMap.put("appsflyerKey", string5);
            } else {
                string5 = this.getProperty("AppsFlyerKey");
                if (string5 != null && string5.length() >= 0) {
                    hashMap.put("appsflyerKey", string5);
                } else {
                    com.appsflyer.a.afLog("AppsFlyer dev key is missing!!! Please use  AppsFlyerLib.getInstance().setAppsFlyerKey(...) to set it. ");
                    this.monitor(context, LOG_TAG, "DEV_KEY_MISSING", null);
                    com.appsflyer.a.afLog("AppsFlyer will not track this event.");
                    return null;
                }
            }
            string5 = this.getCustomerUserId();
            if (string5 != null) {
                hashMap.put("appUserId", string5);
            }
            if ((string5 = AppsFlyerProperties.getInstance().getString("userEmails")) != null) {
                hashMap.put("user_emails", string5);
            } else {
                string5 = this.getProperty("userEmail");
                if (string5 != null) {
                    hashMap.put("sha1_el", j.toSHA1(string5));
                }
            }
            if (eventName != null) {
                hashMap.put("eventName", eventName);
                if (eventValue != null) {
                    hashMap.put("eventValue", eventValue);
                }
            }
            if (this.getAppId() != null) {
                hashMap.put("appid", this.getProperty("appid"));
            }
            if ((string5 = this.getProperty("currencyCode")) != null) {
                if (string5.length() != 3) {
                    com.appsflyer.a.afWarnLog("WARNING: currency code should be 3 characters!!! '" + string5 + "' is not a legal value.");
                }
                hashMap.put("currency", string5);
            }
            if ((string5 = this.getProperty("IS_UPDATE")) != null) {
                hashMap.put("isUpdate", string5);
            }
            boolean bl = this.isPreInstalledApp(context);
            hashMap.put("af_preinstalled", Boolean.toString(bl));
            bl = AppsFlyerProperties.getInstance().getBoolean("collectFacebookAttrId", true);
            if (bl) {
                String string8;
                try {
                    context.getPackageManager().getApplicationInfo("com.facebook.katana", 0);
                    string8 = this.getAttributionId(context.getContentResolver());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    string8 = null;
                    com.appsflyer.a.afWarnLog("Exception while collecting facebook's attribution ID. ");
                }
                catch (Throwable throwable) {
                    string8 = null;
                    com.appsflyer.a.afLogE("Exception while collecting facebook's attribution ID. ", throwable);
                }
                if (string8 != null) {
                    hashMap.put("fb", string8);
                }
            }
            this.addDeviceTracking(context, hashMap);
            try {
                string4 = k.id(new WeakReference<Context>(context));
                if (string4 != null) {
                    hashMap.put("uid", string4);
                }
            }
            catch (Exception exception) {
                com.appsflyer.a.afLogE("ERROR: " + "could not get uid " + exception.getMessage(), exception);
            }
            try {
                hashMap.put("lang", Locale.getDefault().getDisplayLanguage());
            }
            catch (Exception exception) {
                com.appsflyer.a.afLogE("Exception while collecting display language name. ", exception);
            }
            try {
                hashMap.put("lang_code", Locale.getDefault().getLanguage());
            }
            catch (Exception exception) {
                com.appsflyer.a.afLogE("Exception while collecting display language code. ", exception);
            }
            try {
                hashMap.put("country", Locale.getDefault().getCountry());
            }
            catch (Exception exception) {
                com.appsflyer.a.afLogE("Exception while collecting country name. ", exception);
            }
            try {
                string4 = (TelephonyManager)context.getSystemService("phone");
                hashMap.put("operator", string4.getSimOperatorName());
                hashMap.put("carrier", string4.getNetworkOperatorName());
            }
            catch (Exception exception) {
                com.appsflyer.a.afLogE("Exception while collecting network operator/carrier.  ", exception);
            }
            try {
                hashMap.put("network", this.getNetwork(context));
            }
            catch (Throwable throwable) {
                com.appsflyer.a.afLogE("Exception while collecting network info. ", throwable);
            }
            boolean bl2 = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
            if (bl2 && (object3 = this.getUniquePsuedoID()) != null) {
                hashMap.put("deviceFingerPrintId", object3);
            }
            this.checkPlatform(context, hashMap);
            this.getSystemInfo(hashMap);
            object3 = new SimpleDateFormat("yyyy-MM-dd_HHmmssZ", Locale.US);
            if (Build.VERSION.SDK_INT >= 9) {
                try {
                    long l2 = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
                    hashMap.put("installDate", ((DateFormat)object3).format(new Date(l2)));
                }
                catch (Exception exception) {
                    com.appsflyer.a.afLogE("Exception while collecting install date. ", exception);
                }
            }
            try {
                object2 = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                int n = sharedPreferences.getInt("versionCode", 0);
                if (((PackageInfo)object2).versionCode > n) {
                    this.saveIntegerToSharedPreferences(context, "appsflyerConversionDataRequestRetries", 0);
                    this.saveIntegerToSharedPreferences(context, "versionCode", ((PackageInfo)object2).versionCode);
                }
                hashMap.put("app_version_code", Integer.toString(((PackageInfo)object2).versionCode));
                hashMap.put("app_version_name", ((PackageInfo)object2).versionName);
                if (Build.VERSION.SDK_INT >= 9) {
                    long l3 = ((PackageInfo)object2).firstInstallTime;
                    long l4 = ((PackageInfo)object2).lastUpdateTime;
                    hashMap.put("date1", ((DateFormat)object3).format(new Date(l3)));
                    hashMap.put("date2", ((DateFormat)object3).format(new Date(l4)));
                    String string9 = this.getFirstInstallDate((SimpleDateFormat)object3, context);
                    hashMap.put("firstLaunchDate", string9);
                }
            }
            catch (Throwable throwable) {
                com.appsflyer.a.afLogE("Exception while collecting app version data ", throwable);
            }
            if (referrer.length() > 0) {
                hashMap.put("referrer", referrer);
            }
            if ((object2 = sharedPreferences.getString("attributionId", null)) != null && ((String)object2).length() > 0) {
                hashMap.put("installAttribution", object2);
            }
            if ((string3 = sharedPreferences.getString("extraReferrers", null)) != null) {
                hashMap.put("extraReferrers", string3);
            }
            if ((string2 = this.getProperty("afUninstallToken")) != null && (object = com.appsflyer.b.parse(string2)) != null) {
                hashMap.put("af_gcm_token", ((com.appsflyer.b)object).getToken());
            }
            this.isTokenRefreshServiceConfigured = com.appsflyer.a.didConfigureTokenRefreshService(context);
            com.appsflyer.a.afDebugLog("didConfigureTokenRefreshService=" + this.isTokenRefreshServiceConfigured);
            if (!this.isTokenRefreshServiceConfigured) {
                hashMap.put("tokenRefreshConfigured", false);
            }
            if (isLaunchEvent) {
                if (this.pushPayload != null) {
                    object = new JSONObject(this.pushPayload);
                    object.put("isPush", (Object)"true");
                    hashMap.put("af_deeplink", object.toString());
                }
                this.pushPayload = null;
            }
            if (isLaunchEvent && context instanceof Activity) {
                object = this.getDeepLinkUri(context);
                if (object != null) {
                    this.handleDeepLinkCallback(context, hashMap, (Uri)object);
                } else if (this.latestDeepLink != null) {
                    this.handleDeepLinkCallback(context, hashMap, this.latestDeepLink);
                }
            }
            if (this.isRetargetingTestMode) {
                hashMap.put("testAppMode_retargeting", "true");
                object = new JSONObject(hashMap);
                AppsFlyerLib.broadcastBacktoTestApp(context, object.toString());
                com.appsflyer.a.afLog("Sent retargeting params to test app");
            }
            if (this.isInTestMode(context)) {
                hashMap.put("testAppMode", "true");
                object = new JSONObject(hashMap);
                AppsFlyerLib.broadcastBacktoTestApp(context, object.toString());
                com.appsflyer.a.afLog("Sent params to test app");
                this.endTestMode();
            }
            if (this.getProperty("advertiserId") == null) {
                com.appsflyer.a.addGoogleAID(context, hashMap);
                if (this.getProperty("advertiserId") != null) {
                    hashMap.put("GAID_retry", "true");
                } else {
                    hashMap.put("GAID_retry", "false");
                }
            }
            if ((object = com.appsflyer.a.getAmazonAID(context.getContentResolver())) != null) {
                hashMap.put("amazon_aid", ((f)object).getAdvertisingId());
                hashMap.put("amazon_aid_limit", String.valueOf(((f)object).isLimitAdTracking()));
            }
            if ((string = AppsFlyerProperties.getInstance().getReferrer((Context)var1_1)) != null && string.length() > 0 && hashMap.get("referrer") == null) {
                hashMap.put("referrer", string);
            }
            boolean bl3 = "true".equals(sharedPreferences.getString("sentSuccessfully", ""));
            boolean bl4 = sharedPreferences.getBoolean("sentRegisterRequestToAF", false);
            hashMap.put("registeredUninstall", bl4);
            int n = this.getCounter(sharedPreferences, "appsFlyerCount", isLaunchEvent);
            hashMap.put("counter", Integer.toString(n));
            hashMap.put("iaecounter", Integer.toString(this.getCounter(sharedPreferences, "appsFlyerInAppEventCount", var3_17 != null)));
            if (isLaunchEvent && n == 1) {
                AppsFlyerProperties.getInstance().setFirstLaunchCalled();
            }
            hashMap.put("isFirstCall", Boolean.toString(!bl3));
            String string10 = new j().getHashCode(hashMap);
            hashMap.put("af_v", string10);
            string10 = new j().getHashCodeV2(hashMap);
            hashMap.put("af_v2", string10);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            com.appsflyer.a.afLogE(throwable.getLocalizedMessage(), throwable2);
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private String getPushPayloadFromIntent(Context context) {
        Bundle bundle;
        Intent intent;
        String string = null;
        if (context instanceof Activity && (intent = ((Activity)context).getIntent()) != null && (bundle = intent.getExtras()) != null && (string = bundle.getString("af")) != null) {
            void var1_1;
            com.appsflyer.a.afLog("Push Notification received af payload = " + string);
            bundle.remove("af");
            ((Activity)var1_1).setIntent(intent.putExtras(bundle));
        }
        return string;
    }

    private Uri getDeepLinkUri(Context context) {
        Intent intent;
        Uri uri = null;
        if ((intent = ((Activity)intent).getIntent()) != null && "android.intent.action.VIEW".equals(intent.getAction())) {
            uri = intent.getData();
        }
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    private void handleDeepLinkCallback(Context context, Map<String, Object> params, Uri uri) {
        void var1_1;
        Map<String, String> map;
        String string;
        params.put("af_deeplink", uri.toString());
        if (uri.getQueryParameter("af_deeplink") != null) {
            string = uri.getQueryParameter("media_source");
            map = uri.getQueryParameter("is_retargeting");
            if (string != null && map != null && string.equals("AppsFlyer_Test") && ((String)((Object)map)).equals("true")) {
                this.isRetargetingTestMode = true;
            }
            map = this.referrerStringToMap(context, uri.getQuery().toString());
            if (uri.getPath() != null) {
                map.put("path", uri.getPath());
            }
            if (uri.getScheme() != null) {
                map.put("scheme", uri.getScheme());
            }
            if (uri.getHost() != null) {
                map.put("host", uri.getHost());
            }
        } else {
            void var3_3;
            map = new HashMap<String, String>();
            map.put("link", var3_3.toString());
        }
        string = new JSONObject((Map)map).toString();
        this.saveDataToSharedPreferences((Context)var1_1, "deeplinkAttribution", string);
        if (conversionDataListener != null) {
            conversionDataListener.onAppOpenAttribution(map);
        }
    }

    private String generateOtherSDKsString() {
        return "" + this.numericBooleanIsClassExist("com.tune.Tune") + this.numericBooleanIsClassExist("com.adjust.sdk.Adjust") + this.numericBooleanIsClassExist("com.kochava.android.tracker.Feature") + this.numericBooleanIsClassExist("io.branch.referral.Branch") + this.numericBooleanIsClassExist("com.apsalar.sdk.Apsalar") + this.numericBooleanIsClassExist("com.localytics.android.Localytics") + this.numericBooleanIsClassExist("com.tenjin.android.TenjinSDK") + this.numericBooleanIsClassExist("com.talkingdata.sdk.TalkingDataSDK") + this.numericBooleanIsClassExist("it.partytrack.sdk.Track") + this.numericBooleanIsClassExist("jp.appAdForce.android.LtvManager");
    }

    private int numericBooleanIsClassExist(String className) {
        try {
            Class.forName(className);
            return 1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return 0;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void lastEventsProcessing(Context context, Map<String, Object> params, String newEventName, String newEventValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            void var3_3;
            String string = sharedPreferences.getString("prev_event_name", null);
            if (string != null) {
                void var2_2;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("prev_event_timestamp", (Object)("" + sharedPreferences.getLong("prev_event_timestamp", -1L)));
                jSONObject.put("prev_event_value", (Object)sharedPreferences.getString("prev_event_value", null));
                jSONObject.put("prev_event_name", (Object)string);
                var2_2.put("prev_event", jSONObject.toString());
            }
            editor.putString("prev_event_name", (String)var3_3);
            editor.putString("prev_event_value", newEventValue);
            editor.putLong("prev_event_timestamp", System.currentTimeMillis());
            this.editorCommit(editor);
            return;
        }
        catch (Exception exception) {
            com.appsflyer.a.afLogE("Error while processing previous event.", exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isGooglePlayServicesAvailable(Context context) {
        boolean bl = false;
        try {
            void var1_1;
            int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)var1_1);
            if (n == 0) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLogE("WARNING:  Google play services is unavailable. ", throwable);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void addDeviceTracking(Context context, Map<String, Object> params) {
        String string;
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (bl) {
            params.put("deviceTrackingDisabled", "true");
            return;
        }
        Object object = context.getSharedPreferences("appsflyer-data", 0);
        boolean bl2 = AppsFlyerProperties.getInstance().getBoolean("collectIMEI", true);
        String string2 = object.getString("imeiCached", null);
        String string3 = null;
        if (bl2) {
            if (this.isIdCollectionAllowed(context)) {
                try {
                    TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                    string = (String)telephonyManager.getClass().getMethod("getDeviceId", new Class[0]).invoke((Object)telephonyManager, new Object[0]);
                    if (string != null) {
                        string3 = string;
                    } else if (this.userCustomImei != null) {
                        string3 = this.userCustomImei;
                    } else if (string2 != null) {
                        string3 = string2;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    com.appsflyer.a.afWarnLog("WARNING: READ_PHONE_STATE is missing.");
                }
                catch (Exception exception) {
                    com.appsflyer.a.afLogE("WARNING: READ_PHONE_STATE is missing. ", exception);
                }
            } else if (this.userCustomImei != null) {
                string3 = this.userCustomImei;
            }
        } else if (this.userCustomImei != null) {
            string3 = this.userCustomImei;
        }
        if (string3 != null) {
            this.saveDataToSharedPreferences(context, "imeiCached", string3);
            params.put("imei", string3);
        } else {
            com.appsflyer.a.afLog("IMEI was not collected.");
        }
        boolean bl3 = AppsFlyerProperties.getInstance().getBoolean("collectAndroidId", true);
        string = object.getString("androidIdCached", null);
        object = null;
        if (bl3) {
            if (this.isIdCollectionAllowed(context)) {
                try {
                    String string4 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                    if (string4 != null) {
                        object = string4;
                    } else if (this.userCustomAndroidId != null) {
                        object = this.userCustomAndroidId;
                    } else if (string != null) {
                        object = string;
                    }
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    com.appsflyer.a.afLogE(exception.getMessage(), exception2);
                }
            } else if (this.userCustomAndroidId != null) {
                object = this.userCustomAndroidId;
            }
        } else if (this.userCustomAndroidId != null) {
            object = this.userCustomAndroidId;
        }
        if (object != null) {
            void var2_2;
            void var1_1;
            this.saveDataToSharedPreferences((Context)var1_1, "androidIdCached", (String)object);
            var2_2.put("android_id", object);
            return;
        }
        com.appsflyer.a.afLog("Android ID was not collected.");
    }

    /*
     * WARNING - void declaration
     */
    private boolean isIdCollectionAllowed(Context context) {
        void var1_1;
        return Build.VERSION.SDK_INT < 19 || !this.isGooglePlayServicesAvailable((Context)var1_1);
    }

    private boolean isAppsFlyerFirstLaunch(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        return !sharedPreferences.contains("appsFlyerCount");
    }

    /*
     * WARNING - void declaration
     */
    private String getCachedStore(Context context) {
        void var1_1;
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        if (sharedPreferences.contains("INSTALL_STORE")) {
            return sharedPreferences.getString("INSTALL_STORE", null);
        }
        boolean bl = this.isAppsFlyerFirstLaunch(context);
        String string = bl ? this.getCurrentStore(context) : null;
        this.saveDataToSharedPreferences((Context)var1_1, "INSTALL_STORE", string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String getCurrentStore(Context context) {
        void var1_1;
        return this.getManifestMetaData(new WeakReference<void>(var1_1), "AF_STORE");
    }

    String getSystemProperty(String key) {
        Throwable throwable;
        String string = null;
        try {
            string = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class).invoke(null, throwable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            com.appsflyer.a.afLogE(throwable2.getMessage(), throwable);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String getManifestMetaData(WeakReference<Context> context, String key) {
        void var1_1;
        void var2_2;
        if (context.get() == null) {
            return null;
        }
        return this.getManifestMetaData((String)var2_2, ((Context)context.get()).getPackageManager(), ((Context)var1_1.get()).getPackageName());
    }

    /*
     * WARNING - void declaration
     */
    private String getManifestMetaData(String key, PackageManager packageManager, String packageName) {
        String string = null;
        try {
            void var3_4;
            Object object;
            object = object.getApplicationInfo((String)var3_4, 128);
            object = ((ApplicationInfo)object).metaData;
            if (object != null && (object = object.get(key)) != null) {
                string = object.toString();
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            com.appsflyer.a.afLogE("Could not find " + (String)var1_1 + " value in the manifest", throwable);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String preInstallValueFromFile(Context context) {
        void var1_1;
        Object object = this.getSystemProperty(PRE_INSTALL_SYSTEM_RO_PROP);
        if (this.isPreInstallFileInvalid((File)(object = this.getFileFromString((String)object)))) {
            object = this.getManifestMetaData(AF_PRE_INSTALL_PATH, context.getPackageManager(), context.getPackageName());
            object = this.getFileFromString((String)object);
        }
        if (this.isPreInstallFileInvalid((File)object)) {
            object = this.getFileFromString(PRE_INSTALL_SYSTEM_DEFAULT);
        }
        if (this.isPreInstallFileInvalid((File)object)) {
            object = this.getFileFromString(PRE_INSTALL_SYSTEM_DEFAULT_ETC);
        }
        if (this.isPreInstallFileInvalid((File)object)) {
            return null;
        }
        if ((object = this.extractPropertyFromFile((File)object, var1_1.getPackageName())) != null) {
            return object;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private String extractPropertyFromFile(File preInstallFile, String propertyKey) {
        Throwable throwable;
        Object object;
        InputStreamReader inputStreamReader = null;
        Properties properties = new Properties();
        inputStreamReader = new FileReader(preInstallFile);
        properties.load(inputStreamReader);
        com.appsflyer.a.afLog("Found PreInstall property!");
        object = properties.getProperty((String)object);
        try {
            inputStreamReader.close();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            com.appsflyer.a.afLogE(throwable2.getMessage(), throwable);
        }
        return object;
        catch (FileNotFoundException fileNotFoundException) {
            com.appsflyer.a.afDebugLog("PreInstall file wasn't found: " + ((File)((Object)throwable)).getAbsolutePath());
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable42 = throwable3;
                com.appsflyer.a.afLogE(throwable3.getMessage(), throwable42);
            }
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            com.appsflyer.a.afLogE(throwable5.getMessage(), throwable6);
            {
                catch (Throwable throwable7) {
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        object = throwable8;
                        com.appsflyer.a.afLogE(throwable8.getMessage(), (Throwable)object);
                    }
                    throw throwable7;
                }
            }
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Throwable throwable9) {
                throwable6 = throwable9;
                com.appsflyer.a.afLogE(throwable9.getMessage(), throwable6);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPreInstallFileInvalid(File preInstallFile) {
        void var1_1;
        return preInstallFile == null || !var1_1.exists();
    }

    private File getFileFromString(String filePath) {
        Throwable throwable;
        try {
            if (filePath != null && filePath.trim().length() > 0) {
                return new File(((String)((Object)throwable)).trim());
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            com.appsflyer.a.afLogE(throwable2.getMessage(), throwable);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getPreInstallName(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        String string = this.getProperty("preInstallName");
        if (string != null) {
            return string;
        }
        if (sharedPreferences.contains("preInstallName")) {
            string = sharedPreferences.getString("preInstallName", null);
        } else {
            boolean bl = this.isAppsFlyerFirstLaunch(context);
            if (bl) {
                String string2 = this.preInstallValueFromFile(context);
                string = string2 != null ? string2 : this.getManifestMetaData(new WeakReference<Context>(context), "AF_PRE_INSTALL_NAME");
            }
            if (string != null) {
                void var1_1;
                this.saveDataToSharedPreferences((Context)var1_1, "preInstallName", string);
            }
        }
        if (string != null) {
            this.setProperty("preInstallName", string);
        }
        return string;
    }

    private void checkCache(Context context) {
        b b2;
        if (this.isDuringCheckCache || System.currentTimeMillis() - this.lastCacheCheck < 15000L) {
            return;
        }
        if (this.cacheScheduler != null) {
            return;
        }
        this.cacheScheduler = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
        b2 = new b((Context)b2);
        this.scheduleJob(this.cacheScheduler, b2, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private String getConfiguredChannel(WeakReference<Context> context) {
        String string = AppsFlyerProperties.getInstance().getString("channel");
        if (string == null) {
            void var1_1;
            string = this.getManifestMetaData((WeakReference<Context>)var1_1, "CHANNEL");
        }
        return string;
    }

    public boolean isPreInstalledApp(Context context) {
        try {
            ApplicationInfo applicationInfo;
            applicationInfo = context.getPackageManager().getApplicationInfo(applicationInfo.getPackageName(), 0);
            if ((applicationInfo.flags & 1) != 0) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            com.appsflyer.a.afLogE("Could not check if app is pre installed", nameNotFoundException);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private String getCachedChannel(Context context, String currentChannel) throws PackageManager.NameNotFoundException {
        void var2_2;
        void var1_1;
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        if (sharedPreferences.contains("CACHED_CHANNEL")) {
            return sharedPreferences.getString("CACHED_CHANNEL", null);
        }
        this.saveDataToSharedPreferences((Context)var1_1, "CACHED_CHANNEL", currentChannel);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String getFirstInstallDate(SimpleDateFormat dateFormat, Context context) {
        Object object = context.getSharedPreferences("appsflyer-data", 0);
        if ((object = object.getString("appsFlyerFirstInstall", null)) == null) {
            void var2_2;
            if (this.isAppsFlyerFirstLaunch(context)) {
                void var1_1;
                com.appsflyer.a.afDebugLog("AppsFlyer: first launch detected");
                object = var1_1.format(new Date());
            } else {
                object = "";
            }
            this.saveDataToSharedPreferences((Context)var2_2, "appsFlyerFirstInstall", (String)object);
        }
        com.appsflyer.a.afLog("AppsFlyer: first launch date: " + (String)object);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private void checkPlatform(Context context, Map<String, Object> params) {
        Object object = "com.unity3d.player.UnityPlayer";
        try {
            Class.forName((String)object);
            params.put("platformextension", "android_unity");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            void var2_2;
            var2_2.put("platformextension", "android_native");
            return;
        }
        catch (Exception exception) {
            object = exception;
            com.appsflyer.a.afLogE(exception.getMessage(), (Throwable)object);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getSystemInfo(Map<String, Object> params) {
        void var1_1;
        JSONObject jSONObject = new HashMap();
        jSONObject.put("cpu_abi", this.getSystemProperty("ro.product.cpu.abi"));
        jSONObject.put("cpu_abi2", this.getSystemProperty("ro.product.cpu.abi2"));
        jSONObject.put("arch", this.getSystemProperty("os.arch"));
        jSONObject.put("build_display_id", this.getSystemProperty("ro.build.display.id"));
        jSONObject = new JSONObject(jSONObject);
        var1_1.put("deviceData", jSONObject);
    }

    /*
     * Loose catch block
     */
    public String getAttributionId(ContentResolver contentResolver) {
        Object object;
        block18: {
            Object object2;
            block17: {
                object = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
                object2 = object2.query(Uri.parse((String)ATTRIBUTION_ID_CONTENT_URI), object, null, null, null);
                object = null;
                if (object2 != null && object2.moveToFirst()) break block17;
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception) {
                    object2 = exception;
                    com.appsflyer.a.afLogE(exception.getMessage(), (Throwable)object2);
                }
                return null;
            }
            object = object2.getString(object2.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
            try {
                if (object2 != null) {
                    object2.close();
                }
                break block18;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                com.appsflyer.a.afLogE(exception.getMessage(), exception2);
            }
            break block18;
            catch (Exception exception) {
                try {
                    com.appsflyer.a.afLogE("Could not collect cursor attribution. ", exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (object2 != null) {
                            object2.close();
                        }
                    }
                    catch (Exception exception3) {
                        object2 = exception3;
                        com.appsflyer.a.afLogE(exception3.getMessage(), (Throwable)object2);
                    }
                    throw throwable;
                }
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception4) {
                    Exception exception5 = exception4;
                    com.appsflyer.a.afLogE(exception4.getMessage(), exception5);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private int getCounter(SharedPreferences sharedPreferences, String parameterName, boolean isIncrease) {
        void var3_3;
        int n = sharedPreferences.getInt(parameterName, 0);
        if (var3_3 != false) {
            void var2_2;
            SharedPreferences.Editor editor;
            editor = editor.edit();
            editor.putInt((String)var2_2, ++n);
            this.editorCommit(editor);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private long getTimePassedSinceLastLaunch(Context context, boolean shouldSave) {
        void var2_2;
        SharedPreferences sharedPreferences = context.getSharedPreferences("appsflyer-data", 0);
        long l2 = sharedPreferences.getLong("AppsFlyerTimePassedSincePrevLaunch", 0L);
        long l3 = System.currentTimeMillis();
        long l4 = l2 > 0L ? l3 - l2 : -1L;
        if (var2_2 != false) {
            void var1_1;
            this.saveLongToSharedPreferences((Context)var1_1, "AppsFlyerTimePassedSincePrevLaunch", l3);
        }
        return l4 / 1000L;
    }

    @Deprecated
    String getUniquePsuedoID() {
        String string = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
        try {
            String string2 = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(string.hashCode(), string2.hashCode()).toString();
        }
        catch (Exception exception) {
            Object object = exception;
            com.appsflyer.a.afLogE(exception.getMessage(), (Throwable)object);
            object = "serial";
            return new UUID(string.hashCode(), ((String)object).hashCode()).toString();
        }
    }

    private String getNetwork(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if ((connectivityManager = connectivityManager.getActiveNetworkInfo()) != null) {
            if (connectivityManager.getType() == 1) {
                return "WIFI";
            }
            if (connectivityManager.getType() == 0) {
                return "MOBILE";
            }
        }
        return "unknown";
    }

    /*
     * WARNING - void declaration
     */
    public String getAppsFlyerUID(Context context) {
        void var1_1;
        l.getInstance().addApiEvent("getAppsFlyerUID", new String[0]);
        return k.id(new WeakReference<void>(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void sendRequestToServer(String urlString, String postDataString, String afDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean isLaunch) throws IOException {
        URL uRL = new URL(urlString);
        com.appsflyer.a.afLog("url: " + uRL.toString());
        this.debugAction("call server.", "\n" + uRL.toString() + "\nPOST:" + postDataString, (Context)ctxReference.get());
        com.appsflyer.a.logMessageMaskKey("data: " + postDataString);
        this.monitor((Context)ctxReference.get(), LOG_TAG, "EVENT_DATA", postDataString);
        try {
            this.callServer(uRL, postDataString, afDevKey, ctxReference, cacheKey, isLaunch);
            return;
        }
        catch (IOException iOException) {
            com.appsflyer.a.afLogE("Exception in sendRequestToServer. ", iOException);
            boolean bl = AppsFlyerProperties.getInstance().getBoolean("useHttpFallback", false);
            if (bl) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.debugAction("https failed: " + iOException.getLocalizedMessage(), "", (Context)ctxReference.get());
                this.callServer(new URL(var1_1.replace("https:", "http:")), (String)var2_2, (String)var3_3, ctxReference, cacheKey, isLaunch);
                return;
            }
            com.appsflyer.a.afLog("failed to send requeset to server. " + iOException.getLocalizedMessage());
            this.monitor((Context)ctxReference.get(), LOG_TAG, "ERROR", iOException.getLocalizedMessage());
            throw iOException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callServer(URL url, String postData, String appsFlyerDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean isLaunch) throws IOException {
        Context context = (Context)ctxReference.get();
        boolean bl = isLaunch && conversionDataListener != null;
        HttpURLConnection httpURLConnection = null;
        try {
            void var3_10;
            Object object;
            l.getInstance().addServerRequestEvent(url.toString(), postData);
            httpURLConnection = (HttpsURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            int n = postData.getBytes().length;
            httpURLConnection.setRequestProperty("Content-Length", "" + n);
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setDoOutput(true);
            Object object2 = null;
            try {
                void var2_3;
                object2 = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
                ((Writer)object2).write((String)var2_3);
            }
            catch (Throwable throwable) {
                if (object2 != null) {
                    ((OutputStreamWriter)object2).close();
                }
                throw throwable;
            }
            ((OutputStreamWriter)object2).close();
            int n2 = httpURLConnection.getResponseCode();
            object2 = this.readServerResponse(httpURLConnection);
            l.getInstance().addServerResponseEvent(object.toString(), n2, (String)object2);
            com.appsflyer.a.afLogM("response code: " + n2);
            this.monitor(context, LOG_TAG, "SERVER_RESPONSE_CODE", Integer.toString(n2));
            this.debugAction("response from server. status=", Integer.toString(n2), context);
            object = context.getSharedPreferences("appsflyer-data", 0);
            if (n2 == 200) {
                String string;
                if (ctxReference.get() != null && isLaunch) {
                    this.lastSuccessfulLaunchTimestamp = System.currentTimeMillis();
                }
                if ((string = this.getProperty("afUninstallToken")) != null) {
                    com.appsflyer.a.afDebugLog("Uninstall Token exists: " + string);
                    boolean bl2 = object.getBoolean("sentRegisterRequestToAF", false);
                    if (!bl2) {
                        com.appsflyer.a.afDebugLog("Resending Uninstall token to AF servers: " + string);
                        com.appsflyer.b b2 = new com.appsflyer.b(string);
                        com.appsflyer.a.updateServerUninstallToken(context, b2);
                    }
                } else if (this.getProperty("gcmProjectNumber") != null) {
                    com.appsflyer.a.afDebugLog("GCM Project number exists. Fetching token and sending to AF servers");
                    com.appsflyer.a.registerDeviceForUninstalls(new WeakReference<Context>(context));
                }
                if (this.latestDeepLink != null) {
                    this.latestDeepLink = null;
                }
                if (cacheKey != null) {
                    CacheManager.getInstance().deleteRequest(cacheKey, context);
                }
                if (ctxReference.get() != null && cacheKey == null) {
                    this.saveDataToSharedPreferences(context, "sentSuccessfully", "true");
                    this.checkCache(context);
                }
                try {
                    JSONObject jSONObject = new JSONObject((String)object2);
                    boolean bl3 = jSONObject.optBoolean("monitor", false);
                    if (bl3) {
                        l.getInstance().startRemoteDebuggingMode();
                    } else {
                        l.getInstance().dropPreLaunchDebugData();
                        l.getInstance().stopRemoteDebuggingMode();
                    }
                }
                catch (JSONException jSONException) {
                    l.getInstance().dropPreLaunchDebugData();
                    l.getInstance().stopRemoteDebuggingMode();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    com.appsflyer.a.afLogE(throwable.getMessage(), throwable2);
                    l.getInstance().dropPreLaunchDebugData();
                    l.getInstance().stopRemoteDebuggingMode();
                }
            }
            int n3 = object.getInt("appsflyerConversionDataRequestRetries", 0);
            long l2 = object.getLong("appsflyerConversionDataCacheExpiration", 0L);
            if (l2 != 0L && System.currentTimeMillis() - l2 > 5184000000L) {
                this.saveDataToSharedPreferences(context, "attributionId", null);
                this.saveLongToSharedPreferences(context, "appsflyerConversionDataCacheExpiration", 0L);
            }
            if (object.getString("attributionId", null) == null && appsFlyerDevKey != null && bl && conversionDataListener != null && n3 <= 5) {
                object = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
                d d2 = new d(context.getApplicationContext(), appsFlyerDevKey, (ScheduledExecutorService)object);
                this.scheduleJob((ScheduledExecutorService)object, d2, 10L, TimeUnit.MILLISECONDS);
            } else if (var3_10 == null) {
                com.appsflyer.a.afWarnLog("AppsFlyer dev key is missing.");
            } else if (bl && conversionDataListener != null && object.getString("attributionId", null) != null && this.getCounter((SharedPreferences)object, "appsFlyerCount", false) > 1) {
                try {
                    object = this.getConversionData(context);
                    if (object != null) {
                        conversionDataListener.onInstallConversionDataLoaded((Map<String, String>)object);
                    }
                }
                catch (g g2) {
                    g g3 = g2;
                    com.appsflyer.a.afLogE(g2.getMessage(), g3);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
                return;
            }
        }
        catch (Throwable throwable) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void validateAndTrackInAppPurchase(Context context, String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters) {
        l.getInstance().addApiEvent("validateAndTrackInAppPurchase", publicKey, signature, purchaseData, price, currency, additionalParameters == null ? "" : additionalParameters.toString());
        com.appsflyer.a.afLog("Validate in app called with parameters: " + purchaseData + " " + price + " " + currency);
        if (publicKey == null || price == null || signature == null || currency == null || purchaseData == null) {
            if (validatorListener != null) {
                validatorListener.onValidateInAppFailure("Please provide purchase parameters");
                return;
            }
        } else {
            void var3_3;
            void var2_2;
            com.appsflyer.c c2;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
            c2 = new com.appsflyer.c(c2.getApplicationContext(), this.getProperty("AppsFlyerKey"), (String)var2_2, (String)var3_3, purchaseData, price, currency, additionalParameters, scheduledThreadPoolExecutor);
            this.scheduleJob(scheduledThreadPoolExecutor, c2, 10L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleJob(ScheduledExecutorService scheduler, Runnable job, long delay, TimeUnit timeUnits) {
        try {
            void var3_5;
            void var2_4;
            void var1_1;
            if (scheduler == null || scheduler.isShutdown() || scheduler.isTerminated()) {
                com.appsflyer.a.afWarnLog("scheduler is null, shut downed or terminated");
                return;
            }
            var1_1.schedule((Runnable)var2_4, (long)var3_5, timeUnits);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            com.appsflyer.a.afLogE("scheduleJob failed with RejectedExecutionException Exception", rejectedExecutionException);
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.a.afLogE("scheduleJob failed with Exception", throwable);
        }
    }

    /*
     * Loose catch block
     */
    String readServerResponse(HttpURLConnection connection) {
        JSONObject jSONObject;
        Object object;
        StringBuilder stringBuilder;
        block20: {
            BufferedReader bufferedReader = null;
            stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader = null;
            object = connection.getErrorStream();
            if (object == null) {
                object = connection.getInputStream();
            }
            inputStreamReader = new InputStreamReader((InputStream)object);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((object = bufferedReader.readLine()) != null) {
                stringBuilder.append((String)object).append('\n');
            }
            try {
                bufferedReader.close();
                inputStreamReader.close();
            }
            catch (Throwable throwable) {}
            break block20;
            catch (Throwable throwable) {
                try {
                    com.appsflyer.a.afLogE("Could not read connection response from: " + jSONObject.getURL().toString(), throwable);
                }
                catch (Throwable throwable2) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (Throwable throwable3) {}
                    throw throwable2;
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Throwable throwable4) {}
            }
        }
        object = stringBuilder.toString();
        try {
            new JSONObject((String)object);
            return object;
        }
        catch (JSONException jSONException) {
            jSONObject = new JSONObject();
            try {
                jSONObject.put("response_not_json", object);
                return jSONObject.toString();
            }
            catch (JSONException jSONException2) {
                return new JSONObject().toString();
            }
        }
    }

    float getBatteryLevel(Context context) {
        int n;
        int n2;
        float f2;
        block2: {
            Throwable throwable;
            f2 = 1.0f;
            try {
                throwable = throwable.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
                n2 = throwable.getIntExtra("level", -1);
                n = throwable.getIntExtra("scale", -1);
                if (n2 != -1 && n != -1) break block2;
                return 50.0f;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                com.appsflyer.a.afLogE(throwable2.getMessage(), throwable);
            }
        }
        f2 = (float)n2 / (float)n * 100.0f;
        return f2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$002(AppsFlyerLib x0, long x1) {
        void var1_1;
        x0.timeEnteredForeground = var1_1;
        return x0.timeEnteredForeground;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$102(AppsFlyerLib x0, long x1) {
        void var1_1;
        x0.timeWentToBackground = var1_1;
        return x0.timeWentToBackground;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(AppsFlyerLib x0, WeakReference x1) {
        void var1_1;
        x0.callStatsBackground((WeakReference<Context>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(AppsFlyerLib x0, Context x1, String x2, String x3, String x4, String x5, boolean x6) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.sendTrackingWithEvent((Context)var1_1, (String)var2_2, (String)var3_3, x4, x5, x6);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(AppsFlyerLib x0, String x1, String x2, String x3, WeakReference x4, String x5, boolean x6) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.sendRequestToServer((String)var1_1, (String)var2_2, (String)var3_3, x4, x5, x6);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(AppsFlyerLib x0, Context x1, String x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.saveIntegerToSharedPreferences((Context)var1_1, (String)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$900(AppsFlyerLib x0, WeakReference x1) {
        void var1_1;
        return x0.getConfiguredChannel((WeakReference<Context>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1000(AppsFlyerLib x0, Context x1, String x2) throws PackageManager.NameNotFoundException {
        void var2_2;
        void var1_1;
        return x0.getCachedChannel((Context)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1100(AppsFlyerLib x0, Context x1, String x2, long x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.saveLongToSharedPreferences((Context)var1_1, (String)var2_2, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$1200(AppsFlyerLib x0, String x1) {
        void var1_1;
        return x0.attributionStringToMap((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1300(AppsFlyerLib x0, Context x1, String x2, String x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.saveDataToSharedPreferences((Context)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$1400(AppsFlyerLib x0, Context x1) throws g {
        void var1_1;
        return x0.getConversionData((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$1602(AppsFlyerLib x0, long x1) {
        void var1_1;
        x0.lastCacheCheck = var1_1;
        return x0.lastCacheCheck;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1502(AppsFlyerLib x0, boolean x1) {
        void var1_1;
        x0.isDuringCheckCache = var1_1;
        return x0.isDuringCheckCache;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1700(AppsFlyerLib x0, String x1) {
        void var1_1;
        return x0.getProperty((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ScheduledExecutorService access$1802(AppsFlyerLib x0, ScheduledExecutorService x1) {
        void var1_1;
        x0.cacheScheduler = var1_1;
        return x0.cacheScheduler;
    }

    final class b
    implements Runnable {
        private WeakReference<Context> ctxReference = null;

        public b(Context context) {
            this.ctxReference = new WeakReference<Context>(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            if (AppsFlyerLib.this.isDuringCheckCache) {
                return;
            }
            AppsFlyerLib.access$1602(AppsFlyerLib.this, System.currentTimeMillis());
            if (this.ctxReference == null) {
                return;
            }
            AppsFlyerLib.access$1502(AppsFlyerLib.this, true);
            try {
                String string = AppsFlyerLib.access$1700(AppsFlyerLib.this, "AppsFlyerKey");
                WeakReference<Context> weakReference = this.ctxReference;
                synchronized (weakReference) {
                    for (RequestCacheData requestCacheData : CacheManager.getInstance().getCachedRequests((Context)this.ctxReference.get())) {
                        com.appsflyer.a.afLog("resending request: " + requestCacheData.getRequestURL());
                        try {
                            long l2 = System.currentTimeMillis();
                            String string2 = requestCacheData.getCacheKey();
                            long l3 = Long.parseLong(string2, 10);
                            AppsFlyerLib.access$600(AppsFlyerLib.this, requestCacheData.getRequestURL() + "&isCachedRequest=true&timeincache=" + Long.toString((l2 - l3) / 1000L), requestCacheData.getPostData(), string, this.ctxReference, requestCacheData.getCacheKey(), false);
                        }
                        catch (Exception exception) {
                            com.appsflyer.a.afLogE("Failed to resend cached request", exception);
                        }
                    }
                }
            }
            catch (Exception exception) {
                com.appsflyer.a.afLogE("failed to check cache. ", exception);
            }
            finally {
                AppsFlyerLib.access$1502(AppsFlyerLib.this, false);
            }
            AppsFlyerLib.access$1802(AppsFlyerLib.this, null);
        }
    }

    abstract class a
    implements Runnable {
        protected WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey;
        private ScheduledExecutorService executorService;
        private AtomicInteger currentRequestsCounter = new AtomicInteger(0);

        protected abstract void attributionCallback(Map<String, String> var1);

        public abstract String getUrl();

        protected abstract void attributionCallbackFailure(String var1, int var2);

        public a(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = string;
            if (scheduledExecutorService == null) {
                this.executorService = AFExecutor.getInstance().getScheduledThreadPoolExecutor();
                return;
            }
            this.executorService = scheduledExecutorService;
        }

        @Override
        public void run() {
            block21: {
                Object object;
                HttpURLConnection httpURLConnection;
                block20: {
                    if (this.appsFlyerDevKey == null || this.appsFlyerDevKey.length() == 0) {
                        return;
                    }
                    this.currentRequestsCounter.incrementAndGet();
                    httpURLConnection = null;
                    object = (Context)this.ctxReference.get();
                    if (object != null) break block20;
                    this.currentRequestsCounter.decrementAndGet();
                    return;
                }
                try {
                    long l2 = System.currentTimeMillis();
                    CharSequence charSequence = AppsFlyerLib.access$1000(AppsFlyerLib.this, object, AppsFlyerLib.access$900(AppsFlyerLib.this, new WeakReference<Context>((Context)object)));
                    String string = "";
                    if (charSequence != null) {
                        string = "-" + (String)charSequence;
                    }
                    charSequence = new StringBuilder().append(this.getUrl()).append(object.getPackageName()).append(string).append("?devkey=").append(this.appsFlyerDevKey).append("&device_id=").append(k.id(new WeakReference<Context>((Context)object)));
                    l.getInstance().addServerRequestEvent(((StringBuilder)charSequence).toString(), "");
                    com.appsflyer.a.logMessageMaskKey("Calling server for attribution url: " + ((StringBuilder)charSequence).toString());
                    httpURLConnection = (HttpsURLConnection)new URL(((StringBuilder)charSequence).toString()).openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setConnectTimeout(10000);
                    httpURLConnection.setRequestProperty("Connection", "close");
                    httpURLConnection.connect();
                    int n = httpURLConnection.getResponseCode();
                    String string2 = AppsFlyerLib.this.readServerResponse(httpURLConnection);
                    l.getInstance().addServerResponseEvent(((StringBuilder)charSequence).toString(), n, string2);
                    if (n == 200) {
                        long l3 = System.currentTimeMillis();
                        AppsFlyerLib.access$1100(AppsFlyerLib.this, object, "appsflyerGetConversionDataTiming", (l3 - l2) / 1000L);
                        com.appsflyer.a.logMessageMaskKey("Attribution data: " + string2);
                        if (string2.length() > 0 && object != null) {
                            Map map = AppsFlyerLib.access$1200(AppsFlyerLib.this, string2);
                            String string3 = (String)map.get("iscache");
                            if (string3 != null && "false".equals(string3)) {
                                AppsFlyerLib.access$1100(AppsFlyerLib.this, object, "appsflyerConversionDataCacheExpiration", System.currentTimeMillis());
                            }
                            if ((charSequence = new JSONObject(map).toString()) != null) {
                                AppsFlyerLib.access$1300(AppsFlyerLib.this, object, "attributionId", (String)charSequence);
                            } else {
                                AppsFlyerLib.access$1300(AppsFlyerLib.this, object, "attributionId", string2);
                            }
                            com.appsflyer.a.afDebugLog("iscache=" + string3 + " caching conversion data");
                            if (conversionDataListener != null && this.currentRequestsCounter.intValue() <= 1) {
                                try {
                                    object = AppsFlyerLib.access$1400(AppsFlyerLib.this, object);
                                }
                                catch (g g2) {
                                    com.appsflyer.a.afLogE("Exception while trying to fetch attribution data. ", g2);
                                    object = map;
                                }
                                this.attributionCallback((Map<String, String>)object);
                            }
                        }
                    } else {
                        if (conversionDataListener != null) {
                            this.attributionCallbackFailure("Error connection to server: " + n, n);
                        }
                        com.appsflyer.a.logMessageMaskKey("AttributionIdFetcher response code: " + n + "  url: " + charSequence);
                    }
                    this.currentRequestsCounter.decrementAndGet();
                }
                catch (Throwable throwable) {
                    try {
                        if (conversionDataListener != null) {
                            this.attributionCallbackFailure(throwable.getMessage(), 0);
                        }
                        com.appsflyer.a.afLogE(throwable.getMessage(), throwable);
                        return;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        this.currentRequestsCounter.decrementAndGet();
                        if (httpURLConnection == null) break block21;
                        httpURLConnection.disconnect();
                    }
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                    return;
                }
            }
        }
    }

    final class d
    extends a {
        public d(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
            super(context, string, scheduledExecutorService);
        }

        @Override
        public final String getUrl() {
            return "https://api.appsflyer.com/install_data/v3/";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void attributionCallback(Map<String, String> conversionData) {
            void var1_1;
            conversionDataListener.onInstallConversionDataLoaded((Map<String, String>)var1_1);
            ((Context)this.ctxReference.get()).getSharedPreferences("appsflyer-data", 0);
            AppsFlyerLib.access$800(AppsFlyerLib.this, (Context)this.ctxReference.get(), "appsflyerConversionDataRequestRetries", 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void attributionCallbackFailure(String error, int responseCode) {
            void var2_3;
            SharedPreferences sharedPreferences;
            conversionDataListener.onInstallConversionFailure((String)sharedPreferences);
            if (responseCode >= 400 && var2_3 < 500) {
                sharedPreferences = ((Context)this.ctxReference.get()).getSharedPreferences("appsflyer-data", 0);
                int n = sharedPreferences.getInt("appsflyerConversionDataRequestRetries", 0);
                AppsFlyerLib.access$800(AppsFlyerLib.this, (Context)this.ctxReference.get(), "appsflyerConversionDataRequestRetries", ++n);
            }
        }
    }

    final class e
    implements Runnable {
        private String urlString;
        private WeakReference<Context> ctxReference = null;
        Map<String, Object> params;
        boolean isLaunch;

        private e(String string, Map<String, Object> map, Context context, boolean bl) {
            this.urlString = string;
            this.params = map;
            this.ctxReference = new WeakReference<Context>(context);
            this.isLaunch = bl;
        }

        @Override
        public final void run() {
            String string = null;
            try {
                String string2 = (String)this.params.get("appsflyerKey");
                string = new JSONObject(this.params).toString();
                AppsFlyerLib.access$600(AppsFlyerLib.this, this.urlString, string, string2, this.ctxReference, null, this.isLaunch);
                return;
            }
            catch (IOException iOException) {
                com.appsflyer.a.afLogE("Exception while sending request to server. ", iOException);
                if (string != null && this.ctxReference != null && !this.urlString.contains("&isCachedRequest=true&timeincache=")) {
                    CacheManager.getInstance().cacheRequest(new RequestCacheData(this.urlString, string, "4.7.4"), (Context)this.ctxReference.get());
                    com.appsflyer.a.afLogE(iOException.getMessage(), iOException);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                com.appsflyer.a.afLogE(throwable.getMessage(), throwable2);
                return;
            }
        }

        /* synthetic */ e(String string, Map map, Context context, boolean bl, com.appsflyer.a a2) {
            this(string, map, context, bl);
        }
    }

    final class c
    implements Runnable {
        private WeakReference<Context> context;
        private String appsFlyerKey;
        private String eventName;
        private String eventValue;
        private String referrer;
        private ExecutorService executor;
        private boolean isNewAPI;

        private c(WeakReference<Context> weakReference, String string, String string2, String string3, String string4, boolean bl, ExecutorService executorService) {
            this.context = weakReference;
            this.appsFlyerKey = string;
            this.eventName = string2;
            this.eventValue = string3;
            this.referrer = string4;
            this.isNewAPI = bl;
            this.executor = executorService;
        }

        @Override
        public final void run() {
            AppsFlyerLib.access$500(AppsFlyerLib.this, (Context)this.context.get(), this.appsFlyerKey, this.eventName, this.eventValue, this.referrer, this.isNewAPI);
        }

        /* synthetic */ c(WeakReference weakReference, String string, String string2, String string3, String string4, boolean bl, ExecutorService executorService, com.appsflyer.a a2) {
            this(weakReference, string, string2, string3, string4, bl, executorService);
        }
    }
}

