/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.os.AsyncTask;
import android.os.Build;
import com.appsflyer.a;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AFExecutor {
    private static AFExecutor instance;
    private Executor afThreadPoolExecutor;
    private ScheduledExecutorService afScheduledThreadPoolExecutor;
    private Executor afSerialExecutor;

    private AFExecutor() {
    }

    public static AFExecutor getInstance() {
        if (instance == null) {
            instance = new AFExecutor();
        }
        return instance;
    }

    public Executor getSerialExecutor() {
        if (this.afSerialExecutor == null) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.afSerialExecutor = AsyncTask.SERIAL_EXECUTOR;
            } else {
                return Executors.newSingleThreadExecutor();
            }
        }
        return this.afSerialExecutor;
    }

    public Executor getThreadPoolExecutor() {
        boolean bl = this.afThreadPoolExecutor == null || this.afThreadPoolExecutor instanceof ThreadPoolExecutor && (((ThreadPoolExecutor)this.afThreadPoolExecutor).isShutdown() || ((ThreadPoolExecutor)this.afThreadPoolExecutor).isTerminated() || ((ThreadPoolExecutor)this.afThreadPoolExecutor).isTerminating());
        if (bl) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.afThreadPoolExecutor = Executors.newFixedThreadPool(2);
            } else {
                return Executors.newSingleThreadExecutor();
            }
        }
        return this.afThreadPoolExecutor;
    }

    ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        boolean bl = this.afScheduledThreadPoolExecutor == null || this.afScheduledThreadPoolExecutor.isShutdown() || this.afScheduledThreadPoolExecutor.isTerminated();
        if (bl) {
            this.afScheduledThreadPoolExecutor = Executors.newScheduledThreadPool(2);
        }
        return (ScheduledThreadPoolExecutor)this.afScheduledThreadPoolExecutor;
    }

    void shutdownExecutors() {
        try {
            this.stopExecutorService(this.afScheduledThreadPoolExecutor);
            if (this.afThreadPoolExecutor instanceof ThreadPoolExecutor) {
                this.stopExecutorService((ThreadPoolExecutor)this.afThreadPoolExecutor);
            }
            return;
        }
        catch (Throwable throwable) {
            a.afLogE("failed to stop Executors", throwable);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void stopExecutorService(ExecutorService executor) {
        block5: {
            try {
                a.afDebugLog("shut downing executor ...");
                executor.shutdown();
                executor.awaitTermination(10L, TimeUnit.SECONDS);
                if (executor.isTerminated()) break block5;
            }
            catch (InterruptedException interruptedException) {
                block6: {
                    try {
                        a.afDebugLog("InterruptedException!!!");
                        if (executor.isTerminated()) break block6;
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        if (!executor.isTerminated()) {
                            a.afWarnLog("killing non-finished tasks", true);
                        }
                        var1_1.shutdownNow();
                        throw throwable;
                    }
                    a.afWarnLog("killing non-finished tasks", true);
                }
                executor.shutdownNow();
                return;
            }
            a.afWarnLog("killing non-finished tasks", true);
        }
        executor.shutdownNow();
        return;
    }
}

