/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.floatbutton;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.koushikdutta.urlimageviewhelper.UrlImageViewHelper;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.model.MobMenu;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Stack;

public class MobGameFloatMenuView {
    private static final String TAG = null;
    private static int MENU_HEIGHT = 44;
    Activity activity;
    EventListener eventListener;
    View rootView;
    View layoutMenu;
    View timerView;
    @SuppressLint(value={"UseSparseArrays"})
    HashMap<Integer, ImageView> ntfImageViews = new HashMap();
    float density;
    float screenHeight;
    private View menuItemCountdownTimer;
    private OnClickOutsideListener clickOutsideListener;

    public MobGameFloatMenuView(Activity a) {
        this.activity = a;
        this.density = DeviceUtils.getDensity((Context)a);
        this.screenHeight = DeviceUtils.getScreenHeightInPixels((Context)a);
        this.attachView();
        this.initView();
    }

    public void setClickOutsideListenter(OnClickOutsideListener clickOutsideListener) {
        this.clickOutsideListener = clickOutsideListener;
    }

    @SuppressLint(value={"InflateParams"})
    public void attachView() {
        try {
            this.rootView = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_menu, null);
            WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2002, 8, -2);
            params.gravity = 51;
            windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
    public void initView() {
        try {
            this.rootView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    MobGameFloatMenuView.this.hide();
                    MobGameOverlayView.setNtf(true);
                    if (MobGameFloatMenuView.this.clickOutsideListener != null) {
                        MobGameFloatMenuView.this.clickOutsideListener.onClickOutSide();
                    }
                    return true;
                }
            });
            this.layoutMenu = this.rootView.findViewById(R.id.layout_menu);
            this.updateMenu();
            this.hide();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEventListener(EventListener listener) {
        this.eventListener = listener;
    }

    public void show(int x, int y, boolean isAnimated) {
        try {
            if (this.eventListener != null && this.rootView.getVisibility() != 0) {
                this.eventListener.onShow();
            }
            this.rootView.setVisibility(0);
            WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            WindowManager.LayoutParams params = (WindowManager.LayoutParams)this.rootView.getLayoutParams();
            params.x = MENU_HEIGHT * (int)this.density;
            windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)params);
            int menuY = y + (MENU_HEIGHT * (int)this.density - this.layoutMenu.getHeight()) / 2;
            int minY = 0;
            int maxY = (int)(this.screenHeight - (float)this.layoutMenu.getHeight());
            int calY = Math.min(maxY, Math.max(minY, menuY));
            if (calY > menuY) {
                menuY = y;
            } else if (calY < menuY) {
                menuY = y + (MENU_HEIGHT * (int)this.density - this.layoutMenu.getHeight());
            }
            RelativeLayout.LayoutParams params1 = (RelativeLayout.LayoutParams)this.layoutMenu.getLayoutParams();
            params1.addRule(9, -1);
            params1.addRule(11, 0);
            params1.leftMargin = x + 8 * (int)this.density;
            params1.topMargin = menuY;
            if (isAnimated) {
                this.layoutMenu.animate().setDuration(400L).alpha(100.0f);
            }
            this.updateMenuNtf();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showInReverse(int x, int y, boolean isAnimated) {
        try {
            if (this.eventListener != null && this.rootView.getVisibility() != 0) {
                this.eventListener.onShow();
            }
            this.rootView.setVisibility(0);
            WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            WindowManager.LayoutParams params = (WindowManager.LayoutParams)this.rootView.getLayoutParams();
            params.x = 0;
            windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)params);
            int menuY = y + (MENU_HEIGHT * (int)this.density - this.layoutMenu.getHeight()) / 2;
            int minY = 0;
            int maxY = (int)(this.screenHeight - (float)this.layoutMenu.getHeight());
            int calY = Math.min(maxY, Math.max(minY, menuY));
            if (calY > menuY) {
                menuY = y;
            } else if (calY < menuY) {
                menuY = y + (MENU_HEIGHT * (int)this.density - this.layoutMenu.getHeight());
            }
            RelativeLayout.LayoutParams params1 = (RelativeLayout.LayoutParams)this.layoutMenu.getLayoutParams();
            params1.addRule(9, 0);
            params1.addRule(11, -1);
            params1.rightMargin = x + 8 * (int)this.density;
            params1.topMargin = menuY;
            if (isAnimated) {
                this.layoutMenu.animate().setDuration(400L).alpha(100.0f);
            }
            this.updateMenuNtf();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            if (this.eventListener != null && this.rootView.getVisibility() == 0) {
                this.eventListener.onHide();
            }
            this.rootView.setVisibility(4);
            this.layoutMenu.setAlpha(0.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            windowManager.removeView(this.rootView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"InflateParams"})
    void updateMenu() {
        try {
            int i;
            ((ViewGroup)this.layoutMenu).removeAllViews();
            MobMenu mobMenu = GameConfigManager.getInstance().getMobMenu();
            if (mobMenu == null) {
                return;
            }
            ArrayList<MobMenuItem> menuItems = mobMenu.getMenuItems();
            Stack<View> menuStackViews = new Stack<View>();
            for (i = menuItems.size() - 1; i >= 0; --i) {
                MobMenuItem menuItem = menuItems.get(i);
                if (!menuItem.shouldShowHorizontal()) continue;
                View v = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_menu_item, null);
                TextView tv = (TextView)v.findViewById(R.id.title);
                ImageView imv = (ImageView)v.findViewById(R.id.image);
                ImageView imvNoti = (ImageView)v.findViewById(R.id.img_notification);
                this.timerView = v.findViewById(R.id.countdown_timer_layout);
                if (menuItem.isTab()) {
                    for (int subId : menuItem.getSubMenuIds()) {
                        this.ntfImageViews.put(subId, imvNoti);
                    }
                    this.ntfImageViews.put(menuItem.getId(), imvNoti);
                } else {
                    this.ntfImageViews.put(menuItem.getId(), imvNoti);
                }
                Log.d((String)"acb", (String)"go here!");
                String lableHorizontal = menuItem.getLabelHorizontal();
                tv.setText((CharSequence)lableHorizontal);
                tv.setTextSize(2, 11.0f);
                UrlImageViewHelper.setUrlDrawable((ImageView)imv, (String)menuItem.getIconUrlHorizontal());
                Log.d((String)TAG, (String)("FloatButtonTimerHelper.isRuningTimer():" + FloatButtonTimerHelper.isRuningTimer()));
                final MobMenuItem fMenuItem = menuItem;
                v.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (MobGameFloatMenuView.this.eventListener != null) {
                            MobGameFloatMenuView.this.eventListener.onClick(v, fMenuItem);
                        }
                    }
                });
                if ("tin t\u1ee9c".equalsIgnoreCase(lableHorizontal)) {
                    this.menuItemCountdownTimer = v;
                }
                if ("News".equalsIgnoreCase(lableHorizontal)) {
                    this.menuItemCountdownTimer = v;
                }
                if ("\u65b0\u95fb".equalsIgnoreCase(lableHorizontal)) {
                    this.menuItemCountdownTimer = v;
                }
                menuStackViews.push(v);
            }
            for (i = 0; i < menuStackViews.size(); ++i) {
                Log.d((String)"acb", (String)("go here!" + menuStackViews.size() + " " + i));
                View v = (View)menuStackViews.get(i);
                this.timerView = v.findViewById(R.id.countdown_timer_layout);
                if (FloatButtonTimerHelper.isRuningTimer()) {
                    if (menuStackViews.size() <= 4) {
                        this.timerView.setVisibility(0);
                        continue;
                    }
                    if (i > menuStackViews.size() - 5) {
                        this.timerView.setVisibility(0);
                        continue;
                    }
                    this.timerView.setVisibility(8);
                    continue;
                }
                this.timerView.setVisibility(8);
            }
            int itemsPerRow = 4;
            while (!menuStackViews.isEmpty()) {
                TableRow tblrow = new TableRow((Context)this.activity);
                tblrow.setGravity(16);
                for (int j = 0; !menuStackViews.isEmpty() && j < itemsPerRow; ++j) {
                    tblrow.addView((View)menuStackViews.pop());
                }
                ((ViewGroup)this.layoutMenu).addView((View)tblrow);
            }
            this.updateMenuNtf();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateMenuNtf() {
        try {
            if (this.ntfImageViews == null) {
                return;
            }
            ArrayList<ImageView> imvs = new ArrayList<ImageView>(this.ntfImageViews.values());
            for (int i = 0; i < imvs.size(); ++i) {
                ImageView imageView = imvs.get(i);
                if (imageView != null) {
                    imageView.setVisibility(8);
                }
                if (FloatButtonTimerHelper.isRuningTimer()) {
                    if (i < 4) {
                        this.timerView.setVisibility(0);
                        continue;
                    }
                    this.timerView.setVisibility(8);
                    continue;
                }
                this.timerView.setVisibility(8);
            }
            ArrayList<Integer> ntfs = NotificationUtils.getNtfs((Context)this.activity);
            if (ntfs == null) {
                return;
            }
            for (int i = 0; i < ntfs.size(); ++i) {
                Log.d((String)TAG, (String)("ntfs size:" + ntfs.size()));
                Log.d((String)TAG, (String)("ntfs value:" + ntfs.get(i)));
                ImageView imageView = this.ntfImageViews.get(ntfs.get(i));
                if (imageView != null) {
                    imageView.setVisibility(0);
                }
                if (!FloatButtonTimerHelper.isRuningTimer() || ntfs.get(i) != 2 && ntfs.get(i) != 3) continue;
                imageView.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCountdownTimer(long countDownRunningTime) {
        Log.d((String)TAG, (String)("updateCountdownTimer: " + countDownRunningTime));
        try {
            if (this.menuItemCountdownTimer == null) {
                return;
            }
            final CountdownChronometer countDownTimer = (CountdownChronometer)this.menuItemCountdownTimer.findViewById(R.id.countdown_timer);
            countDownTimer.setCountdownListener(new CountdownChronometer.CountdownListener(){

                @Override
                public void done() {
                    if (countDownTimer != null) {
                        countDownTimer.setVisibility(8);
                        MobGameFloatMenuView.this.timerView.setVisibility(8);
                    }
                }
            });
            if (countDownRunningTime / 1000L <= 0L) {
                countDownTimer.setVisibility(8);
                this.timerView.setVisibility(8);
                return;
            }
            int countTime = (int)(countDownRunningTime / 1000L);
            ValueAnimator anim2 = new ValueAnimator();
            anim2.setIntValues(new int[]{Color.parseColor((String)"#ee4242"), Color.parseColor((String)"#ad2020")});
            anim2.setEvaluator((TypeEvaluator)new ArgbEvaluator());
            anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    countDownTimer.setBackgroundColor((Integer)valueAnimator.getAnimatedValue());
                }
            });
            anim2.setRepeatCount(countTime);
            anim2.setDuration(1000L);
            anim2.start();
            this.timerView.setVisibility(0);
            countDownTimer.setVisibility(0);
            countDownTimer.setBase(Calendar.getInstance().getTimeInMillis() + countDownRunningTime);
            countDownTimer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshFloatMenu() {
        this.updateMenu();
    }

    static interface EventListener {
        public void onClick(View var1, MobMenuItem var2);

        public void onShow();

        public void onHide();
    }

    public static interface OnClickOutsideListener {
        public void onClickOutSide();
    }
}

