package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.mobgame.MobGameSDK;
import com.mobgame.model.ZaloResponse;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by khaitran on 6/16/17.
 */

public class LoginZaloTask extends AsyncTask<String , Void , Void> {

    private Listener callback;

    public LoginZaloTask(Listener callback) {
        Log.d("TAG" , "Login Zalo task");
        this.callback = callback;
    }

    @Override
    protected Void doInBackground(String... params) {

        Context c = MobGameSDK.getApplicationContext();
        RestfulApi api = RestfulApi.getInstance();
        String oauthenCode = params[0];

        Call<ZaloResponse> call = api.getVerifyLoginZalo(oauthenCode);

        call.enqueue(new Callback<ZaloResponse>() {

            @Override
            public void onResponse(Call<ZaloResponse> call, Response<ZaloResponse> response) {
                Log.d("TAG" , "response zalo:" + response.body().toString());
                try {

                    if (response.isSuccessful()) {
                        ZaloResponse zaloResponse = null;
                        String str = response.body().getData();
                        Log.d("TAG" , "response zalo:" + str);
                        if (callback != null) {
                            callback.onSuccess(str);
                        }
                    } else {
                        if (callback != null) {
                            callback.onFailure(new Exception());
                        }
                    }
                } catch (Exception e) {
                    if (callback != null) {
                        Log.d("TAG" , "response fail 1");
                        callback.onFailure(e);
                    }
                }
            }

            @Override
            public void onFailure(Call<ZaloResponse> call, Throwable t) {
                if (callback != null) {
                    Log.d("TAG" , "response fail");
                    callback.onFailure(t);
                }
            }
        });
        return null;
    }

    public interface Listener {
        public void onSuccess(String str);
        public void onFailure(Throwable t);
    }
}
