package com.mobgame.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.google.gson.annotations.SerializedName;

public class MobMenu {
	
	@SerializedName("menu")
	ArrayList<MobMenuItem> menuItems;
	
	public static MobMenu parse(String json) {
		/*GsonBuilder gb = new GsonBuilder();
		gb.registerTypeAdapter(MobMenuItem.class, new MobMenuItemDeserializer());
		Gson gson = gb.create();
//		Type listType = new TypeToken<ArrayList<MobMenuItem>>() {}.getType();
//		ArrayList<MobMenuItem> menuItems = gson.fromJson(json.trim(), ArrayList.class);
//		MobMenu mobMenu = new MobMenu();
//		mobMenu.setMenuItems(menuItems);
		MobMenu mobMenu = gson.fromJson(json, MobMenu.class);
		return mobMenu;*/

		try {
			ArrayList<MobMenuItem> menuItems = new ArrayList<MobMenuItem>();
			JSONArray menuJsonAray = new JSONArray(json);
			for (int i = 0; i < menuJsonAray.length(); i++) {
				try {
					MobMenuItem menuItem = new MobMenuItem();
					JSONObject menuItemJSON = menuJsonAray.getJSONObject(i);
					if (menuItemJSON.has("id")) {
						menuItem.setId(menuItemJSON.getInt("id"));
					}
					if (menuItemJSON.has("priority")) {
						menuItem.setPriority(menuItemJSON.getInt("priority"));
					}
					if (menuItemJSON.has("is_tab") && menuItemJSON.getBoolean("is_tab")) {
						menuItem.setTab(true);
					}
					if (menuItemJSON.has("external") && menuItemJSON.getBoolean("external")) {
						menuItem.setExternal(true);
					}
					if (menuItemJSON.has("show") && menuItemJSON.getBoolean("show")) {
						menuItem.setShouldShow(true);
					}
					if (menuItemJSON.has("icon")) {
						menuItem.setIconUrl(menuItemJSON.getString("icon"));
					}
					if (menuItemJSON.has("title")) {
						menuItem.setLabel(menuItemJSON.getString("title"));
					}
					if (menuItemJSON.has("horizontal_show") && menuItemJSON.getBoolean("horizontal_show")) {
						menuItem.setShouldShowHorizontal(true);
					}
					if (menuItemJSON.has("horizontal_icon")) {
						menuItem.setIconUrlHorizontal(menuItemJSON.getString("horizontal_icon"));
					}
					if (menuItemJSON.has("horizontal_title")) {
						menuItem.setLabelHorizontal(menuItemJSON.getString("horizontal_title"));
					}
					if (menuItem.isTab()) {
						try {
							JSONArray menuActions = menuItemJSON.getJSONArray("action");
							menuItem.setCommand("dashboard");
							menuItem.setParams(menuActions.toString());
							int[] subMenuIds = new int[menuActions.length()];
							for (int j = 0; j < menuActions.length(); j++) {
								JSONObject obj = menuActions.getJSONObject(j);
								subMenuIds[j] = obj.getInt("id");
							}
							menuItem.setSubMenuIds(subMenuIds);
//							menuItem.setSubItems(menuActions);
						} catch (JSONException e) {}
					} else {
						String menuAction = menuItemJSON.getString("action");
						try {
							JSONObject menuActionJSON = new JSONObject(menuAction);
							menuItem.setCommand(menuActionJSON.getString("command"));
							menuItem.setParams(menuActionJSON.getString("param"));
						} catch (JSONException e) {
							try {
								JSONArray menuActions = new JSONArray();
								menuActions.put(menuItemJSON);
								menuItem.setCommand("dashboard");
								menuItem.setParams(menuActions.toString());
//								menuItem.setSubItems(menuActions);
							} catch (Exception e1) {}
						}
					}
					menuItems.add(menuItem);
				} catch (JSONException e) {
					
				}
				
			}
	
			MobMenu mobMenu = new MobMenu();
			mobMenu.setMenuItems(menuItems);
			return mobMenu;
		} catch (JSONException e) {
			return new MobMenu();
		}
	}
	
	public MobMenu() {		
	}

	public ArrayList<MobMenuItem> getMenuItems() {
		if (menuItems == null) {
			menuItems = new ArrayList<>();
		}
		return menuItems;
	}

	public void setMenuItems(ArrayList<MobMenuItem> menuItems) {
		this.menuItems = menuItems;
	}
	
	public MobMenuItem getMobMenuItemById(int menuId) {
		for (MobMenuItem menuItem : menuItems) {
			if (menuItem.getId() == menuId) {
				return menuItem;
			}
			for (int id : menuItem.getSubMenuIds()) {
				if (id == menuId) {
					return menuItem;
				}
			}
		}
		return null;
	}
	
	public ArrayList<MobMenuItem> getMobMenuItemsByIds(ArrayList<Integer> menuIds) {
		Set<Integer> setMenuIds = new HashSet<Integer>(menuIds);
		ArrayList<MobMenuItem> result = new ArrayList<MobMenuItem>();
		if (menuItems != null && !menuItems.isEmpty()) {
			for (int menuId : setMenuIds) {
				for (MobMenuItem menuItem : menuItems) {
					if (menuItem.getId() == menuId) {
						result.add(menuItem);
						continue;
					}
					for (int id : menuItem.getSubMenuIds()) {
						if (id == menuId) {
							result.add(menuItem);
							continue;
						}
					}
				}
			}
			return result;
		}
		return result;
	}

}
