package com.mobgame.component;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;

import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import com.mobgame.utils.Constants;

import java.io.IOException;

public final class GoogleAuthManager {

	private final static String TAG = GoogleAuthManager.class.getSimpleName();
	private static GoogleAuthManager INSTANCE;

	private static final int REQUEST_GOOGLE_PLAY_SERVICES = 412;

	private GoogleSignInClient mGoogleSignInClient;
	private GooglePlusResultCallback googlePlusResultCallback;
	private Activity activity;
	private String SCOPE = "oauth2:https://www.googleapis.com/auth/userinfo.profile";

	public static GoogleAuthManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new GoogleAuthManager();
		}
		return INSTANCE;
	}

	private GoogleAuthManager() {}

	void init(Activity activity) {
		try {
			this.activity = activity;
			GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
					.requestEmail()
					.build();

			mGoogleSignInClient = GoogleSignIn.getClient(activity, gso);

		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		try {
			if (requestCode == Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES) {
				try {
					Task<GoogleSignInAccount> signinTask = GoogleSignIn.getSignedInAccountFromIntent(data);
					GoogleSignInAccount account = signinTask.getResult(ApiException.class);
					if(account!=null){
						// Signed in successfully, show authenticated UI.
						String str = account.getIdToken();
						Log.d("TAG " , "GGOOOOOOO : " + str);
						if (googlePlusResultCallback != null){
							Log.d("TAG " , "GGOOOOOOO");
							new GetToken(activity,SCOPE,account.getEmail(),account,googlePlusResultCallback).execute();
						}
					}else{
						if (googlePlusResultCallback != null){
							googlePlusResultCallback.onLoginError("Google Signin Error");
						}
					}


				} catch (ApiException e) {
					// The ApiException status code indicates the detailed failure reason.
					// Please refer to the GoogleSignInStatusCodes class reference for more information.
					Log.w(TAG, "signInResult:failed code=" + e.getStatusCode());
                  if (googlePlusResultCallback != null)
                      googlePlusResultCallback.onLoginError("Google Signin Error");
					  Log.d(TAG, "onActivityResult: Google Signin Error, account = null");
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void login(Activity activity, GooglePlusResultCallback googlePlusResultCallback) {
		try {
			this.googlePlusResultCallback = googlePlusResultCallback;
			Intent signInIntent = mGoogleSignInClient.getSignInIntent();
			activity.startActivityForResult(signInIntent, Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void logout() {
		try {
			GoogleSignInAccount account = GoogleSignIn.getLastSignedInAccount(activity);
			if (account!=null && mGoogleSignInClient != null){
				mGoogleSignInClient.signOut();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public interface GooglePlusResultCallback {
		void onLoginSuccess(GoogleSignInAccount account, String mToken);

		void onLoginError(String mess);
	}

	public String getToken(Activity activity, String email, String scope) throws IOException, GoogleAuthException {
		return GoogleAuthUtil.getToken(activity, email, scope);
	}

	class GetToken extends AsyncTask<Void,Void,String> {

		Activity mActivity;
		String mScope;
		String mEmail;
		GooglePlusResultCallback mCallback;
		GoogleSignInAccount mGogleSignin;

		public GetToken(Activity activity, String scope, String email,GoogleSignInAccount googleSignInAccount
				,GooglePlusResultCallback callback){

			this.mActivity = activity;
			this.mScope = scope;
			this.mEmail = email;
			this.mCallback = callback;
			this.mGogleSignin = googleSignInAccount;

		}
		@Override
		protected String doInBackground(Void... params) {

			try {
				return getToken(activity,mEmail,mScope);
			} catch (IOException e) {
				e.printStackTrace();
			} catch (GoogleAuthException e) {
				e.printStackTrace();
			}
			return "";
		}

		@Override
		protected void onPostExecute(String aVoid) {
			super.onPostExecute(aVoid);
			try {
				if(!TextUtils.isEmpty(aVoid))
					mCallback.onLoginSuccess(mGogleSignin,aVoid);
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	}

	public boolean isGoogleServiceAvailable(Activity activity) {
		try {
			GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
			int result = googleAPI.isGooglePlayServicesAvailable(activity);
			if(result != ConnectionResult.SUCCESS) {
				if(googleAPI.isUserResolvableError(result)) {
					googleAPI.getErrorDialog(activity, result,
							REQUEST_GOOGLE_PLAY_SERVICES).show();
				}
				return false;
			}

			return true;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
}
