package com.mobgame.api;

import retrofit2.Call;
import retrofit2.Callback;
import android.os.AsyncTask;
import android.text.TextUtils;

import com.mobgame.model.LoginResponse;

public class UpgradeToFacebookTask extends AsyncTask<Void, Void, Void> {
	
	private String token;
	
	private Callback<LoginResponse> callback;

	public UpgradeToFacebookTask(String token) {
		this.token = token;
	}
	
	public UpgradeToFacebookTask(String token, Callback<LoginResponse> callback) {
		this.token = token;
		this.callback = callback;
	}

	public void setCallback(Callback<LoginResponse> callback) {
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
//		Context c = MobGameSDK.getApplicationContext();
		try {
			if (!TextUtils.isEmpty(token)) {
				RestfulApi api = RestfulApi.getInstance();
				Call<LoginResponse> call = api.upgradeToFacebook(token);
				call.enqueue(callback);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}
}