/*
 * Copyright 2012 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mobgame;

import java.util.ArrayList;
import java.util.Calendar;

import org.json.JSONObject;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;

import com.bumptech.glide.Glide;
import com.google.android.gcm.GCMBaseIntentService;
import com.google.android.gcm.GCMRegistrar;
import com.mobgame.api.SaveGCMTask;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.Constants;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.TimeUtils;

/**
 * IntentService responsible for handling GCM messages.
 */
public class MobGameGCMIntentService extends GCMBaseIntentService {


	private static final String TAG = MobGameGCMIntentService.class
			.getSimpleName();
	private static final String GCM_SENDER_ID = "461098885975";

	private static Class<?> mainClass;
	private static Handler registerHandler = new Handler();
	public static int NOTIFICATION_ID = 1110;

	public MobGameGCMIntentService() {
		super(GCM_SENDER_ID);
	}

	protected int getDrawableSmall(Context c) {
		return Res.drawableResource(c, R.drawable.ic_stat_mob);
	}

	@Override
	protected void onRegistered(Context c, String registrationId) {
		Log.i(TAG, "onRegistered:" + registrationId);
		registerToServer(c, registrationId);
	}

	@Override
	protected void onUnregistered(Context context, String regId) {
		Log.i(TAG, "onUnregistered:" + regId);
	}

	@Override
	protected void onError(Context context, String errorId) {
		Log.i(TAG, "onError: " + errorId);
	}

	@Override
	protected boolean onRecoverableError(Context context, String errorId) {
		Log.i(TAG, "onRecoverableError: " + errorId);
		return super.onRecoverableError(context, errorId);
	}

	@Override
	protected void onMessage(Context context, Intent messageIntent) {
		try{
			Log.i(TAG, "onMessage: " + messageIntent);
			Vibrator v = (Vibrator) context
					.getSystemService(Context.VIBRATOR_SERVICE);
			v.vibrate(30); // Vibrate for 30 ms

			Bundle extras = messageIntent.getExtras();
			String title = extras.getString("title");
			String message = extras.getString("message");
			String id = extras.getString("id");
			String url = extras.getString("url");
			String timer = extras.getString("timer");
			String link = extras.getString("link");
//        String openDashboard = extras.getString("open_dashboard");

			if(link!=null){
				Preference.save(context, Constants.DEEPLINK, link);
			}else if(url!=null){
				Preference.save(context, Constants.DEEPLINK, url);
                Preference.save(context, MobGameActivity.KEY_ENABLE_TITLE, false);
			}

			Log.i(TAG, "id: " + id);
			Log.i(TAG, "title: " + title);
			Log.i(TAG, "message: " + message);
			Log.i(TAG, "url: " + url);
			Log.i(TAG, "timer: " + timer);

			//hiendv: load url image to cache first
			if(url!=null){
				Glide.with(context.getApplicationContext())
						.load(url)
						.downloadOnly(512, 256);
			}

			// Send broadcast
			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", "gcm");
			intent.putExtra("id", id);
			intent.putExtra("title", title);
			intent.putExtra("mesage", message);
//        intent.putExtra("open_dashboard", openDashboard.toString());
			if(timer != null || timer == ""){
				Log.d(TAG, "VAO DAY");

				parseTimerData(context, timer, intent);
			}

			LocalBroadcastManager.getInstance(context).sendBroadcast(intent);

			GameConfigManager.getInstance().setHasUnreadNotifications(true);
			if (!TextUtils.isEmpty(id)) {
				NotificationUtils.addNtf(context, Integer.parseInt(id));
			}
			if (!TextUtils.isEmpty(title)
					||	!TextUtils.isEmpty(message)) {
				if(url!=null){
					NotificationUtils.getInstance(context)
							.setMainClass(mainClass)
							.setMessage(message)
							.setTitle(title)
							.setImageUrl(url)
							.setLink(link)
							.setId(id)
							.showNotificationWithImage();
				}else{
					NotificationUtils.getInstance(context)
							.setMainClass(mainClass)
							.setMessage(message)
							.setTitle(title)
							.setLink(link)
							.setId(id)
							.showNotification();
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void parseTimerData(Context context, String timer, Intent intent) {
		if (!TextUtils.isEmpty(timer)) {
			try {
				Log.d(TAG, "Timer : " +  timer);
				JSONObject timerJsonObj = new JSONObject(timer);
				long startTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("start"));
				long endTime = TimeUtils.getMilisecondByTimestamp(timerJsonObj.optLong("end"));
				int id = timerJsonObj.getInt("id");
				final long now = Calendar.getInstance().getTimeInMillis();
				TimerData timerData = FloatButtonTimerHelper
						.getFloatButtonTimerData(context);//chua object arrayList timer
				if(timerData == null){
					Log.d(TAG, "vao null");
					ArrayList<TimerObject> listTimerObject = new ArrayList<>();
					TimerObject timerObject = new TimerObject();
					timerObject.setId(id);
					timerObject.setStartTime(startTime);
					timerObject.setEndTime(endTime);

					listTimerObject.add(timerObject);
					timerData = new TimerData();
					timerData.setListTimerObject(listTimerObject);
					timerData.saveData(context, timerData);
					if(startTime <= now && now < endTime){
						FloatButtonTimerHelper.setcanRunTimer(true);
						FloatButtonTimerHelper.setisRuningTimer(true);
					}
				}else{
					Log.d(TAG, "Vao khong null");
					ArrayList<TimerObject> listTimer = new ArrayList<>();
					listTimer  = timerData.getListTimerObject();

					TimerObject timerObj = new TimerObject();
					timerObj.setId(id);
					timerObj.setStartTime(startTime);
					timerObj.setEndTime(endTime);

					listTimer.add(timerObj);
					timerData.setListTimerObject(listTimer);
					timerData.saveData(context, timerData);

					if(FloatButtonTimerHelper.isRuningTimer() == true){
						FloatButtonTimerHelper.setcanRunTimer(false);
					}else{
						if(startTime <= now && now < endTime){
							FloatButtonTimerHelper.setcanRunTimer(true);
							FloatButtonTimerHelper.setisRuningTimer(true);
						}else{
							FloatButtonTimerHelper.setcanRunTimer(false);
						}
					}
				}
				intent.putExtra("show-timer", true);

			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	static void register(Context context) {
		Log.i(TAG, "register");
		try {
			if (context instanceof Activity) {
				Activity activity = (Activity) context;
				mainClass = activity.getClass();
				Preference.save(context, Constants.SHARED_PREF_MAIN_ACTIVITY,
						mainClass.getName());
				Log.i(TAG, "mainClass:" + mainClass.getName());
			}
			// Make sure the device has the proper dependencies.
			final Context appContext = context.getApplicationContext();
			GCMRegistrar.checkDevice(appContext);
			// Make sure the manifest was properly set - comment out this line
			// while developing the app, then uncomment it when it's ready.
			GCMRegistrar.checkManifest(appContext);

			final String regId = GCMRegistrar.getRegistrationId(appContext);
			Log.i(TAG, "regId:" + regId);
			if (TextUtils.isEmpty(regId)) {
				// Automatically registers application on startup.
				Log.i(TAG, "Automatically registers application on startup");
				GCMRegistrar.register(appContext, GCM_SENDER_ID);
			} else {
				registerToServer(appContext, regId);
			}
		} catch (Exception e) {
			// Exception might occur on devices without GG Play Store
			e.printStackTrace();
		}
	}

	static void destroy(Context context) {
		try{
			if (registerHandler != null) {
				registerHandler.removeCallbacksAndMessages(null);
			}
			GCMRegistrar.onDestroy(context.getApplicationContext());
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private static void registerToServer(Context context, String regId) {
		try {
			Log.i(TAG, "register");
			if (!TextUtils.isEmpty(regId)) {
				(new SaveGCMTask(regId)).execute();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}


}
