/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.mobgame.R;
import java.util.Locale;

public class MobGamePagerTabStrip
extends HorizontalScrollView {
    private static final int[] ATTRS = new int[]{16842901, 16842904};
    private LinearLayout.LayoutParams defaultTabLayoutParams;
    private LinearLayout.LayoutParams expandedTabLayoutParams;
    private final PageListener pageListener = new PageListener();
    private ViewPager.OnPageChangeListener delegatePageListener;
    private LinearLayout tabsContainer;
    private ViewPager pager;
    private int tabCount;
    private int currentPosition = 0;
    private float currentPositionOffset = 0.0f;
    private Paint rectPaint;
    private Paint dividerPaint;
    private int indicatorColor = -10066330;
    private int underlineColor = 0x1A000000;
    private int dividerColor = 0x1A000000;
    private boolean shouldExpand = true;
    private int scrollOffset = 52;
    private int indicatorHeight = 3;
    private int underlineHeight = 1;
    private int dividerPadding = 12;
    private int tabPadding = 24;
    private int dividerWidth = 1;
    private int tabTextSize = 12;
    private int tabTextColor = -10066330;
    private Typeface tabTypeface = null;
    private int tabTypefaceStyle = 1;
    private int lastScrollX = 0;
    private int tabBackgroundResId = R.drawable.background_tab;
    private Locale locale;

    public MobGamePagerTabStrip(Context context) {
        this(context, null);
    }

    public MobGamePagerTabStrip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MobGamePagerTabStrip(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        try {
            this.setFillViewport(true);
            this.setWillNotDraw(false);
            this.tabsContainer = new LinearLayout(context);
            this.tabsContainer.setOrientation(0);
            this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.addView((View)this.tabsContainer);
            DisplayMetrics dm = this.getResources().getDisplayMetrics();
            this.scrollOffset = (int)TypedValue.applyDimension((int)1, (float)this.scrollOffset, (DisplayMetrics)dm);
            this.indicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.indicatorHeight, (DisplayMetrics)dm);
            this.underlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.underlineHeight, (DisplayMetrics)dm);
            this.dividerPadding = (int)TypedValue.applyDimension((int)1, (float)this.dividerPadding, (DisplayMetrics)dm);
            this.tabPadding = (int)TypedValue.applyDimension((int)1, (float)this.tabPadding, (DisplayMetrics)dm);
            this.dividerWidth = (int)TypedValue.applyDimension((int)1, (float)this.dividerWidth, (DisplayMetrics)dm);
            this.tabTextSize = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSize, (DisplayMetrics)dm);
            TypedArray a = context.obtainStyledAttributes(attrs, ATTRS);
            this.tabTextSize = a.getDimensionPixelSize(0, this.tabTextSize);
            this.tabTextColor = a.getColor(1, this.tabTextColor);
            a.recycle();
            a = context.obtainStyledAttributes(attrs, R.styleable.MobGamePagerTabStrip);
            this.indicatorColor = a.getColor(R.styleable.MobGamePagerTabStrip_pstsIndicatorColor, this.indicatorColor);
            this.underlineColor = a.getColor(R.styleable.MobGamePagerTabStrip_pstsUnderlineColor, this.underlineColor);
            this.dividerColor = a.getColor(R.styleable.MobGamePagerTabStrip_pstsDividerColor, this.dividerColor);
            this.indicatorHeight = a.getDimensionPixelSize(R.styleable.MobGamePagerTabStrip_pstsIndicatorHeight, this.indicatorHeight);
            this.underlineHeight = a.getDimensionPixelSize(R.styleable.MobGamePagerTabStrip_pstsUnderlineHeight, this.underlineHeight);
            this.dividerPadding = a.getDimensionPixelSize(R.styleable.MobGamePagerTabStrip_pstsDividerPadding, this.dividerPadding);
            this.tabPadding = a.getDimensionPixelSize(R.styleable.MobGamePagerTabStrip_pstsTabPaddingLeftRight, this.tabPadding);
            this.tabBackgroundResId = a.getResourceId(R.styleable.MobGamePagerTabStrip_pstsTabBackground, this.tabBackgroundResId);
            this.shouldExpand = a.getBoolean(R.styleable.MobGamePagerTabStrip_pstsShouldExpand, this.shouldExpand);
            this.scrollOffset = a.getDimensionPixelSize(R.styleable.MobGamePagerTabStrip_pstsScrollOffset, this.scrollOffset);
            a.recycle();
            this.rectPaint = new Paint();
            this.rectPaint.setAntiAlias(true);
            this.rectPaint.setStyle(Paint.Style.FILL);
            this.dividerPaint = new Paint();
            this.dividerPaint.setAntiAlias(true);
            this.dividerPaint.setStrokeWidth((float)this.dividerWidth);
            this.defaultTabLayoutParams = new LinearLayout.LayoutParams(-2, -1);
            this.expandedTabLayoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
            if (this.locale == null) {
                this.locale = this.getResources().getConfiguration().locale;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setViewPager(ViewPager pager) {
        try {
            this.pager = pager;
            if (pager.getAdapter() == null) {
                throw new IllegalStateException("ViewPager does not have adapter instance.");
            }
            pager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageListener);
            this.notifyDataSetChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.delegatePageListener = listener;
    }

    public void notifyDataSetChanged() {
        try {
            this.tabsContainer.removeAllViews();
            this.tabCount = this.pager.getAdapter().getCount();
            for (int i = 0; i < this.tabCount; ++i) {
                if (this.pager.getAdapter() instanceof IconTabProvider) {
                    this.addIconTab(i, ((IconTabProvider)this.pager.getAdapter()).getPageIconResId(i));
                    continue;
                }
                this.addTextTab(i, this.pager.getAdapter().getPageTitle(i));
            }
            this.updateTabStyles();
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @SuppressLint(value={"NewApi"})
                public void onGlobalLayout() {
                    MobGamePagerTabStrip.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    MobGamePagerTabStrip.this.currentPosition = MobGamePagerTabStrip.this.pager.getCurrentItem();
                    MobGamePagerTabStrip.this.scrollToChild(MobGamePagerTabStrip.this.currentPosition, 0);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTextTab(int position, CharSequence title) {
        try {
            TextView tab = new TextView(this.getContext());
            tab.setText(title);
            tab.setGravity(17);
            tab.setSingleLine();
            this.addTab(position, (View)tab);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addIconTab(int position, int resId) {
        try {
            ImageButton tab = new ImageButton(this.getContext());
            tab.setImageResource(resId);
            this.addTab(position, (View)tab);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTab(final int position, View tab) {
        try {
            tab.setFocusable(true);
            tab.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGamePagerTabStrip.this.pager.setCurrentItem(position);
                }
            });
            tab.setPadding(this.tabPadding, 0, this.tabPadding, 0);
            this.tabsContainer.addView(tab, position, (ViewGroup.LayoutParams)(this.shouldExpand ? this.expandedTabLayoutParams : this.defaultTabLayoutParams));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTabStyles() {
        try {
            for (int i = 0; i < this.tabCount; ++i) {
                View v = this.tabsContainer.getChildAt(i);
                v.setBackgroundResource(this.tabBackgroundResId);
                if (!(v instanceof TextView)) continue;
                TextView tab = (TextView)v;
                tab.setTextSize(0, (float)this.tabTextSize);
                tab.setTypeface(this.tabTypeface, this.tabTypefaceStyle);
                if (i == this.pager.getCurrentItem()) {
                    tab.setTextColor(this.tabTextColor);
                    continue;
                }
                tab.setTextColor(Color.rgb((int)33, (int)33, (int)33));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scrollToChild(int position, int offset) {
        try {
            if (this.tabCount == 0) {
                return;
            }
            int newScrollX = this.tabsContainer.getChildAt(position).getLeft() + offset;
            if (position > 0 || offset > 0) {
                newScrollX -= this.scrollOffset;
            }
            if (newScrollX != this.lastScrollX) {
                this.lastScrollX = newScrollX;
                this.scrollTo(newScrollX, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        try {
            if (this.isInEditMode() || this.tabCount == 0) {
                return;
            }
            int height = this.getHeight();
            this.rectPaint.setColor(this.underlineColor);
            canvas.drawRect(0.0f, (float)(height - this.underlineHeight), (float)this.tabsContainer.getWidth(), (float)height, this.rectPaint);
            this.rectPaint.setColor(this.indicatorColor);
            View currentTab = this.tabsContainer.getChildAt(this.currentPosition);
            float lineLeft = currentTab.getLeft();
            float lineRight = currentTab.getRight();
            if (this.currentPositionOffset > 0.0f && this.currentPosition < this.tabCount - 1) {
                View nextTab = this.tabsContainer.getChildAt(this.currentPosition + 1);
                float nextTabLeft = nextTab.getLeft();
                float nextTabRight = nextTab.getRight();
                lineLeft = this.currentPositionOffset * nextTabLeft + (1.0f - this.currentPositionOffset) * lineLeft;
                lineRight = this.currentPositionOffset * nextTabRight + (1.0f - this.currentPositionOffset) * lineRight;
            }
            canvas.drawRect(lineLeft, (float)(height - this.indicatorHeight), lineRight, (float)height, this.rectPaint);
            this.dividerPaint.setColor(this.dividerColor);
            for (int i = 0; i < this.tabCount - 1; ++i) {
                View tab = this.tabsContainer.getChildAt(i);
                canvas.drawLine((float)tab.getRight(), (float)this.dividerPadding, (float)tab.getRight(), (float)(height - this.dividerPadding), this.dividerPaint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.invalidate();
    }

    public void setIndicatorColorResource(int resId) {
        this.indicatorColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorHeight(int indicatorLineHeightPx) {
        this.indicatorHeight = indicatorLineHeightPx;
        this.invalidate();
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public void setUnderlineColor(int underlineColor) {
        this.underlineColor = underlineColor;
        this.invalidate();
    }

    public void setUnderlineColorResource(int resId) {
        this.underlineColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.invalidate();
    }

    public void setDividerColorResource(int resId) {
        this.dividerColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getDividerColor() {
        return this.dividerColor;
    }

    public void setUnderlineHeight(int underlineHeightPx) {
        this.underlineHeight = underlineHeightPx;
        this.invalidate();
    }

    public int getUnderlineHeight() {
        return this.underlineHeight;
    }

    public void setDividerPadding(int dividerPaddingPx) {
        this.dividerPadding = dividerPaddingPx;
        this.invalidate();
    }

    public int getDividerPadding() {
        return this.dividerPadding;
    }

    public void setScrollOffset(int scrollOffsetPx) {
        this.scrollOffset = scrollOffsetPx;
        this.invalidate();
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setShouldExpand(boolean shouldExpand) {
        this.shouldExpand = shouldExpand;
        this.requestLayout();
    }

    public boolean getShouldExpand() {
        return this.shouldExpand;
    }

    public void setTextSize(int textSizePx) {
        this.tabTextSize = textSizePx;
        this.updateTabStyles();
    }

    public int getTextSize() {
        return this.tabTextSize;
    }

    public void setTextColor(int textColor) {
        this.tabTextColor = textColor;
        this.updateTabStyles();
    }

    public void setTextColorResource(int resId) {
        this.tabTextColor = this.getResources().getColor(resId);
        this.updateTabStyles();
    }

    public int getTextColor() {
        return this.tabTextColor;
    }

    public void setTypeface(Typeface typeface, int style2) {
        this.tabTypeface = typeface;
        this.tabTypefaceStyle = style2;
        this.updateTabStyles();
    }

    public void setTabBackground(int resId) {
        this.tabBackgroundResId = resId;
    }

    public int getTabBackground() {
        return this.tabBackgroundResId;
    }

    public void setTabPaddingLeftRight(int paddingPx) {
        this.tabPadding = paddingPx;
        this.updateTabStyles();
    }

    public int getTabPaddingLeftRight() {
        return this.tabPadding;
    }

    public void onRestoreInstanceState(Parcelable state) {
        try {
            SavedState savedState = (SavedState)state;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.currentPosition = savedState.currentPosition;
            this.requestLayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPosition = this.currentPosition;
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPosition;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPosition = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPosition);
        }
    }

    private class PageListener
    implements ViewPager.OnPageChangeListener {
        private PageListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            try {
                MobGamePagerTabStrip.this.currentPosition = position;
                MobGamePagerTabStrip.this.currentPositionOffset = positionOffset;
                MobGamePagerTabStrip.this.scrollToChild(position, (int)(positionOffset * (float)MobGamePagerTabStrip.this.tabsContainer.getChildAt(position).getWidth()));
                MobGamePagerTabStrip.this.invalidate();
                if (MobGamePagerTabStrip.this.delegatePageListener != null) {
                    MobGamePagerTabStrip.this.delegatePageListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onPageScrollStateChanged(int state) {
            try {
                if (state == 0) {
                    MobGamePagerTabStrip.this.scrollToChild(MobGamePagerTabStrip.this.pager.getCurrentItem(), 0);
                }
                if (MobGamePagerTabStrip.this.delegatePageListener != null) {
                    MobGamePagerTabStrip.this.delegatePageListener.onPageScrollStateChanged(state);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onPageSelected(int position) {
            try {
                for (int i = 0; i < MobGamePagerTabStrip.this.tabCount; ++i) {
                    View v = MobGamePagerTabStrip.this.tabsContainer.getChildAt(i);
                    if (!(v instanceof TextView)) continue;
                    TextView tab = (TextView)v;
                    if (i == MobGamePagerTabStrip.this.pager.getCurrentItem()) {
                        tab.setTextColor(MobGamePagerTabStrip.this.tabTextColor);
                        continue;
                    }
                    tab.setTextColor(Color.rgb((int)33, (int)33, (int)33));
                }
                if (MobGamePagerTabStrip.this.delegatePageListener != null) {
                    MobGamePagerTabStrip.this.delegatePageListener.onPageSelected(position);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface IconTabProvider {
        public int getPageIconResId(int var1);
    }
}

