package com.mobgame;

import android.util.Log;

import com.appsflyer.AppsFlyerLib;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;

/**
 * Created by NamAnh on 8/9/2017.
 */

public class MobInstanceIDService extends InstanceIDListenerService {
    @Override
    public void onTokenRefresh() {

        super.onTokenRefresh();
        try {
        String senderId = getResources().getString(R.string.gcm_sender_id);
        InstanceID instance = InstanceID.getInstance(getApplicationContext());
            String refreshedToken = instance.getToken(senderId, GoogleCloudMessaging.INSTANCE_ID_SCOPE, null);
            Log.d("MobInstanceIdService", "onTokenRefresh: refreashedToken:"+refreshedToken);
            if (refreshedToken != null) {
                AppsFlyerLib.getInstance().updateServerUninstallToken(getApplicationContext(), refreshedToken); // ADD THIS LINE HERE
            }
        } catch (Throwable e) {
            Log.e("MobInstanceIdService", "onTokenRefresh: Couldn't get the refreshed token.", e);
        }
    }
}
