/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.js;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Html;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;
import com.facebook.share.widget.GameRequestDialog;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.api.UploadBitmapTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.utils.Constants;
import com.mobgame.utils.PermissionUtils;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class CmdDashboard {
    private static final String TAG = CmdDashboard.class.getSimpleName();
    private static CmdDashboard INSTANCE;
    private MobGameWebFragment webFragment;
    private HashMap<String, Bitmap> issuePhotos;

    private CmdDashboard() {
    }

    public static CmdDashboard getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdDashboard();
        }
        return INSTANCE;
    }

    public void handleResult(Activity activity, int requestCode, int resultCode, Intent data) {
        try {
            switch (requestCode) {
                case 20002: {
                    Uri selectImageUri = data.getData();
                    Bitmap bitmap = this.getCompressedBitmapFromUri(selectImageUri);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
                    byte[] byteArray = byteArrayOutputStream.toByteArray();
                    String encoded = Base64.encodeToString((byte[])byteArray, (int)0);
                    String key = "img" + Calendar.getInstance().getTimeInMillis();
                    String jsFunction = String.format("getImageData('%s', '%s');", encoded, key);
                    Log.d((String)TAG, (String)("js function: " + jsFunction));
                    this.webFragment.invokeJavascript(jsFunction);
                    if (this.issuePhotos == null) {
                        this.issuePhotos = new HashMap();
                    }
                    this.issuePhotos.put(key, bitmap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobOpenContact(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenContact:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String support_email = obj.getString("support_email");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("mailto:" + support_email)));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobSendSMS(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobSendSMS:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String body = obj.getString("body");
            Intent smsVIntent = new Intent("android.intent.action.VIEW");
            smsVIntent.setType("vnd.android-dir/mms-sms");
            smsVIntent.putExtra("sms_body", body);
            activity.startActivity(smsVIntent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobSendEmail(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobSendEmail:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String subject = obj.getString("subject");
            String body = obj.getString("body");
            Intent email = new Intent("android.intent.action.SEND", Uri.parse((String)"mailto:"));
            email.setType("text/plain");
            email.putExtra("android.intent.extra.EMAIL", "");
            email.putExtra("android.intent.extra.SUBJECT", subject);
            email.putExtra("android.intent.extra.TEXT", (CharSequence)Html.fromHtml((String)body));
            activity.startActivity(Intent.createChooser((Intent)email, (CharSequence)"Choose an email client from..."));
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobAppInvite(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobAppInvite:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            final Activity a = activity;
            final String url = callbackUrl;
            FacebookManager.InviteContent content = new FacebookManager.InviteContent();
            if (obj.has("applinkurl")) {
                content.setApplinkUrl(obj.getString("applinkurl"));
            }
            if (obj.has("previewimageurl")) {
                content.setPreviewImageUrl(obj.getString("previewimageurl"));
            }
            FacebookManager.getInstance().invite(activity, content, new FacebookManager.InviteCallback(){

                @Override
                public void onSuccess(Bundle data) {
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        new PostTask(url, null, false, new PostTask.Callback(){

                            @Override
                            public void onSuccess(String response) {
                                Intent intent = new Intent("com.mobgame.broadcast");
                                intent.putExtra("category", "reload");
                                LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                            }

                            @Override
                            public void onFailure(Throwable e) {
                            }
                        }).execute(new Void[0]);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    Toast.makeText((Context)a, (CharSequence)Res.string((Context)a, R.string.something_went_wrong), (int)1).show();
                }

                @Override
                public void onCancel() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobAppShare(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobAppShare:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            final Activity a = activity;
            final String url = callbackUrl;
            FacebookManager.ShareContent shareContent = new FacebookManager.ShareContent();
            if (obj.has("url")) {
                shareContent.setContentUrl(obj.getString("url"));
            }
            if (obj.has("content_title")) {
                shareContent.setContentTitle(obj.getString("content_title"));
            }
            if (obj.has("content")) {
                shareContent.setContentDescription(obj.getString("content"));
            }
            final boolean hasSocial = isSocial;
            FacebookManager.getInstance().shareLink(activity, shareContent, new FacebookManager.ShareCallback(){

                @Override
                public void onSuccess(String postId) {
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        new PostTask(url, null, false, new PostTask.Callback(){

                            @Override
                            public void onSuccess(String response) {
                                if (!hasSocial) {
                                    Intent intent = new Intent("com.mobgame.broadcast");
                                    intent.putExtra("category", "reload");
                                    LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                                }
                            }

                            @Override
                            public void onFailure(Throwable e) {
                            }
                        }).execute(new Void[0]);
                    }
                }

                @Override
                public void onError(Throwable t) {
                    Toast.makeText((Context)a, (CharSequence)Res.string((Context)a, R.string.something_went_wrong), (int)1).show();
                }

                @Override
                public void onCancel() {
                    Toast.makeText((Context)a, (CharSequence)"Cancel", (int)1).show();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenBrowser(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenBrowser:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String url = obj.getString("url");
            this.mobOpenBrowser(activity, Uri.parse((String)url));
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    private void mobOpenBrowser(Activity activity, Uri uri) {
        Log.i((String)TAG, (String)("mobOpenBrowser:" + uri));
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenFBFanpage(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenFanPage:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String pageid = obj.getString("pageid");
            String callbackUrl = null;
            boolean isSocial = false;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            if (obj.has("isSocial")) {
                isSocial = obj.getBoolean("isSocial");
            }
            try {
                activity.getPackageManager().getPackageInfo("com.facebook.katana", 0);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("fb://page/" + pageid)));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                this.mobOpenBrowser(activity, Uri.parse((String)("https://m.facebook.com/profile.php?id=" + pageid)));
            }
            if (!TextUtils.isEmpty((CharSequence)callbackUrl)) {
                final Activity a = activity;
                if (!Utils.hasDomain(callbackUrl)) {
                    callbackUrl = Constants.BASE_URL_DOMAIN + callbackUrl;
                }
                final boolean hasSocial = isSocial;
                new PostTask(callbackUrl, null, false, new PostTask.Callback(){

                    @Override
                    public void onSuccess(String response) {
                        if (!hasSocial) {
                            Intent intent = new Intent("com.mobgame.broadcast");
                            intent.putExtra("category", "reload");
                            LocalBroadcastManager.getInstance((Context)a).sendBroadcast(intent);
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                    }
                }).execute(new Void[0]);
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenFBGroup(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenGroup:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            String groupid = obj.getString("groupid");
            try {
                activity.getPackageManager().getPackageInfo("com.facebook.katana", 0);
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("fb://group/" + groupid)));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                this.mobOpenBrowser(activity, Uri.parse((String)("https://facebook.com/groups/" + groupid)));
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobOpenModal(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobOpenModal:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "dashboard");
            intent.putExtra("urls", "[{'action':'" + obj.getString("url") + "'}]");
            LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobOpenOfferWall(Activity activity, String params) {
        try {
            Log.i((String)TAG, (String)"mobOpenOfferWall");
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "mobOpenOfferWall");
            LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void mobMakePhoneCall(Activity activity, String params) {
        Log.i((String)TAG, (String)("mobMakePhoneCall:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            Intent intent = new Intent("android.intent.action.DIAL");
            intent.setData(Uri.parse((String)("tel:" + obj.getString("number"))));
            activity.startActivity(intent);
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    void mobCopyToClipboard(Activity activity, String params) {
        try {
            int sdk = Build.VERSION.SDK_INT;
            JSONObject obj = new JSONObject(params);
            String data = obj.getString("data").trim();
            if (sdk < 11) {
                android.text.ClipboardManager clipboard = (android.text.ClipboardManager)activity.getSystemService("clipboard");
                clipboard.setText((CharSequence)data);
            } else {
                ClipboardManager clipboard = (ClipboardManager)activity.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"clipboard", (CharSequence)data);
                clipboard.setPrimaryClip(clip);
            }
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.copied), (int)1).show();
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void mobGetIssue(Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("mobGetIssue:" + params));
        try {
            JSONObject obj = new JSONObject(params);
            long issueId = Long.parseLong(obj.getString("id"));
            if (issueId != 0L) {
                if (this.issuePhotos != null) {
                    for (Map.Entry<String, Bitmap> entry : this.issuePhotos.entrySet()) {
                        String key = entry.getKey();
                        Bitmap bitmap = entry.getValue();
                        new UploadBitmapTask(Constants.URL_UPLOAD_ISSUE_IMAGE + "?id=" + issueId, bitmap).execute(new Void[0]);
                    }
                }
                this.issuePhotos = null;
            }
        }
        catch (Exception e) {
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void deleteImageData(Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("deleteImageData:" + params));
        if (this.issuePhotos == null) {
            return;
        }
        if (this.issuePhotos.isEmpty()) {
            return;
        }
        try {
            JSONObject obj = new JSONObject(params);
            String index = obj.optString("index");
            if (this.issuePhotos.containsKey(index)) {
                this.issuePhotos.remove(index);
            }
            Log.d((String)TAG, (String)("issue photo size:" + this.issuePhotos.size()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)Res.string((Context)activity, R.string.something_went_wrong), (int)1).show();
        }
    }

    public void clearImageData(Activity activity) {
        Log.d((String)TAG, (String)"clearImageData");
        if (this.issuePhotos == null) {
            return;
        }
        if (this.issuePhotos.isEmpty()) {
            return;
        }
        this.issuePhotos.clear();
    }

    public void mobSelectImage(Activity activity, MobGameWebFragment webFragment, String params) {
        try {
            Log.d((String)TAG, (String)("mobSelectImage: " + params));
            if (this.issuePhotos != null && this.issuePhotos.size() > 2) {
                AlertDialog.Builder alert = new AlertDialog.Builder((Context)activity);
                alert.setMessage((CharSequence)activity.getString(R.string.alert_image_validate));
                alert.setNegativeButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                AlertDialog dialog = alert.create();
                dialog.setCancelable(false);
                dialog.show();
                return;
            }
            this.webFragment = webFragment;
            boolean grantedReadStorage = PermissionUtils.hasPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(MobGameSDK.currentActivity, "android.permission.READ_EXTERNAL_STORAGE");
            }
            if (grantedReadStorage) {
                Intent intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                intent.setType("image/*");
                activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Choose photo"), 20002);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Bitmap getCompressedBitmapFromUri(Uri imageUri) {
        Bitmap bitmap = null;
        try {
            String[] projection = new String[]{"_data"};
            Cursor cursor = MobGameSDK.currentActivity.managedQuery(imageUri, projection, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String selectImagePath = cursor.getString(column_index);
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            o.inSampleSize = 6;
            BitmapFactory.decodeFile((String)selectImagePath, (BitmapFactory.Options)o);
            int REQUIRED_SIZE = 75;
            int scale = 1;
            while (o.outWidth / scale / 2 >= 75 && o.outHeight / scale / 2 >= 75) {
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            bitmap = BitmapFactory.decodeFile((String)selectImagePath, (BitmapFactory.Options)o2);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
        }
        return bitmap;
    }

    public void mobChooseFriend(Activity activity, String params) {
        try {
            JSONObject obj = new JSONObject(params);
            String callbackUrl = null;
            if (obj.has("callbackUrl")) {
                callbackUrl = obj.getString("callbackUrl");
            }
            final String url = callbackUrl;
            FacebookManager.InviteGameContent parameter = new FacebookManager.InviteGameContent();
            parameter.setTitle("Invite friend play game");
            parameter.setMessage("Play game with me");
            FacebookManager.getInstance().inviteGameRequest(activity, parameter, new FacebookManager.InviteGameCallback(){

                @Override
                public void onSuccess(GameRequestDialog.Result data) {
                    Log.i((String)TAG, (String)"invite onSuccess");
                    List list = data.getRequestRecipients();
                    HashMap<String, String> maps = new HashMap<String, String>();
                    String str = "";
                    for (int i = 0; i < list.size(); ++i) {
                        str = str + (String)list.get(i) + ",";
                    }
                    Log.d((String)"STR", (String)("str:" + str));
                    String id2 = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                    maps.put("account_id", id2);
                    maps.put("fbid_friends", str);
                    new PostTask(url, maps, true, true, id2, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                        }

                        @Override
                        public void onFailure(Throwable e) {
                        }
                    }).execute(new Void[0]);
                }

                @Override
                public void onError(Throwable t) {
                    Log.i((String)TAG, (String)"invite onError");
                }

                @Override
                public void onCancel() {
                    Log.i((String)TAG, (String)"invite onCancel");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

