/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.float18button;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.Transformation;
import com.mobgame.R;
import com.mobgame.utils.DeviceUtils;

@SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
public class NotiFloatGestureView {
    static final int ANIMAION_TIME_MOVE_TO_EDGE = 200;
    static final int BUTTON_SIZE = 120;
    Activity activity;
    View rootView;
    View floatArea;
    EventListener listener;
    GestureDetector gestureDetector;
    int buttonSize;
    int movableWidth;
    int movableHeight;
    float density;
    long timeTouchDown;
    long timeTouchUp;
    float deltaX;
    float deltaY;
    WindowManager windowManager;
    WindowManager.LayoutParams params;
    private View.OnTouchListener mOnTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            boolean comsumed = true;
            try {
                NotiFloatGestureView.this.gestureDetector.onTouchEvent(event);
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        NotiFloatGestureView.this.timeTouchDown = System.currentTimeMillis();
                        NotiFloatGestureView.this.onTouchDown(event);
                        break;
                    }
                    case 1: {
                        NotiFloatGestureView.this.onTouchUp(event);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 2: {
                        NotiFloatGestureView.this.onTouchMove(event);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return comsumed;
        }
    };
    GestureListener mGestureListener = new GestureListener();

    public NotiFloatGestureView(Activity a) {
        this.activity = a;
        this.density = DeviceUtils.getDensity((Context)a);
        this.movableWidth = DeviceUtils.getScreenWidthInPixels((Context)a);
        this.movableHeight = DeviceUtils.getScreenHeightInPixels((Context)a);
        this.buttonSize = (int)(120.0f * this.density);
        this.gestureDetector = new GestureDetector((Context)a, (GestureDetector.OnGestureListener)new GestureListener());
        this.initView();
        this.attachView();
    }

    public void initView() {
        this.rootView = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_area_noti, null);
        this.floatArea = this.rootView.findViewById(R.id.layout_float_noti);
        this.floatArea.getLayoutParams().width = this.buttonSize;
        this.floatArea.setOnTouchListener(this.mOnTouchListener);
    }

    public void attachView() {
        try {
            this.windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            this.params = new WindowManager.LayoutParams(-2, -2, 2002, 8, -2);
            this.params.gravity = 51;
            this.params.x = 0;
            this.params.y = 0;
            this.windowManager.addView(this.rootView, (ViewGroup.LayoutParams)this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEventListener(EventListener listener) {
        this.listener = listener;
    }

    public void setMovableWidth(int width) {
        this.movableWidth = width;
    }

    public void setMovableHeight(int height) {
        this.movableHeight = height;
    }

    public int getSize() {
        return 120;
    }

    public int getSizeInPixels() {
        return this.buttonSize;
    }

    public int getX() {
        if (this.rootView == null) {
            return 0;
        }
        return this.params.x;
    }

    public int getY() {
        if (this.rootView == null) {
            return 0;
        }
        return this.params.y;
    }

    public void moveTo(int x, int y) {
        this.moveTo(x, y, false);
    }

    public void moveTo(int x, int y, boolean isAnimated) {
        try {
            this.params.x = x;
            this.params.y = y;
            this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onMove(this.params.x, this.params.y);
                this.listener.onTouchUp(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveToEdge(boolean isAnimated) {
        try {
            if (isAnimated) {
                Animation animation = new Animation(){

                    protected void applyTransformation(float interpolatedTime, Transformation t) {
                        super.applyTransformation(interpolatedTime, t);
                        try {
                            float left = NotiFloatGestureView.this.params.x;
                            float right = (float)(NotiFloatGestureView.this.movableWidth - NotiFloatGestureView.this.buttonSize) - left;
                            NotiFloatGestureView.this.params.x = left <= right ? (int)(left - left * interpolatedTime) : (int)(left - (left - (float)NotiFloatGestureView.this.movableWidth) * interpolatedTime);
                            NotiFloatGestureView.this.windowManager.updateViewLayout(NotiFloatGestureView.this.rootView, (ViewGroup.LayoutParams)NotiFloatGestureView.this.params);
                            if (NotiFloatGestureView.this.listener != null) {
                                NotiFloatGestureView.this.listener.onMove(NotiFloatGestureView.this.params.x, NotiFloatGestureView.this.params.y);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                animation.setDuration(200L);
                animation.setInterpolator((Interpolator)new OvershootInterpolator(0.5f));
                this.floatArea.startAnimation(animation);
            } else {
                float left = this.params.x;
                float right = (float)(this.movableWidth - this.buttonSize) - left;
                this.params.x = left <= right ? 0 : this.movableWidth - this.buttonSize;
                this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
                if (this.listener != null) {
                    this.listener.onMove(this.params.x, this.params.y);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchDown(MotionEvent event) {
        try {
            this.deltaX = event.getX();
            this.deltaY = event.getY();
            if (this.listener != null) {
                this.listener.onTouchDown(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchMove(MotionEvent event) {
        try {
            float left = event.getRawX() - this.deltaX;
            float top = event.getRawY() - this.deltaY;
            left = Math.max(0.0f, Math.min((float)this.movableWidth, left));
            top = Math.max(0.0f, Math.min((float)this.movableHeight, top));
            this.params.x = (int)left;
            this.params.y = (int)top;
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)this.params);
            this.windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)this.params);
            if (this.listener != null) {
                this.listener.onTouchMove(event);
                this.listener.onMove(this.params.x, this.params.y);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTouchUp(MotionEvent event) {
        if (this.listener != null) {
            this.listener.onTouchUp(event);
        }
    }

    public void show() {
        try {
            this.rootView.setVisibility(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hide() {
        try {
            if (this.rootView != null) {
                this.rootView.setVisibility(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            this.windowManager.removeView(this.rootView);
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (NotiFloatGestureView.this.listener != null) {
                NotiFloatGestureView.this.listener.onClick(e);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
        }
    }

    static interface EventListener {
        public void onTouchUp(MotionEvent var1);

        public void onTouchDown(MotionEvent var1);

        public void onTouchMove(MotionEvent var1);

        public void onClick(MotionEvent var1);

        public void onMove(int var1, int var2);
    }
}

