/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.component;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import com.google.ads.conversiontracking.AdWordsAutomatedUsageReporter;
import com.mobgame.MobGameSDK;
import com.mobgame.ads.AdsManager;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.model.CharacterInfo;
import com.mobgame.model.Game;
import com.mobgame.model.MobMenu;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Preference;

public final class GameConfigManager {
    private static final String TAG = GameConfigManager.class.getSimpleName();
    public static final String SHARED_PREF_MACCESS_TOKEN = "shared_pref_maccess_token";
    private static GameConfigManager INSTANCE;
    private String appkey;
    private Game gameConfig;
    private UserInfo userInfo;
    private CharacterInfo characterInfo;
    private MobMenu mobMenu;
    private String accessToken;
    private boolean hasUnreadNotifications;
    private String appsflyerId;
    private boolean appsflyerStarted;
    private String appsflyerDevKey;

    public static GameConfigManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GameConfigManager();
        }
        return INSTANCE;
    }

    public String getAppKey() {
        return this.appkey;
    }

    public void setAppKey(String appkey) {
        this.appkey = appkey;
    }

    public boolean isAppsflyerStarted() {
        return this.appsflyerStarted;
    }

    public void setAppsflyerStarted(boolean appsflyerStarted) {
        this.appsflyerStarted = appsflyerStarted;
    }

    public String getAppsflyerDevKey() {
        return this.appsflyerDevKey;
    }

    public void setAppsflyerDevKey(String appsflyerDevKey) {
        this.appsflyerDevKey = appsflyerDevKey;
    }

    public Game getGameConfig() {
        return this.gameConfig;
    }

    public void setGameConfig(Game gameConfig) {
        try {
            this.gameConfig = gameConfig;
            this.initLang(gameConfig.getLang());
            this.initGoogleAuth();
            this.initFacebook(gameConfig.getFacebookId());
            if (!this.appsflyerStarted) {
                this.initAppsFlyer(gameConfig.getAppsflyer());
            } else {
                this.updateAppsFlyerConfig(gameConfig.getAppsflyer());
            }
            this.initGoogleAnalytics(new String[]{gameConfig.getGoogleAnalyticsId(), gameConfig.getGoogleAnalyticsIdTotal(), gameConfig.getGoogleAnalyticsIdLocal()});
            this.initAdwords(gameConfig.getAdwords());
            this.initAds(gameConfig.getAdsConfig());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void clearUserInfo() {
        this.userInfo = null;
    }

    public CharacterInfo getCharacterInfo() {
        if (this.characterInfo == null) {
            this.characterInfo = new CharacterInfo();
        }
        return this.characterInfo;
    }

    public void setCharacterInfo(CharacterInfo characterInfo) {
        this.characterInfo = characterInfo;
    }

    public void clearCharacterInfo() {
        this.characterInfo = null;
    }

    public String getAccessToken() {
        if (this.accessToken == null) {
            this.accessToken = "";
            try {
                Activity a = MobGameSDK.activity;
                this.accessToken = a != null ? Preference.getString((Context)a, SHARED_PREF_MACCESS_TOKEN) : Preference.getString(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        Activity a = MobGameSDK.activity;
        try {
            if (a != null) {
                Preference.save((Context)a, SHARED_PREF_MACCESS_TOKEN, accessToken);
            } else {
                Preference.save(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN, accessToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accessToken = accessToken;
    }

    public String getAppsFlyerId() {
        return this.appsflyerId;
    }

    public void setAppsFlyerId(String appsflyerId) {
        this.appsflyerId = appsflyerId;
    }

    public void clearAccessToken() {
        try {
            Activity a = MobGameSDK.activity;
            if (a != null) {
                Preference.remove((Context)a, SHARED_PREF_MACCESS_TOKEN);
            } else {
                Preference.remove(MobGameSDK.getApplicationContext(), SHARED_PREF_MACCESS_TOKEN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accessToken = null;
    }

    public MobMenu getMobMenu() {
        if (this.mobMenu == null) {
            this.mobMenu = new MobMenu();
        }
        return this.mobMenu;
    }

    public void setMobMenu(MobMenu mobMenu) {
        this.mobMenu = mobMenu;
    }

    public void clearMobMenu() {
        this.mobMenu = null;
    }

    public void clearLogin() {
        this.clearMobMenu();
        this.clearUserInfo();
        this.clearCharacterInfo();
        this.clearAccessToken();
    }

    public boolean isHasUnreadNotifications() {
        return this.hasUnreadNotifications;
    }

    public void setHasUnreadNotifications(boolean hasUnreadNotifications) {
        this.hasUnreadNotifications = hasUnreadNotifications;
    }

    public void clearUnreadNotifications() {
        this.hasUnreadNotifications = false;
    }

    public String getFacebookId() {
        return this.gameConfig.getFacebookId();
    }

    private void initFacebook(String facebookAppId) {
        try {
            Log.i((String)TAG, (String)"initFacebook");
            Activity a = MobGameSDK.activity;
            FacebookManager.getInstance().init(a.getApplicationContext(), facebookAppId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initGoogleAuth() {
        try {
            Activity a = MobGameSDK.activity;
            GoogleAuthManager.getInstance().init(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAppsFlyer(Game.AppsFlyerConfig config) {
        try {
            Log.i((String)TAG, (String)"initAppsFlyer");
            final Activity a = MobGameSDK.activity;
            AppsFlyerLib.getInstance().setCurrencyCode(config.getCurrency());
            AppsFlyerLib.getInstance().startTracking(a.getApplication(), config.getDevKey());
            AppsFlyerLib.getInstance().trackEvent(a.getApplicationContext(), "app_launcher", null);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    EventClientManager.getInstance((Context)a).saveEventClient("normal", "app_launcher", null);
                }
            }).start();
            this.appsflyerId = AppsFlyerLib.getInstance().getAppsFlyerUID((Context)a);
            if (this.appsflyerDevKey.isEmpty()) {
                Log.d((String)TAG, (String)"initAppsFlyer: kh\u00f4ng truy\u1ec1n appsflyer dev key t\u1eeb MobgameSDK");
            } else if (!this.appsflyerDevKey.equalsIgnoreCase(config.getDevKey())) {
                Log.d((String)TAG, (String)"initAppsFlyer: key t\u1eeb config BeforeAuthen kh\u00e1c key t\u1eeb MobgameSDK");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateAppsFlyerConfig(Game.AppsFlyerConfig config) {
        try {
            Log.i((String)TAG, (String)"updateAppsFlyerConfig");
            Activity a = MobGameSDK.activity;
            AppsFlyerLib.getInstance().setCurrencyCode(config.getCurrency());
            this.appsflyerId = AppsFlyerLib.getInstance().getAppsFlyerUID((Context)a);
            if (this.appsflyerDevKey.isEmpty()) {
                Log.d((String)TAG, (String)"updateAppsFlyerConfig: kh\u00f4ng truy\u1ec1n appsflyer dev key t\u1eeb MobgameSDK");
            } else if (!this.appsflyerDevKey.equalsIgnoreCase(config.getDevKey())) {
                Log.d((String)TAG, (String)"updateAppsFlyerConfig: key t\u1eeb config BeforeAuthen kh\u00e1c key t\u1eeb MobgameSDK");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initGoogleAnalytics(String id2) {
        this.initGoogleAnalytics(new String[]{id2});
    }

    private void initGoogleAnalytics(String[] ids) {
        try {
            Activity a = MobGameSDK.activity;
            if (a != null) {
                GoogleAnalyticsManager.getInstance().init(a.getApplicationContext());
            } else {
                GoogleAnalyticsManager.getInstance().init(MobGameSDK.getApplicationContext());
            }
            for (String id2 : ids) {
                GoogleAnalyticsManager.getInstance().addTracker(id2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAdwords(Game.AdwordsConfig config) {
        try {
            Activity a = MobGameSDK.activity;
            String conversionId = config.getConversionId();
            if (a != null) {
                AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting((Context)a.getApplicationContext(), (String)conversionId);
            } else {
                AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting((Context)MobGameSDK.getApplicationContext(), (String)conversionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAds(Game.AdsConfig config) {
        try {
            Activity a = MobGameSDK.activity;
            AdsManager.setApiKey((String)config.getApiKey());
            if (a != null) {
                AdsManager.startTracking((Context)a.getApplicationContext());
            } else {
                AdsManager.startTracking((Context)MobGameSDK.getApplicationContext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initLang(String lang) {
        try {
            if ("vie".equalsIgnoreCase(lang) || "vi".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("vie");
            } else if ("eng".equalsIgnoreCase(lang) || "en".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("eng");
            } else if ("es_es".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("es_es");
            } else if ("zh".equalsIgnoreCase(lang) || "zh_cn".equalsIgnoreCase(lang) || "zh_tw".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("zh_cn");
            } else if ("th".equalsIgnoreCase(lang) || "tha".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("tha");
            } else if ("ind".equalsIgnoreCase(lang) || "id".equalsIgnoreCase(lang)) {
                this.gameConfig.setLang("ind");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

