package com.mobgame.gui.floatbutton;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Stack;

import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TableRow;
import android.widget.TextView;

import com.koushikdutta.urlimageviewhelper.UrlImageViewHelper;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.gui.CountdownChronometer.CountdownListener;
import com.mobgame.model.MobMenu;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;

public class MobGameFloatMenuView {

	private static final String TAG = null;
	//	private static String TAG = MobFloatMenuView.class.getSimpleName();
	private static int MENU_HEIGHT = MobGameFloatGestureView.BUTTON_SIZE;
	Activity activity;
	EventListener eventListener;
	View rootView, layoutMenu , timerView/*, imgBackground*/;
	@SuppressLint("UseSparseArrays")
	HashMap<Integer, ImageView> ntfImageViews = new HashMap<Integer, ImageView>();
	// Screen
	float density;
	float screenHeight;
	private View menuItemCountdownTimer;
	private OnClickOutsideListener clickOutsideListener;

	public MobGameFloatMenuView(Activity a) {
		activity = a;

		density = DeviceUtils.getDensity(a);
		screenHeight = DeviceUtils.getScreenHeightInPixels(a);

		attachView();
		initView();
	}

	public interface OnClickOutsideListener{
		void onClickOutSide();
	}

	public void setClickOutsideListenter(OnClickOutsideListener clickOutsideListener){
		this.clickOutsideListener = clickOutsideListener;
	}

	@SuppressLint("InflateParams")
	public void attachView()
	{
		rootView = LayoutInflater.from(activity).inflate(R.layout.float_menu, null);
		WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
				Activity.WINDOW_SERVICE);
		WindowManager.LayoutParams params = new WindowManager.LayoutParams(
				WindowManager.LayoutParams.MATCH_PARENT,
				WindowManager.LayoutParams.MATCH_PARENT,
				WindowManager.LayoutParams.TYPE_PHONE,
				WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
				PixelFormat.TRANSPARENT);
		params.gravity = Gravity.LEFT | Gravity.TOP;
		windowManager.addView(rootView, params);

	}

	@SuppressLint({ "InflateParams", "ClickableViewAccessibility" })
	public void initView() {
		rootView.setOnTouchListener(new OnTouchListener() {

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				hide();
				MobGameOverlayView.setNtf(true);
				if(clickOutsideListener != null){
					clickOutsideListener.onClickOutSide();
				}

				return true;
			}
		});
		layoutMenu = rootView.findViewById(R.id.layout_menu);
//		imgBackground = rootView.findViewById(R.id.img_background);

		updateMenu();
		hide();
	}

	public void setEventListener(EventListener listener) {
		eventListener = listener;
	}

	public void show(int x, int y, boolean isAnimated) {
		try {
			if (eventListener != null && rootView.getVisibility() != View.VISIBLE) {
				eventListener.onShow();
			}
			rootView.setVisibility(View.VISIBLE);
			WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
					Activity.WINDOW_SERVICE);
			WindowManager.LayoutParams params = (WindowManager.LayoutParams) rootView.getLayoutParams();
//			params.gravity = Gravity.LEFT | Gravity.TOP;
			params.x = MENU_HEIGHT * (int) density;
//			params.y = y;
			windowManager.updateViewLayout(rootView, params);

			int menuY = y + (MENU_HEIGHT * (int) density - layoutMenu.getHeight()) / 2;
			int minY = 0;
			int maxY = (int) (screenHeight - layoutMenu.getHeight());
			int calY = Math.min(maxY, Math.max(minY, menuY));
			if (calY > menuY) {
				menuY = y;
			} else if (calY < menuY) {
				menuY = y + (MENU_HEIGHT * (int) density - layoutMenu.getHeight());
			}
			RelativeLayout.LayoutParams params1 = (LayoutParams) layoutMenu.getLayoutParams();
			params1.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
			params1.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, 0);
			params1.leftMargin = x + 8 * (int) density;
			params1.topMargin = menuY;
			if (isAnimated) {
				layoutMenu.animate()
						.setDuration(400)
						.alpha(100);
			} else {

			}
			updateMenuNtf();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public void showInReverse(int x, int y, boolean isAnimated)
	{
		try {
			if (eventListener != null && rootView.getVisibility() != View.VISIBLE) {
				eventListener.onShow();
			}
			rootView.setVisibility(View.VISIBLE);
			WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
					Activity.WINDOW_SERVICE);
			WindowManager.LayoutParams params = (WindowManager.LayoutParams) rootView.getLayoutParams();
			params.x = 0;
//			params.y = y - 200;
			windowManager.updateViewLayout(rootView, params);

			int menuY = y + (MENU_HEIGHT * (int) density - layoutMenu.getHeight()) / 2;
			int minY = 0;
			int maxY = (int) (screenHeight - layoutMenu.getHeight());
			int calY = Math.min(maxY, Math.max(minY, menuY));
			if (calY > menuY) {
				menuY = y;
			} else if (calY < menuY) {
				menuY = y + (MENU_HEIGHT * (int) density - layoutMenu.getHeight());
			}
			RelativeLayout.LayoutParams params1 = (LayoutParams) layoutMenu.getLayoutParams();
			params1.addRule(RelativeLayout.ALIGN_PARENT_LEFT, 0);
			params1.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
			params1.rightMargin = x + 8 * (int) density;
			params1.topMargin = menuY;
			if (isAnimated) {
				layoutMenu.animate()
						.setDuration(400)
						.alpha(100);
//			    rootView.setAlpha(0);
			} else {

			}
			updateMenuNtf();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public void hide() {
		if (eventListener != null && rootView.getVisibility() == View.VISIBLE) {
			eventListener.onHide();
		}
		rootView.setVisibility(View.INVISIBLE);
//		imgBackground.setAlpha(0);
		layoutMenu.setAlpha(0);
	}

	public void dismiss()
	{
		try {
			rootView.setVisibility(View.GONE);
			WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
					Activity.WINDOW_SERVICE);
			windowManager.removeView(rootView);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@SuppressLint("InflateParams")
	void updateMenu() {
		try {
			((ViewGroup) layoutMenu).removeAllViews();

			/*ArrayList<Integer> ntfIds = Utils.getNtfs(activity);*/

			MobMenu mobMenu = GameConfigManager.getInstance().getMobMenu();
			if(mobMenu == null){
				return;
			}

			ArrayList<MobMenuItem> menuItems = mobMenu.getMenuItems();
			Stack<View> menuStackViews = new Stack<View>();
			for (int i = menuItems.size() - 1; i >= 0; i--) {

				MobMenuItem menuItem = menuItems.get(i);

				if (menuItem.shouldShowHorizontal()) {

					// Attach to horizontal menu
					View v = LayoutInflater.from(activity).inflate(R.layout.float_menu_item, null);
					TextView tv = (TextView) v.findViewById(R.id.title);
					ImageView imv = (ImageView) v.findViewById(R.id.image);
					ImageView imvNoti = (ImageView) v.findViewById(R.id.img_notification);
					timerView = v.findViewById(R.id.countdown_timer_layout);

					/*boolean hasNotification = false;*/
					if (menuItem.isTab()) {
						/*JSONArray menuActions = new JSONArray(menuItem.getAction());
						for (int j = 0; j < menuActions.length(); j++) {
							JSONObject subMenuJSON = menuActions.getJSONObject(j);
							ntfImageViews.put(subMenuJSON.getInt("id"), imvNoti);
						}*/
						for (int subId : menuItem.getSubMenuIds()) {
							ntfImageViews.put(subId, imvNoti);
						}
						ntfImageViews.put(menuItem.getId(), imvNoti);
					} else {
						/*if (ntfIds.contains(menuItemJSON.getInt("id"))) {
							hasNotification = true;
						}*/
						ntfImageViews.put(menuItem.getId(), imvNoti);
					}
					Log.d("acb", "go here!");
					String lableHorizontal = menuItem.getLabelHorizontal();
					tv.setText(lableHorizontal);
					tv.setTextSize(TypedValue.COMPLEX_UNIT_SP, 11);
//					Glide.with(activity)
//					    .load(menuItem.getIconUrlHorizontal())
//					    .into(imv);
					UrlImageViewHelper.setUrlDrawable(imv, menuItem.getIconUrlHorizontal());
					Log.d(TAG, "FloatButtonTimerHelper.isRuningTimer():" + FloatButtonTimerHelper.isRuningTimer());
					if(FloatButtonTimerHelper.isRuningTimer()){
						if(i <= 4){
							timerView.setVisibility(View.VISIBLE);
						}else{
							timerView.setVisibility(View.GONE);
						}
					}else{
						timerView.setVisibility(View.GONE);
					}

					final MobMenuItem fMenuItem = menuItem;
					v.setOnClickListener(new OnClickListener() {

						@Override
						public void onClick(View v)
						{
							if (eventListener != null) {
								eventListener.onClick(v, fMenuItem);
							}
						}
					});

					/*if (hasNotification) {
						imvNoti.setVisibility(View.VISIBLE);
					}*/

					if("tin tức".equalsIgnoreCase(lableHorizontal)){
						menuItemCountdownTimer = v;
					}

					menuStackViews.push(v);
				}
			}


			int itemsPerRow = 4;
//			if (views.size() > 4) {
//				itemsPerRow = views.size() / 2 + views.size() % 2;
//			}
			while (!menuStackViews.isEmpty()) {
				TableRow tblrow = new TableRow(activity);
//				tblrow.setMinimumHeight(views.get(0).getHeight());
				tblrow.setGravity(Gravity.CENTER_VERTICAL);
				for (int j = 0; !menuStackViews.isEmpty() && j < itemsPerRow; j++) {
					tblrow.addView(menuStackViews.pop());
				}
				((ViewGroup) layoutMenu).addView(tblrow);
			}
			updateMenuNtf();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void updateMenuNtf() {
		if (ntfImageViews == null) return;
		ArrayList<ImageView> imvs = new ArrayList<ImageView>(ntfImageViews.values());
		for (int i = 0; i < imvs.size(); i++) {
			ImageView imageView = imvs.get(i);
			if(imageView != null){
				imageView.setVisibility(View.GONE);
			}
			if (FloatButtonTimerHelper.isRuningTimer()) {
				if (i < 4) {
					timerView.setVisibility(View.VISIBLE);
				} else {
					timerView.setVisibility(View.GONE);
				}
			} else {
				timerView.setVisibility(View.GONE);
			}
		}

		ArrayList<Integer> ntfs = NotificationUtils.getNtfs(activity);
		if (ntfs == null) return;
		for (int i = 0; i < ntfs.size(); i++) {
			Log.d(TAG, "ntfs size:" +  ntfs.size());
			Log.d(TAG, "ntfs value:" +  ntfs.get(i));
			ImageView imageView = ntfImageViews.get(ntfs.get(i));
			if(imageView != null /*&& !FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)*/){
				imageView.setVisibility(View.VISIBLE);
			}
			if(FloatButtonTimerHelper.isRuningTimer()
					&& (ntfs.get(i) == 2 || ntfs.get(i) == 3) ){
				imageView.setVisibility(View.GONE);
			}
//			if (FloatButtonTimerHelper.isRuningTimer()) {
//				if (i < 4) {
//					timerView.setVisibility(View.VISIBLE);
//				} else {
//					timerView.setVisibility(View.GONE);
//				}
//			} else {
//				timerView.setVisibility(View.GONE);
//			}
		}
	}

	public void updateCountdownTimer(long countDownRunningTime){
		Log.d(TAG, "updateCountdownTimer: " + countDownRunningTime);
		try {

			if(menuItemCountdownTimer == null){
				return;
			}

			final CountdownChronometer countDownTimer = (CountdownChronometer) menuItemCountdownTimer.findViewById(R.id.countdown_timer);
			countDownTimer.setCountdownListener(new CountdownListener() {

				@Override
				public void done() {
					if(countDownTimer != null){
						countDownTimer.setVisibility(View.GONE);
						timerView.setVisibility(View.GONE);
					}
				}
			});

			if(countDownRunningTime / 1000 <= 0){
				countDownTimer.setVisibility(View.GONE);
				timerView.setVisibility(View.GONE);
				return;
			}
			int countTime = (int) (countDownRunningTime /1000);
			ValueAnimator anim = new ValueAnimator();

			anim.setIntValues(Color.parseColor("#ee4242"), Color.parseColor("#ad2020"));
			anim.setEvaluator(new ArgbEvaluator());
			anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
				@Override
				public void onAnimationUpdate(ValueAnimator valueAnimator) {
					countDownTimer.setBackgroundColor((Integer)valueAnimator.getAnimatedValue());
				}
			});
			anim.setRepeatCount(countTime);
			anim.setDuration(1000);
			anim.start();
			timerView.setVisibility(View.VISIBLE);
			countDownTimer.setVisibility(View.VISIBLE);
			countDownTimer.setBase(Calendar.getInstance().getTimeInMillis() + countDownRunningTime);
			countDownTimer.start();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}
	public void refreshFloatMenu(){
		updateMenu();
	}
	interface EventListener {
		public void onClick(View v, MobMenuItem menuItem);
		public void onShow();
		public void onHide();
	}
}
