package com.mobgame.gui;

import android.animation.Animator;
import android.animation.Animator.AnimatorListener;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v13.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager.OnPageChangeListener;
import android.support.v4.view.ViewPager.SimpleOnPageChangeListener;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;

import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.Game;
import com.mobgame.utils.Constants;

public class MobGamePagerFragment extends Fragment {

	private Activity activity;
	private View layoutMain;
	private MobGameViewPager viewPager;
	private MobGamePagerTabStrip tabs;
	private FragmentPagerAdapter adapter;
	private MobGameWebFragment.EventListener mWebEventListener;
	private OnPageChangeListener mOnPageChangeListener;
	private int selectedIndex;
	
	public MobGamePagerFragment() {}
	@SuppressLint("ValidFragment")
	public MobGamePagerFragment(Activity activity) {
		this.activity = activity;
	}

	public static final MobGamePagerFragment newInstance(Activity activity){
		MobGamePagerFragment mobGamePagerFragment = new MobGamePagerFragment(activity);
		return mobGamePagerFragment;
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = inflater.inflate(R.layout.fragment_pager, container, false);
		layoutMain = view.findViewById(R.id.layout_main);
		viewPager = (MobGameViewPager) view.findViewById(R.id.pager);
		tabs = (MobGamePagerTabStrip) view.findViewById(R.id.pager_title_strip);
		
		Game gameConfigs = GameConfigManager.getInstance().getGameConfig();
		
		String lang = Constants.LANG_EN;
		if(gameConfigs != null){
			lang = gameConfigs.getLang();
		}
		
		if (Constants.LANG_VI.equalsIgnoreCase(lang)) {
			tabs.setIndicatorColor(Color.rgb(241, 67, 8));
			tabs.setTextColor(Color.rgb(241, 67, 8));
		} else {
			tabs.setIndicatorColor(Color.rgb(194, 39, 45));
			tabs.setTextColor(Color.rgb(194, 39, 45));
		}
		
		if (adapter != null) {
			setAdapter(adapter);
		}
		if (mOnPageChangeListener != null) {
			viewPager.addOnPageChangeListener(mOnPageChangeListener);
		}

		return view;
	}
	
	public void setAdapter(FragmentPagerAdapter adapter) {
		setAdapter(adapter, this.selectedIndex);
	}
	
	public void setAdapter(FragmentPagerAdapter adapter, final int selectedIndex) {
		if (viewPager != null && tabs != null) {
			viewPager.setAdapter(null); // IMPORTANT !!!
			viewPager.setAdapter(adapter);
//			adapter.notifyDataSetChanged();
			tabs.setViewPager(viewPager);
			if (adapter.getCount() <= 1
				&& this.adapter.getCount() > 1) {
				hideTabs(false);
			} else if (adapter.getCount() > 1
				&& this.adapter.getCount() <= 1) {
				showTabs(false);
			}

			for (int i = 0; i < adapter.getCount(); i++) {
				Fragment frag = adapter.getItem(i);
				if (frag instanceof MobGameWebFragment) {
					((MobGameWebFragment) frag).setWebViewTag(i + "");
					if (mWebEventListener != null) {
						((MobGameWebFragment) frag).setEventListener(mWebEventListener);
					}
				}
			}
			viewPager.setCurrentItem(selectedIndex, false);
			if (mOnPageChangeListener != null) {
				mOnPageChangeListener.onPageSelected(selectedIndex);
			}
		}
		this.adapter = adapter;
		this.selectedIndex = selectedIndex;  
	}
	
	public void notifyTabsChanged() {
		if (tabs != null) {
			tabs.notifyDataSetChanged();
		}
	}

	public void setWebEventListener(MobGameWebFragment.EventListener eventListener) {
		this.mWebEventListener = eventListener;
		if (adapter != null) {
			for (int i = 0; i < adapter.getCount(); i++) {
				Fragment frag = adapter.getItem(i);
				if (frag instanceof MobGameWebFragment) {
					((MobGameWebFragment) frag).setEventListener(mWebEventListener);
				}
			}
		}
	}

	public void addOnPageChangeListener(SimpleOnPageChangeListener onPageChangeListener) {
		if (viewPager != null) {
			viewPager.addOnPageChangeListener(onPageChangeListener);
		}
		this.mOnPageChangeListener = onPageChangeListener;
	}
	
	public int countTabs() {
		return adapter.getCount();
	}
	
	public void showTabs(boolean isAnimated) {
		viewPager.setPagingEnabled(true);
		tabs.setVisibility(View.VISIBLE);
		if (isAnimated) {
			tabs.animate()
				.setDuration(250)
				.y(0);
			viewPager.animate()
				.setDuration(250)
				.y(tabs.getHeight())
				.setListener(mAnimatorListener);
		} else {
			tabs.setY(0);
			viewPager.setY(tabs.getHeight());
			((ViewGroup) layoutMain).updateViewLayout(
					viewPager, 
					new RelativeLayout.LayoutParams(
						LayoutParams.MATCH_PARENT, 
						layoutMain.getHeight() - tabs.getHeight()
					)
				);
		}
	}

	public void hideTabs(boolean isAnimated) {
		if (viewPager == null) return;
		viewPager.setPagingEnabled(false);
		if (isAnimated) {
			tabs.animate()
				.setDuration(250)
				.y(-tabs.getHeight());
			viewPager.animate()
				.setDuration(250)
				.y(0)
				.setListener(mAnimatorListener);
		} else {
			tabs.setY(-tabs.getHeight());
			viewPager.setY(0);
			((ViewGroup) layoutMain).updateViewLayout(
					viewPager, 
					new RelativeLayout.LayoutParams(
						LayoutParams.MATCH_PARENT, 
						layoutMain.getHeight()
					)
				);
		}
	}
	
	public void updateTabs() {
		((ViewGroup) layoutMain).updateViewLayout(
				viewPager, 
				new RelativeLayout.LayoutParams(
					LayoutParams.MATCH_PARENT, 
					layoutMain.getHeight() - tabs.getHeight() - (int) tabs.getY()
				)
			);
	}

	private AnimatorListener mAnimatorListener = new AnimatorListener() {

		@Override
		public void onAnimationStart(Animator animator) {
			activity.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					((ViewGroup) layoutMain).updateViewLayout(
							viewPager, 
							new RelativeLayout.LayoutParams(
								LayoutParams.MATCH_PARENT, 
								layoutMain.getHeight()
							)
						);
				}
			});
		}

		@Override
		public void onAnimationRepeat(Animator animator) {}
		
		@Override
		public void onAnimationEnd(Animator animator) {
			activity.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					updateTabs();
				}
			});
		}

		@Override
		public void onAnimationCancel(Animator animator) {}
	};

}
