package com.mobgame.component;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentSender.SendIntentException;
import android.os.Bundle;
import android.util.Log;

import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.GoogleApiClient.ConnectionCallbacks;
import com.google.android.gms.common.api.GoogleApiClient.OnConnectionFailedListener;
import com.mobgame.MobGameSDK;
import com.mobgame.utils.Constants;

public final class GoogleAuthManager {

	private final static String TAG = GoogleAuthManager.class.getSimpleName();
	private static GoogleAuthManager INSTANCE;
	
	private GoogleApiClient mGoogleApiClient;
	private boolean mResolvingError = false;
	
	public static GoogleAuthManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new GoogleAuthManager();
		}
		return INSTANCE;
	}
	
	private GoogleAuthManager() {}
	
	void init(Activity activity) {
		GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
			.requestEmail()
		    .build();
		
		mGoogleApiClient = new GoogleApiClient.Builder(activity)
	        .addConnectionCallbacks(mConnectionCallbacks)
	        .addOnConnectionFailedListener(mOnConnectionFailedListener)
	        .addApi(Auth.GOOGLE_SIGN_IN_API, gso)
	        .build();
	}
	
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (requestCode == 123) {
	        mResolvingError = false;
	        if (resultCode == 0) {
	            // Make sure the app is not already connected or attempting to connect
	            if (!mGoogleApiClient.isConnecting() && !mGoogleApiClient.isConnected()) {
	                mGoogleApiClient.connect();
	            }
	        }
	    }
		if (requestCode == Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES) {
	        GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
	        if (result.isSuccess()) {
	            // Signed in successfully, show authenticated UI.
//	            GoogleSignInAccount acc = result.getSignInAccount();
	        } else {
	            // Signed out, show unauthenticated UI.
	        }
	    }

	}
	
	public void login(Activity activity) {
		Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(mGoogleApiClient);
		activity.startActivityForResult(signInIntent, Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES);
	}
	
	public void logout() {
		if (mGoogleApiClient != null && mGoogleApiClient.isConnected()) {
	        mGoogleApiClient.disconnect();
	    }
	}
	
	private ConnectionCallbacks mConnectionCallbacks = new ConnectionCallbacks() {
		
		@Override
		public void onConnected(Bundle bundle) {
//			Log.i(TAG, "onConnected:" + bundle + "; " + Plus.AccountApi.getAccountName(mGoogleApiClient));
			try {
			    
			} catch (Exception e) {
				e.printStackTrace();
		        mGoogleApiClient.disconnect();
			}
		}

		@Override
		public void onConnectionSuspended(int arg0) {
		}

	};
	
	private OnConnectionFailedListener mOnConnectionFailedListener = new OnConnectionFailedListener() {

		@Override
		public void onConnectionFailed(ConnectionResult result) {
			Log.i(TAG, "onConnectionFailed:" + result);
			 if (mResolvingError) {
	            // Already attempting to resolve an error.
	            return;
	        } else if (result.hasResolution()) {
	            try {
	                mResolvingError = true;
	                result.startResolutionForResult(MobGameSDK.activity, 123);
	            } catch (SendIntentException e) {
	                // There was an error with the resolution intent. Try again.
	                mGoogleApiClient.connect();
	            }
	        } else {
	            // Show dialog using GoogleApiAvailability.getErrorDialog()
//	            showErrorDialog(result.getErrorCode());
	            mResolvingError = true;
	        }

		}
	};
	
}
