package com.mobgame;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.res.Configuration;
import android.hardware.SensorManager;
import android.net.Uri;
import android.util.Log;
import android.view.OrientationEventListener;

import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.Utils;

class MobGameHelper {

	private static Activity activity = MobGameSDK.activity;
	
	private static MobGameOverlayView floatButton;
	private static boolean didShowPermissionDialog = false;
	
	static void initFloatButton() {
		if (checkDrawOverApps()) {
			if (floatButton != null) {
				floatButton.dismiss();
			}
			floatButton = new MobGameOverlayView(activity);
		}
	}
	
	static void initFloatButtonIfNeeded() {
		if (checkDrawOverApps()) {
			if (floatButton == null) {
				floatButton = new MobGameOverlayView(activity);
			}
		}
	}

	static void showFloatButton() {
		if (checkDrawOverApps()) {
			activity.runOnUiThread(new Runnable() {

				@Override
				public void run() {
					initFloatButtonIfNeeded();
					if (!floatButton.isShowing()
							&&	!floatButton.isShowingConfirmDialog()) {
						if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
							startFloatButtonTimer();
						}
						floatButton.show(FloatButtonTimerHelper.isRuningTimer());
					}
					if(floatButton.isShowing()
							&& !floatButton.isShowingConfirmDialog()){
						if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
							startFloatButtonTimer();
							floatButton.show(FloatButtonTimerHelper.isRuningTimer());
						}
					}
				}
			});
		}
	}

	static void hideFloatButton() {
		if (floatButton != null) {
			activity.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					if (floatButton != null) {
						floatButton.hide();
					}
				}
			});
		}
	}
	
	static void notifyFloatButton() {
		
		if (floatButton != null) {
			floatButton.viberate();
		}
	}

	static void showTimer(){
		if(floatButton == null){
			return;
		}
		if(FloatButtonTimerHelper.canRunTimer()){
			floatButton.startTimer();
		}
	}

	static void updateFloatButtonMenu() {
		if (floatButton != null) {
			floatButton.updateMenu();
		}
	}

	static void dismissFloatButton() {
		activity.runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				if (floatButton != null) {
					floatButton.dismiss();
					floatButton = null;
				}
			}
		});
	}

	private static boolean checkDrawOverApps() {
		Log.e("TAG" , "canDrawOverApp : " + !Utils.canDrawOverApp(activity));
		if (!Utils.canDrawOverApp(activity)) {
			if (!didShowPermissionDialog) {
				new AlertDialog.Builder(Utils.getContextThemeWrapper(activity))
					.setTitle("Warning")
					.setCancelable(false)
					.setMessage("We need permission to bring you our best features")
					.setPositiveButton(android.R.string.ok, new OnClickListener() {
						public void onClick(DialogInterface dialog, int which) {
							Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse("package:"
									+ activity.getPackageName()));
							activity.startActivityForResult(intent, 1234);
							dialog.dismiss();
						}
					})
					.show();
				didShowPermissionDialog = true;
			}
			return false;
		}else{

		}
		return true;
	}
	static void startFloatButtonTimer(){
		if(floatButton == null){
			return;
		}
		Log.d("TAG", "fuck");
		floatButton.startTimer();
	}

}
