/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.HashMap;
import java.util.Set;

public final class Preference {
    private static final String PREFERENCE_NAME = "sp_mobgame";

    public static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(PREFERENCE_NAME, 0);
    }

    public static boolean save(Context context, String key, String value) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    public static String getString(Context context, String key) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        return sharedPreferences.getString(key, "");
    }

    public static boolean save(Context context, HashMap<String, String> valuesMap) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        String value = "";
        for (String key : valuesMap.keySet()) {
            value = valuesMap.get(key);
            editor.putString(key, value);
        }
        return editor.commit();
    }

    public static boolean save(Context context, String key, boolean value) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(key, value);
        return editor.commit();
    }

    public static boolean getBoolean(Context context, String key, boolean defaultValue) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        return sharedPreferences.getBoolean(key, defaultValue);
    }

    public static void clear(Context context) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    public static void remove(Context context, String key) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(key);
        editor.commit();
    }

    public static boolean save(Context context, String key, int value) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        return editor.commit();
    }

    public static boolean save(Context context, String key, long value) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(key, value);
        return editor.commit();
    }

    public static int getInt(Context context, String key, int defaultValue) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        return sharedPreferences.getInt(key, defaultValue);
    }

    public static long getLong(Context context, String key, long defaultValue) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        return sharedPreferences.getLong(key, defaultValue);
    }

    public static boolean save(Context context, String key, float value) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putFloat(key, value);
        return editor.commit();
    }

    public static float getFloat(Context context, String key, float defaultValue) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        return sharedPreferences.getFloat(key, defaultValue);
    }

    public static boolean save(Context context, String key, Set<String> value) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putStringSet(key, value);
        return editor.commit();
    }

    public static Set<String> getStringSet(Context context, String key, Set<String> defaultValue) {
        SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
        return sharedPreferences.getStringSet(key, defaultValue);
    }
}

