/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RestfulApi;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.MobMenu;
import com.mobgame.model.TimerData;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetInfoAfterAuthenTask
extends AsyncTask<Void, Void, Void> {
    private Listener callback;

    public GetInfoAfterAuthenTask(Listener callback) {
        this.callback = callback;
    }

    protected Void doInBackground(Void ... params) {
        Context c = MobGameSDK.getApplicationContext();
        String sign = EncryptionUtils.getSignedString(c);
        RestfulApi api = RestfulApi.getInstance();
        Call<EncodedResponse> call = api.getInfoAfterAuthen(sign);
        call.enqueue((Callback)new Callback<EncodedResponse>(){

            public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
                Context c = MobGameSDK.getApplicationContext();
                UserInfo userInfo = null;
                Log.d((String)"TAG", (String)("code : " + response.code()));
                if (response.code() == 200 && response.body() != null) {
                    block18: {
                        String responseBody = ((EncodedResponse)response.body()).getDecodedData();
                        try {
                            String saveLogin;
                            JSONObject json = new JSONObject(responseBody);
                            if (json.has("saveLogin") && ((saveLogin = json.getString("saveLogin")).equals("true") || saveLogin.equals("1"))) {
                                boolean enableTimer;
                                if (json.has("userInfo")) {
                                    String userInfoStr = json.getString("userInfo");
                                    userInfo = UserInfo.parse(userInfoStr);
                                }
                                if (json.has("ntf")) {
                                    String ntf = json.getString("ntf");
                                    JSONArray ntfs = new JSONArray(ntf);
                                    for (int i = 0; i < ntfs.length(); ++i) {
                                        JSONObject ntfObj = ntfs.getJSONObject(i);
                                        if (!ntfObj.has("id") || !ntfObj.has("noti") || !ntfObj.getBoolean("noti")) continue;
                                        NotificationUtils.addNtf(c, ntfObj.getInt("id"));
                                        GameConfigManager.getInstance().setHasUnreadNotifications(true);
                                    }
                                } else {
                                    GameConfigManager.getInstance().setHasUnreadNotifications(false);
                                }
                                if (json.has("menu")) {
                                    String menu = json.getString("menu");
                                    MobMenu mobMenu = MobMenu.parse(menu);
                                    GameConfigManager.getInstance().setMobMenu(mobMenu);
                                } else {
                                    GameConfigManager.getInstance().clearMobMenu();
                                }
                                if (json.has("enable_dashboard")) {
                                    boolean value = json.getBoolean("enable_dashboard");
                                    Preference.save(c, "shared_pref_db_enabled", value);
                                } else {
                                    Preference.remove(c, "shared_pref_db_enabled");
                                }
                                if (json.has("show_ads")) {
                                    boolean showAds = json.getInt("show_ads") != 0;
                                    Preference.save(c, "shared_pref_show_ads", showAds);
                                } else {
                                    Preference.remove(c, "shared_pref_show_ads");
                                }
                                if (json.has("enable_timer") && (enableTimer = json.optBoolean("enable_timer"))) {
                                    TimerData timerData = TimerData.parse(json.optJSONArray("timer"));
                                    userInfo.setTimerData(timerData);
                                    userInfo.setEnableTimer(enableTimer);
                                }
                            }
                        }
                        catch (JSONException e) {
                            if (GetInfoAfterAuthenTask.this.callback == null) break block18;
                            GetInfoAfterAuthenTask.this.callback.onFailure(e);
                        }
                    }
                    if (GetInfoAfterAuthenTask.this.callback != null) {
                        GetInfoAfterAuthenTask.this.callback.onSuccess(userInfo);
                    }
                } else if (GetInfoAfterAuthenTask.this.callback != null) {
                    Log.d((String)"TAG", (String)("ERROR when " + response.code()));
                    GetInfoAfterAuthenTask.this.callback.onFailure(new Exception());
                }
            }

            public void onFailure(Call<EncodedResponse> call, Throwable t) {
                if (GetInfoAfterAuthenTask.this.callback != null) {
                    GetInfoAfterAuthenTask.this.callback.onFailure(t);
                }
            }
        });
        return null;
    }

    public static interface Listener {
        public void onSuccess(UserInfo var1);

        public void onFailure(Throwable var1);
    }
}

