/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.mobgame.MobGameSDK;
import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.Utils;

class MobGameHelper {
    private static Activity activity = MobGameSDK.activity;
    private static MobGameOverlayView floatButton;
    private static boolean didShowPermissionDialog;

    MobGameHelper() {
    }

    static void initFloatButton() {
        if (MobGameHelper.checkDrawOverApps()) {
            if (floatButton != null) {
                floatButton.dismiss();
            }
            floatButton = new MobGameOverlayView(activity);
        }
    }

    static void initFloatButtonIfNeeded() {
        if (MobGameHelper.checkDrawOverApps() && floatButton == null) {
            floatButton = new MobGameOverlayView(activity);
        }
    }

    static void showFloatButton() {
        if (MobGameHelper.checkDrawOverApps()) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MobGameHelper.initFloatButtonIfNeeded();
                    if (!floatButton.isShowing() && !floatButton.isShowingConfirmDialog()) {
                        if (FloatButtonTimerHelper.isEnableFloatButtonTimer((Context)activity)) {
                            MobGameHelper.startFloatButtonTimer();
                        }
                        floatButton.show(FloatButtonTimerHelper.isRuningTimer());
                    }
                    if (floatButton.isShowing() && !floatButton.isShowingConfirmDialog() && FloatButtonTimerHelper.isEnableFloatButtonTimer((Context)activity)) {
                        MobGameHelper.startFloatButtonTimer();
                        floatButton.show(FloatButtonTimerHelper.isRuningTimer());
                    }
                }
            });
        }
    }

    static void hideFloatButton() {
        if (floatButton != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (floatButton != null) {
                        floatButton.hide();
                    }
                }
            });
        }
    }

    static void notifyFloatButton() {
        if (floatButton != null) {
            floatButton.viberate();
        }
    }

    static void showTimer() {
        if (floatButton == null) {
            return;
        }
        if (FloatButtonTimerHelper.canRunTimer()) {
            floatButton.startTimer();
        }
    }

    static void updateFloatButtonMenu() {
        if (floatButton != null) {
            floatButton.updateMenu();
        }
    }

    static void dismissFloatButton() {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (floatButton != null) {
                    floatButton.dismiss();
                    floatButton = null;
                }
            }
        });
    }

    private static boolean checkDrawOverApps() {
        Log.e((String)"TAG", (String)("canDrawOverApp : " + !Utils.canDrawOverApp((Context)activity)));
        if (!Utils.canDrawOverApp((Context)activity)) {
            if (!didShowPermissionDialog) {
                new AlertDialog.Builder((Context)Utils.getContextThemeWrapper((Context)activity)).setTitle((CharSequence)"Warning").setCancelable(false).setMessage((CharSequence)"We need permission to bring you our best features").setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + activity.getPackageName())));
                        activity.startActivityForResult(intent, 1234);
                        dialog.dismiss();
                    }
                }).show();
                didShowPermissionDialog = true;
            }
            return false;
        }
        return true;
    }

    static void startFloatButtonTimer() {
        if (floatButton == null) {
            return;
        }
        Log.d((String)"TAG", (String)"fuck");
        floatButton.startTimer();
    }

    static {
        didShowPermissionDialog = false;
    }
}

