/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.mobgame.R;
import com.mobgame.ads.utils.DeviceUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;

public class NotificationUtils {
    private static String TAG = "NotificationUtils";
    private Class mainClass;
    private Context context;
    private String title;
    private String message;
    private String imageUrl;
    private String id;
    private String link;
    private int smallIcon;
    private static NotificationUtils instance;

    public void showNotificationGif() {
    }

    public void updateNotificationGif() {
    }

    public void showNotification() {
        String name = "channel";
        String description = "channel des";
        Log.i((String)TAG, (String)("showNotification:title=" + this.title + ";msg=" + this.message));
        try {
            Log.i((String)TAG, (String)("mainClass:" + this.mainClass));
            if (this.mainClass == null) {
                try {
                    String className = Preference.getString(this.context, "shared_pref_main_activity");
                    this.mainClass = Class.forName(className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            Drawable ico = this.context.getApplicationInfo().loadIcon(this.context.getPackageManager());
            Bitmap bitmap = Utils.drawableToBitmap(ico);
            int bitmapSize = (int)Math.min(64.0f * DeviceUtils.getDensity((Context)this.context), (float)bitmap.getWidth());
            CharSequence appTitle = this.context.getApplicationInfo().loadLabel(this.context.getPackageManager());
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.setBigContentTitle((CharSequence)this.title);
            bigTextStyle.bigText((CharSequence)this.message);
            bigTextStyle.setSummaryText(appTitle);
            NotificationManager mNotificationManager = (NotificationManager)this.context.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int importance = 4;
                NotificationChannel mChannel = mNotificationManager.getNotificationChannel(this.id);
                if (mChannel == null) {
                    mChannel = new NotificationChannel(this.id, (CharSequence)name, importance);
                    mChannel.setDescription(description);
                    mChannel.enableVibration(true);
                    mChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                    mNotificationManager.createNotificationChannel(mChannel);
                }
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context, this.id).setWhen(System.currentTimeMillis()).setContentText((CharSequence)this.message).setContentTitle((CharSequence)this.title).setSmallIcon(NotificationUtils.getDrawableSmall(this.context)).setLargeIcon(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmapSize, (int)bitmapSize, (boolean)false)).setAutoCancel(true).setTicker((CharSequence)this.title).setNumber(NotificationUtils.countNtfs(this.context)).setStyle((NotificationCompat.Style)bigTextStyle).setDefaults(7);
                Intent resultIntent = new Intent(this.context, this.mainClass);
                resultIntent.setFlags(0x14000000);
                resultIntent.putExtra("title", this.title);
                resultIntent.putExtra("message", this.message);
                resultIntent.putExtra("id", this.id);
                resultIntent.putExtra("link", this.link);
                resultIntent.putExtra("url", this.imageUrl);
                TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
                stackBuilder.addParentStack(this.mainClass);
                stackBuilder.addNextIntent(resultIntent);
                PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)this.context.getApplicationContext(), (int)959, (Intent)resultIntent, (int)0x8000000);
                mBuilder.setContentIntent(resultPendingIntent);
                mNotificationManager.notify(1, mBuilder.build());
            } else {
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context).setWhen(System.currentTimeMillis()).setContentText((CharSequence)this.message).setContentTitle((CharSequence)this.title).setSmallIcon(NotificationUtils.getDrawableSmall(this.context)).setLargeIcon(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmapSize, (int)bitmapSize, (boolean)false)).setAutoCancel(true).setTicker((CharSequence)this.title).setNumber(NotificationUtils.countNtfs(this.context)).setStyle((NotificationCompat.Style)bigTextStyle).setDefaults(7);
                Intent resultIntent = new Intent(this.context, this.mainClass);
                resultIntent.setFlags(0x14000000);
                resultIntent.putExtra("title", this.title);
                resultIntent.putExtra("message", this.message);
                resultIntent.putExtra("id", this.id);
                resultIntent.putExtra("link", this.link);
                resultIntent.putExtra("url", this.imageUrl);
                TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
                stackBuilder.addParentStack(this.mainClass);
                stackBuilder.addNextIntent(resultIntent);
                PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)this.context.getApplicationContext(), (int)959, (Intent)resultIntent, (int)0x8000000);
                mBuilder.setContentIntent(resultPendingIntent);
                mNotificationManager.notify(1, mBuilder.build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showNotificationWithImage() {
        String name = "channel with image";
        String description = "channel img des";
        Log.i((String)TAG, (String)("showNotification:title=" + this.title + ";msg=" + this.message));
        try {
            Log.i((String)TAG, (String)("mainClass:" + this.mainClass));
            if (this.mainClass == null) {
                try {
                    String className = Preference.getString(this.context, "shared_pref_main_activity");
                    this.mainClass = Class.forName(className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            Drawable ico = this.context.getApplicationInfo().loadIcon(this.context.getPackageManager());
            Bitmap bitmap = Utils.drawableToBitmap(ico);
            int bitmapSize = (int)Math.min(64.0f * DeviceUtils.getDensity((Context)this.context), (float)bitmap.getWidth());
            RequestOptions options = new RequestOptions().centerCrop();
            Bitmap bigPictureBitmap = (Bitmap)Glide.with((Context)this.context).asBitmap().load(this.imageUrl).apply(options).into(512, 256).get();
            NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
            bigPictureStyle.setSummaryText((CharSequence)this.message);
            bigPictureStyle.bigPicture(bigPictureBitmap);
            bigPictureStyle.setBigContentTitle((CharSequence)this.title);
            NotificationManager mNotificationManager = (NotificationManager)this.context.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int importance = 4;
                NotificationChannel mChannel = mNotificationManager.getNotificationChannel(this.id);
                if (mChannel == null) {
                    mChannel = new NotificationChannel(this.id, (CharSequence)name, importance);
                    mChannel.setDescription(description);
                    mChannel.enableVibration(true);
                    mChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                    mNotificationManager.createNotificationChannel(mChannel);
                }
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context, this.id).setWhen(System.currentTimeMillis()).setContentText((CharSequence)this.message).setContentTitle((CharSequence)this.title).setSmallIcon(NotificationUtils.getDrawableSmall(this.context)).setLargeIcon(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmapSize, (int)bitmapSize, (boolean)false)).setAutoCancel(true).setTicker((CharSequence)this.title).setNumber(NotificationUtils.countNtfs(this.context)).setStyle((NotificationCompat.Style)bigPictureStyle).setDefaults(7);
                Intent resultIntent = new Intent(this.context, this.mainClass);
                resultIntent.setFlags(0x14000000);
                resultIntent.putExtra("title", this.title);
                resultIntent.putExtra("message", this.message);
                resultIntent.putExtra("id", this.id);
                resultIntent.putExtra("link", this.link);
                resultIntent.putExtra("url", this.imageUrl);
                TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
                stackBuilder.addParentStack(this.mainClass);
                stackBuilder.addNextIntent(resultIntent);
                PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)this.context.getApplicationContext(), (int)959, (Intent)resultIntent, (int)0x8000000);
                mBuilder.setContentIntent(resultPendingIntent);
                mNotificationManager.notify(1, mBuilder.build());
            } else {
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context).setWhen(System.currentTimeMillis()).setContentText((CharSequence)this.message).setContentTitle((CharSequence)this.title).setSmallIcon(NotificationUtils.getDrawableSmall(this.context)).setLargeIcon(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmapSize, (int)bitmapSize, (boolean)false)).setAutoCancel(true).setTicker((CharSequence)this.title).setNumber(NotificationUtils.countNtfs(this.context)).setStyle((NotificationCompat.Style)bigPictureStyle).setDefaults(7);
                Intent resultIntent = new Intent(this.context, this.mainClass);
                resultIntent.setFlags(0x14000000);
                resultIntent.putExtra("title", this.title);
                resultIntent.putExtra("message", this.message);
                resultIntent.putExtra("id", this.id);
                resultIntent.putExtra("link", this.link);
                resultIntent.putExtra("url", this.imageUrl);
                TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
                stackBuilder.addParentStack(this.mainClass);
                stackBuilder.addNextIntent(resultIntent);
                PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)this.context.getApplicationContext(), (int)959, (Intent)resultIntent, (int)0x8000000);
                mBuilder.setContentIntent(resultPendingIntent);
                mNotificationManager.notify(1, mBuilder.build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.ic_stat_mob);
    }

    public static void addNtf(Context c, int id2) {
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            JSONArray ntfs = new JSONArray();
            try {
                ntfs = new JSONArray(ntfsString);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            ntfs.put(id2);
            Preference.save(c, "shared_pref_notificatons", ntfs.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNtf(Context c, int id2) {
        Log.d((String)TAG, (String)("removeNotificationId" + id2));
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            JSONArray ntfs = new JSONArray(ntfsString);
            JSONArray newNtfs = new JSONArray();
            for (int i = 0; i < ntfs.length(); ++i) {
                if (id2 == ntfs.getInt(i)) continue;
                newNtfs.put(ntfs.getInt(i));
            }
            Log.d((String)TAG, (String)("left removeNotificationId" + newNtfs));
            Preference.save(c, "shared_pref_notificatons", newNtfs.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static boolean hasNtf(Context c) {
        Log.d((String)TAG, (String)("NTF : " + !NotificationUtils.getNtfs(c).isEmpty()));
        return !NotificationUtils.getNtfs(c).isEmpty();
    }

    public static boolean hasNtf(Context c, int id2) {
        return NotificationUtils.getNtfs(c).contains(id2);
    }

    public static ArrayList<Integer> getNtfs(Context c) {
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            JSONArray ntfs = new JSONArray(ntfsString);
            ArrayList<Integer> ntfIds = new ArrayList<Integer>();
            for (int i = ntfs.length() - 1; i >= 0; --i) {
                ntfIds.add(ntfs.getInt(i));
            }
            return ntfIds;
        }
        catch (JSONException jSONException) {
            return new ArrayList<Integer>();
        }
    }

    public static void removeAllNtf(Context c) {
        try {
            Preference.save(c, "shared_pref_notificatons", "[]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int countNtfs(Context c) {
        try {
            return NotificationUtils.getNtfs(c).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public NotificationUtils(Context context) {
        this.context = context;
    }

    public static NotificationUtils getInstance(Context context) {
        if (instance == null) {
            instance = new NotificationUtils(context);
        }
        return instance;
    }

    public Class getMainClass() {
        return this.mainClass;
    }

    public NotificationUtils setMainClass(Class mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public NotificationUtils setImageUrl(String url) {
        this.imageUrl = url;
        return this;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public NotificationUtils setContext(Context context) {
        this.context = context;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public NotificationUtils setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public NotificationUtils setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public NotificationUtils setId(String id2) {
        this.id = id2;
        return this;
    }

    public String getLink() {
        return this.link;
    }

    public NotificationUtils setLink(String link) {
        this.link = link;
        return this;
    }

    public int getSmallIcon() {
        return this.smallIcon;
    }

    public NotificationUtils setSmallIcon(int smallIcon) {
        this.smallIcon = smallIcon;
        return this;
    }
}

