/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.js;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.widget.Toast;
import com.facebook.AccessToken;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.model.MobAccessToken;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.HashMap;
import java.util.Set;

final class CmdLogin {
    private static final String TAG = CmdLogin.class.getSimpleName();
    private static CmdLogin INSTANCE;

    private CmdLogin() {
    }

    public static CmdLogin getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdLogin();
        }
        return INSTANCE;
    }

    void mobLoginSuccess(Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginSuccess");
        Utils.hideLoading();
        MobAccessToken accessToken = MobAccessToken.parse(params);
        GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
        Intent intent = new Intent("com.mobgame.broadcast");
        intent.putExtra("category", "login");
        LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
    }

    void mobLoginGuest(final Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGuest");
        try {
            Utils.showLoading(activity, Res.string((Context)activity, R.string.logging_in));
            String mac_address = DeviceUtils.getUniqueDeviceID((Context)activity);
            String key = Utils.getSHACheckSum(mac_address + "abc");
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("mac_address", mac_address);
            postParams.put("key", key);
            webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_MAC_ADDRESS, postParams, new PostTask.Callback(){

                @Override
                public void onSuccess(String response) {
                    Utils.hideLoading();
                }

                @Override
                public void onFailure(Throwable e) {
                    e.printStackTrace();
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
        }
    }

    void mobLoginFacebook(final Activity activity, final MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("mobLoginStartFb:" + params));
        Utils.showLoading(activity, "", Res.string((Context)activity, R.string.connecting_facebook), false);
        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback(){

            @Override
            public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("access_token", accessToken.getToken());
                    webFragment.postUrlWithMobHeaders(Constants.URL_RECEIVE_ACCESS_TOKEN, postParams, new PostTask.Callback(){

                        @Override
                        public void onSuccess(String response) {
                            Utils.hideLoading();
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            Utils.hideLoading();
                        }
                    });
                }
                catch (Exception e) {
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                    Utils.hideLoading();
                }
            }

            @Override
            public void onCancel() {
                Utils.hideLoading();
            }

            @Override
            public void onError(Throwable t) {
                Utils.hideLoading();
                CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
            }
        });
    }

    void mobUpgradeFacebook(final Activity activity, final MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)("mobFacebookForUpdate:" + params));
        Utils.showLoading(activity, Res.string((Context)activity, R.string.connecting_facebook));
        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback(){

            @Override
            public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
                Utils.hideLoading();
                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("token", accessToken.getToken());
                    webFragment.postUrlWithMobHeaders(Constants.URL_UPDATE_FROM_FACEBOOK, postParams);
                }
                catch (Exception e) {
                    CmdLogin.this.handleException(activity, Res.string((Context)activity, R.string.something_went_wrong));
                }
            }

            @Override
            public void onCancel() {
                Utils.hideLoading();
            }

            @Override
            public void onError(Throwable t) {
                Utils.hideLoading();
            }
        });
    }

    void mobLoginGooglePlay(Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGooglePlay");
        Utils.showLoading(activity, Res.string((Context)activity, R.string.connecting_google_play));
        GoogleAuthManager.getInstance().login(activity);
    }

    void mobLoginGoogleAccount(Activity activity, MobGameWebFragment webFragment, String params) {
        Log.i((String)TAG, (String)"mobLoginGoogleAccount");
    }

    private void handleException(final Activity activity, final String message) {
        Utils.hideLoading();
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)activity, (CharSequence)message, (int)1).show();
            }
        });
        Intent intent = new Intent("com.mobgame.broadcast");
        intent.putExtra("category", "login");
        intent.putExtra("status", false);
        intent.putExtra("message", message);
        LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
    }
}

