package com.mobgame.gui.floatbutton;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.PixelFormat;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TableRow;
import android.widget.TextView;

import com.koushikdutta.urlimageviewhelper.UrlImageViewHelper;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.MobMenu;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class MobGameFloatMenuView {

//	private static String TAG = MobFloatMenuView.class.getSimpleName();
	private static int MENU_HEIGHT = MobGameFloatGestureView.BUTTON_SIZE;
	Activity activity;
	EventListener eventListener;
	View rootView, layoutMenu/*, imgBackground*/;
	@SuppressLint("UseSparseArrays") 
	HashMap<Integer, ImageView> ntfImageViews = new HashMap<Integer, ImageView>();
	// Screen
	float density;
	float screenHeight;

	public MobGameFloatMenuView(Activity a) {
		activity = a;

		density = DeviceUtils.getDensity(a);
		screenHeight = DeviceUtils.getScreenHeightInPixels(a);

		attachView();
		initView();
	}

	@SuppressLint("InflateParams")
	public void attachView()
	{
		rootView = LayoutInflater.from(activity).inflate(R.layout.float_menu, null);
		WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
				Activity.WINDOW_SERVICE);
		WindowManager.LayoutParams params = new WindowManager.LayoutParams(
				WindowManager.LayoutParams.MATCH_PARENT,
				WindowManager.LayoutParams.MATCH_PARENT, 
				WindowManager.LayoutParams.TYPE_PHONE,
				WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, 
				PixelFormat.TRANSPARENT);
		params.gravity = Gravity.LEFT | Gravity.TOP;
		windowManager.addView(rootView, params);
	}
	
	@SuppressLint({ "InflateParams", "ClickableViewAccessibility" })
	public void initView() {
		rootView.setOnTouchListener(new OnTouchListener() {

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				hide();
				return true;
			}
		});
		layoutMenu = rootView.findViewById(R.id.layout_menu);
//		imgBackground = rootView.findViewById(R.id.img_background);

		updateMenu();
		hide();
	}
	
	public void setEventListener(EventListener listener) {
		eventListener = listener;
	}
	
	public void show(int x, int y, boolean isAnimated) {
		if (eventListener != null && rootView.getVisibility() != View.VISIBLE) {
			eventListener.onShow();
		}
		rootView.setVisibility(View.VISIBLE);
		WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
				Activity.WINDOW_SERVICE);
		WindowManager.LayoutParams params = (WindowManager.LayoutParams) rootView.getLayoutParams();
//		params.gravity = Gravity.LEFT | Gravity.TOP;
		params.x = MENU_HEIGHT * (int) density;
//		params.y = y;
		windowManager.updateViewLayout(rootView, params);
		
		int menuY = y + (MENU_HEIGHT * (int) density - layoutMenu.getHeight()) / 2;
		int minY = 0;
		int maxY = (int) (screenHeight - layoutMenu.getHeight());
		int calY = Math.min(maxY, Math.max(minY, menuY));
		if (calY > menuY) {
			menuY = y;
		} else if (calY < menuY) {
			menuY = y + (MENU_HEIGHT * (int) density - layoutMenu.getHeight());
		}
		RelativeLayout.LayoutParams params1 = (LayoutParams) layoutMenu.getLayoutParams();
		params1.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
		params1.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, 0);
		params1.leftMargin = x + 8 * (int) density;
		params1.topMargin = menuY;
//		RelativeLayout.LayoutParams params2 = (LayoutParams) imgBackground.getLayoutParams();
//		params2.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
//		params2.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, 0);
//		params2.leftMargin = x + 4 * (int) density;
//		params2.topMargin = y;
		if (isAnimated) {	
//			ResizeWidthAnimation anim = new ResizeWidthAnimation(imgBackground, layoutMenu.getWidth() - MENU_HEIGHT * 2, layoutMenu.getWidth());
//			anim.setInterpolator(new OvershootInterpolator());
//		    anim.setDuration(400);
//		    imgBackground.startAnimation(anim);
//		    ViewPropertyAnimator.animate(imgBackground)
//				.setDuration(400)
//				.alpha(100);
			layoutMenu.animate()
				.setDuration(400)
				.alpha(100);
//		    rootView.findViewById(R.id.img_background).setAlpha(0);
		} else {
			
		}
		updateMenuNtf();
	}

	public void showInReverse(int x, int y, boolean isAnimated)
	{
		if (eventListener != null && rootView.getVisibility() != View.VISIBLE) {
			eventListener.onShow();
		}
		rootView.setVisibility(View.VISIBLE);
		WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
				Activity.WINDOW_SERVICE);
		WindowManager.LayoutParams params = (WindowManager.LayoutParams) rootView.getLayoutParams();
		params.x = 0;
//		params.y = y - 200;
		windowManager.updateViewLayout(rootView, params);
		
		int menuY = y + (MENU_HEIGHT * (int) density - layoutMenu.getHeight()) / 2;
		int minY = 0;
		int maxY = (int) (screenHeight - layoutMenu.getHeight());
		int calY = Math.min(maxY, Math.max(minY, menuY));
		if (calY > menuY) {
			menuY = y;
		} else if (calY < menuY) {
			menuY = y + (MENU_HEIGHT * (int) density - layoutMenu.getHeight());
		}
		RelativeLayout.LayoutParams params1 = (LayoutParams) layoutMenu.getLayoutParams();
		params1.addRule(RelativeLayout.ALIGN_PARENT_LEFT, 0);
		params1.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
		params1.rightMargin = x + 8 * (int) density;
		params1.topMargin = menuY;
//		RelativeLayout.LayoutParams params2 = (LayoutParams) imgBackground.getLayoutParams();
//		params2.addRule(RelativeLayout.ALIGN_PARENT_LEFT, 0);
//		params2.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
//		params2.rightMargin = x + 4 * (int) density;
//		params2.topMargin = y;
		if (isAnimated) {
//			ResizeWidthAnimation anim = new ResizeWidthAnimation(imgBackground, layoutMenu.getWidth() - MENU_HEIGHT * 2, layoutMenu.getWidth());
//			anim.setInterpolator(new OvershootInterpolator());
//		    anim.setDuration(400);
//		    imgBackground.startAnimation(anim);
//		    ViewPropertyAnimator.animate(imgBackground)
//				.setDuration(400)
//				.alpha(100);
			layoutMenu.animate()
				.setDuration(400)
				.alpha(100);
//		    rootView.setAlpha(0);
		} else {
			
		}
		updateMenuNtf();
	}
	
	public void hide() {
		if (eventListener != null && rootView.getVisibility() == View.VISIBLE) {
			eventListener.onHide();
		}
		rootView.setVisibility(View.INVISIBLE);
//		imgBackground.setAlpha(0);
		layoutMenu.setAlpha(0);
	}

	public void dismiss()
	{
		try {
			rootView.setVisibility(View.GONE);
			WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
					Activity.WINDOW_SERVICE);
			windowManager.removeView(rootView);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@SuppressLint("InflateParams")
	void updateMenu() {
//		try {
			((ViewGroup) layoutMenu).removeAllViews();
			
			/*ArrayList<Integer> ntfIds = Utils.getNtfs(activity);*/
			
			MobMenu mobMenu = GameConfigManager.getInstance().getMobMenu();
			if(mobMenu == null){
				return;
			}

			ArrayList<MobMenuItem> menuItems = mobMenu.getMenuItems();
			Stack<View> views = new Stack<View>();
			for (int i = menuItems.size() - 1; i >= 0; i--) {
				MobMenuItem menuItem = menuItems.get(i);
				if (menuItem.shouldShowHorizontal()) {

					// Attach to horizontal menu
					View v = LayoutInflater.from(activity).inflate(R.layout.float_menu_item, null);
					TextView tv = (TextView) v.findViewById(R.id.title);
					ImageView imv = (ImageView) v.findViewById(R.id.image);
					ImageView imvNoti = (ImageView) v.findViewById(R.id.img_notification);

					/*boolean hasNotification = false;*/
					if (menuItem.isTab()) {
						/*JSONArray menuActions = new JSONArray(menuItem.getAction());
						for (int j = 0; j < menuActions.length(); j++) {
							JSONObject subMenuJSON = menuActions.getJSONObject(j);
							ntfImageViews.put(subMenuJSON.getInt("id"), imvNoti);
						}*/
						for (int subId : menuItem.getSubMenuIds()) {
							ntfImageViews.put(subId, imvNoti);
						}
						ntfImageViews.put(menuItem.getId(), imvNoti);
					} else {
						/*if (ntfIds.contains(menuItemJSON.getInt("id"))) {
							hasNotification = true;
						}*/
						ntfImageViews.put(menuItem.getId(), imvNoti);
					}
					Log.d("acb", "go here!");
					tv.setText(menuItem.getLabelHorizontal());
					tv.setTextSize(TypedValue.COMPLEX_UNIT_SP, 11);
//					Glide.with(activity)
//					    .load(menuItem.getIconUrlHorizontal())
//					    .into(imv);
					UrlImageViewHelper.setUrlDrawable(imv, menuItem.getIconUrlHorizontal());
					final MobMenuItem fMenuItem = menuItem;
					v.setOnClickListener(new OnClickListener() {

						@Override
						public void onClick(View v)
						{
							if (eventListener != null) {
								eventListener.onClick(v, fMenuItem);
							}
						}
					});

					/*if (hasNotification) {
						imvNoti.setVisibility(View.VISIBLE);
					}*/

					views.push(v);
				}
			}

//			String menuConfigsString = Preference.getString(activity, 
//					Constants.SHARED_PREF_DB_MENU);
//			JSONArray menuConfigs = new JSONArray(menuConfigsString);
//			Stack<View> views = new Stack<View>();
//			for (int i = menuConfigs.length() - 1; i >= 0; i--) {
//				JSONObject menuItemJSON = menuConfigs.getJSONObject(i);
//				if (menuItemJSON.has("horizontal_show") && menuItemJSON.getBoolean("horizontal_show")) {
//					
//					// Attach to horizontal menu
//					View v = LayoutInflater.from(activity).inflate(R.layout.float_menu_item, null);
//					TextView tv = (TextView) v.findViewById(R.id.title);
//					ImageView imv = (ImageView) v.findViewById(R.id.image);
//					ImageView imvNoti = (ImageView) v.findViewById(R.id.img_notification);
//
//					/*boolean hasNotification = false;*/
//					FloatMenuModel menuItem = null;
//					boolean isTab = menuItemJSON.getBoolean("is_tab");
//					if (isTab) {
//						JSONArray menuActions = menuItemJSON.getJSONArray("action");
//						for (int j = 0; j < menuActions.length(); j++) {
//							JSONObject subMenuJSON = menuActions.getJSONObject(j);
//							/*if (ntfIds.contains(subMenuJSON.getInt("id"))) {
//								hasNotification = true;
//							}*/
//							ntfImageViews.put(subMenuJSON.getInt("id"), imvNoti);
//						}
//						menuItem = new FloatMenuModel(
//								menuItemJSON.getInt("id"),
//								menuItemJSON.getString("horizontal_title"), 
//								menuItemJSON.getString("horizontal_icon"),
//								menuActions
//							);
//						ntfImageViews.put(menuItemJSON.getInt("id"), imvNoti);
//					} else {
//						JSONArray menuActions = new JSONArray();
//						menuActions.put(menuItemJSON);
//						/*if (ntfIds.contains(menuItemJSON.getInt("id"))) {
//							hasNotification = true;
//						}*/
//						menuItem = new FloatMenuModel(
//								menuItemJSON.getInt("id"),
//								menuItemJSON.getString("horizontal_title"), 
//								menuItemJSON.getString("horizontal_icon"),
//								menuActions
//							);
//						ntfImageViews.put(menuItemJSON.getInt("id"), imvNoti);
//					}
//
//					tv.setText(menuItem.label);
//					tv.setTextSize(TypedValue.COMPLEX_UNIT_SP, 11);
//
//					Glide.with(activity)
//					    .load(menuItem.iconUrl)
//					    .into(imv);
//					final FloatMenuModel fMenuItem = menuItem;
//					v.setOnClickListener(new OnClickListener() {
//
//						@Override
//						public void onClick(View v)
//						{
//							if (eventListener != null) {
//								eventListener.onClick(v, fMenuItem);
//							}
//						}
//					});
//
//					/*if (hasNotification) {
//						imvNoti.setVisibility(View.VISIBLE);
//					}*/
//
//					views.push(v);
//				}
//			}

			int itemsPerRow = 4;
//			if (views.size() > 4) {
//				itemsPerRow = views.size() / 2 + views.size() % 2;
//			}
			while (!views.isEmpty()) {
				TableRow tblrow = new TableRow(activity);
//				tblrow.setMinimumHeight(views.get(0).getHeight());
				tblrow.setGravity(Gravity.CENTER_VERTICAL);
				for (int j = 0; !views.isEmpty() && j < itemsPerRow; j++) {
					tblrow.addView(views.pop());
				}
				((ViewGroup) layoutMenu).addView(tblrow);
			}
			updateMenuNtf();
			
//		} catch (JSONException e) {
//			e.printStackTrace();
//		}
	}
	
	private void updateMenuNtf() {
		if (ntfImageViews == null) return;
		ArrayList<ImageView> imvs = new ArrayList<ImageView>(ntfImageViews.values());
		for (int i = 0; i < imvs.size(); i++) {
			ImageView imageView = imvs.get(i);
			if(imageView != null){
				imageView.setVisibility(View.GONE);
			}
		}

		ArrayList<Integer> ntfs = Utils.getNtfs(activity);
		if (ntfs == null) return;
		for (int i = 0; i < ntfs.size(); i++) {
			ImageView imageView = ntfImageViews.get(ntfs.get(i));
			if(imageView  != null){
				imageView.setVisibility(View.VISIBLE);
			}
		}
	}

	interface EventListener {
		public void onClick(View v, MobMenuItem menuItem);
		public void onShow();
		public void onHide();
	}

}
