/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.appsflyer.a;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.UUID;

class g {
    private static String sID = null;

    public static synchronized String id(WeakReference<Context> context) {
        if (context.get() == null) {
            return sID;
        }
        if (sID == null) {
            String string = g.readInstallationSP(context);
            if (string != null) {
                sID = string;
            } else {
                try {
                    File file = new File(((Context)context.get()).getFilesDir(), "AF_INSTALLATION");
                    if (!file.exists()) {
                        sID = g.generateId(context);
                    } else {
                        sID = g.readInstallationFile(file);
                        file.delete();
                    }
                    g.writeInstallationSP(context, sID);
                }
                catch (Exception exception) {
                    a.afLogE("Error getting AF unique ID", exception);
                }
            }
        }
        return sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInstallationFile(File installation) {
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        try {
            randomAccessFile = new RandomAccessFile(installation, "r");
            byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new String(byArray != null ? byArray : new byte[]{});
    }

    private static String generateId(WeakReference<Context> context) throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = ((Context)context.get()).getPackageManager().getPackageInfo(((Context)context.get()).getPackageName(), 0);
        String string = Build.VERSION.SDK_INT >= 9 ? packageInfo.firstInstallTime + "-" + Math.abs(new Random().nextLong()) : UUID.randomUUID().toString();
        return string;
    }

    private static String readInstallationSP(WeakReference<Context> context) {
        if (context.get() == null) {
            return null;
        }
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences("appsflyer-data", 0);
        return sharedPreferences.getString("AF_INSTALLATION", null);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void writeInstallationSP(WeakReference<Context> context, String sId) throws PackageManager.NameNotFoundException {
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences("appsflyer-data", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("AF_INSTALLATION", sId);
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }
}

