/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.support.annotation.RequiresApi;
import com.appsflyer.a;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;

@RequiresApi(api=23)
@TargetApi(value=23)
class AFKeystoreWrapper {
    private final Object lock = new Object();
    private KeyStore keystore;
    private Context context;
    private String uid;
    private int reInstallCounter;

    public AFKeystoreWrapper(Context context) {
        this.context = context;
        this.uid = "";
        this.reInstallCounter = 0;
        this.initKeyStore();
    }

    private void initKeyStore() {
        a.afLog("Initialising KeyStore..");
        try {
            this.keystore = KeyStore.getInstance("AndroidKeyStore");
            this.keystore.load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            a.afLog("Couldn't load keystore instance of type: AndroidKeyStore");
        }
    }

    public void createFirstInstallData(String appsFlyerUID) {
        this.uid = appsFlyerUID;
        this.reInstallCounter = 0;
        this.createKey(this.generateAliasString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReInstallCounter() {
        String string = this.generateAliasString();
        Object object = this.lock;
        synchronized (object) {
            ++this.reInstallCounter;
            this.deleteKey(string);
        }
        this.createKey(this.generateAliasString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadData() {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.keystore != null) {
                try {
                    Enumeration<String> enumeration = this.keystore.aliases();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        if (string == null || !this.isAppsFlyerPrefix(string)) continue;
                        String[] stringArray = string.split(",");
                        if (stringArray.length == 3) {
                            a.afLog("Found a matching AF key with alias:\n" + string);
                            bl = true;
                            String[] stringArray2 = stringArray[1].trim().split("=");
                            String[] stringArray3 = stringArray[2].trim().split("=");
                            if (stringArray2.length == 2 && stringArray3.length == 2) {
                                this.uid = stringArray2[1].trim();
                                this.reInstallCounter = Integer.parseInt(stringArray3[1].trim());
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    a.afLog("Couldn't list KeyStore Aliases: " + throwable.getClass().getName());
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKey(String alias) {
        a.afLog("Creating a new key with alias: " + alias);
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.keystore.containsAlias(alias)) {
                    Calendar calendar = Calendar.getInstance();
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.add(1, 5);
                    KeyGenParameterSpec keyGenParameterSpec = null;
                    if (Build.VERSION.SDK_INT >= 23) {
                        keyGenParameterSpec = new KeyGenParameterSpec.Builder(alias, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(calendar.getTime()).setCertificateNotAfter(calendar2.getTime()).build();
                    } else if (Build.VERSION.SDK_INT >= 18) {
                        keyGenParameterSpec = new KeyPairGeneratorSpec.Builder(this.context).setAlias(alias).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(calendar.getTime()).setEndDate(calendar2.getTime()).build();
                    }
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    keyPairGenerator.initialize((AlgorithmParameterSpec)keyGenParameterSpec);
                    keyPairGenerator.generateKeyPair();
                } else {
                    a.afLog("Alias already exists: " + alias);
                }
            }
        }
        catch (Exception exception) {
            a.afLog("Exception " + exception.getMessage() + " occurred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteKey(String alias) {
        a.afLog("Deleting key with alias: " + alias);
        try {
            Object object = this.lock;
            synchronized (object) {
                this.keystore.deleteEntry(alias);
            }
        }
        catch (KeyStoreException keyStoreException) {
            a.afLog("Exception " + keyStoreException.getMessage() + " occurred");
        }
    }

    private boolean isAppsFlyerPrefix(String alias) {
        return alias.startsWith("com.appsflyer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateAliasString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("com.appsflyer").append(",");
        Object object = this.lock;
        synchronized (object) {
            stringBuilder.append("KSAppsFlyerId").append("=").append(this.uid).append(",");
            stringBuilder.append("KSAppsFlyerRICounter").append("=").append(this.reInstallCounter);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUid() {
        Object object = this.lock;
        synchronized (object) {
            return this.uid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReInstallCounter() {
        Object object = this.lock;
        synchronized (object) {
            return this.reInstallCounter;
        }
    }
}

