package com.mobgame;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;

import org.json.JSONException;
import org.json.JSONObject;

import android.Manifest;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application.ActivityLifecycleCallbacks;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Animation.AnimationListener;
import android.view.animation.AnimationUtils;
import android.webkit.CookieSyncManager;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.appsflyer.AFInAppEventParameterName;
import com.appsflyer.AFInAppEventType;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.ads.AdListener;
import com.mobgame.ads.AdsManager;
import com.mobgame.ads.OfferWall;
import com.mobgame.ads.PopupAd;
import com.mobgame.ads.utils.LogUtils;
import com.mobgame.api.GetInfoAfterAuthenTask;
import com.mobgame.api.GetInfoBeforeAuthenTask;
import com.mobgame.api.LogoutTask;
import com.mobgame.api.SaveCharacterTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.gui.MobGameSocialDialogFragment;
import com.mobgame.gui.MobGameUpgradeDialog;
import com.mobgame.js.CmdDashboard;
import com.mobgame.js.CmdPayment;
import com.mobgame.model.Game;
import com.mobgame.model.MUrl;
import com.mobgame.model.MobMenuItem;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Constants;
import com.mobgame.utils.PermissionUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
@SuppressWarnings("deprecation")
public class MobGameSDK {

	private static final String TAG = MobGameSDK.class.getSimpleName();
	private static MobGameSDK INSTANCE;

	public static Activity activity;
	public static Activity currentActivity;

	private SensorManager sensorManager;
	private Sensor accelerometerSensor;
	private boolean accelerometerPresent;
	private MobGameListener mListener;
	
	private PopupAd popupAd;
	private OfferWall offerWall;
	
	private static boolean shouldShowFloatButton;
	private static boolean shouldShowPopup;
//	private int countViberate = 0;

	private ArrayList<String> queuePopups = new ArrayList<String>();
	private static final String POPUP_HELLO = "popup_hello";
	private static final String POPUP_ACCOUNT = "popup_account";
	private static final String POPUP_NTFS = "popup_ntfs";
	private static final String POPUP_FLOAT_BUTTON = "popup_float_button";
	private static final String POPUP_ADS = "popup_ads";
	private static final long TIMEOUT_DISMISS_FLOAT_BUTTON = 24 * 60 * 60 * 1000; // 24 hours
	private int menuId;
	private boolean isShowAds = true;

	private SensorEventListener accelerometerListener = new SensorEventListener() {
		
		private float oldZ;

		@Override
		public void onAccuracyChanged(Sensor event, int accuracy) {
		}

		@Override
		public void onSensorChanged(SensorEvent event) {
			float z_value = event.values[2];
			if (z_value < 0
			&& oldZ * z_value < 0) {
				Preference.remove(activity, Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME);
				Preference.remove(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON);
				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "float_button");
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
			}
			oldZ = z_value;
		}
	};

	private boolean loginProcessDone = false;
	private MobGameSDK() {}

	public static MobGameSDK getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new MobGameSDK();
		}
		return INSTANCE;
	}

	public void init(Activity activity, String appkey) {
		Log.i(TAG, "MobGameSDK");
		MobGameSDK.activity = activity;		
		if (mListener == null) {
			setMobGameListener(new MobGameListener() {
				
				@Override
				public void onPaySuccessful(String userId, String orderId,
						String orderProduct, String orderInfo, String orderTime,
						String platformPrice, String gamePrice, String state,
						String game_role_id, String game_area_id, String is_sandbox) {}
				
				@Override
				public void onLoginSuccessful(String accountID, String accessToken) {}
				
				@Override
				public void onError(int errorCode, String message) {}
			});
		}

	
		GameConfigManager.getInstance().setAppKey(appkey);
		
		activity.getApplication().unregisterActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
		activity.getApplication().registerActivityLifecycleCallbacks(mActivityLifecycleCallbacks);
		activity.getApplication().unregisterComponentCallbacks(mComponentCallbacks);
		activity.getApplication().registerComponentCallbacks(mComponentCallbacks);

		// activity.onCreate()
		LocalBroadcastManager.getInstance(activity.getApplicationContext())
			.registerReceiver(mGlobalMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));
	
		CookieSyncManager.createInstance(activity.getApplicationContext());
	
		sensorManager = (SensorManager) activity.getSystemService(Context.SENSOR_SERVICE);
		List<Sensor> sensorList = sensorManager.getSensorList(Sensor.TYPE_ACCELEROMETER);
		if (sensorList.size() > 0) {
			accelerometerPresent = true;
			accelerometerSensor = sensorList.get(0);
		} else {
			accelerometerPresent = false;
		}
		
		MobGameGCMIntentService.register(activity);
	}
	
	public void onHandleIntent(Intent intent){
	    Uri data = intent.getData();
	    if (data != null) {
	    	// fb<123>://dashboard?menu-id=<menu-id>
	    	try {
	    		int menuId = Integer.parseInt(data.getQueryParameter("menu-id"));
	    		Log.d(TAG, "menu-id:" + menuId);
	    		MobGameSDK.this.menuId = menuId;
	    		if (menuId > 0) {
	    			MobMenuItem menuItem = GameConfigManager.getInstance()
	    					.getMobMenu()
	    					.getMobMenuItemById(menuId);
	    			menuId = -1;
	    			if (menuItem != null) {
	    				Intent intent2 = new Intent(Constants.INTENT_FILTER);
	    				intent.putExtra("category", menuItem.getCommand());
	    				intent.putExtra("data", menuItem.getParams());
	    				LocalBroadcastManager.getInstance(activity.getApplicationContext())
	    					.sendBroadcast(intent2);
	    				return;
	    			}
	    		}
	    	} catch (Exception e) {
	    		MobGameSDK.this.menuId = -1;
	    	}
	    } else {
	    	MobGameSDK.this.menuId = -1;
	    }
	}

	public static Context getApplicationContext() {
		return activity.getApplicationContext();
	}

	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		Log.i(TAG, "onActivityResult:requestCode=" + requestCode + ";resultCode=" + resultCode);
		try {
			switch (requestCode) {
				case Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES:
					GoogleAuthManager.getInstance().onActivityResult(requestCode, resultCode, data);
			        break;
				case Constants.REQUEST_CODE_FACEBOOK_LOGIN:
				case Constants.REQUEST_CODE_FACEBOOK_SHARE:
				case Constants.REQUEST_CODE_FACEBOOK_INVITE:
					FacebookManager.getInstance().onActivityResult(requestCode, resultCode, data);
					break;
				case Constants.REQUEST_CODE_FACEBOOK_INVITE_GAME:
					FacebookManager.getInstance().onActivityResult(requestCode, resultCode, data);
					break;
				case Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING:
//				case Constants.REQUEST_CODE_PAYPAL_PAYMENT:
//				case Constants.REQUEST_CODE_PAYPAL_FUTURE_PAYMENT:
//				case Constants.REQUEST_CODE_PAYPAL_PROFILE_SHARING:
					CmdPayment.getInstance().handleResult(
							activity, requestCode, resultCode, data);
					break;
				case Constants.REQUEST_CODE_PICKER:
					CmdDashboard.getInstance().handleResult(
							activity, requestCode, resultCode, data);
				default:
					break;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	
	@TargetApi(19)
	public void onWindowFocusChanged(boolean hasFocus) {
		if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
	        if (hasFocus) {
	            activity.getWindow().getDecorView()
	                    .setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
	                            | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
	                            | View.SYSTEM_UI_FLAG_FULLSCREEN
	                            | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
	        }
	    }
	}

	public void login() {
		Log.i(TAG, "login");
		if (GameConfigManager.getInstance().getGameConfig() == null) {
			getGameInfoRemote();
			return;
		}
		if (isLoggedIn()) {
			return;
		}
		loginProcessDone = false;
		shouldShowFloatButton = false;
		MobGameHelper.hideFloatButton();
		if (!isLoggedIn()) {
			Intent intent = new Intent(activity, MobGameActivity.class);
			intent.putExtra(MobGameActivity.KEY_DATA, "[{'action':'" + Constants.URL_USER + "'}]");
			intent.putExtra(MobGameActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
			intent.putExtra(MobGameActivity.KEY_ENABLE_SIDE_MENU, false);
			activity.startActivity(intent);

			if (offerWall.isShowing()) offerWall.close();
		} else {
			handleLogin();
		}
	}

	private void logout(boolean forceLogout){
		loginProcessDone = true;
		logout();
	}
	public void logout() {
		if(!loginProcessDone){
			return;
		}
		Log.i(TAG, "logout");
		new LogoutTask().execute();
		MobGameHelper.hideFloatButton();
		queuePopups.clear();
	}

	public void dashboard() {
		Log.i(TAG, "dashboard");
		if (GameConfigManager.getInstance().getGameConfig() == null) {
			getGameInfoRemote();
			return;
		}
		if (!Utils.isDashboardEnabled(activity)) {
			Log.i(TAG, "Dashboard is disabled");
			return;
		}
		if (!isLoggedIn()) {
			Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
		} else {
			MobGameHelper.hideFloatButton();
			Intent intent = new Intent(activity, MobGameActivity.class);
			activity.startActivity(intent);

			if (offerWall.isShowing()) offerWall.close();
		}
	}
	
	private void dashboard(String data) throws JSONException {
		Log.i(TAG, "dashboard:" + data.toString());
		if (GameConfigManager.getInstance().getGameConfig() == null) {
			getGameInfoRemote();
			return;
		}
		if (!Utils.isDashboardEnabled(activity)) {
			Log.i(TAG, "Dashboard is disabled");
			return;
		}
		if (!isLoggedIn()) {
			Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
		} else {
			MobGameHelper.hideFloatButton();
			//TODO disable dashboard
			Intent intent = new Intent(activity, MobGameActivity.class);
			if(isJsonArray(data)){
				intent.putExtra(MobGameActivity.KEY_DATA, data);
			}else{
				JSONObject jsonData = new JSONObject(data);
				boolean autohideHeaderBar = true;
				if (jsonData.has("autohide_header_bar")) {
					autohideHeaderBar = jsonData.getBoolean("autohide_header_bar");
				}
				boolean enableSideMenu = true;
				if (jsonData.has("enable_side_menu")) {
					enableSideMenu = jsonData.getBoolean("enable_side_menu");
				}
				intent.putExtra(MobGameActivity.KEY_DATA, jsonData.getJSONArray("items").toString());
				intent.putExtra(MobGameActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, autohideHeaderBar);
				intent.putExtra(MobGameActivity.KEY_ENABLE_SIDE_MENU, enableSideMenu);
			}
			activity.startActivity(intent);

			if (offerWall.isShowing()) offerWall.close();
		}
	}
	private boolean isJsonArray(String strData){
		try {
			JSONObject json = new JSONObject(strData);
			return false;
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return true;
		}
		
	}
	public void payment() {
		payment(null);
	}

	public void payment(String state) {
		Log.i(TAG, "payment:" + state);
		if (GameConfigManager.getInstance().getGameConfig() == null) {
			getGameInfoRemote();
			return;
		}
		if (!isLoggedIn()) {
			Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
		} else {
			MobGameHelper.hideFloatButton();
			String url = Constants.URL_PAYMENT;
			if (!TextUtils.isEmpty(state)) {
				url += "?state=" + state;
			}
			Log.d(TAG, url);
			Intent intent = new Intent(activity, MobGameActivity.class);
			intent.putExtra(MobGameActivity.KEY_DATA, "[{'action':'" + url + "'}]");
			intent.putExtra(MobGameActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
			intent.putExtra(MobGameActivity.KEY_ENABLE_SIDE_MENU, false);
			activity.startActivity(intent);

			if (offerWall.isShowing()) offerWall.close();
		}
	}

	public void showDialogSocial(){
		if (GameConfigManager.getInstance().getGameConfig() == null) {
			getGameInfoRemote();
			return;
		}
		if (!isLoggedIn()) {
			Toast.makeText(activity, "You must login first", Toast.LENGTH_SHORT).show();
		} else {
			showFragment(Constants.URL_SOCIAL, false);
		}
	}
	boolean isShowSocialDialog = false;
	private void showFragment(String url, boolean isEncrypted) {
		if (url != null && !url.equals("")) {
			
			FragmentManager fm = activity.getFragmentManager();
			MobGameSocialDialogFragment fr = (MobGameSocialDialogFragment) fm
					.findFragmentByTag(Constants.TAG_FRAGMENT);
			MobGameHelper.hideFloatButton();
			
			isShowSocialDialog = true;
			if (fr == null) {
				fr = new MobGameSocialDialogFragment(new MUrl(url, isEncrypted));
				fr.setOnDismissListener(new DialogInterface.OnDismissListener() {

					@Override
					public void onDismiss(DialogInterface dialog) {
						Log.d(TAG, "alo alo 2 : " + Utils.isDashboardEnabled(activity));
						if(isShowSocialDialog 
								&& Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)
								&& Utils.isDashboardEnabled(activity)){
							MobGameHelper.showFloatButton();
						}
						isShowSocialDialog = false;
					}
				});
				FragmentTransaction fragmentTransaction = fm.beginTransaction();
				fragmentTransaction.add(fr, Constants.TAG_FRAGMENT);
				// fragmentTransaction.commit();
				fragmentTransaction.commitAllowingStateLoss();
			} else {
				try {
					fr.loadUrlWithMobHeaders(new MUrl(url, isEncrypted));
				} catch (InterruptedException | ExecutionException e) {
					e.printStackTrace();
				}
			}
		}else{
			Log.d(TAG, "url null");
		}
	}
	public void close() {
		close(true);
	}
	
	private void close(boolean check) {
		Intent i = new Intent(Constants.INTENT_FILTER);
		i.putExtra("category", "dashboard_close");
		LocalBroadcastManager.getInstance(activity).sendBroadcast(i);

//		MobGameHelper.showFloatButton();
		queuePopups.add(POPUP_FLOAT_BUTTON);

		if (check) {
			showPopup();
		}
	}

	public void setUserConfig(String mAreaId, String mAreaName, String mRoleId, String mRoleName) {
		Log.i(TAG, "setUserConfig: area_id=" + mAreaId + ";role_id=" + mRoleId + ";area_name=" + mAreaName + ";role_name=" + mRoleName);
		(new SaveCharacterTask(mAreaId, mAreaName, mRoleId, mRoleName)).execute();
	}
	
	public boolean isLoggedIn() {
		return !TextUtils.isEmpty(GameConfigManager.getInstance().getAccessToken());
	}

	private void showOfferWall() {
        if(!Utils.isOnline(activity)){
            Toast.makeText(activity, activity.getResources().getString(R.string.error_network)
                    , Toast.LENGTH_LONG).show();
            return;
        }
        if(offerWall == null){
        	offerWall = new OfferWall(activity);
        }
//        new Handler().post(new Runnable() {
//			
//			@Override
//			public void run() {
				// TODO Auto-generated method stub
				
				offerWall.loadAd();
				offerWall.show();
//				TODO if (popupAd != null && popupAd.isShowing()) popupAd.close();
				offerWall.setAdListener(new AdListener() {
					
					@Override
					public void onAdOpened() {
						MobGameHelper.hideFloatButton();
					}
					
					@Override
					public void onAdLoadedError(int errorCode, String msg) {}

					@Override
					public void onAdLoaded() {}
					
					@Override
					public void onAdClosed() {
						Intent intent = new Intent(Constants.INTENT_FILTER);
						intent.putExtra("category", "float_button");
						LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
					}
				});
//			}
//		});
		
	}
	
	private void handleLogin() {
		Log.e(TAG , "Fuck");
		(new GetInfoAfterAuthenTask(new GetInfoAfterAuthenTask.Listener() {
			
			@Override
			public void onSuccess(UserInfo userInfo) {
				GameConfigManager.getInstance().setUserInfo(userInfo);
				
				if (userInfo != null) {
					String accountId = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
					String accessToken = GameConfigManager.getInstance().getAccessToken();
					mListener.onLoginSuccessful(
						accountId,
						accessToken);
					return;				
				}
			}
			
			@Override
			public void onFailure(Throwable t) {
				logout(true);
				mListener.onError(
					MobGameListener.ERROR_LOGIN,
					"Unable to login to MobGame server");
			}
		})).execute();
	}
	boolean isUpgradeDialog = false;
	public void callShowPopup(){
		showPopup();
	}
	private void showPopup() {
		if (queuePopups == null || queuePopups.isEmpty()) {
			return;
		}
		if (isShowingHello) {
			return;
		}
		if (menuId > 0) {
			
			MobMenuItem menuItem = GameConfigManager.getInstance()
					.getMobMenu()
					.getMobMenuItemById(menuId);
			menuId = -1;
			if (menuItem != null) {
				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", menuItem.getCommand());
				intent.putExtra("data", menuItem.getParams());
				LocalBroadcastManager.getInstance(activity.getApplicationContext())
					.sendBroadcast(intent);
				return;
			}
			
		}
		String popup = queuePopups.get(0);
		Log.d(TAG, "Show popup: " + popup);
		queuePopups.remove(0);
		if (POPUP_HELLO.equalsIgnoreCase(popup)) {
			if(countShowHello < 2)
			showHello(activity, 4000, new Runnable() {
				public void run() {
					loginProcessDone = true;
					showPopup();
					Log.d(TAG, "showHello 3:");
				}
			});			
		} else if (POPUP_ACCOUNT.equalsIgnoreCase(popup)) {
//			if(!isBackWhenShow)//check crash : back button when after show hello 
			currentActivity.runOnUiThread(new Runnable() {
				public void run() {
					try {
						if (dialog != null) {
							dialog.dismiss();
						}
					} catch (Exception e) {}
					dialog = new MobGameUpgradeDialog(activity);
					dialog.setCancelable(false);
					dialog.setOnCancelClickListener(new OnClickListener() {
						public void onClick(View arg0) {
							Utils.hideLoading();
							new Handler().postDelayed(new Runnable() {
								public void run() {
									showPopup();
								}
							}, 1000);
						}
					});
					dialog.show();
				}
			});
		} else if (POPUP_NTFS.equalsIgnoreCase(popup)) {
			
			ArrayList<Integer> ids = Utils.getNtfs(getApplicationContext());
			ArrayList<MobMenuItem> menuItems = GameConfigManager.getInstance()
					.getMobMenu()
					.getMobMenuItemsByIds(ids);
			if (menuItems.size() > 0 && !menuItems.isEmpty()) {

				MobMenuItem menuItem = menuItems.get(0);
				for (int i = 1; i < menuItems.size(); i++) {
//					if (menuItems.get(i).getPriority() < menuItem.getPriority()) {//nho hien truoc
					if (menuItems.get(i).getPriority() > menuItem.getPriority()) {//lon hien truoc
						menuItem = menuItems.get(i);
						Log.e(TAG, "menuItem value:" +  menuItem);
					}
				}

				close(false);
				final MobMenuItem fMenuItem = menuItem;
				new Handler().postDelayed(new Runnable() {
					
					@Override
					public void run() {
						Intent intent = new Intent(Constants.INTENT_FILTER);
						intent.putExtra("category", fMenuItem.getCommand());
						intent.putExtra("data", fMenuItem.getParams());
						LocalBroadcastManager.getInstance(activity.getApplicationContext())
							.sendBroadcast(intent);
					}
				}, 500);
				
			} else {

				close(false);
				new Handler().postDelayed(new Runnable() {
					
					@Override
					public void run() {
						dashboard();
					}
				}, 500);
			}
			
		} else if (POPUP_FLOAT_BUTTON.equalsIgnoreCase(popup)) {
			shouldShowFloatButton = true;
			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", "float_button");
			LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
			showPopup();

		} else if (POPUP_ADS.equalsIgnoreCase(popup)) {
			Log.d(TAG, "go inside POPUP_ADS");
			shouldShowFloatButton = true;
			if(popupAd == null){
				popupAd = new PopupAd(activity);
				if(adStatus != StatusAd.AD_LOADING || adStatus != StatusAd.AD_OPENED){
					popupAd.loadAd();
				}
			}
			new Handler().postDelayed(new Runnable() {
				
				@Override
				public void run() {
					Log.d(TAG, "showPopup Ads");
					if(!Utils.canDrawOverApp(activity)){
						queuePopups.add(POPUP_ADS);
						return;
					}
					if(isLoggedIn() && adStatus == StatusAd.AD_LOADED){
						if(dialog != null){
							if(!dialog.isShowing()){
								if(!offerWall.isShowing()){
									if(!isShowSocialDialog){
										adStatus = StatusAd.AD_SHOWING;
										popupAd.show();
									}else{
										queuePopups.add(POPUP_ADS);
									}
								}else{
									queuePopups.add(POPUP_ADS);
								}
							}else{
								queuePopups.add(POPUP_ADS);
							}
						}else{
							if(!offerWall.isShowing()){
								if(!isShowSocialDialog){
									adStatus = StatusAd.AD_SHOWING;
									popupAd.show();
								}else{
									queuePopups.add(POPUP_ADS);
								}
							}else{
								queuePopups.add(POPUP_ADS);
							}
						}
					}	
				}
			}, 1000);
			
			showPopup();
		} 
	}

	private MobGameUpgradeDialog dialog;
	MobGameListener mDefaultListener = new MobGameListener() {

		@Override
		public void onLoginSuccessful(String accID, String token) {
			
		}

		@Override
		public void onPaySuccessful(String userId, String orderId,
				String orderProduct, String orderInfo, String orderTime,
				String platformPrice, String gamePrice, String state,
				String game_role_id, String game_area_id, String is_sandbox) {
			
			try {
				double price = 0.01 * Double.parseDouble(platformPrice);
				HashMap<String, Object> eventValue = new HashMap<String, Object>();
				eventValue.put(AFInAppEventParameterName.REVENUE, price);
				eventValue.put(AFInAppEventParameterName.CONTENT_TYPE, "category_rev");
				eventValue.put(AFInAppEventParameterName.CONTENT_ID, "123456");
				eventValue.put(AFInAppEventParameterName.CURRENCY, "USD");
				AppsFlyerLib.getInstance().trackEvent(
						currentActivity.getApplicationContext(),
						AFInAppEventType.PURCHASE, eventValue);
			} catch (Exception e) {
				// in case platformPrice cannot be parsed
			}
//			close();
		}

		@Override
		public void onError(int errorCode, String message) {
			
		}
	};
	
	private int countShowHello = 0;
	public void setMobGameListener(MobGameListener listener) {
		final MobGameListener fl = listener;
		MobGameListener onLoginListener = new MobGameListener() {

			@Override
			public void onLoginSuccessful(String accID, String token) {
				countShowHello = 1;
				Log.i(TAG, "OnLoginListener::onLoginSuccessful");
				Log.i(TAG, "accountID = " + accID + "; accessToken = " + token);

				String userId = GameConfigManager.getInstance().getUserInfo().getUser().getUserId();
				if(userId != null){
					AdsManager.setUserId(userId);
				}

				close(false);
				MobGameHelper.hideFloatButton();

				queuePopups.clear();
				
				queuePopups.add(POPUP_HELLO);
				
				UserInfo.UserDaily userDaily = GameConfigManager.getInstance().getUserInfo().getUserDaily();
				int typeHello = userDaily.getTypeHello();
				if (typeHello >= 2) {
					queuePopups.add(POPUP_ACCOUNT);
				}
				
				if (Utils.hasNtf(activity)) {
					queuePopups.add(POPUP_NTFS);
				}
				
				queuePopups.add(POPUP_FLOAT_BUTTON);
                doLoadPopupAds();
				showPopup();
				MobGameHelper.updateFloatButtonMenu();
				
				MobGameGCMIntentService.register(activity);

				fl.onLoginSuccessful(accID, token);
			}

			@Override
			public void onPaySuccessful(String userId, String orderId,
					String orderProduct, String orderInfo, String orderTime,
					String platformPrice, String gamePrice, String state,
					String game_role_id, String game_area_id, String is_sandbox) {
				
				try {
					double price = 0.01 * Double.parseDouble(platformPrice);
					HashMap<String, Object> eventValue = new HashMap<String, Object>();
					eventValue.put(AFInAppEventParameterName.REVENUE, price);
					eventValue.put(AFInAppEventParameterName.CONTENT_TYPE, "category_rev");
					eventValue.put(AFInAppEventParameterName.CONTENT_ID, "123456");
					eventValue.put(AFInAppEventParameterName.CURRENCY, "USD");
					AppsFlyerLib.getInstance().trackEvent(
							currentActivity.getApplicationContext(),
							AFInAppEventType.PURCHASE, eventValue);
				} catch (Exception e) {
					// in case platformPrice cannot be parsed
				}
//				close();
				
				fl.onPaySuccessful(
					userId, 
					orderId, orderProduct, orderInfo, orderTime, 
					platformPrice, gamePrice, state, 
					game_role_id, game_area_id, 
					is_sandbox);
				isShowAds = false;
			}

			@Override
			public void onError(int errorCode, String message) {
				
			}
		};
		mListener = onLoginListener;
	}
	
	private enum StatusAd{
		AD_INIT , AD_LOADING, AD_OPENED , AD_LOADED , AD_CLOSED , AD_ERROR , AD_SHOWING
	}
	private StatusAd adStatus = StatusAd.AD_INIT;
    private void doLoadPopupAds() {
        
        boolean showAds = Preference.getBoolean(activity, Constants.SHARED_PREF_SHOW_ADS, false);
        if(!showAds){
            return;
        }
        if(popupAd == null){
            return;
        }
        if(adStatus != StatusAd.AD_LOADING && adStatus != StatusAd.AD_OPENED
        		&& adStatus != StatusAd.AD_SHOWING && adStatus != StatusAd.AD_LOADED){
        	popupAd.loadAd();
        	adStatus = StatusAd.AD_LOADING;
        	Log.d(TAG, "Ads loading....");
        	popupAd.setAdListener(new AdListener() {
                @Override
                public void onAdOpened() {
                    // TODO Auto-generated method stub
                	Log.d(TAG, "onAdOpened ");
                	adStatus = StatusAd.AD_OPENED;
                }
                @Override
                public void onAdLoadedError(int arg0, String errorMessage) {
                    Log.d(TAG, "Load ad error: " + errorMessage);
                    adStatus = StatusAd.AD_ERROR;
                }
                @Override
                public void onAdLoaded() {
                	Log.d(TAG, "Ads loaded!");
                	adStatus = StatusAd.AD_LOADED;
                    queuePopups.add(POPUP_ADS);
                    showPopup();
                }
                @Override
                public void onAdClosed() {
                	Log.d(TAG, "onAdClosed");
                	adStatus = StatusAd.AD_CLOSED;
                }
            });
        }else{
        	showPopup();
        }
        
    }
    private boolean isShowPopupUpgrade(){
    	if(dialog != null){
    		if(dialog.isShowing())
    			return false;
    		else
    			return true;
    	}else{
    		return true;
    	}
    }

	private ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new ActivityLifecycleCallbacks() {
		
		private final String TAG = ActivityLifecycleCallbacks.class.getSimpleName();

		@Override
		public void onActivityCreated(Activity a, Bundle b) {
			Log.i(TAG, "onActivityCreated:" + a.getClass().getSimpleName());
			currentActivity = a;
			if (a.equals(activity)) {
				// Xu li deeplink o day!!!
			}
		}

		@Override
		public void onActivityStarted(Activity a) {
			Log.i(TAG, "onActivityStarted:" + a.getClass().getSimpleName());
			currentActivity = a;
			if (a.equals(activity)) {
				
			}
		}
		
		@Override
		public void onActivityResumed(Activity a) {
			Log.i(TAG, "onActivityResumed:" + a.getClass().getSimpleName());
			currentActivity = a;
			if (a.equals(activity)) {
				Log.d(TAG, "menu-id onActivityResumed:" + menuId);
				requestReadExternalPermission();
//				if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
//					WebView.setWebContentsDebuggingEnabled(true);
//				}
				
				Game gameConfig = GameConfigManager.getInstance().getGameConfig();
				if (gameConfig == null) {
					getGameInfoRemote();
				}
				
				LocalBroadcastManager.getInstance(activity.getApplicationContext())
					.registerReceiver(mMessageReceiver, new IntentFilter(Constants.INTENT_FILTER));

				CookieSyncManager.getInstance().startSync();

				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "float_button");
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
				Log.d(TAG, "shouldShowPopup:" + shouldShowPopup);
				if (shouldShowPopup) {
					showPopup();
					shouldShowPopup = false;
				}
				Log.e(TAG, "isShowAds: " + isShowAds);
				if(isLoggedIn() && isShowAds && isShowPopupUpgrade()){
					Log.e(TAG, "Go inside :" + isShowAds + ", isShowPopupUpgrade():" + isShowPopupUpgrade());
					doLoadPopupAds();
				}

				if (accelerometerPresent) {
					sensorManager.registerListener(accelerometerListener,
							accelerometerSensor, SensorManager.SENSOR_DELAY_NORMAL);
				}
//				if(isLogined){
//					Log.e(TAG, "isLogined:" + isLogined);
//					MobGameHelper.updateFloatButtonMenu();
//				}
			}
		}
		
		@SuppressLint("InlinedApi") private void requestReadExternalPermission() {
			boolean grantedReadStorage = PermissionUtils
					.hasPermission(Manifest.permission.READ_EXTERNAL_STORAGE);

			if (!grantedReadStorage) {
				PermissionUtils.requestPermission(activity,
						Manifest.permission.READ_EXTERNAL_STORAGE);
			}
			
		}
		
		@Override
		public void onActivityPaused(Activity a) {
			Log.i(TAG, "onActivityPaused:" + a.getClass().getSimpleName());
			currentActivity = a;
			if (a.equals(activity)) {
				
				if (accelerometerPresent) {
					sensorManager.unregisterListener(accelerometerListener);
				}

				MobGameHelper.hideFloatButton();

				CookieSyncManager.getInstance().stopSync();

				LocalBroadcastManager.getInstance(activity.getApplicationContext())
					.unregisterReceiver(mMessageReceiver);
			}
		}
		
		@Override
		public void onActivityStopped(Activity a) {
			Log.i(TAG, "onActivityStopped:" + a.getClass().getSimpleName());
			if (a.equals(activity)) {
				MobGameHelper.hideFloatButton();
			}
		}

		@Override
		public void onActivityDestroyed(Activity a) {
			Log.i(TAG, "onActivityDestroyed:" + a.getClass().getSimpleName());
			if (a.equals(activity)) {
				if(!a.getClass().getSimpleName().equals("MobGameActivity")
						&& !a.getClass().getSimpleName().equals("FacebookActivity")){
					isShowAds = true;
				}
				Log.i(TAG, "removeAllCookie");
//				CookieManager cookieManager = CookieManager.getInstance();
//				cookieManager.removeSessionCookie();
//				cookieManager.removeAllCookie();
				
				MobGameGCMIntentService.destroy(activity);

				LocalBroadcastManager.getInstance(activity.getApplicationContext())
					.unregisterReceiver(mGlobalMessageReceiver);
			}
		}

		@Override
		public void onActivitySaveInstanceState(Activity a, Bundle b) {
			if (a.equals(activity)) {
				
			}
		}
		
	};
	
	private ComponentCallbacks mComponentCallbacks = new ComponentCallbacks() {

		@Override
		public void onConfigurationChanged(Configuration newConfig) {
		    // Checks the orientation of the screen
			Log.d(TAG, "onConfigurationChanged");
		    if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE
		    ||	newConfig.orientation == Configuration.ORIENTATION_PORTRAIT) {
		    	Log.d(TAG, "onConfigurationChanged : " + newConfig.orientation);
		    	if(Utils.isDashboardEnabled(activity)){
//					MobGameHelper.checkDrawOverApps();
					MobGameHelper.initFloatButton();
		    	}
		    	Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "float_button");
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);		    	
		    }
		}

		@Override
		public void onLowMemory() {}
		
	};

	private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {

		@Override
		public void onReceive(Context context, Intent intent) {
		    Log.d(TAG, "BroadcastReceiver::onReceive");
		    String category = intent.getStringExtra("category");
		    Log.e(TAG, "category:" + category);
			if (category != null) {
				if ("dashboard".equalsIgnoreCase(category)) {

					String data = intent.getStringExtra("data");
					if (!TextUtils.isEmpty(data)) {
						try {
							dashboard(data);
						} catch (JSONException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} else {
						dashboard();
					}
				} else if ("float_button".equalsIgnoreCase(category)) {

					String msg = intent.getStringExtra("message");
					Log.d(TAG, "message:" + msg);
					if ("hide".equalsIgnoreCase(msg)) {
						Log.d(TAG, "Da vao day");
						MobGameHelper.hideFloatButton();
					} else {
//						if(GameConfigManager.getInstance().isHasUnreadNotifications()){
//								MobGameHelper.notifyFloatButton();
//								GameConfigManager.getInstance().setHasUnreadNotifications(false);
//						}
						Log.d(TAG, "alo alo : " + Utils.isDashboardEnabled(activity));
						if (GameConfigManager.getInstance().getGameConfig() != null
						&& isLoggedIn()
						&& !offerWall.isShowing()
						&& Utils.isDashboardEnabled(activity)
//						&& Utils.isFloatButtonEnabled(activity)
						&& shouldShowFloatButton
						&& !isShowSocialDialog
						) {
//							int dismissTime = Preference.getInt(activity, 
//									Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME, -1);
//							Calendar c = Calendar.getInstance();
//							int today = c.get(Calendar.DAY_OF_YEAR);
//							
//							if (dismissTime != today) {
//								MobGameHelper.showFloatButton();
//							}
							if(GameConfigManager.getInstance().isHasUnreadNotifications()
									&& Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)){
								MobGameHelper.notifyFloatButton();
								
							}
							long currentTimeMilisecond = Calendar.getInstance().getTimeInMillis();
							long dismissTime = Preference.getLong(activity, 
									Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME, 
									-1L);
							
							if(dismissTime < 0){
								MobGameHelper.showFloatButton();
								return;
							}
							
							long totalTime = currentTimeMilisecond - dismissTime;
							LogUtils.log(activity, TAG, String.format("total time float button dismissed: %s hours", (totalTime / 60 * 60 * 1000)));
							if(totalTime >= TIMEOUT_DISMISS_FLOAT_BUTTON){
								MobGameHelper.showFloatButton();
								Preference.remove(activity, Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME);
							}
						}
					}
				} else if ("gcm".equalsIgnoreCase(category)) {

					if (GameConfigManager.getInstance().getGameConfig() != null
					&& isLoggedIn()
					&& !offerWall.isShowing()
					&& Utils.isDashboardEnabled(activity)
					) {
						MobGameHelper.notifyFloatButton();
					}
				} else if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
					showOfferWall();
				} else if ("mobOpenFanPage".equalsIgnoreCase(category)) {

					String params = intent.getStringExtra("data");
					CmdDashboard.getInstance().mobOpenFBFanpage(activity, params);
				} else if ("mobOpenGroup".equalsIgnoreCase(category)) {

					String params = intent.getStringExtra("data");
					CmdDashboard.getInstance().mobOpenFBGroup(activity, params);
				} else if ("mobOpenBrowser".equalsIgnoreCase(category)) {

					String params = intent.getStringExtra("data");
					CmdDashboard.getInstance().mobOpenBrowser(activity, params);
				} else if ("MobGameUpgradeDialog.btnUpgradeInfo".equalsIgnoreCase(category)) {

					shouldShowPopup = true;
				}

			}
		}
	};

	private BroadcastReceiver mGlobalMessageReceiver = new BroadcastReceiver() {

		@Override
		public void onReceive(Context context, Intent intent) {
		    Log.d(TAG, "GlobalMessageReceiver::onReceive");
		    String category = intent.getStringExtra("category");
		    Log.d(TAG, "GlobalMessageReceiver::onReceive " + category);
			if (category != null) {
				if ("login".equalsIgnoreCase(category)) {
					
					handleLogin();
				} else if ("payment".equalsIgnoreCase(category)) {
					
					boolean success = intent.getBooleanExtra("status", false);
					if (success) {
						String userId = intent.getStringExtra("user_id");
						String orderId = intent.getStringExtra("order_id");
						String orderProduct = intent.getStringExtra("order_product");
						String orderInfo = intent.getStringExtra("order_info");
						String orderTime = intent.getStringExtra("order_time");
						String platformPrice = intent.getStringExtra("platform_price");
						String gamePrice = intent.getStringExtra("game_price");
						String state = intent.getStringExtra("state");
						String game_role_id = intent.getStringExtra("game_role_id");
						String game_area_id = intent.getStringExtra("game_area_id");
						String is_sandbox = intent.getStringExtra("is_sandbox");

						mListener.onPaySuccessful(userId, orderId,
								orderProduct, orderInfo, orderTime,
								platformPrice, gamePrice, state, game_role_id,
								game_area_id, is_sandbox);
					} else {
						String message = intent.getStringExtra("message");
						mListener.onError(MobGameListener.ERROR_PAYMENT,
								message);
					}
				} else if ("reload".equalsIgnoreCase(category)) {
					MobGameActivity.shouldReload = true;
				}
			}
		}
	};

	private GetInfoBeforeAuthenTask mGetInfoBeforeAuthenTask;
	private void getGameInfoRemote() {
		Log.d(TAG , "Fuck 1");
		if (mGetInfoBeforeAuthenTask != null && !mGetInfoBeforeAuthenTask.isCancelled())
			mGetInfoBeforeAuthenTask.cancel(true);
		
		mGetInfoBeforeAuthenTask = new GetInfoBeforeAuthenTask(new GetInfoBeforeAuthenTask.Listener() {
			
			@Override
			public void onSuccess(Game gameConfig) {
				if (gameConfig == null) {

					onGetGameInfoRemoteFailed();
				} else {			
					GameConfigManager.getInstance().setGameConfig(gameConfig);
					
					offerWall = new OfferWall(activity);
					
					popupAd = new PopupAd(activity);
					/*popupAd.setAdListener(new AdListener() {
						@Override
						public void onAdOpened() {
							// TODO Auto-generated method stub
							
						}
						@Override
						public void onAdLoadedError(int arg0, String arg1) {
							// TODO Auto-generated method stub
							
						}
						@Override
						public void onAdLoaded() {
							Log.d(TAG, "Ads load done");
							queuePopups.add(POPUP_ADS);
						}
						@Override
						public void onAdClosed() {
							showPopup();
						}
					});*/
					Log.d(TAG , "Fuck 1");
					if (isLoggedIn()) {
						handleLogin();
					}
				}
			}
			
			@Override
			public void onFailure(Throwable t) {
				Log.d(TAG , "Fuck 2");
				t.printStackTrace();
				onGetGameInfoRemoteFailed();
			}
		});
		mGetInfoBeforeAuthenTask.execute();
	}

	private void onGetGameInfoRemoteFailed() {
		AlertDialog.Builder builder = new AlertDialog.Builder(Utils.getContextThemeWrapper(activity));
		builder.setCancelable(false);
		builder.setMessage(Res.string(activity, R.string.unable_to_connect));
		builder.setPositiveButton(
				Res.string(activity, R.string.retry),
				new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						getGameInfoRemote();
					}
				});
		builder.setNegativeButton(
				Res.string(activity, R.string.exit),
				new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						Intent intent = new Intent(
								Intent.ACTION_MAIN);
						intent.addCategory(Intent.CATEGORY_HOME);
						intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
						activity.startActivity(intent);
					}
				});
		builder.show();
	}

	private static View helloView;
	private static boolean isShowingHello;
	private static final int DEFAULT_HELLO_TIMEOUT = 3000;
	
	public void showHello(Activity activity) {
		showHello(activity, DEFAULT_HELLO_TIMEOUT, null);
	}

	public void showHello(final Activity activity, long duration, final Runnable afterHideRunnable) {
		try {
			if (activity == null) return;
			if (isShowingHello) return;

			final String username = GameConfigManager.getInstance().getUserInfo().getUser().getUserName();
			Log.i(TAG, "showHello:" + username);
			activity.runOnUiThread(new Runnable() {

				@SuppressLint("InflateParams") 
				@Override
				public void run() {
					Utils.hideLoading();
					ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
					LayoutInflater inflater = LayoutInflater.from(activity);
					helloView = inflater.inflate(R.layout.layout_processing, null);
					
					ImageView img = (ImageView) helloView.findViewById(R.id.imv_loading);
					Drawable imgDrawable = Res.drawable(activity, R.drawable.logo_sm);					
					img.setImageDrawable(imgDrawable);
					
					TextView tv = (TextView) helloView.findViewById(R.id.txt_status);
					tv.setText(Res.string(activity, R.string.hello) + ", " + username);
					
					try {
						UserInfo.UserDaily userDaily = GameConfigManager.getInstance().getUserInfo().getUserDaily();
						String title = userDaily.getTitle();
						int coin = userDaily.getCoin();
						
						if (coin > 0) {
							View layoutMobCoin = helloView.findViewById(R.id.layout_mobcoin);
							layoutMobCoin.setVisibility(View.VISIBLE);
							TextView tvMobCoinActivity = (TextView) helloView.findViewById(R.id.txt_mobcoin_activity);
							tvMobCoinActivity.setText(title);
							TextView tvMobCoin = (TextView) helloView.findViewById(R.id.txt_mobcoin_value);
							tvMobCoin.setText("+" + coin);
						} else {
							View layoutMobCoin = helloView.findViewById(R.id.layout_mobcoin);
							layoutMobCoin.setVisibility(View.GONE);
						}
					} catch (Exception e) {}

					rootView.addView(helloView);

					helloView.startAnimation(AnimationUtils.loadAnimation(activity, R.anim.top_in));
					isShowingHello = true;
					countShowHello = countShowHello + 1;
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			new Handler().postDelayed(new Runnable() {
				
				@Override
				public void run() {
					hideHello(activity, true);
					if (afterHideRunnable != null) {
						afterHideRunnable.run();
					}
				}
			}, duration + 500);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void hideHello(final Activity activity, boolean isAnimated) {
		isShowingHello = false;
		countShowHello = countShowHello + 1;
		if (isAnimated) {
			activity.runOnUiThread(new Runnable() {
				public void run() {
					Animation animation = AnimationUtils.loadAnimation(activity, R.anim.top_out);
					animation.setAnimationListener(new AnimationListener() {
						@Override
						public void onAnimationStart(Animation animation) {}
						
						@Override
						public void onAnimationRepeat(Animation animation) {}
						
						@Override
						public void onAnimationEnd(Animation animation) {
							ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
							rootView.removeView(helloView);
						}
					});
	
					helloView.startAnimation(animation);
				}
			});
		} else {
			try {
				ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
				rootView.removeView(helloView);
			} catch (Exception e) {}
		}
	}
	
}
