/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.floatbutton;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.koushikdutta.urlimageviewhelper.UrlImageViewHelper;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.MobMenu;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class MobGameFloatMenuView {
    private static int MENU_HEIGHT = 44;
    Activity activity;
    EventListener eventListener;
    View rootView;
    View layoutMenu;
    @SuppressLint(value={"UseSparseArrays"})
    HashMap<Integer, ImageView> ntfImageViews = new HashMap();
    float density;
    float screenHeight;

    public MobGameFloatMenuView(Activity a) {
        this.activity = a;
        this.density = DeviceUtils.getDensity((Context)a);
        this.screenHeight = DeviceUtils.getScreenHeightInPixels((Context)a);
        this.attachView();
        this.initView();
    }

    @SuppressLint(value={"InflateParams"})
    public void attachView() {
        this.rootView = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_menu, null);
        WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2002, 8, -2);
        params.gravity = 51;
        windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
    }

    @SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
    public void initView() {
        this.rootView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                MobGameFloatMenuView.this.hide();
                return true;
            }
        });
        this.layoutMenu = this.rootView.findViewById(R.id.layout_menu);
        this.updateMenu();
        this.hide();
    }

    public void setEventListener(EventListener listener) {
        this.eventListener = listener;
    }

    public void show(int x, int y, boolean isAnimated) {
        if (this.eventListener != null && this.rootView.getVisibility() != 0) {
            this.eventListener.onShow();
        }
        this.rootView.setVisibility(0);
        WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
        WindowManager.LayoutParams params = (WindowManager.LayoutParams)this.rootView.getLayoutParams();
        params.x = MENU_HEIGHT * (int)this.density;
        windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)params);
        int menuY = y + (MENU_HEIGHT * (int)this.density - this.layoutMenu.getHeight()) / 2;
        int minY = 0;
        int maxY = (int)(this.screenHeight - (float)this.layoutMenu.getHeight());
        int calY = Math.min(maxY, Math.max(minY, menuY));
        if (calY > menuY) {
            menuY = y;
        } else if (calY < menuY) {
            menuY = y + (MENU_HEIGHT * (int)this.density - this.layoutMenu.getHeight());
        }
        RelativeLayout.LayoutParams params1 = (RelativeLayout.LayoutParams)this.layoutMenu.getLayoutParams();
        params1.addRule(9, -1);
        params1.addRule(11, 0);
        params1.leftMargin = x + 8 * (int)this.density;
        params1.topMargin = menuY;
        if (isAnimated) {
            this.layoutMenu.animate().setDuration(400L).alpha(100.0f);
        }
        this.updateMenuNtf();
    }

    public void showInReverse(int x, int y, boolean isAnimated) {
        if (this.eventListener != null && this.rootView.getVisibility() != 0) {
            this.eventListener.onShow();
        }
        this.rootView.setVisibility(0);
        WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
        WindowManager.LayoutParams params = (WindowManager.LayoutParams)this.rootView.getLayoutParams();
        params.x = 0;
        windowManager.updateViewLayout(this.rootView, (ViewGroup.LayoutParams)params);
        int menuY = y + (MENU_HEIGHT * (int)this.density - this.layoutMenu.getHeight()) / 2;
        int minY = 0;
        int maxY = (int)(this.screenHeight - (float)this.layoutMenu.getHeight());
        int calY = Math.min(maxY, Math.max(minY, menuY));
        if (calY > menuY) {
            menuY = y;
        } else if (calY < menuY) {
            menuY = y + (MENU_HEIGHT * (int)this.density - this.layoutMenu.getHeight());
        }
        RelativeLayout.LayoutParams params1 = (RelativeLayout.LayoutParams)this.layoutMenu.getLayoutParams();
        params1.addRule(9, 0);
        params1.addRule(11, -1);
        params1.rightMargin = x + 8 * (int)this.density;
        params1.topMargin = menuY;
        if (isAnimated) {
            this.layoutMenu.animate().setDuration(400L).alpha(100.0f);
        }
        this.updateMenuNtf();
    }

    public void hide() {
        if (this.eventListener != null && this.rootView.getVisibility() == 0) {
            this.eventListener.onHide();
        }
        this.rootView.setVisibility(4);
        this.layoutMenu.setAlpha(0.0f);
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            windowManager.removeView(this.rootView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"InflateParams"})
    void updateMenu() {
        ((ViewGroup)this.layoutMenu).removeAllViews();
        MobMenu mobMenu = GameConfigManager.getInstance().getMobMenu();
        if (mobMenu == null) {
            return;
        }
        ArrayList<MobMenuItem> menuItems = mobMenu.getMenuItems();
        Stack<View> views = new Stack<View>();
        for (int i = menuItems.size() - 1; i >= 0; --i) {
            MobMenuItem menuItem = menuItems.get(i);
            if (!menuItem.shouldShowHorizontal()) continue;
            View v = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_menu_item, null);
            TextView tv = (TextView)v.findViewById(R.id.title);
            ImageView imv = (ImageView)v.findViewById(R.id.image);
            ImageView imvNoti = (ImageView)v.findViewById(R.id.img_notification);
            if (menuItem.isTab()) {
                for (int subId : menuItem.getSubMenuIds()) {
                    this.ntfImageViews.put(subId, imvNoti);
                }
                this.ntfImageViews.put(menuItem.getId(), imvNoti);
            } else {
                this.ntfImageViews.put(menuItem.getId(), imvNoti);
            }
            Log.d((String)"acb", (String)"go here!");
            tv.setText((CharSequence)menuItem.getLabelHorizontal());
            tv.setTextSize(2, 11.0f);
            UrlImageViewHelper.setUrlDrawable((ImageView)imv, (String)menuItem.getIconUrlHorizontal());
            final MobMenuItem fMenuItem = menuItem;
            v.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MobGameFloatMenuView.this.eventListener != null) {
                        MobGameFloatMenuView.this.eventListener.onClick(v, fMenuItem);
                    }
                }
            });
            views.push(v);
        }
        int itemsPerRow = 4;
        while (!views.isEmpty()) {
            TableRow tblrow = new TableRow((Context)this.activity);
            tblrow.setGravity(16);
            for (int j = 0; !views.isEmpty() && j < itemsPerRow; ++j) {
                tblrow.addView((View)views.pop());
            }
            ((ViewGroup)this.layoutMenu).addView((View)tblrow);
        }
        this.updateMenuNtf();
    }

    private void updateMenuNtf() {
        if (this.ntfImageViews == null) {
            return;
        }
        ArrayList<ImageView> imvs = new ArrayList<ImageView>(this.ntfImageViews.values());
        for (int i = 0; i < imvs.size(); ++i) {
            ImageView imageView = imvs.get(i);
            if (imageView == null) continue;
            imageView.setVisibility(8);
        }
        ArrayList<Integer> ntfs = Utils.getNtfs((Context)this.activity);
        if (ntfs == null) {
            return;
        }
        for (int i = 0; i < ntfs.size(); ++i) {
            this.ntfImageViews.get(ntfs.get(i)).setVisibility(0);
        }
    }

    static interface EventListener {
        public void onClick(View var1, MobMenuItem var2);

        public void onShow();

        public void onHide();
    }
}

