/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.urlimageviewhelper;

import android.content.Context;
import android.os.AsyncTask;
import com.koushikdutta.urlimageviewhelper.UrlDownloader;
import com.koushikdutta.urlimageviewhelper.UrlImageViewHelper;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public class HttpUrlDownloader
implements UrlDownloader {
    private UrlImageViewHelper.RequestPropertiesCallback mRequestPropertiesCallback;

    public UrlImageViewHelper.RequestPropertiesCallback getRequestPropertiesCallback() {
        return this.mRequestPropertiesCallback;
    }

    public void setRequestPropertiesCallback(UrlImageViewHelper.RequestPropertiesCallback callback) {
        this.mRequestPropertiesCallback = callback;
    }

    @Override
    public void download(final Context context, final String url, String filename, final UrlDownloader.UrlDownloaderCallback callback, final Runnable completion) {
        AsyncTask<Void, Void, Void> downloader = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    HttpURLConnection urlConnection;
                    InputStream is = null;
                    String thisUrl = url;
                    while (true) {
                        ArrayList<NameValuePair> props;
                        URL u = new URL(thisUrl);
                        urlConnection = (HttpURLConnection)u.openConnection();
                        urlConnection.setInstanceFollowRedirects(true);
                        if (HttpUrlDownloader.this.mRequestPropertiesCallback != null && (props = HttpUrlDownloader.this.mRequestPropertiesCallback.getHeadersForRequest(context, url)) != null) {
                            for (NameValuePair pair : props) {
                                urlConnection.addRequestProperty(pair.getName(), pair.getValue());
                            }
                        }
                        if (urlConnection.getResponseCode() != 302 && urlConnection.getResponseCode() != 301) break;
                        thisUrl = urlConnection.getHeaderField("Location");
                    }
                    if (urlConnection.getResponseCode() != 200) {
                        UrlImageViewHelper.clog("Response Code: " + urlConnection.getResponseCode(), new Object[0]);
                        return null;
                    }
                    is = urlConnection.getInputStream();
                    callback.onDownloadComplete(HttpUrlDownloader.this, is, null);
                    return null;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return null;
                }
            }

            protected void onPostExecute(Void result) {
                completion.run();
            }
        };
        UrlImageViewHelper.executeTask(downloader);
    }

    @Override
    public boolean allowCache() {
        return true;
    }

    @Override
    public boolean canDownloadUrl(String url) {
        return url.startsWith("http");
    }
}

