/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.cache;

import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.cache.RequestCacheData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final int CACHE_MAX_SIZE = 40;
    public static final String AF_CACHE_DIR = "AFRequestCache";
    private static CacheManager ourInstance = new CacheManager();

    public static CacheManager getInstance() {
        return ourInstance;
    }

    private CacheManager() {
    }

    private File getCacheDir(Context context) {
        return new File(context.getFilesDir(), AF_CACHE_DIR);
    }

    public void init(Context context) {
        try {
            if (!this.getCacheDir(context).exists()) {
                this.getCacheDir(context).mkdir();
            }
        }
        catch (Exception exception) {
            Log.i((String)AppsFlyerLib.LOG_TAG, (String)"Could not create cache directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cacheRequest(RequestCacheData data, Context context) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = this.getCacheDir(context);
            if (!file.exists()) {
                file.mkdir();
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 40) {
                Log.i((String)AppsFlyerLib.LOG_TAG, (String)"reached cache limit, not caching request");
                return;
            }
            Log.i((String)AppsFlyerLib.LOG_TAG, (String)"caching request...");
            File file2 = new File(this.getCacheDir(context), Long.toString(System.currentTimeMillis()));
            file2.createNewFile();
            outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file2.getPath(), true));
            outputStreamWriter.write("version=");
            outputStreamWriter.write(data.getVersion());
            outputStreamWriter.write(10);
            outputStreamWriter.write("url=");
            outputStreamWriter.write(data.getRequestURL());
            outputStreamWriter.write(10);
            outputStreamWriter.write("data=");
            outputStreamWriter.write(data.getPostData());
            outputStreamWriter.write(10);
            outputStreamWriter.flush();
            return;
        }
        catch (Exception exception) {
            Log.i((String)AppsFlyerLib.LOG_TAG, (String)"Could not cache request");
            return;
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public List<RequestCacheData> getCachedRequests(Context context) {
        ArrayList<RequestCacheData> arrayList = new ArrayList<RequestCacheData>();
        try {
            File file = this.getCacheDir(context);
            if (!file.exists()) {
                file.mkdir();
            } else {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    Log.i((String)AppsFlyerLib.LOG_TAG, (String)("Found cached request" + file2.getName()));
                    arrayList.add(this.loadRequestData(file2));
                }
            }
        }
        catch (Exception exception) {
            Log.i((String)AppsFlyerLib.LOG_TAG, (String)"Could not cache request");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestCacheData loadRequestData(File file) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            char[] cArray = new char[(int)file.length()];
            fileReader.read(cArray);
            RequestCacheData requestCacheData = new RequestCacheData(cArray);
            requestCacheData.setCacheKey(file.getName());
            RequestCacheData requestCacheData2 = requestCacheData;
            return requestCacheData2;
        }
        catch (Exception exception) {
            RequestCacheData requestCacheData = null;
            return requestCacheData;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void deleteRequest(String cacheKey, Context context) {
        File file = this.getCacheDir(context);
        File file2 = new File(file, cacheKey);
        Log.i((String)AppsFlyerLib.LOG_TAG, (String)("Deleting " + cacheKey + " from cache"));
        if (file2.exists()) {
            try {
                file2.delete();
            }
            catch (Exception exception) {
                Log.i((String)AppsFlyerLib.LOG_TAG, (String)("Could not delete " + cacheKey + " from cache"), (Throwable)exception);
            }
        }
    }
}

