package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.webkit.CookieManager;

import com.mobgame.MobGameSDK;
import com.mobgame.ads.AdsManager;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Preference;

public class LogoutTask extends AsyncTask<Void, Void, Void> {
	
	public LogoutTask() {
	}

	@Override
	protected Void doInBackground(Void... params) {
		Context c = MobGameSDK.getApplicationContext();
		
		Preference.remove(c, Constants.SHARED_PREF_COOKIES);
		CookieManager cookieManager = CookieManager.getInstance();
		cookieManager.removeSessionCookie();
		cookieManager.removeAllCookie();

		GameConfigManager.getInstance().clearLogin();
		GoogleAnalyticsManager.getInstance().removeTrackers();
		FacebookManager.getInstance().logout();
		GoogleAuthManager.getInstance().logout();
		AdsManager.setUserId(null);

		return null;
	}
}